//
// Sawmill Source Code
// 
// This source code is the intellectual property of Flowerfire,
// and is protected by federal trade secret laws.  Do not
// redistribute, modify, or use this source code without the 
// express written consent of Flowerfire.
//
// For more information, see http://www.sawmill.net/trade_secret.html
//
// This file contains utility function prototypes
//

#ifndef HCHAR_CHECKS
#define HCHAR_CHECKS

#define ISSPACE(c) ((c == ' ') || (c == '\r') || (c == '\n') || (c == '\t') || (c == '\v') || (c == '\f'))
#define ISALPHA(c) (((c >= 'a') && (c <= 'z')) || ((c >= 'A') && (c <= 'Z')))
#define ISCNTRL(c) ((c < ' ') || (c == 0x7f))
#define ISDIGIT(c) ((c >= '0') && (c <= '9'))
#define ISALNUM(c) (ISALPHA(c) || ISDIGIT(c))
#define ISXDIGIT(c) (((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f')) || ((c >= 'A') && (c <= 'F')))
#define ISLOWER(c) ((c >= 'a') && (c <= 'z'))
#define ISUPPER(c) ((c >= 'A') && (c <= 'Z'))
#define ISPUNCT(c) (!ISSPACE(c) && !ISALPHA(c) && !ISCNTRL(c) && !ISDIGIT(c))

#endif


