//
// Sawmill Source Code
// 
// This source code is the intellectual property of Flowerfire,
// and is protected by federal trade secret laws.  Do not
// redistribute, modify, or use this source code without the 
// express written consent of Flowerfire.
//
// For more information, see http://www.sawmill.net/trade_secret.html
//

#ifndef HSCONFIG
#define HSCONFIG

#pragma warning(disable : 4996)

#if defined(WIN32) || defined(WIN64)
# ifndef WINDOWS
#  define WINDOWS 1
# endif
#endif

#ifndef WINDOWS
typedef int SOCKET;
#endif

#ifdef XCODE
# include "macosx_config.h"
#else
# if defined(WINDOWS) && !defined(MINGW)
#  include "win32_config.h"
# else
#  ifdef macintosh
#   include "mac_config.h"
#  else
#   ifdef IRIX
#    include "irix_config.h"
#   else
#    ifdef SUN_STUDIO
#     include "sun_studio_config.h"
#    else
#     ifdef HAVE_CONFIG_H
#      include "config.h"
#     endif
#    endif
#   endif
#  endif
# endif
#endif

//#include "platform.h"

//#define MAKE_PURIFY_HAPPY
// mint is the largest native signed integer type
// muint is the largest native unsigned integer type

#ifdef WIN64
typedef long long mint;
typedef unsigned long long muint;
#define MINT_IS_LONG_LONG 1
/* #define MINT_MAX LONG_LONG_MAX */
/* #define UMINT_MAX ULONG_LONG_MAX */
/* #define MINT_MIN LONG_LONG_MIN */
/* #define UMINT_MIN ULONG_LONG_MIN */
#define MINT_MAX LLONG_MAX
#define UMINT_MAX ULLONG_MAX
#define MINT_MIN LLONG_MIN
#define UMINT_MIN ULLONG_MIN
#else
typedef long mint;
typedef unsigned long muint;
#define MINT_MAX LONG_MAX
#define UMINT_MAX ULONG_MAX
#define MINT_MIN LONG_MIN
#define UMINT_MIN ULONG_MIN
#endif

// Check if we have MySQL
#ifdef USE_MYSQL
#define HAVE_MYSQL 1
#endif

// Assume we have pthreads (we can't function without them, so no loss).
#define HAVE_PTHREAD 1

#if !HAVE_BZERO
#define bzero(s, n)	memset ((s), 0, (n))
#endif

//#define NAN nan("")
//include <math.h>

// 26/May/2006 - GMF - If we don't have nan(), emulate it with strtod("NaN")
// This could be optimized, if necessary, by calling this once early on (e.g., from main()), and using the result from then on.
#if !HAVE_NAN
#include <stdlib.h>
#define nan(X) strtod("NaN", NULL)
#endif

#if defined(WIN32) && !defined(MINGW)
// The following types work with Visual C++ on 32-bit Windows
typedef __int64 int64;
typedef signed __int64 uint64;
typedef int int32;
typedef unsigned int uint32;
typedef short int16;
typedef unsigned short uint16;
typedef char int8;
typedef unsigned char uint8;
#else
// The following types work on 64-bit Linux with gcc:
// and on MinGW on 32-bit Windows.
typedef long long int64;
typedef unsigned long long uint64;
typedef int int32;
typedef unsigned int uint32;
typedef short int16;
typedef unsigned short uint16;
typedef char int8;
typedef unsigned char uint8;
#endif

#endif


