import java.net.*;
import java.io.*;


public class NetworkServer
{
  protected int port, maxConnections;
  static protected String iPlanetString = "format=";

  public NetworkServer (int port, int maxConnections)
  {
	this.port = port;
	this.maxConnections = maxConnections;
  }


  public void listen()
  {
    int i = 0;
    try {
  	ServerSocket listener = new ServerSocket(port);
	Socket server;
	while (i++ < maxConnections || maxConnections == 0)
	{
	  server = listener.accept();
	  handleConnection(server);
	}
    }catch(IOException ioe){
	System.out.println("IOException : " + ioe);
	ioe.printStackTrace();
    }
  }

  protected void handleConnection(Socket server) throws IOException
  {
    SocketUtil s = new SocketUtil(server);
    BufferedReader in = s.getBufferedReader();
    //    PrintWriter out = s.getPrintWriter();
    OutputStream os = server.getOutputStream();
    PrintWriter out = new PrintWriter(os);

    int header = 0;

    String line, field,value;
    int i = 0;
    int j = 0;
    int arrIndex = 0;
    String fieldArray[] = new String[100]; 
    String valueArray[] = new String[100];
    StringBuffer processedString;
    
  
    //read data from Sawmill
    while ((line = in.readLine()) != null )
    {

      System.out.println("line read: " + line);

	// ******** first line ******** 
	if (header == 0){
	   System.out.println("the header");
	   header++;

	   //System.out.println(line);
	   while (j < line.length() && j > -1)
	   {
		i = line.indexOf("|",j);

		if (i > -1)
		{
		  field = line.substring(j, i);
		  fieldArray[arrIndex++] = field;
		  j = i+1;
		}else{
		  break;
		}

            }

	    //print the contents of the array
	    for (int k = 0; (k < fieldArray.length) && (fieldArray[k] != null); k++)
	    {
		System.out.println("field = " + fieldArray[k]);
	    }

	   //out.print(line+"\n");
	    //	   out.print("\n");
	    //	   out.flush();
	   
	
	// ******** last line ********
	}else if (line.equals("***END***")){
	   System.out.println("end of file ... closing connection");
	   break;

	// ******** data lines ********	    
	}else {
	   System.out.println("process line");
	   i = 0;
	   j = 0;
	   arrIndex = 0;

	   while (j < line.length() && j > -1)
	   {
		i = line.indexOf("|",j);

		if (i > -1)
		{
		  value = line.substring(j, i);
		  valueArray[arrIndex++] = value;
		  j = i+1;
		}else {
		  break;
		}

            }

	      //print the contents of the array
	      for (int k = 0; (k < valueArray.length) && (valueArray[k] != null); k++)
	      {
		//System.out.println(fieldArray[k] + "     " + "value = " + valueArray[k]);
		if (k == 14){
		   //System.out.println("***** cookie info ****");
		   //System.out.println(valueArray[k]);
		   populateVariables(valueArray[k], valueArray);
		   //System.out.println("**********************");
	     	   //System.out.println("");
		   
		}
	    }


	   //now that values for aol and promocode have been updated re-display the array
    	   for (int k = 0; (k < valueArray.length) && (valueArray[k] != null); k++)
    	   {
		System.out.println( "fieldArray["+k+"]" + "\t" + "\t" + valueArray[k]);
    	   }

	   //convert array to a string and send back to the client
	   processedString = arrayToString(valueArray);
	   System.out.println("ProcessString = " + processedString.toString());

	   if ((processedString.toString()).startsWith("%")){
		System.out.println("the line starts with %");
		out.print("\n");
	   }else {
	   	out.print(processedString.toString()+"\n");
	   }

	   //System.out.println("back to client : " + processedString.toString() + "\n");
	   out.flush();
	   System.out.println("after flush");
	}
    }

    System.out.println("Closing connection");
    server.close();

  }//handleConnect


  protected void populateVariables (String s, String [] valueArray)
  {
	String aol = new String("aol=");
	String promocode = new String("promocode=");
	int i = 0;
	int j = 0;
	String value;

	//extract value of aol
	try{
	  int aolLength = aol.length();
	  i = s.indexOf(aol);
	  i = i + aolLength; 
	  j = s.indexOf('&',i);
	  value = s.substring(i,j);
	  System.out.println("***** value of aol = " + value);
	  valueArray[1] = value;
	}catch (StringIndexOutOfBoundsException e){
	  System.out.println("value of i = " + i);
	  e.printStackTrace();
	}
	
	


	//extract value of promocode
	i = 0;
	j = 0;

	//extract value of promocode
	try{
          int promoLength = promocode.length();
	  i = s.indexOf(promocode);
	  i = i + promoLength; 
	  j = s.indexOf('&',i);
	  value = s.substring(i,j);
	  System.out.println("***** value of promocode = " + value);
	  valueArray[2] = value;
	}catch (StringIndexOutOfBoundsException e){
	  System.out.println("value of i = " + i);
	  e.printStackTrace();
	}

  } //populateVariables


  protected StringBuffer arrayToString(String [] valueArray)
  {
 	//convert the String array to a String
	int i;
	for (i = 0; i < valueArray.length; i++)
	{
		if (valueArray[i] == null ) {
		  break;
		}
	}

	int length = i - 1;
	StringBuffer valueString = new StringBuffer(length);

	for (i = 0; i < length; i++)
	{
		if (valueString.capacity() > 0){
		  valueString.append(valueArray[i]);
		  valueString.append("|");
		}else{
		  System.out.println("ran out of StringBuffer capacity at i = " + i);
		  break;
		}

	}

	return valueString;

  }


}//class
