// js document

var _profile_name;
var _report_name;
var _report_elements; // array of all report-elements in a report

// sort
var _active_sort_by = new Array();
var _active_sort_direction = new Array();

// zoom;
var _zoom_is_active;
var _sub_zoom_is_active;
var _zoom_db = new Array;; // zoom_field_name and zoom_value pairs

// date time
var _data_time_exists;
var _date_time_filter_type;
var _date_time_filter_value;

// global filter
var _global_filter_is_active;

// session page paths
var _session_page_paths_is_active;
var _page_paths_page;
var _page_paths_page_is_empty_msg;

// session page paths, values assigned in body of session page paths report
var _page_names_lookup_path;
var _max_text_length_in_page_names_lookup_list;
var _max_number_of_rows_in_page_names_lookup_list;
var _number_of_pages_in_page_names_lookup;
var _number_of_pages_in_page_names_lookup_search_result;
var _page_names_lookup_search_is_active;
var _loading_data_info;
var _no_pages_found_info;

// row numbers
var _invalid_start_row_msg;
var _row_number_list_sequence;

window.onload = init_system;

function init_system() {
	
	// alert(get_user_agent());
	
	if (window.name == 'main_frame') {
		
		// alert('window is main_frame');
		
		// Show reports toolbar in top_frame
		var reports_toolbar = parent.top_frame.document.getElementById('reports_toolbar');
		var reports_toolbar_right = parent.top_frame.document.getElementById('reports_toolbar_right');
		
		if (reports_toolbar != null) {
			
			// enables/disables calendar button and date range button 
			
			parent.top_frame.set_date_time_button_state();
	
			reports_toolbar.style.display = 'block';
			
			if (reports_toolbar_right != null) {
			
				reports_toolbar_right.style.display = 'block';
			}
		}
		
		// Session page paths only
		var page_names_lookup = document.getElementById('page_names_lookup');
		if (page_names_lookup != null) {
			set_page_names_lookup_button_state();
		}
	}
	else if (window.name == 'print_report') {
		
		// printer friendly - report is displayed in new window
		
		// alert('window is print_report');
		
		// hide specific elements
		
		var elements = ['zoom_other_report_list_row', 'filter_on_off_section'];
		
		for (var i = 0; i < elements.length; i++) {
			
			var element = document.getElementById(elements[i]);
			
			if (element) {
				
				element.style.display = 'none';
			}
		}
		
		// disable links
		
		var links = document.getElementsByTagName('a');
		
		for (var i = 0; i < links.length; i++) {
			
			if (links[i].target == '_blank') {
				
				// this is a page link, hide it
				
				links[i].style.display = 'none';
			}
			else {
				links[i].onclick = null;
				links[i].style.color = 'Black';
			}
		}
		
		// disable and input fields and select boxes
		
		var input_fields = document.getElementsByTagName('input');
		for (var i = 0; i < input_fields.length; i++) {
			input_fields[i].disabled = true;
		}
		
		var select_boxes = document.getElementsByTagName('select');
		for (var i = 0; i < select_boxes.length; i++) {
			select_boxes[i].disabled = true;
		}
	}
}

function init_events_xhtml_doc() {
	
	// don't remove this function (function can be empty)! Function is invoced via util.js!
}

// ==============
// Request report
// ==============

function request_report() {
	
	// loads a new report via POST
	
	var sys_form = document.getElementById('sys_form');
	var url = '?p+' + _profile_name + '+dp+templates.statistics.report';
	sys_form.action = url;
	
	parent.hide_report();

	// populate sys_form
	
	new_hfe('volatile.sys.report_name', _report_name);
	
	new_hfe('volatile.sys.date_time_filter_type', _date_time_filter_type);
	new_hfe('volatile.sys.date_time_filter_value', _date_time_filter_value);
	
	new_hfe('volatile.sys.global_filter_is_active', _global_filter_is_active);
	
	new_hfe('volatile.sys.zoom_is_active', _zoom_is_active);
	
	// alert('_zoom_db.length: ' + _zoom_db.length + '\n_zoom_is_active: ' + _zoom_is_active);
	
	if (_zoom_is_active && (_zoom_db.length > 0)) {
		
		for (var i = 0; i < _zoom_db.length; i++) {
			
			// alert('adding value to _zoom_db');
			
			var zoom_field = _zoom_db[i].name;
			var zoom_value = _zoom_db[i].value;
			
			new_hfe('volatile.sys.zoom_fields.' + zoom_field, zoom_value);
		}
	}
	
	if (_session_page_paths_is_active) {
		
		new_hfe('volatile.sys.session_page_paths_is_active', true);
	}
	
	sys_form.submit();
}

// ==============
// Refresh report
// ==============

function refresh_report() {
	
	var date_filter_button = document.getElementById('date_filter_button');
	var global_filter_button = document.getElementById('global_filter_button');
	
	if (!date_filter_button.checked) {
		_date_time_filter_type = 'none';
		_date_time_filter_value = '';
	}
	
	// Note, the global_filter_buttonin does not exist in the Lite version!
	
	_global_filter_is_active = false;
	
	if (global_filter_button != null) {
		
		_global_filter_is_active = global_filter_button.checked;
	}
	
	reset_sys_form();
	new_hfe('volatile.sys.reset_row_numbers', true);
	request_report();
}

// =========
// Date/Time
// =========

function set_filter_date_time(date_time) {
	
	// alert("date_time: " + date_time);
	
	reset_sys_form();
	
	_date_time_filter_type = 'date_time';
	_date_time_filter_value = date_time;
	
	new_hfe('volatile.sys.reset_row_numbers', true);
	
	request_report();
}

function set_filter_date_time_range(date_time_range) {
	
	// alert("range: " + date_time_range);
	
	reset_sys_form();
	
	_date_time_filter_type = 'date_time_range';
	_date_time_filter_value = date_time_range;
	
	new_hfe('volatile.sys.reset_row_numbers', true);
	
	request_report();
}

function clear_date_time_filter() {
	
	reset_sys_form();
	
	_date_time_filter_type = 'none';
	_date_time_filter_value = '';
	
	new_hfe('volatile.sys.reset_row_numbers', true);
	
	request_report();
}

// =============
// Global filter
// =============

function set_global_filter(global_filter_is_active) {
	
	// if no filter is active within the filter editor
	// then global_filter_is_active is set to false!
	
	reset_sys_form();
	_global_filter_is_active = global_filter_is_active;
	new_hfe('volatile.sys.reset_row_numbers', true);
	request_report();
}

// ==========
// Zoom
// ==========


function zoom(report_element_id, zoom_field, zoom_value, sub_zoom_field, sub_zoom_value) {
	
	var default_report_on_zoom = get_default_report_on_zoom(report_element_id);
	
	var zoom_in_hierarchy = (_report_name == default_report_on_zoom) ? true : false;
	
	_zoom_is_active = true;
	_report_name = default_report_on_zoom;
	
	reset_sys_form();
	
	new_hfe('volatile.sys.new_zoom', true);
	new_hfe('volatile.sys.new_zoom_field', zoom_field);
	new_hfe('volatile.sys.new_zoom_value', zoom_value);
	new_hfe('volatile.sys.zoom_in_hierarchy', zoom_in_hierarchy);
	
	new_hfe('volatile.sys.reset_row_numbers', true);
	
	// sub_zoom_field and sub_zoom_value are only available if zoom
	// is initiated from sub_tables (break down tables)
	// or from Individual Sessions report
	
	if (sub_zoom_field != null) {
		
		new_hfe('volatile.sys.sub_zoom_is_active', true);
		new_hfe('volatile.sys.new_sub_zoom_field', sub_zoom_field);
		new_hfe('volatile.sys.new_sub_zoom_value', sub_zoom_value);
	}
	
	request_report();
}

function zoom_other_report(dat) {
	
	if (dat.value != 'none') {
	
		_report_name = dat.value;
		reset_sys_form();
		new_hfe('volatile.sys.reset_row_numbers', true);
		request_report();
	}
}

function get_default_report_on_zoom(report_element_id) {

	var element = document.getElementById('default_report_on_zoom_list_' + report_element_id);

	// if already in zoom then get the default_report_on_zoom
	// from the zoom_other_report_list

	// alert('OK 2:' + element);

	if (element == null) {
		element = document.getElementById('zoom_other_report_list');
	}

	// alert('OK 3:' + element);

	var i = (element.selectedIndex == -1) ? 0 : element.selectedIndex;
	var default_report_on_zoom = element.options[i].value;
	return default_report_on_zoom;
}

// ===========
// Row numbers
// ===========

function set_row_numbers(report_element_id, starting_row, ending_row) {
	
	var report_element_name = _report_elements[report_element_id];

	reset_sys_form();
	
	new_hfe('volatile.sys.report_element_name', report_element_name);
	new_hfe('volatile.sys.starting_row', starting_row);
	new_hfe('volatile.sys.ending_row', ending_row);
	
	request_report();
}

function set_row_numbers_by_list(report_element_id, number_of_total_rows, dat) {
	
	var row_number_list = document.getElementById('row_number_list_' + report_element_id);
    var report_element_name = _report_elements[report_element_id];
    var selected_rows = parseInt(dat.value);
    var starting_row = get_starting_row(report_element_id);
	var ending_row;
	var set_rows_per_report_element = true;
		
	row_number_list.options[0].selected = true;
		
	if (validate_starting_row(starting_row, number_of_total_rows)) {
		
		ending_row = (starting_row + selected_rows) - 1;
		
		if (ending_row > number_of_total_rows) {
			ending_row = number_of_total_rows
		}		
			
		reset_sys_form();
		
		new_hfe('volatile.sys.report_element_name', report_element_name);
		new_hfe('volatile.sys.starting_row', starting_row);
		new_hfe('volatile.sys.ending_row', ending_row);
		
		if (selected_rows == number_of_total_rows) {
			
			// set rows_per_report_element to sequence value prior the total rows
			// except if total rows is euqal a regular row interval value, i.e. 10, 20, 50, 100, etc.
			
			modify_selected_rows = true;
			
			for (var i = 0; i < _row_number_list_sequence.length; i++) {
				
				if (_row_number_list_sequence[i] == number_of_total_rows) {
					modify_selected_rows = false;
				}
			}
			
			if (modify_selected_rows) {
				
				for (var i = _row_number_list_sequence.length - 1; i > 0; i--) {
					
					if (_row_number_list_sequence[i] < number_of_total_rows) {
						
						selected_rows = _row_number_list_sequence[i];
						break;
					}
				}
			}
		}
		
		new_hfe('volatile.sys.rows_per_report_element', selected_rows);
		
		request_report();
	}
}

function set_row_numbers_via_enter_key(event, report_element_id, number_of_total_rows, rows_per_report_element) {
	
	var key_code = (event.which) ? event.which : event.keyCode;
	
	// alert(key_code);

	if (key_code == 13 || key_code == 3) {
		
		var starting_row = get_starting_row(report_element_id);
		
		if (validate_starting_row(starting_row, number_of_total_rows)) {
			
			var ending_row = (starting_row + rows_per_report_element) - 1;
			
			if (ending_row > number_of_total_rows) {
				ending_row = number_of_total_rows;
			}
		
			set_row_numbers(report_element_id, starting_row, ending_row)
		}
	}
}

function get_starting_row(report_element_id) {
	   
	var starting_row = strip_whitespace(document.getElementById('starting_row:' + report_element_id).value);
	
	if (starting_row != '') {
		
		if (value_is_integer(starting_row)) {
			starting_row = parseInt(starting_row);
		}
		else {
			starting_row = 0;
		}
	}
	else {
		starting_row = 0;
	}
	
	return starting_row;
}

function validate_starting_row(starting_row, number_of_total_rows) {
	
	if (starting_row > 0 && starting_row <= number_of_total_rows) {
		
		return true;
	}
	else {
		var msg = _invalid_start_row_msg.replace(/_TOTAL_ROWS_/, number_of_total_rows);
		alert(msg);
		return false;
	}
}


// ============
// Sort columns
// ============

function set_sort_column(report_element_id, sort_by) {
	
      // alert('active sort by: ' + active_sort_by + '\n active sort direction: ' + active_sort_direction);
    var report_element_name = _report_elements[report_element_id];
	var sort_direction = 'descending'; // default sort direction
	
	
	if (sort_by == _active_sort_by[report_element_id]) {
		if (_active_sort_direction[report_element_id] == 'descending') {
			sort_direction = 'ascending';
		}
	}
	
	reset_sys_form();
	
	new_hfe('volatile.sys.report_element_name', report_element_name);
	new_hfe('volatile.sys.sort_by', sort_by);
	new_hfe('volatile.sys.sort_direction', sort_direction);
	
	request_report();
}

// ========================================
// Paths through a page, session page paths
// ========================================

function get_page_paths_string() {
	
	var page_paths_page_string = 'volatile.page_paths_name+' + _page_paths_page;
	return page_paths_page_string;
}

function set_page_name(report_element_id, page_name, dat) {
	
	// invoked from "paths through a page report" via page link
	// or via set_page_paths_input

	// convert display "/ (default)" to internal "/{default}" presentation
	page_name = page_name.replace('/ (default)', '/{default}');
	
	// page_name = page_name.replace('\$', '__HexEsc__24'); KHP 26 Oct 2006
	page_name = page_name.replace(/\$/g, '__HexEsc__24');

	// alert('page_name: ' + page_name);
	
	var report_element_name = _report_elements[report_element_id];
	
	reset_sys_form();
	
	new_hfe('volatile.sys.report_element_name', report_element_name);
	
	new_hfe('volatile.sys.session_page_paths_page', page_name);
	new_hfe('volatile.sys.page_names_lookup_search_is_active', _page_names_lookup_search_is_active);
	
	if (dat != null) {
		var number_of_rows = dat.value;
		var row_number_list_element = document.getElementById('session_page_paths_row_numbers_list');
		new_hfe('volatile.sys.session_page_paths_number_of_rows', number_of_rows);
		
		row_number_list_element.options[0].selected = true;
	}
	
	request_report();
}

function set_page_name_via_input(report_element_id) {
	
	// invoked from "paths through a page report" via input
	var page_name = strip_whitespace(document.getElementById('page_name').value);

	// check if a page name is defined
	if (value_is_not_empty_msg(page_name, _page_paths_page_is_empty_msg)) {
		set_page_name(report_element_id, page_name);
	}
}

function set_page_name_via_enter_key(report_element_id, event) {
	
	// invoked from "paths through a page report"
	var key_code = (event.which) ? event.which : event.keyCode;

	if (key_code == 13 || key_code == 3) {
		set_page_name_via_input(report_element_id);
	}
}

function set_page_name_via_lookup() {
	
	// inserts page_name from lookup into page name field
	var page_name_element = document.getElementById('page_name');
	var page_names_lookup_list = document.getElementById('page_names_lookup_list');
	var i = page_names_lookup_list.selectedIndex;
	
	page_name_element.value = page_names_lookup_list.options[i].value;
}

function lookup_page_names() {
	
	// invoked by setting the row numbers in page names lookup listbox
	var page_names_lookup_list = document.getElementById('page_names_lookup_list');
	var rows_list = document.getElementById('page_names_row_list');
	var i = rows_list.selectedIndex;
	var row_range = rows_list.options[i].value; // i.e. 501-1000
	row_range = row_range.split('-');
	
	var url = '?dp+templates.statistics.report_elements.util.session_page_paths.lookup_page_names';
	url += '+volatile.page_names_lookup_path+' + _page_names_lookup_path;
	url += '+volatile.start_row+' + row_range[0];
	url += '+volatile.end_row+' + row_range[1];
	url += '+volatile.search_is_active+' + _page_names_lookup_search_is_active;
	
	set_page_names_lookup_button_state();
	dim_page_names_lookup_list();
	
	// clear any previous _page_names_lookup_list response values
	// _page_names_lookup_list = null;
	// _page_names_lookup_list = xmlhttp_call(url, lookup_page_names_response);
	
	return call_to_server(url);
}

function look_up_page_names_by_back_next_btn(direction) {
	
	var rows_list = document.getElementById('page_names_row_list');
	var i = rows_list.selectedIndex;
	
	if (direction == 'next') {
		rows_list.options[i+1].selected = true;
		lookup_page_names();
	}
	else {
		rows_list.options[i-1].selected = true;
		lookup_page_names();
	}
	
	set_page_names_lookup_button_state();
}

function server_response_lookup_page_names(dat) {
	
	// alert('server_response_lookup_page_names');

	build_page_names_lookup_list(dat);
}

function set_page_names_lookup_button_state() {
	
	var page_names_lookup_show_all_btn = document.getElementById('page_names_lookup_show_all_btn'); // Clears search result
	var page_names_lookup_back_btn = document.getElementById('page_names_lookup_back_btn');
	var page_names_lookup_next_btn = document.getElementById('page_names_lookup_next_btn');
	var page_names_row_list = document.getElementById('page_names_row_list');
	var i = page_names_row_list.selectedIndex;
	
	if (page_names_row_list.length <= 1) {
		page_names_lookup_back_btn.disabled = true;
		page_names_lookup_next_btn.disabled = true;
	}
	else {
		if (i == 0) {
			page_names_lookup_back_btn.disabled = true;
			page_names_lookup_next_btn.disabled = false;
		}
		else if (i == page_names_row_list.length - 1) {
			page_names_lookup_back_btn.disabled = false;
			page_names_lookup_next_btn.disabled = true;
		}
		else {
			page_names_lookup_back_btn.disabled = false;
			page_names_lookup_next_btn.disabled = false;
		}
	}
	
	if (_page_names_lookup_search_is_active) {
		page_names_lookup_show_all_btn.disabled = false;
	}
	else {
		page_names_lookup_show_all_btn.disabled = true;
	}
}

function dim_page_names_lookup_list() {
	
	// Clear and disable page_names_lookup_list and show "loading"
	var page_names_lookup_list = document.getElementById('page_names_lookup_list');
	
	page_names_lookup_list.options.length = 0;
	page_names_lookup_list.options[0] = new Option(_loading_data_info, '', false, false);
	page_names_lookup_list.disabled = true;
}

function build_page_names_lookup_list(dat) {
	
	var page_names_lookup_list = document.getElementById('page_names_lookup_list');
	
	page_names_lookup_list.options.length = 0;
	
	for (var i = 0; i < dat.length; i++) {
		var page_name = dat[i];
		var page_name_short = page_name;
		
		if (page_name.length > _max_text_length_in_page_names_lookup_list) {
			page_name_short = page_name.substring(0, _max_text_length_in_page_names_lookup_list);
		}
		
		page_names_lookup_list.options[i] = new Option(page_name_short, page_name, false, false);
	}
	page_names_lookup_list.disabled = false;
}

function search_page_names() {
	
	var search_string = strip_whitespace(document.getElementById('page_names_lookup_search_string').value);
	
	if (value_is_not_empty(search_string)) {
	
		var url = '?dp+templates.statistics.report_elements.util.session_page_paths.search_page_names';
		url += '+volatile.page_names_lookup_path+' + _page_names_lookup_path;
		url += '+volatile.search_string+' + search_string;
		url += '+volatile.max_number_of_rows_in_page_names_lookup_list+' + _max_number_of_rows_in_page_names_lookup_list;
		
		dim_page_names_lookup_list();
		_page_names_lookup_search_is_active = true;
		
		return call_to_server(url);
	}
}

function search_page_names_via_enter_key(event) {
	
	// invoked from "paths through a page report"
	var key_code = (event.which) ? event.which : event.keyCode;

	if (key_code == 13 || key_code == 3) {
		search_page_names();
	}
}

function server_response_search_page_names(dat) {
	
	// alert('server_response_search_page_names');
	
	_number_of_pages_in_page_names_lookup_search_result = dat.page_count;
	
	if (_number_of_pages_in_page_names_lookup_search_result > 0) {
		
		set_page_names_lookup_label(_number_of_pages_in_page_names_lookup_search_result);
		rebuild_page_names_row_list(_number_of_pages_in_page_names_lookup_search_result);		
		build_page_names_lookup_list(dat.pages);
	}
	else {
		var page_names_lookup_list = document.getElementById('page_names_lookup_list');
		
		set_page_names_lookup_label(_number_of_pages_in_page_names_lookup_search_result);
		rebuild_page_names_row_list(_number_of_pages_in_page_names_lookup_search_result);
		
		page_names_lookup_list.options[0] = new Option(_no_pages_found_info, '0', false, false);
	}
}

function clear_page_names_search_result() {
	
	_page_names_lookup_search_is_active = false;
	
	var search_string_element = document.getElementById('page_names_lookup_search_string');
	search_string_element.value = "";
	set_page_names_lookup_label(_number_of_pages_in_page_names_lookup);
	rebuild_page_names_row_list(_number_of_pages_in_page_names_lookup);
	lookup_page_names();
}

function toggle_page_names_lookup() {
	
	var page_names_lookup = document.getElementById('page_names_lookup');
	var page_names_lookup_search = document.getElementById('page_names_lookup_search');
	
	if (page_names_lookup.style.display == 'none') {
		page_names_lookup.style.display = 'block';
		page_names_lookup_search.style.display = 'block';
	}
	else {
		page_names_lookup.style.display = 'none';
		page_names_lookup_search.style.display = 'none';
	}
}

function set_page_names_lookup_label(lookup_total_rows) {
	
	var page_names_lookup_label = document.getElementById('page_names_lookup_label');
	var page_names_lookup_search_result_label = document.getElementById('page_names_lookup_search_result_label');
	var page_names_lookup_total_rows_label = document.getElementById('page_names_lookup_total_rows_label');
	
	if (_page_names_lookup_search_is_active) {
		page_names_lookup_label.style.display = 'none';
		page_names_lookup_search_result_label.style.display = 'block';
	}
	else {
		page_names_lookup_search_result_label.style.display = 'none';
		page_names_lookup_label.style.display = 'block';
	}
	
	var total_rows_old = page_names_lookup_total_rows_label.firstChild;
	var total_rows_new = document.createTextNode(lookup_total_rows);
	page_names_lookup_total_rows_label.replaceChild(total_rows_new, total_rows_old);
}

function rebuild_page_names_row_list(lookup_total_rows) {
	
	var page_names_rows_list = document.getElementById('page_names_row_list');
	var list_range_start = 1;
	var list_range_end;
	var continue_row_range = true;
	var count = 1;
	var list_range_value;
	var list_range_text;
	
	page_names_rows_list.options.length = 0;
	
	if (lookup_total_rows >= 2) {
		while (continue_row_range) {
		
			list_range_end = _max_number_of_rows_in_page_names_lookup_list * count;
			
			if (list_range_end >= lookup_total_rows) {
				list_range_end = lookup_total_rows;
				continue_row_range = false;
			}
			
			list_range_value = list_range_start + '-' + list_range_end;
			list_range_text = list_range_start + ' - ' + list_range_end;
			
			var selected = (count == 1) ? true : false;
						
			page_names_rows_list.options[count - 1] = new Option(list_range_text, list_range_value, false, selected);
			
			list_range_start = list_range_end + 1;
		
			count++;
		}
	}
	else if (lookup_total_rows == 1) {
		page_names_rows_list.options[0] = new Option('1', '1', false, true);
	}
	else {
		page_names_rows_list.options[0] = new Option('0', '0', false, true);
	}
	
	set_page_names_lookup_button_state();
}

// =============
// Session paths
// =============

function set_session_path(report_element_id, session_path_num, session_path_flag) {
	
	var report_element_name = _report_elements[report_element_id];
	var max_rows_on_expand = get_max_rows_on_expand();
	
	// alert(session_path_num + session_path_flag);
	
	reset_sys_form();
	
	new_hfe('volatile.sys.report_element_name', report_element_name);
	new_hfe('volatile.sys.session_path_num', session_path_num);
	new_hfe('volatile.sys.session_path_flag', session_path_flag);
	new_hfe('volatile.sys.max_rows_on_expand', max_rows_on_expand);
	
	request_report();
}

function reset_session_paths(report_element_id) {
	
	var report_element_name = _report_elements[report_element_id];
	var max_rows_on_expand = get_max_rows_on_expand();
	
	reset_sys_form();
	
	new_hfe('volatile.sys.report_element_name', report_element_name);
	new_hfe('volatile.sys.reset_session_paths', true);
	new_hfe('volatile.sys.max_rows_on_expand', max_rows_on_expand);
	
	request_report();
}

function set_session_path_rows(report_element_id, master_node_path, rows_displayed, total_rows) {
	
	var report_element_name = _report_elements[report_element_id];
	var max_rows_on_expand = get_max_rows_on_expand();
	var rows_to_display = rows_displayed + max_rows_on_expand;
	
	// alert(rows_to_display);
	
	if (rows_to_display > total_rows) {
		rows_to_display = total_rows;
	}
	
	reset_sys_form();
	
	new_hfe('volatile.sys.session_path', master_node_path);
	new_hfe('volatile.sys.session_path_rows_to_display', rows_to_display);
	new_hfe('volatile.sys.max_rows_on_expand', max_rows_on_expand);
	
	request_report();
}

function get_max_rows_on_expand() {
	
	var element = document.getElementById('max_rows_on_expand_list');
	var i = (element.selectedIndex == -1) ? 0 : element.selectedIndex;
	return parseInt(element.options[i].value);
}

// ======
// Export
// ======

function open_export_form(report_element_name) {

	var width = 600;
    var height = 400;
	var window_name = 'export_form'
	var url = '?dp+templates.statistics.report_export_startup_window';
	url += '+p+' + _profile_name;
	url += '+volatile.report_element_name+' + report_element_name;

	var left = parseInt((screen.availWidth/2) - (width/2));
    var top = parseInt((screen.availHeight/2) - (height/2));
	export_window = window.open(url,window_name,'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',status=yes,scrollbars=yes,resizable=yes');
    export_window.focus();
}

// =============
// Table options
// =============

function set_table_options() {
	
	// reset row numbers required because
	// number of total rows may change when setting
	// only_bottom_level_items or omit_parenthesized_items
	
	reset_sys_form();	
	new_hfe('volatile.sys.reset_row_numbers', true);
	request_report();
}

function open_table_options_form(report, report_element) {

	var width = 600;
    var height = 400;
	var window_name = 'table_options_form'
	var url = '?dp+templates.statistics.table_options.table_options_form';
	url += '+p+' + _profile_name;
	url += '+volatile.report+' + report;
	url += '+volatile.report_element+' + report_element;
	// alert(url);
	
	open_form_window(url, window_name, width, height);
}

// ===============
// Misc. Utilities
// ===============

function check_form_values() {
	
	// temp function only
	
	var sys_form = document.getElementById('sys_form');
	
	var y = 'form values\n';
		
	for (var i = 0; i < sys_form.length; i++) {
		
		var name = sys_form[i].name;
		var value = sys_form[i].value;
		
		y += name + ', ' + value + '\n';
	}
	
	alert(y);
}

function reset_sys_form() {
	
	// cleans up sys_form from any previous values
	
	var sys_form = document.getElementById('sys_form');
	
	if (sys_form.length > 0) {
		while (sys_form.lastChild != null) {
			var form_field = sys_form.lastChild;
			sys_form.removeChild(form_field);
		}
	}
}

function set_table_tab(tab_id) {
	
	var dat = tab_id.split(':');
	var tab = dat[0];
	var report_element_id = dat[1];

	// alert(dat);
	var row_numbers_tab = document.getElementById('row_numbers_tab:' + report_element_id);
	var zoom_options_tab = document.getElementById('zoom_options_tab:' + report_element_id);
	var row_numbers_bar = document.getElementById('row_numbers_bar:' + report_element_id);
	var zoom_options_bar = document.getElementById('zoom_options_bar:' + report_element_id);

	if (tab == 'row_numbers_tab') {
		if (row_numbers_tab.style.display != 'block') {
			zoom_options_tab.className = 'table-tab-off';
			row_numbers_tab.className = 'table-tab-on';
			zoom_options_bar.style.display = 'none';
			row_numbers_bar.style.display = 'block';
		}
	}
	else {
		if (zoom_options_tab.style.display != 'block') {
			row_numbers_tab.className = 'table-tab-off';
			zoom_options_tab.className = 'table-tab-on';
			row_numbers_bar.style.display = 'none';
			zoom_options_bar.style.display = 'block';
		}
	}
}

function reload_report() {
	var url = window.location.href;
	// alert(url);
	location.replace(url);
}

function new_hfe(name, value) { // new hidden form element
	var sys_form = document.getElementById('sys_form');
	new_element = document.createElement('input');
	new_element.type = 'hidden';
	new_element.name = name;
	new_element.value = value;
	sys_form.appendChild(new_element);
}
