Imports System
Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports Microsoft.VisualBasic
Imports System.Text.RegularExpressions
Imports System.IO

Public Class TCPSrv

    Public Overloads Shared Sub Main()
       StartListening()
    End Sub

    ' Incoming data from the client.
    Public data As String = Nothing


    Public Shared Sub StartListening()
        ' Data buffer for incoming data.
        Dim bytes() As Byte = New [Byte](1024) {}

        ' Establish the local endpoint for the socket.
        ' Dns.GetHostName returns the name of the 
        ' host running the application.
        Dim ipHostInfo As IPHostEntry = Dns.Resolve(Dns.GetHostName())
        Dim ipAddress As IPAddress = ipHostInfo.AddressList(0)
        Dim localEndPoint As New IPEndPoint(ipAddress, 8100)

        ' Create a TCP/IP socket.
        Dim listener As New Socket(AddressFamily.InterNetwork, _
            SocketType.Stream, ProtocolType.Tcp)

        ' Bind the socket to the local endpoint and 
        ' listen for incoming connections.
        Try
            listener.Bind(localEndPoint)
            listener.Listen(10)

            ' Start listening for connections.
            While True
                ' Program is suspended while waiting for an incoming connection.
                Dim handler As Socket = listener.Accept()

                Dim Status As Boolean = True
                Dim Header As Boolean = True
                Dim intCounter1 As Integer
                intCounter1 = 0
                Dim servermessage As String = Nothing
                Dim clientmessage As String = Nothing
                Dim NetworkStream As NetworkStream
                NetworkStream = New NetworkStream(handler)
                Dim streamWriter As StreamWriter
                streamWriter = New StreamWriter(NetworkStream)
                Dim streamReader As StreamReader
                streamReader = New StreamReader(NetworkStream)
                Dim strPage As String

                Do While (Status)
                    'If there is still a connection, read the data
                    If handler.Connected Then
                        servermessage = streamReader.ReadLine()
                        If servermessage = "***END***" Then 'If we receive the close connection statement
                            Status = False
                            Exit Do
                        End If
                        If Header = False Then
                            'Make sure that we are processing text\html
                            If InStr(UCase(servermessage), "|HTM|") > 0 Or InStr(UCase(servermessage), "|HTML|") > 0 _
                            Or InStr(UCase(servermessage), "|ASP|") > 0 Then
                                Dim arrData As String()
                                'Split the data into an array
                                arrData = Split(servermessage, "|", , CompareMethod.Text)
                                'We know where the page URL is in the data because we found the title in the header.
                                strPage = arrData(intCounter1)
                                Dim strUrl As String
                                strUrl = "http://serverurl"
                                strUrl = strUrl & strPage
                                Dim wrGeturl As WebRequest
                                wrGeturl = WebRequest.Create(strUrl)
                                Dim objStream As Stream
                                'Do an HTTP Request
                                objStream = wrGeturl.GetResponse().GetResponseStream()
                                Dim objReader As StreamReader
                                objReader = New StreamReader(objStream)
                                Dim strLine As String
                                strLine = ""
                                'Wait for a response
                                strLine = objReader.ReadToEnd
                                objReader.Close()
                                objStream.Close()
                                'Look for the <title> tag in the response and parse it out
                                Dim regexp As Regex = New Regex("<title>((.|\n)*?)</title>", RegexOptions.IgnoreCase)
                                Dim objMatch As Match
                                Dim strTitle As String

                                strTitle = (regexp.Match(strLine)).ToString()
                                strTitle = Trim(Replace(Mid(strTitle, 8), "</title>", "", 1, 1, 1))
                                clientmessage = servermessage.Replace(strPage, strTitle)
                                'Replace the URL in the original packet with the title and return it to sawmill
                                streamWriter.WriteLine(clientmessage)
                                streamWriter.Flush()
                            Else
                                'This is not text\html so don't process it.  Just return the header as is.
                                streamWriter.WriteLine(clientmessage)
                                streamWriter.Flush()
                            End If

                        End If
                        'The first packet is always the header titles so process it first
                        If Header = True Then
                            Dim arrHeader As String()
                            arrHeader = Split(servermessage, "|", , CompareMethod.Text)
                            'Find which position in the array is the page URL and store it
                            For intCounter1 = 0 To UBound(arrHeader)
                                If arrHeader(intCounter1) = "page" Then
                                    Header = False
                                    Exit For
                                End If
                            Next
                        End If
                    End If
                    streamWriter.Flush()
                Loop
                handler.Shutdown(SocketShutdown.Both)
                handler.Close()
            End While

        Catch e As Exception
            Console.WriteLine(e.ToString())
            listener.Close()
            StartListening()
        End Try
    End Sub
End Class

