' ***********************************************************************
' Sawmill Active Directory Authentication - see comments thruout the
'	script for documentation on what is happening
'	K. Bryant July 30 2007
'	v 1.7
'
'For AD authentication, put this in preferences.cfg (update path as needed)
'   authentication_command_line = "cscript /nologo D:\\WebAnalytics-Scripts\\WailogWindows\\SawmillADAuthenticate.vbs"
'
' ***********************************************************************
' *** If authentication fails then Sawmill wants to see this literal: ***
' ***		*FAILED*					      ***
' *** If authentication OK then Sawmill wants to see either literal:  ***
' ***		*ADMIN*	   if you want the user to be a Sawmill admin ***
' *** 	       OR 						      ***
' ***		a list of Sawmill profiles to assign to the user      ***
' ***   	note: profiles must be listed 1 profile per line to STDOUT   ***
' ***********************************************************************

On Error Resume Next

Dim dso 'As IADsOpenDSObject
Dim obj1, obj2 'As IADs
Dim adUname 'As String
Dim domain     'As String
Dim username     'As String
Dim szPassword 'As String

Const ADS_SECURE_AUTHENTICATION = 1
Const ADS_USE_ENCRYPTION = 2

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
' Some debugging code to write output to file
'Const ForWriting = 2										'these lines are for debugging
'set objNTFS = Wscript.CreateObject("Scripting.FileSystemObject")				'these lines are for debugging
'set objTextOut = objNTFS.CreateTextFile("C:\Temp\@testSawP\SawMillADAuthenticate.txt", ForWriting)	'these lines are for debugging
'set objTextOut = objNTFS.CreateTextFile("D:\WebAnalytics-Scripts\WailogWindows\SawMillADAuthenticate.txt", ForWriting)	'these lines are for debugging
'If Err.Number <> 0 Then		' if we cannot create file just clear the error
'	Err.Clear									'these lines are for debugging									'these lines are for debugging
'End If											'these lines are for debugging
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@


' *****************************************************************
' *** Get Sawmill Login username				***
' *** This is passed in by Sawmill login screen as argument 0	***
' *****************************************************************
domain = "MyDomain"					'This is the Active Directory Domain Name  Update as needed!!!

If WScript.Arguments.Length > 2 Then
	Wscript.STDOut.Write "*FAILED*" & vbCRLF
	'objTextOut.WriteLine "Arg length is " & WScript.Arguments.Length 	'these lines are for debugging
	'objTextOut.WriteLine "More than 2 arguments passed"			'these lines are for debugging
	Wscript.Quit
'Else
	'objTextOut.WriteLine " Arg length is " & WScript.Arguments.Length 	'these lines are for debugging
End If

If WScript.Arguments.Length >= 1 Then
	adUname = domain & "\" & Wscript.Arguments(0)	'Prefix username with the AD Domain for authentication
	username = Wscript.Arguments(0)
Else
	Wscript.STDOut.Write "*FAILED*" & vbCRLF
	'objTextOut.WriteLine "No Id Supplied"	'these lines are for debugging
	Wscript.Quit
End If

' *****************************************************************
' *** Get Sawmill Login password				***
' *****************************************************************
If WScript.Arguments.Length = 2 Then
	szPassword = Wscript.Arguments(1)
	szPassword = Replace(szPassword, "__HexEsc__22", chr(34))	' this is passed when users password contains a double quote
Else
	Wscript.STDOut.Write "*FAILED*" & vbCRLF
	'objTextOut.WriteLine "No Password Supplied"		'these lines are for debugging
	Wscript.Quit
End If
'WScript.StdOut.Write "Please enter your password:" 		'these lines are for debugging
'Set objPassword = CreateObject("ScriptPW.Password")		'these lines are for debugging
'szPassword = objPassword.GetPassword()				'these lines are for debugging

'objTextOut.WriteLine adUname & " " & szPassword			'these lines are for debugging	
'objTextOut.WriteLine " Error state after getting id and pswd is " & Err.Number		'these lines are for debugging

' **************************************************************
' *** Verify username and password against Active Directory  ***
' **************************************************************
Err.Clear									'these lines are for debugging									'these lines are for debugging
'objTextOut.WriteLine " Error state before LDAP Call is " & Err.Number	'these lines are for debugging
Set dso = GetObject("LDAP:")

' Securely Authenticate and Encrypt Traffic

Set obj1 = dso.OpenDSObject( _
    "LDAP://DC=xx,DC=yyy,DC=zzz,DC=org", _
    adUname, _
    szPassword, _
    ADS_SECURE_AUTHENTICATION OR ADS_USE_ENCRYPTION)

'objTextOut.WriteLine " Error state after LDAP Call is " & Err.Number		'these lines are for debugging

If Err.Number <> 0 Then
	Wscript.STDOut.Write "*FAILED*" & vbCRLF
	'objTextOut.WriteLine "AD Authentication Failed " & Err.Number		'these lines are for debugging
	Wscript.Quit
Else
	'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	'@@@ This block of code can be used if you desire to read a text file which
	'@@@ contains usernames and associated sawmill profiles rather the querying
	'@@@ Active Directory for group memberships
	'@@@ The text file must be comma delemited formatted like this:
	'@@@	user01,*ADMIN*
	'@@@	user02,sawmill_profile1,sawmill_profile2,sawmill_profile3,etc
	'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	' ************************
	' *** Define Constants ***
	' ************************
	'Const ForReading = 1
	'Const SMUsers = "C:\WebAnalytics-Scripts\WailogWindows\smusers.txt"

	' ***********************************************************************
	' read text file to obtain users Sawmill profiles		      ***
	' ***********************************************************************
	'iIndex = 0
	'Dim objFileSys
	'Set objFileSys = CreateObject("Scripting.FileSystemObject")
	'Set SMFile = objFileSys.OpenTextFile(SMUsers, ForReading)
	'
	'Do While Not SMFile.AtEndOfStream
	'	strCurLine = Trim(SMFile.ReadLine)
	'	arrCurLine = Split(strCurLine,",")
	'	If IsArray(arrCurLine) Then
	'		If username = arrCurLine(0) Then
	'			For iIndex = LBound(arrCurLine) + 1 to UBound(arrCurLine)
	'				Wscript.Echo arrCurLine(iIndex)
	'				Index = iIndex + 1
	'			Next
	'		iIndex = 0
	'		End If
	'	End If
	'Loop
	'
	'SMFile.Close
	'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	'@@@ End of code block for reading text file
	'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	'***************************************************************************************
	'* Look up user name in AD and check for membership in Sawmill groups
	'* If found then 
	'*	print *ADMIN* if user is a member of AD group that is an admin for Sawmill
	'* 	or 
	'*	print AD group names if the name equates to profiles defined in Sawmill
	'*
	'***************************************************************************************
	iAdminFlag = False							' a flag for admin user
	strProfiles = ""							' will hold the list of AD Groups
	iMultiProfiles = False							' a flag for user with more than 1 sawmill profile
								
	Set userObj = GetObject("WinNT://" & domain & "/" & username & ",user")
	'objTextOut.WriteLine "Error state after user object lookup in AD is " & Err.Number		'these lines are for debugging
		If Err.Number <> 0 Then
			Wscript.STDOut.Write "*FAILED*" & vbCRLF		'user not found in AD
			'objTextOut.WriteLine "Failed to get user object in AD"	'these lines are for debugging
			Err.Clear
		Else
			For Each grp In userObj.Groups
			'objTextOut.WriteLine domain & "\" & username & " is a member of " & grp.Name	'these lines are for debugging
				If grp.Name = "SAWMILL-ADMIN1" Then		'consider this AD as group Sawmill Admin
					iAdminFlag = True
				End If				
				If grp.Name = "SAWMILL-ADMIN2"	Then		'consider this AD as group Sawmill Admin
					iAdminFlag = True
				End If	
				If Left(grp.Name, 16) =  "sawmill-profile-" Then	'Sawmill AD Group prefix(the full AD group name must be defined in Sawmill also!)
					If iMultiProfiles = False Then
						strProfiles = grp.Name & vbCRLF
						iMultiProfiles = True		'set this in case we find more
					Else
						strProfiles = grp.Name & vbCRLF & strProfiles
					End If
				End If
			Next

			If strProfiles = "" and iAdminFlag = False Then 
				strProfiles = "sawmill" & vbCRLF		'no matching profiles found
				'objTextOut.WriteLine "No sawmill profiles found - defaulting to profile named sawmill"	'these lines are for debugging
			End If

			If iAdminFlag = True Then
				Wscript.STDOut.Write "*ADMIN*" & vbCRLF		'now write *ADMIN*
				'objTextOut.WriteLine "*ADMIN*" & vbCRLF		' these lines are for debugging
			Else
				Wscript.STDOut.Write strProfiles		'or write list of profiles
				'objTextOut.WriteLine strProfiles		' these lines are for debugging

			End If

		End If
	Set userObj = nothing
End If

'objTextOut.close					' these lines are for debugging
'set objNTFS = nothing					' these lines are for debugging


