#!/usr/local/bin/perl

# Very, very simple test server for Sawmill filter testing.
# Paul Hansen <phansen@800response.com>

use strict;

# This module requires a whole bunch of stuff.
# It looks compatible with most UNIX platforms, not sure about others.
# Documentation is at:
# http://search.cpan.org/doc/CHSTROSS/NetServer-Generic-1.03/Generic.pm
use NetServer::Generic;

# We'll split out stuff on STDERR if the server is started with 
# the argument "debug".

#my $debugging = 1;
my $debugging = 0;

if ($ARGV[0] eq 'debug') {
    $debugging = 1;
    print STDERR "Debugging output is ON.\n";
}

##########################################################################
# A few quick configuration options:

# Input value separator. This is a regexp because I'm using
# Perl's split() function.
my $input_delimiter = '\|';

# Output value separator.
# Perl's join() function uses a string as the delimiter, NOT a regexp.
my $output_delimiter = '|';

# Command when we're done with this filter run.
my $done_cmd = '***END***';

# Local address to bind to.
my $hostname = 'localhost';

# Port we'll listen on.
my $port = 8788;

# Server mode.
# Can be one of forking, select, select_fast, client, threaded, or prefork. 
# "threaded" will probably not work. "select" may block.
my $mode = 'select';

##########################################################################
# Create a little "closure" coderef to handle requests. I suppose
# it's encapsulated this way so it can be passed to forked children, etc.
my $server_cb = sub {

    # The argument to this is the server object.
    my($s) = shift;

    print STDERR "Received client connection, waiting for input.\n"
        if $debugging;

    # Initialize a counter for lines received, so
    # we can properly handle the first line as a fieldlist.
    my $i = 0;

    # Define an array for our field names.
    my @fields = ();

    # We receive all client input on the STDIN handle.
    # so treat it like we're looping through a file.

    # We'll stuff input into the scalar "$input".
    while (defined(my $input = <STDIN>)) {

        # Remove input record separator (probably \n).
        # Or any other stuff at the end of the line.
        $input =~ s/[\r\n]+$//s;

        # print STDERR "INPUT:$input\n" if $debugging;

        # Disconnect the client.
        if ($input eq $done_cmd) {

            print STDERR "Shutting down client connection. Waiting...\n"
                if $debugging;

            return;

        # Shutdown.
        #} elsif ($input =~ /^exit/i) {

        # Disabled for testing; just close it from the controlling
        # terminal or kill it in the process list.

        #    print "Shutting down server.\n";
        #    $s->quit();

        }

        ### Time to handle real input.

        # First line of input from this client--it's a field list.

        if ($i == 0) {

            # That little -1 makes split() return empty values
            # at the end of the array, rather thandrop them.
            @fields = split($input_delimiter, $input, -1);

            if ($debugging) {
                print STDERR "$i\tFields: " . join(',', @fields) . "\n";
            }

        } else {

            my @values = split($input_delimiter, $input, -1);

            if ($debugging) {
                print STDERR "$i\tValues: " . join(',', @values) . "\n";
                print STDERR "\tVariable assignments:\n";
            }

            # Create a little hash so we can reference
            # values by field name.
            my %row = ();

            for (my $f = 0; $f < @fields; $f++) {
                $row{$fields[$f]} = $values[$f];
                print STDERR "\t\t$fields[$f] = $values[$f]\n" if $debugging;
            }

	    $values[5] = "/top" . $values[5];

            # For now, we'll just echo back what we got,
            # after parsing it.

            print STDOUT join($output_delimiter, @values) . "\n";

        }

        # Increment the line counter.
        $i++;

    }

}; # <-- this little semicolon is important to terminate the closure!

print "Initializing server object...\n";

# Create an instance of the server class.
my ($server) = new NetServer::Generic;

# Initialize server properties.
$server->hostname($hostname);
$server->port($port);
$server->callback($server_cb);
$server->mode($mode);

print "Starting server...\n";
$server->run();
