
// Reports Editor

function h(name) {
	// converts hash value to uppercase
	return name.toUpperCase();
}

function generate_database_fields_hash_table() {
	
	for (i = 0; i < _database_fields.length; i++) {
		
		// use uppercase to avoid "length" name conflicts!
		var name = _database_fields[i].name;
		_database_fields[name.toUpperCase()] = _database_fields[i];
		
		// _database_fields[_database_fields[i].name] = _database_fields[i];
	}
	
	for (i = 0; i < _session_fields.length; i++) {
		// use uppercase to avoid "length" name conflicts!
		var name = _session_fields[i].name;
		_session_fields[name.toUpperCase()] = _session_fields[i];
	}
}

function generate_default_field_arrays() {

	// This arrays are used as default field values when opening the report elements form
	// There are different arrays to avoid any conflicts between different report_element types
	
	// tables
	if (_table_reports_support) {
	
		for (var i = 0; i < _numerical_database_fields.length; i++) {
		
			_default_table_fields[i] = {field_name:_numerical_database_fields[i], show_number_column:true, show_percent_column:false, show_bar_column:false, show_graph:false};
		}
	}
	
	// session pages
	
	if (_session_reports_support) {
	
		_default_entry_exit_pages_fields[0] = {field_name:'page', visible:true};
		_default_entry_exit_pages_fields[1] = {field_name:'sessions', show_number_column:true, show_percent_column:false, show_bar_column:false};
		
		_default_session_pages_fields[0] = {field_name:'page', visible:true};
		_default_session_pages_fields[1] = {field_name:'sessions', show_number_column:true, show_percent_column:false, show_bar_column:false};
		_default_session_pages_fields[2] = {field_name:'events', show_number_column:true, show_percent_column:false, show_bar_column:false};
		_default_session_pages_fields[3] = {field_name:'time_spent', show_number_column:true, show_percent_column:false, show_bar_column:false};

		_default_session_users_fields[0] = {field_name:'user', visible:true};
		_default_session_users_fields[1] = {field_name:'sessions', show_number_column:true, show_percent_column:false, show_bar_column:false};
		_default_session_users_fields[2] = {field_name:'events', show_number_column:true, show_percent_column:false, show_bar_column:false};
		_default_session_users_fields[3] = {field_name:'time_spent', show_number_column:true, show_percent_column:false, show_bar_column:false};
		
		_default_individual_sessions_fields[0] = {field_name:'session_id', visible:true};
		_default_individual_sessions_fields[1] = {field_name:'user', visible:true};
		_default_individual_sessions_fields[2] = {field_name:'events', show_number_column:true, show_percent_column:false, show_bar_column:false};
		_default_individual_sessions_fields[3] = {field_name:'start_time', visible:true};
		_default_individual_sessions_fields[4] = {field_name:'end_time', visible:true};
		_default_individual_sessions_fields[5] = {field_name:'time_spent', show_number_column:true, show_percent_column:false, show_bar_column:false};
	}
	
	// log_detail
	for (var i = 0; i < _log_detail_fields.length; i++) {
		
		var log_detail_field = _log_detail_fields[i];
		var db_field = _database_fields[h(log_detail_field)];
		
		// if (_database_fields[_log_detail_fields[i]].data_type == 'string') {
		if (db_field.data_type == 'string') {
		
			_default_log_detail_fields[i] = {field_name:_log_detail_fields[i], visible:true};
		}
		else {
		
			_default_log_detail_fields[i] = {field_name:_log_detail_fields[i], show_number_column:true, show_percent_column:false, show_bar_column:false};
		}
	}
}

function generate_active_sort_by_data_array() {

	var supported_report_elements = ['table', 'table_with_sub_table', 'entry_pages', 'exit_pages', 'individual_sessions', 'session_pages', 'session_users'];
	
	_active_sort_by_data = new Array();
	
	for (var i = 0; i < supported_report_elements.length; i++) {
		_active_sort_by_data[i] = {report_element_type:supported_report_elements[i], sort_by:'', sort_direction:''};
	}

	// create hash table to access _active_sort_by_data by report_element_type
	for (i = 0; i < _active_sort_by_data.length; i++) {
		var name = _active_sort_by_data[i].report_element_type;
		_active_sort_by_data[name.toUpperCase()] = _active_sort_by_data[i];
	}
}


function build_report_element_list() {

	var container = document.getElementById('report_element_list_container');
	
	// clean up existing list
	var c = container.firstChild;

	if (c != null) {
		container.removeChild(c);
	}
	
	var table_element = document.createElement('table');
	table_element.cellSpacing = 0;
	var tbody_element = document.createElement('tbody');
	// table_element.className = 'report-editor-list-items';
	table_element.appendChild(tbody_element);
	
	if (_report_elements.length > 0) {
		
		for (var i = 0; i < _report_elements.length; i++) {
		
			// --------
			// item row
			// --------
	  
			var row_element = document.createElement('tr');
			
			// ========================================
			// create the report element check-box cell
			// ========================================
						
			var td_element_for_checkbox = document.createElement('td');
			td_element_for_checkbox.style.paddingTop = '4px';
			td_element_for_checkbox.style.paddingBottom = '4px';
			td_element_for_checkbox.style.paddingLeft = '4px';
			td_element_for_checkbox.style.verticalAlign = 'baseline';
			
			var input_element = document.createElement('input');
			input_element.type = 'checkbox';
			
			var checkbox_id = 'report_element_disabled:' + i;
			
			input_element.id = checkbox_id;
			input_element.onclick = set_report_element_disabled;
			
			// Note, we set the checkbox to 'checked' after the table is complete
			// because IE does not check the checkboxes correctly if done at this place	
			
			td_element_for_checkbox.appendChild(input_element);
			row_element.appendChild(td_element_for_checkbox);
			
			// ===================================
			// create the report element text cell
			// ===================================
			
			var td_element_for_text = document.createElement('td');
			td_element_for_text.style.padding = '4px';
			td_element_for_text.style.whiteSpace = 'normal';
			td_element_for_text.style.verticalAlign = 'baseline';
			
			var label_element = document.createElement('label');
			label_element.htmlFor = checkbox_id;
			var label = document.createTextNode(_report_elements[i].label);
			label_element.appendChild(label);
			
			
			td_element_for_text.appendChild(label_element);
			row_element.appendChild(td_element_for_text);
			
			// ================================================
			// create the edit and delete button cell and links
			// ================================================
			
			var td_element_for_links = document.createElement('td');
			td_element_for_links.style.paddingLeft = '18px';
			td_element_for_links.style.paddingTop = '4px';
			td_element_for_links.style.paddingBottom = '4px';
			td_element_for_links.style.paddingRight = '6px';
			td_element_for_links.style.verticalAlign = 'baseline';
			
			// --------------------
			// create the edit link
			// --------------------
			
			var a_elem_for_edit = document.createElement('a');
			var edit_text = document.createTextNode(_edit_label);
			a_elem_for_edit.appendChild(edit_text);
			a_elem_for_edit.id = 'edit_report_element:' + i;
			a_elem_for_edit.href = 'javascript:;';
			a_elem_for_edit.onclick = edit_report_element;
					
			td_element_for_links.appendChild(a_elem_for_edit);
	
			// -----------------------------------
			// create edit | delete separator text
			// -----------------------------------
			
			var separator_text = document.createTextNode(' | ');
			td_element_for_links.appendChild(separator_text);
	
			// ----------------------
			// create the delete link
			// ----------------------
			
			var a_elem_for_delete = document.createElement('a');
			var delete_text = document.createTextNode(_delete_label);
			a_elem_for_delete.appendChild(delete_text);
			a_elem_for_delete.id = 'delete_report_element:' + i;
			a_elem_for_delete.href = 'javascript:;';
			a_elem_for_delete.onclick = delete_report_element;

			td_element_for_links.appendChild(a_elem_for_delete);
			
			row_element.appendChild(td_element_for_links);
			
			tbody_element.appendChild(row_element);
		}
		
		container.appendChild(table_element);
		
		// ----------------------------------------------
		// set report element checkboxes enabled/disabled
		// ----------------------------------------------
		
		for (var i = 0; i < _report_elements.length; i++) {
		
			var the_checkbox = document.getElementById('report_element_disabled:' + i);
			
			// alert(_report_elements[i].disabled);
			
			the_checkbox.checked = _report_elements[i].disabled ? false : true;
		}
	}
	else {
	
		// show info of how to add an item
	
	}
}

function set_report_element_disabled() {

	// update _report_elemets array if report element gets enabled/disabled
	
	var id = this.id;
	var dat = id.split(':');
	var i = parseInt(dat[dat.length - 1]);
	var element = document.getElementById(id);

	_report_elements[i].disabled = element.checked ? false : true;
	
	// alert(_report_elements[i].disabled);
}

function new_report_element() {

	_new_report_element_active = true;

	var default_report_element_type = 'overview';

	parent.document.title = _new_report_element_window_title;
	
	parent.top_frame.switch_toolbar('report_element');
	
	preset_report_element_type_list(default_report_element_type);
	
	preset_report_element_form(default_report_element_type);
	
	// set standard table as default if creating a new report element
	parent.top_frame.set_report_element_type(default_report_element_type);

}

function edit_report_element() {

	var id = this.id;
	var dat = id.split(':');
	var i = parseInt(dat[dat.length - 1]);
	var report_element_type = _report_elements[i].type;

	// check if report element type is supported
	
	var type_support_ok = false;

	if (report_element_type == 'overview' || report_element_type == 'log_detail') {
	
		type_support_ok = true;
	}
	else if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {
	
		if (_table_reports_support) {
		
			type_support_ok = true;
		}
		else {
		
			alert(_msg_report_element_type_not_supported);
		}
	}
	else { // session reports
	
		if (_session_reports_support) {
		
			type_support_ok = true;
		}
		else {
			alert(_msg_session_report_element_type_not_supported_message);
		}
	}
	
	if (type_support_ok) {

		_new_report_element_active = false;
		_active_report_element_index = i;
		
		parent.document.title = _edit_report_element_window_title;
	
		parent.top_frame.switch_toolbar('report_element');
		
		preset_report_element_type_list(report_element_type);
		
		preset_report_element_form(report_element_type);
		
		parent.top_frame.set_report_element_type(report_element_type);
	}
}

function preset_report_element_type_list(report_element_type) {

	// selects the active report element type in list
	
	select_list_item('report_element_type_list', report_element_type);
}

function preset_report_element_form(report_element_type) {

	var report_element_form = document.getElementById('report_element_form');

	report_element_form.reset();
	
	// -----------
	// Set general
	// -----------
	
	// report name
	
	var report_name = parent.top_frame.document.getElementById('report_label').value;
	var report_name_container = document.getElementById('report_name_container');
	
	if (report_name == '') {report_name = '-';}
	
	var text = document.createTextNode(report_name);
	report_name_container.replaceChild(text, report_name_container.firstChild);
	
	
	// report element name
	
	var report_element_name_field = document.getElementById('report_element_name_field');
	
	if (_new_report_element_active) {
	
		report_element_name_field.value = 'New report element';
	}
	else {
	
		report_element_name_field.value = _report_elements[_active_report_element_index].label;
	}
	
	// show report element header bar
	
	var show_report_element_header_bar = document.getElementById('show_report_element_header_bar');
	
	if (_new_report_element_active) {
		show_report_element_header_bar.checked = false;
	}
	else {
		show_report_element_header_bar.checked = _report_elements[_active_report_element_index].show_header_bar;
	}
	
	// report element filter
	
	var report_element_filter_field = document.getElementById('report_element_filter_field');
	
	if (_new_report_element_active) {
	
		report_element_filter_field.value = '';
	}
	else {
		report_element_filter_field.value = _report_elements[_active_report_element_index].filter;
	}
	
	// default_report_on_zoom
	
	var default_report_on_zoom_support = get_default_report_on_zoom_support();
	var default_report_on_zoom_list = document.getElementById('default_report_on_zoom_list');

	if (!_new_report_element_active && default_report_on_zoom_support) {
	
		if (_report_elements[_active_report_element_index].default_report_on_zoom != null) {
		
			var report_name = _report_elements[_active_report_element_index].default_report_on_zoom;
			select_list_item('default_report_on_zoom_list', report_name);
		}	
	}
	else {
		default_report_on_zoom_list.selectedIndex = 0;
	}
	
	
	// -----------------------
	// Set main_field & fields
	// -----------------------
	
	// keep default values for new report elements
	// In edit mode set fields only if report_element type is table or table_with_sub_table

	if (!_new_report_element_active && (report_element_type == 'table' || report_element_type == 'table_with_sub_table')) {
	
		var main_field = _report_elements[_active_report_element_index].database_field_name;
		
		select_list_item('main_field_list', main_field);
		
		if (report_element_type == 'table_with_sub_table') {
			
			var main_field_of_sub_table =  _report_elements[_active_report_element_index].sub_table.database_field_name;
	
			select_list_item('main_field_of_sub_table_list', main_field_of_sub_table);
		}
	}
		
	// -----------------------
	// reset temp field arrays
	// -----------------------
	
	_temp_table_fields.length = 0;
	_temp_entry_exit_pages_fields.length = 0;
	_temp_session_pages_fields.length = 0;
	_temp_session_users_fields.length = 0;
	_temp_individual_sessions_fields.length = 0;
	_temp_log_detail_fields.length = 0;
	
	// ---------------------
	// set temp field arrays
	// ---------------------
	
	// arrays are used to operate upon report element data while in report_element_form,
	// so the original _report_elements array remains intact unless the report_element_form
	// is confirmed by the OK button
	
	_temp_table_fields = _default_table_fields.slice(0);
	_temp_entry_exit_pages_fields = _default_entry_exit_pages_fields.slice(0);
	_temp_session_pages_fields = _default_session_pages_fields.slice(0);
	_temp_session_users_fields = _default_session_users_fields.slice(0);
	_temp_individual_sessions_fields = _default_individual_sessions_fields.slice(0);
	_temp_log_detail_fields = _default_log_detail_fields.slice(0);
	
	if (!_new_report_element_active) {
	
		// get original report element fields and overwrite default fields
	
		if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {
		
			_temp_table_fields.lenght = 0;
					
			_temp_table_fields = _report_elements[_active_report_element_index].columns.slice(0);	
			
		}
		else if (report_element_type == 'log_detail') {
		
			_temp_log_detail_fields.length = 0;
		
			_temp_log_detail_fields = _report_elements[_active_report_element_index].columns.slice(0);
		};
	};
	
	// -----------------
	// set graph options
	// -----------------
	
	_chrono_graph_defaults = new Object();
	_graph_defaults = new Object();
	
	_chrono_graph_is_default = {
		graph_type:true,
		sort_option:true,
		pie_chart_options:true,
		bar_line_graph_size:true,
		pie_chart_size:true
	};
	
	_graph_is_default = {
		graph_type:true,
		sort_option:true,
		bar_line_graph_options:true,
		pie_chart_options:true,
		bar_line_graph_size:true,
		pie_chart_size:true
	};
	
	if (!_new_report_element_active &&
		(report_element_type == 'table' || report_element_type == 'table_with_sub_table') &&
		(_report_elements[_active_report_element_index].graphs != null)) {
	
		// update _graph_is_default values if local report element graph options exists
		
		var chrono = (main_field == 'date_time' || main_field == 'day_of_week' || main_field == 'hour_of_day') ? true : false;
		
		
		var object_ref = _report_elements[_active_report_element_index].graphs;
		
		
		if (object_ref.graph_type != null) {
		
			if (chrono) {_chrono_graph_is_default.graph_type = false} else {_graph_is_default.graph_type = false}
		}
		
		if (object_ref.sort_direction != null) { // sort_direction is for chrono only
		
			_chrono_graph_is_default.sort_option = false;
		}
		
		if (object_ref.sort_all_descending != null) {
		
			_graph_is_default.sort_option = false;
		}
		
		if (object_ref.bar_line_graph != null) {
		
		
			if (object_ref.bar_line_graph.x_axis_length != null) {
			
				if (chrono) {_chrono_graph_is_default.bar_line_graph_size = false} else {_graph_is_default.bar_line_graph_size = false}
			}
		
			if (object_ref.bar_line_graph.max_variables != null ||
				object_ref.bar_line_graph.show_remainder != null ||
				object_ref.bar_line_graph.show_legend != null ||
				object_ref.bar_line_graph.max_legend_rows != null) {
			
				_graph_is_default.bar_line_graph_options = false;
			}
		}
		
		if (object_ref.pie_chart != null) {
		
		
			if (object_ref.pie_chart.x_axis_length != null) {
			
				if (chrono) {_chrono_graph_is_default.pie_chart_size = false} else {_graph_is_default.pie_chart_size = false}
			}
		
			if (object_ref.pie_chart.max_variables != null ||
				object_ref.pie_chart.max_legend_rows != null) {
			
				if (chrono) {_chrono_graph_is_default.pie_chart_options = false} else {_graph_is_default.pie_chart_options = false}
			}
		}
	}
	
	// --------------------------------------------------------
	// set the chrono graph defaults (default check boxes only)
	// --------------------------------------------------------
	
	var default_chrono_graph_type_btn = document.getElementById('default_chrono_graph_type_btn');
	var default_chrono_graph_sort_direction_btn = document.getElementById('default_chrono_graph_sort_direction_btn');
	var default_chrono_pie_chart_options_btn = document.getElementById('default_chrono_pie_chart_options_btn');
	var default_chrono_bar_line_graph_size_btn = document.getElementById('default_chrono_bar_line_graph_size_btn');
	var default_chrono_pie_chart_size_btn = document.getElementById('default_chrono_pie_chart_size_btn');
	
	default_chrono_graph_type_btn.checked = !_chrono_graph_is_default.graph_type;
	default_chrono_graph_sort_direction_btn.checked = !_chrono_graph_is_default.sort_option;
	default_chrono_pie_chart_options_btn.checked = !_chrono_graph_is_default.pie_chart_options;
	default_chrono_bar_line_graph_size_btn.checked = !_chrono_graph_is_default.bar_line_graph_size;
	default_chrono_pie_chart_size_btn.checked = !_chrono_graph_is_default.pie_chart_size;
	
	set_chrono_graph_type();
	set_chrono_sort_direction();
	set_chrono_pie_chart_options();
	set_chrono_bar_line_graph_size();
	set_chrono_pie_chart_size();
	
	// -------------------------------------------------------------
	// set the none chrono graph defaults (default check boxes only)
	// -------------------------------------------------------------
	
	var default_graph_type_btn = document.getElementById('default_graph_type_btn');
	var default_graph_sort_direction_btn = document.getElementById('default_graph_sort_direction_btn');
	var default_bar_line_graph_options_btn = document.getElementById('default_bar_line_graph_options_btn');
	var default_pie_chart_options_btn = document.getElementById('default_pie_chart_options_btn');
	var default_bar_line_graph_size_btn = document.getElementById('default_bar_line_graph_size_btn');
	var default_pie_chart_size_btn = document.getElementById('default_pie_chart_size_btn');

	default_graph_type_btn.checked = !_graph_is_default.graph_type;
	default_graph_sort_direction_btn.checked = !_graph_is_default.sort_option;
	default_bar_line_graph_options_btn.checked = !_graph_is_default.bar_line_graph_options;
	default_pie_chart_options_btn.checked = !_graph_is_default.pie_chart_options;
	default_bar_line_graph_size_btn.checked = !_graph_is_default.bar_line_graph_size;
	default_pie_chart_size_btn.checked = !_graph_is_default.pie_chart_size;

	set_graph_type();
	set_graph_sort_direction();
	set_bar_line_graph_options();
	set_pie_chart_options();
	set_bar_line_graph_size();
	set_pie_chart_size();
	
	
	// ------------------------------------
	// set the table options default_values
	// ------------------------------------
	
	// includes sort_by and sort_direction of table columns!
	
	generate_active_sort_by_data_array();
	
	set_table_options(report_element_type);
}

// --------------------------
// report element general tab
// --------------------------

function set_general_options_display() {

	var default_report_on_zoom_section = document.getElementById('default_report_on_zoom_section');
	var default_report_on_zoom_support = get_default_report_on_zoom_support();
	
	if (default_report_on_zoom_support) {
	
		default_report_on_zoom_section.style.display = 'block';
	}
	else {
		default_report_on_zoom_section.style.display = 'none';
	}
}

// ======
// fields
// ======

function update_fields_section(report_element_type) {

	var main_field_section = document.getElementById('main_field_section');

	// var inactive_fields_list = document.getElementById('inactive_fields_list');
	// var active_fields_list = document.getElementById('active_fields_list');
	
	var main_field_of_sub_table_label = document.getElementById('main_field_of_sub_table_label');
	var main_field_of_sub_table_list = document.getElementById('main_field_of_sub_table_list');

	if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {
	
		main_field_section.style.display = 'block';
		
		if (report_element_type == 'table') {
		
			main_field_of_sub_table_label.style.display = 'none';
			main_field_of_sub_table_list.style.display = 'none';
		}
		else {
		
			main_field_of_sub_table_label.style.display = 'block';
			main_field_of_sub_table_list.style.display = 'block';
		}
		
		update_fields_lists();
	}
	else {
		main_field_section.style.display = 'none';
		
		update_fields_lists();
	}
}

function update_fields_lists() {

	var inactive_fields_list = document.getElementById('inactive_fields_list');
	var active_fields_list = document.getElementById('active_fields_list');
	var report_element_type = get_active_report_element_type();
	
	var active_fields = (report_element_type != 'log_detail') ? _temp_table_fields.slice(0) : _temp_log_detail_fields.slice(0);
	var all_fields = (report_element_type != 'log_detail') ? _numerical_database_fields.slice(0) : _log_detail_fields.slice(0);
	
	// alert('ori _temp_table_fields lenth: ' + _temp_table_fields.length + '\nactive_fields length: ' + active_fields.length);

	// clear lists
	inactive_fields_list.length = 0;
	active_fields_list.length = 0;
	
	// update the active fields list
	
	// alert(all_fields[1].label);
	
	for (var i = 0; i < active_fields.length; i++) {
	
		var field_name = active_fields[i].field_name;
		var field_label = _database_fields[h(field_name)].label;
	
		active_fields_list.options[i] = new Option(field_label, field_name, false, false);
	}
	
	// create hash table of active fields for quick lookup
	
	var temp_hash = new Array;
	for (i = 0; i < active_fields.length; i++) {
		var name = active_fields[i].field_name;
		temp_hash[name.toUpperCase()] = true;
	}
	
	// update the inactive fields list
	
	for (var i = 0; i < all_fields.length; i++) {
		
		var field_name = all_fields[i];
		
		// alert(active_fields[field_name]);
		
		if (temp_hash[h(field_name)] == null) {
		
			// field does not exist in active fields, so add it to inactive fields list
			var field_label = _database_fields[h(field_name)].label;
		
			inactive_fields_list.options[inactive_fields_list.length] = new Option(field_label, field_name, false, false);
		}
	}
}


function remove_active_field() {

	var report_element_type = get_active_report_element_type();
	var active_fields_list = document.getElementById('active_fields_list');
	var i = active_fields_list.selectedIndex;
	
	if (i >= 0) {
	
		// delete the field from the the _temp array
	
		if (report_element_type != 'log_detail') {
		
			_temp_table_fields.splice(i, 1);
	
		}
		else {
		
			_temp_log_detail_fields.splice(i, 1);
		}
		
		update_fields_lists();
	}
}

function remove_all_active_fields() {

	var report_element_type = get_active_report_element_type();
	var active_fields_list = document.getElementById('active_fields_list');

	if (active_fields_list.length > 0) {
	
		if (report_element_type != 'log_detail') {
		
			_temp_table_fields.length = 0;
	
		}
		else {
		
			_temp_log_detail_fields.length = 0;
		}
		
		update_fields_lists();
	}
}

function add_inactive_field() {

	var inactive_fields_list = document.getElementById('inactive_fields_list');
	var i = inactive_fields_list.selectedIndex;
	
	if (i >= 0) {
	
		var field_name_to_add = inactive_fields_list.options[i].value;
		
		add_default_field_to_active_fields(field_name_to_add);
		
		update_fields_lists();
	}
}

function add_all_inactive_fields() {

	var inactive_fields_list = document.getElementById('inactive_fields_list');
	
	if (inactive_fields_list.length > 0) {
		
		for (var i = 0; i < inactive_fields_list.length; i++) {
		
			var field_name_to_add = inactive_fields_list.options[i].value;
		
			add_default_field_to_active_fields(field_name_to_add);
		}
		
		update_fields_lists();
	}
}

function add_default_field_to_active_fields(field_name_to_add) {

	var report_element_type = get_active_report_element_type();

	// get the default field values
	var default_fields = new Array();
	default_fields = (report_element_type != 'log_detail') ? _default_table_fields.slice(0) : _default_log_detail_fields.slice(0);
	
	for (var i = 0; i < default_fields.length; i++) {
	
		if (default_fields[i].field_name == field_name_to_add) {
		
			// add the default field object to the corresponding temp fields array
		
			if (report_element_type != 'log_detail') {
			
				_temp_table_fields[_temp_table_fields.length] = default_fields[i];
			}
			else {
			
				_temp_log_detail_fields[_temp_log_detail_fields.length] = default_fields[i];
			}
			break;
		}
	}
}

// ------------------
// sort active fields
// ------------------

function move_active_field_via_keys(event) {

	var key_code = (event.which) ? event.which : event.keyCode;
	
	if (key_code == 45) {
		move_active_field('down');
	}
	
	if (key_code == 43) {
		move_active_field('up');
	}
}

function move_active_field(direction) {

	// Note, we don't change the fields list itself but we update the objects sort order
	// in the temp array and then update the list as objects exist in the array

	var report_element_type = get_active_report_element_type();
	var active_fields_list = document.getElementById('active_fields_list');

	var i = active_fields_list.selectedIndex;
	var i_new;
	var move_ok = false;
	var the_object_to_move = new Array();
	
	// alert('_temp_table_fields before sort: ' + _temp_table_fields[i].field_name); 
	
	if (i >= 0) {

		if (direction == 'up') {
		
			if (i != 0) { // if not first item in list
			
				i_new = i - 1;
				move_ok = true;
			}
		}
		else { // direction down
		
			if (i != active_fields_list.length - 1) { // if not last item in list
			
				i_new = i + 1;
				move_ok = true;
			}
		}
		
		if (move_ok) {
		
			if (report_element_type != 'log_detail') {
			
				the_object_to_move = _temp_table_fields.splice(i, 1); // remove the item
				_temp_table_fields.splice(i_new, 0, the_object_to_move[0]); // reinsert the item
				
			}
			else {
			
				the_object_to_move = _temp_log_detail_fields.splice(i, 1); // remove the item
				_temp_log_detail_fields.splice(i_new, 0, the_object_to_move[0]); // reinsert the item
			}
			
			update_fields_lists();
			active_fields_list.selectedIndex = i_new;
		}
	}
}

// ---------------------
// delete report element
// ---------------------

function delete_report_element() {

	var element_id = this.id;
	var dat = element_id.split(':');
	var i = parseInt(dat[dat.length - 1]);
	var report_element_label = _report_elements[i].label;
	var msg = _msg_confirm_delete_message;
	msg = msg.replace(/__PARAM__1__/, report_element_label);
	
	if (confirm(msg)) {
	
		// delete report element from array
		_report_elements.splice(i, 1);
		
		// rebuild the report element list
		
		build_report_element_list();
	}
}

// ------
// graphs
// ------

function build_graphs() {

	// builds the graph rows which can be checked/unchecked
	
	var table_element = document.getElementById('graphs_container'); // table element!
	
	// clean up existing table
	var c = table_element.firstChild;

	if (c != null) {
		table_element.removeChild(c);
	}
	
	var tbody = document.createElement('tbody');
	table_element.appendChild(tbody);
	

	// --------------------
	// create header column
	// --------------------
	
	var tr = document.createElement('tr');
	var th = document.createElement('th');
	th.style.paddingTop = '2px';
	th.style.paddingBottom = '4px';
	var txt = document.createTextNode(_show_hide_graphs_label);
	
	th.appendChild(txt);
	tr.appendChild(th);
	tbody.appendChild(tr);
	
	// -----------------------
	// create graph rows/cells
	// -----------------------
	
	for (var i = 0; i < _temp_table_fields.length; i++) {
	
		var field_name = _temp_table_fields[i].field_name;
		
		var tr = document.createElement('tr');
		
		var td = document.createElement('td');
		td.style.paddingTop = '2px';
		td.style.paddingBottom = '2px';
		td.style.paddingLeft = '7px';

		var cb = document.createElement('input');
		cb.type = 'checkbox';
		var id = 'show_graph:' + i;
		cb.id = id;
		cb.onclick = update_show_graph_state;
		
		var label = document.createElement('label');
		label.htmlFor = id;
		
		var txt = document.createTextNode(' ' + _database_fields[h(field_name)].label);
		label.appendChild(txt);
		td.appendChild(cb);
		td.appendChild(label);
		tr.appendChild(td);
		
		tbody.appendChild(tr);
	}
	
	// set the checkboxes state
	
	for (var i = 0; i < _temp_table_fields.length; i++) {
	
		var field_name = _temp_table_fields[i].field_name;
		var show_graph = _temp_table_fields[i].show_graph;
		
		var element = document.getElementById('show_graph:' + i);
		
		if (show_graph) {
		
			element.checked = 'checked';
		}	
	}
}

function update_show_graph_state() {

	// enable/disable graph in columns
	
	var id = this.id;
	var dat = id.split(':');
	var i = parseInt(dat[dat.length - 1]);
	
	var element = document.getElementById(id);
	
	_temp_table_fields[i].show_graph = element.checked;	
}

function set_graph_options_display() {
	
	var main_field = get_selected_main_field();
	
	var chrono_graph_options_section = document.getElementById('chrono_graph_options_section');
	var graph_options_section = document.getElementById('graph_options_section');
	var no_graph_options_info = document.getElementById('no_graph_options_info');
	var chrono_graph_options_label = document.getElementById('chrono_graph_options_label');
	var graph_options_label = document.getElementById('graph_options_label');
	
	chrono_graph_options_section.style.display = 'none';
	graph_options_section.style.display = 'none';
	no_graph_options_info.style.display = 'none';
	chrono_graph_options_label.style.display = 'none';
	graph_options_label.style.display = 'none';
	
	if (main_field == 'date_time' ||
		main_field == 'day_of_week' ||
		main_field == 'hour_of_day') {
		
		chrono_graph_options_label.style.display = 'block';
		chrono_graph_options_section.style.display = 'block';
	}
	else if (main_field != '') { // none chronological main_field selecetd
	
		graph_options_label.style.display = 'block';
		graph_options_section.style.display = 'block';
	}
	else { // no main_field selecetd
	
		graph_options_label.style.display = 'block';
		no_graph_options_info.style.display = 'block';
	}
}

// =====
// table
// =====


function set_table_options(report_element_type) {

	var omit_table_btn = document.getElementById('omit_table_btn');
	var show_omitted_items_row_btn = document.getElementById('show_omitted_items_row_btn');
	var show_averages_row_btn = document.getElementById('show_averages_row_btn');
	var show_totals_row_btn = document.getElementById('show_totals_row_btn');
	var show_parenthesized_items_btn = document.getElementById('show_parenthesized_items_btn');
	var show_only_bottom_level_items_btn = document.getElementById('show_only_bottom_level_items_btn');
	var number_of_rows_field = document.getElementById('number_of_rows_field');
	
	var sub_table_show_omitted_items_row_btn = document.getElementById('sub_table_show_omitted_items_row_btn');
	var sub_table_show_averages_row_btn = document.getElementById('sub_table_show_averages_row_btn');
	var sub_table_show_totals_row_btn = document.getElementById('sub_table_show_totals_row_btn');
	var sub_table_show_parenthesized_items_btn = document.getElementById('sub_table_show_parenthesized_items_btn');
	var sub_table_number_of_rows_field = document.getElementById('sub_table_number_of_rows_field');

	// preset table options default values
	
	var omit_table = false;
	var show_omitted_items_row = true;
	var show_averages_row = false;
	var show_totals_row = true;
	var omit_parenthesized_items = false;
	var only_bottom_level_items = false;
	var number_of_rows = 10;
	
	var sub_table_show_omitted_items_row = true;
	var sub_table_show_averages_row = false;
	var sub_table_show_totals_row = true;
	var sub_table_omit_parenthesized_items = false;
	var sub_table_number_of_rows = 10;
	
	// sort direction
	var sort_direction = '';
	
	// get original values if editing an existing report element
	
	if (!_new_report_element_active) {
	
		var object_ref = _report_elements[_active_report_element_index];
	
		if (report_element_type == 'table' ||
			report_element_type == 'table_with_sub_table' ||
			report_element_type == 'entry_pages' ||
			report_element_type == 'exit_pages' ||
			report_element_type == 'individual_sessions' ||
			report_element_type == 'session_pages' ||
			report_element_type == 'session_users') {
			
			show_omitted_items_row = object_ref.show_omitted_items_row;
			show_averages_row = object_ref.show_averages_row;
			show_totals_row = object_ref.show_totals_row;
			omit_parenthesized_items = object_ref.omit_parenthesized_items;
			number_of_rows = object_ref.ending_row;
			
			
			// set sort_by field and sort_direction of table columns
			
			sort_direction = object_ref.sort_direction;
	
			_active_sort_by_data[h(report_element_type)].sort_by = object_ref.sort_by;
			_active_sort_by_data[h(report_element_type)].sort_direction = sort_direction;
			
			if (report_element_type == 'table') {
			
				omit_table = object_ref.omit_table;
			}
			
			if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {
							
				if (object_ref.only_bottom_level_items != null) {
					only_bottom_level_items = object_ref.only_bottom_level_items;
				}
			}
			
			if (report_element_type == 'table_with_sub_table') {
			
				var sub_table_ref = _report_elements[_active_report_element_index].sub_table;
				
				sub_table_show_omitted_items_row = sub_table_ref.show_omitted_items_row;
				sub_table_show_averages_row = sub_table_ref.show_averages_row;
				sub_table_show_totals_row = sub_table_ref.show_totals_row;
				sub_table_omit_parenthesized_items = sub_table_ref.omit_parenthesized_items;
				sub_table_number_of_rows = sub_table_ref.ending_row;
				
				// alert('set table options - sub_table_omit_parenthesized_items: ' + sub_table_omit_parenthesized_items);
			}
		}
		
		if (report_element_type == 'log_detail') {
		
			number_of_rows = object_ref.ending_row;
		}
	}
	
	// set the table values
	
	omit_table_btn.checked = omit_table;
	show_omitted_items_row_btn.checked = show_omitted_items_row;
	show_averages_row_btn.checked = show_averages_row;
	show_totals_row_btn.checked = show_totals_row;
	show_parenthesized_items_btn.checked = !omit_parenthesized_items;
	show_only_bottom_level_items_btn.checked = only_bottom_level_items;
	number_of_rows_field.value = number_of_rows;
	
	sub_table_show_omitted_items_row_btn.checked = sub_table_show_omitted_items_row;
	sub_table_show_averages_row_btn.checked = sub_table_show_averages_row;
	sub_table_show_totals_row_btn.checked = sub_table_show_totals_row;
	sub_table_show_parenthesized_items_btn.checked = !sub_table_omit_parenthesized_items;
	sub_table_number_of_rows_field.value = sub_table_number_of_rows;
	
	// set sort_direction on table columns tab
	//update_sort_direction_buttons();
}

function set_table_options_display() {

	var report_element_type = get_active_report_element_type();
	
	var main_field = get_selected_main_field();
	
	var omit_table_section = document.getElementById('omit_table_section');
	var table_options_section = document.getElementById('table_options_section');
	var show_only_bottom_level_items_section = document.getElementById('show_only_bottom_level_items_section');
	var table_row_numbers_section = document.getElementById('table_row_numbers_section');
	var sub_table_options_section = document.getElementById('sub_table_options_section');
	
	var show_only_bottom_level_items = false;
	
	omit_table_section.style.display = 'none';
	table_options_section.style.display = 'none';
	show_only_bottom_level_items_section.style.display = 'none';
	table_row_numbers_section.style.display = 'none';
	sub_table_options_section.style.display = 'none';
	
	if (report_element_type == 'log_detail') {
	
		table_row_numbers_section.style.display = 'block';
	}
	else {
	
		if (report_element_type == 'table') {
		
			omit_table_section.style.display = 'block';
		}
	
		table_options_section.style.display = 'block';
		
		// show only_bottom_level_items checkbox if main field is hierarchical
		if (is_hierarchical_field(main_field)) {
			show_only_bottom_level_items = true;
		}		
		
		table_row_numbers_section.style.display = 'block';
		
		if (report_element_type == 'table_with_sub_table') {
			
			// show only_bottom_level_items checkbox if subtable field is hierarchical
			if (is_hierarchical_field(get_selected_main_field_of_sub_table())) {
				show_only_bottom_level_items = true;
			}		
			sub_table_options_section.style.display = 'block';
		}
		
		if (show_only_bottom_level_items) {
			show_only_bottom_level_items_section.style.display = 'block';
		}
	}
}

function is_hierarchical_field(field_name) {
	
	if ((field_name != '') && (_database_fields[h(field_name)].hierarchical != null)) {
		if (_database_fields[h(field_name)].hierarchical) {
			return true;
		}
	}
	return false;
}

// =============
// table columns
// =============

function build_table_columns() {

	var report_element_type = get_active_report_element_type();

	var text_word = _text_word;
	var number_word = _number_word;
	var number_percent_word = _number_percent_word;
	var bar_graph_word = _bar_graph_word;
	
	var v_space = '4px'; // paddingTop and paddingBottom
	var h_space = '7px';
	var light_color = '#808080';
	
	var temp_fields; // assign one of the _temp fields arrays depending on report element type
	
	var is_session;
	
	if (report_element_type == 'table' || report_element_type == 'table_with_sub_table' || report_element_type == 'log_detail') {
		is_session = false;
	}
	else {
		is_session = true;
	}


	var table_element = document.getElementById('table_columns_container'); // table element!
	
	// clean up existing table
	var c = table_element.firstChild;

	if (c != null) {
		table_element.removeChild(c);
	}
	
	var tbody = document.createElement('tbody');
	table_element.appendChild(tbody);
	
	// ---------------
	// temp_controller
	// ---------------
	
	// track the state of the check boxes in a temp array and
	// apply the state after all check boxes have been created
	// This is required due an IE bug
	
	var temp_controller = new Array();

	// --------------------
	// create header column
	// --------------------
	
	var tr = document.createElement('tr');
	var th = document.createElement('th');
	th.colspan = 4;
	var txt = document.createTextNode(_columns_label);
	
	th.appendChild(txt);
	th.style.paddingTop = '2px';
	th.style.paddingBottom = '5px';
	tr.appendChild(th);
	tbody.appendChild(tr);
	
	if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {
	
		// build main field row
	
		var main_field = get_selected_main_field();
		var main_field_label;
		
		if (main_field != '') {
			main_field_label = _database_fields[h(main_field)].label;
		} 
		else {
			main_field_label = _no_main_field_selected_text;
		}
		
		var tr = document.createElement('tr');
		
		// 1st column
		var td = document.createElement('td');
		td.style.paddingTop = v_space;
		td.style.paddingBottom = v_space;
		td.style.paddingLeft = h_space;
		td.style.paddingRight = h_space;
		var txt = document.createTextNode(main_field_label);
		td.appendChild(txt);
		tr.appendChild(td);
		
		// 2nd column (main field will be always disabled)
		var td = document.createElement('td');
		td.style.paddingTop = v_space;
		td.style.paddingBottom = v_space;
		td.style.paddingLeft = h_space;
		td.style.paddingRight = h_space;
		td.style.color = light_color;
		var cb = document.createElement('input');
		var id = 'table_column:main_field';
		cb.id = id;
		cb.type = 'checkbox';
		
		temp_controller[temp_controller.length] = {id:id, checked:true, disabled:true};
		
		var txt = document.createTextNode(' ' + text_word);
		td.appendChild(cb);
		td.appendChild(txt);
		tr.appendChild(td);
		
		// 3rd column & 4th column
		for (var i = 0; i < 2; i++) {
			
			var td = document.createElement('td');
			td.style.paddingTop = v_space;
			td.style.paddingBottom = v_space;
			td.style.paddingLeft = h_space;
			td.style.paddingRight = h_space;
			var txt = document.createTextNode(' ');
			td.appendChild(txt);
			tr.appendChild(td);
		}
		
		tbody.appendChild(tr);
		
		if (report_element_type == 'table_with_sub_table') {
		
			// add main_field of sub table!
	
		}
		
		temp_fields = _temp_table_fields.slice(0);
		
	}
	else if (report_element_type == 'entry_pages' || report_element_type == 'exit_pages') {
	
		temp_fields = _temp_entry_exit_pages_fields.slice(0);
	}
	else if (report_element_type == 'session_pages') {
	
		temp_fields = _temp_session_pages_fields.slice(0);
	}
	else if (report_element_type == 'session_users') {
	
		temp_fields = _temp_session_users_fields.slice(0);
	}
	else if (report_element_type == 'individual_sessions') {
	
		temp_fields = _temp_individual_sessions_fields.slice(0);
	}
	else if (report_element_type == 'log_detail') {
	
		temp_fields = _temp_log_detail_fields.slice(0);
	}
	
	// --------------
	// build the rows
	// --------------
		
	for (var i = 0; i < temp_fields.length; i++) {
	
		var field_name = temp_fields[i].field_name;
		var field_label = (!is_session) ? _database_fields[h(field_name)].label : _session_fields[h(field_name)].label;
		var data_type = (!is_session) ? _database_fields[h(field_name)].data_type : _session_fields[h(field_name)].data_type;
		
		var tr = document.createElement('tr');
		
		// 1st column with field label
		var td = document.createElement('td');
		td.style.paddingTop = v_space;
		td.style.paddingBottom = v_space;
		td.style.paddingLeft = h_space;
		td.style.paddingRight = h_space;
		var txt = document.createTextNode(field_label);
		td.appendChild(txt);
		tr.appendChild(td);
		
		if (data_type == 'string') {
		
			// 2nd column, shows the text checkbox
			var td = document.createElement('td');
			td.style.paddingTop = v_space;
			td.style.paddingBottom = v_space;
			td.style.paddingLeft = h_space;
			td.style.paddingRight = h_space;
			td.style.color = light_color;
			var cb = document.createElement('input');
			cb.type = 'checkbox';
			var id = 'table_column:visible:' + i;
			cb.id = id;
			cb.onclick = update_table_column_state;
			
			temp_controller[temp_controller.length] = {id:id, checked:temp_fields[i].visible, disabled:false};
			
			var label = document.createElement('label');
			label.htmlFor = id;
			var txt = document.createTextNode(' ' + text_word);
			label.appendChild(txt);
			td.appendChild(cb);
			td.appendChild(label);
			tr.appendChild(td);
			
			// 3rd column & 4th column are empty
			for (var j = 0; j < 2; j++) {
				
				var td = document.createElement('td');
				td.style.paddingTop = v_space;
				td.style.paddingBottom = v_space;
				td.style.paddingLeft = h_space;
				td.style.paddingRight = h_space;
				var txt = document.createTextNode(' ');
				td.appendChild(txt);
				tr.appendChild(td);
			}
		}
		else {
		
			// 2nd, 3rd and 4th column
			
			var col_type = 'show_number_column';
			
			for (var k = 0; k < 3; k++) {
		
				if (k == 1) {
					col_type = 'show_percent_column';
				}
				else if (k == 2) {
					col_type = 'show_bar_column';
				}
				
				var td = document.createElement('td');
				td.style.paddingTop = v_space;
				td.style.paddingBottom = v_space;
				td.style.paddingLeft = h_space;
				td.style.paddingRight = h_space;
				td.style.color = light_color;
				var cb = document.createElement('input');
				cb.type = 'checkbox';
				var id = 'table_column:' + col_type + ':' + i;
				cb.id = id;
				cb.onclick = update_table_column_state;
				
				var checked;
				var the_text;
				if (k == 0) {
					checked = temp_fields[i].show_number_column;
					the_text = number_word;
				}
				else if (k ==1) {
					checked = temp_fields[i].show_percent_column;
					the_text = number_percent_word;
				}
				else {
					checked = temp_fields[i].show_bar_column;
					the_text = bar_graph_word;
				}
				
				temp_controller[temp_controller.length] = {id:id, checked:checked, disabled:false};
				
				var label = document.createElement('label');
				label.htmlFor = id;
				var txt = document.createTextNode(' ' + the_text);
				label.appendChild(txt);
				td.appendChild(cb);
				td.appendChild(label);
				tr.appendChild(td);
			}
		}
		
		tbody.appendChild(tr);
	}
	
	// ---------------------
	// Set check boxes state
	// ---------------------
	
	for (var i = 0; i < temp_controller.length; i++) {
	
		var element = document.getElementById(temp_controller[i].id);
		
		if (temp_controller[i].checked) {
			element.checked = 'checked';
		}
		
		if (temp_controller[i].disabled) {
			element.disabled = 'disabled';
		}
	}
}

function update_table_column_state() {

	// This updates the column state in temp array when checking/unchecking table columns
	
	// alert('update column: ' + this.id);
	
	var report_element_type = get_active_report_element_type();
	
	var id = this.id;
	var dat = id.split(':');
	var i = parseInt(dat[2]);
	var column_type = dat[1]; // show_number_column | show_percent_column | show_bar_column
	
	var element = document.getElementById(id);
	
	if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {

		_temp_table_fields[i][column_type] = element.checked;
	}
	else if (report_element_type == 'entry_pages' || report_element_type == 'exit_pages') {
		
		_temp_entry_exit_pages_fields[i][column_type] = element.checked;
	}
	else if (report_element_type == 'session_pages') {
	
		_temp_session_pages_fields[i][column_type] = element.checked;
	}
	else if (report_element_type == 'session_users') {
	
		_temp_session_users_fields[i][column_type] = element.checked;
	}
	else if (report_element_type == 'individual_sessions') {
	
		_temp_individual_sessions_fields[i][column_type] = element.checked;
	}
	else if (report_element_type == 'log_detail') {
	
		_temp_log_detail_fields[i][column_type] = element.checked;
	}
}

function update_active_sort_by_field() {

	// updates global _active_sort_by_data upon selecting a different sort_by field

	var report_element_type = get_active_report_element_type();

	var sort_by_list = document.getElementById('table_column_sort_by_list');
	var i = sort_by_list.selectedIndex;
	
	if (i > 0) {
	
		_active_sort_by_data[h(report_element_type)].sort_by = sort_by_list.options[i].value;
		
		// if no sort direction is defined then automatically set one
		
		if (_active_sort_by_data[h(report_element_type)].sort_direction == '') {
		
			_active_sort_by_data[h(report_element_type)].sort_direction = 'descending';
		}
	}
	else {
	
		// if first field, no sort_by field is seleceted
		
		_active_sort_by_data[h(report_element_type)].sort_by = '';
		_active_sort_by_data[h(report_element_type)].sort_direction = '';
	}
	
	update_sort_direction_buttons();
}

function update_sort_direction_buttons() {

	var report_element_type = get_active_report_element_type();
	
	var table_column_sort_ascending_btn = document.getElementById('table_column_sort_ascending_btn');
	var table_column_sort_descending_btn = document.getElementById('table_column_sort_descending_btn');
	var sort_direction = _active_sort_by_data[h(report_element_type)].sort_direction;
	var disabled;
	
	if (sort_direction == 'ascending') {
	
		table_column_sort_ascending_btn.checked = true;
		disabled = false;
	}
	else if (sort_direction == 'descending') {
		
		table_column_sort_descending_btn.checked = true;
		disabled = false;
	}
	else {
		table_column_sort_ascending_btn.checked = false;
		table_column_sort_descending_btn.checked = false;
		disabled = true;
	}
	
	table_column_sort_ascending_btn.disabled = disabled;
	table_column_sort_descending_btn.disabled = disabled;
}

function update_active_sort_direction() {

	var report_element_type = get_active_report_element_type();
	var table_column_sort_ascending_btn = document.getElementById('table_column_sort_ascending_btn');
	
	if (table_column_sort_ascending_btn.checked) {
	
		_active_sort_by_data[h(report_element_type)].sort_direction = 'ascending';
	}
	else {
		_active_sort_by_data[h(report_element_type)].sort_direction = 'descending';
	}
}

function update_table_columns_sort_controls() {

	// also update the sort ascending/descending buttons!

	var report_element_type = get_active_report_element_type();

	var sort_by_list = document.getElementById('table_column_sort_by_list');
	var is_selected = false;
	
	if (report_element_type != 'log_detail') {
	
		// clear list
		sort_by_list.options.length = 0;
	
		// add unsorted option
		sort_by_list.options[0] = new Option('----------------------', '0', false, false);
	
		// determine if table is a session table
		
		var is_session = false;
		
		if (report_element_type != 'table' && report_element_type != 'table_with_sub_table') {
			is_session = true;
		}
		
		// get active fields array
		
		var temp_fields; // assign one of the _temp fields arrays depending on report element type
		
		if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {

			temp_fields = _temp_table_fields.slice(0);
			
			// add the main_field and main_field of sub table to sort_by list
			
			var main_field = get_selected_main_field();
			
			if (main_field != '') {
				
				sort_by_list.options[sort_by_list.length] = new Option(_database_fields[h(main_field)].label, main_field, false, false);
			}
			
			if (report_element_type == 'table_with_sub_table') {
			
				var main_field_of_sub_table = get_selected_main_field_of_sub_table();
				
				if (main_field_of_sub_table != '') {
				
					sort_by_list.options[sort_by_list.length] = new Option(_database_fields[h(main_field_of_sub_table)].label, main_field_of_sub_table, false, false);
				}
			}
		}
		else if (report_element_type == 'entry_pages' || report_element_type == 'exit_pages') {
		
			temp_fields = _temp_entry_exit_pages_fields.slice(0);
		}
		else if (report_element_type == 'session_pages') {
		
			temp_fields = _temp_session_pages_fields.slice(0);
		}
		else if (report_element_type == 'session_users') {
		
			temp_fields = _temp_session_users_fields.slice(0);
		}
		else if (report_element_type == 'individual_sessions') {
		
			temp_fields = _temp_individual_sessions_fields.slice(0);
		}
		else if (report_element_type == 'log_detail') {
		
			temp_fields = _temp_log_detail_fields.slice(0);
		}

		// populate fields
		
		for (var i = 0; i < temp_fields.length; i++) {
	
			var field_name = temp_fields[i].field_name;
			var field_label = (!is_session) ? _database_fields[h(field_name)].label : _session_fields[h(field_name)].label;
		
			sort_by_list.options[sort_by_list.length] = new Option(field_label, field_name, false, false);
		}
		
		// select the field (field selection does not work in above loop in IE!)
		
		var sort_by_field_has_been_selected = false;
		
		for (var i = 0; i < sort_by_list.length; i++) {
		
			var field_name = sort_by_list.options[i].value;
			
			if (field_name == _active_sort_by_data[h(report_element_type)].sort_by) {
			
				sort_by_list.selectedIndex = i;
				sort_by_field_has_been_selected = true;
				break;
			}
		}
		
		if (!sort_by_field_has_been_selected) {
		
			// possible that an active sort_by field does not exist,
			// or it has been removed from the fields list.
			
			_active_sort_by_data[h(report_element_type)].sort_by = '';
			_active_sort_by_data[h(report_element_type)].sort_direction = '';
		}
		
		update_sort_direction_buttons();
		
	} // if report_element_type not log_detail
}

function set_table_columns_display() {

	var report_element_type = get_active_report_element_type();
	var table_columns_sort_section = document.getElementById('table_columns_sort_section');

	if (report_element_type != 'log_detail') {
	
		table_columns_sort_section.style.display = 'block';
	}
	else {
		table_columns_sort_section.style.display = 'none';
	}
}

// ====================
// Sort report elements
// ====================

function move_report_element_via_keys(event) {

	var key_code = (event.which) ? event.which : event.keyCode;
	
	if (key_code == 45) {
		move_report_element('down');
	}
	
	if (key_code == 43) {
		move_report_element('up');
	}
}

function move_report_element(direction) {

	// Note, we don't change the list itself, we update the objects position in the report elements array!

	var the_list = document.getElementById('sort_report_elements_list');

	var i = the_list.selectedIndex;
	var i_new;
	var move_ok = false;
	var the_object_to_move = new Array();
	
	if (i >= 0) {

		if (direction == 'up') {
		
			if (i != 0) { // if not first item in list
			
				i_new = i - 1;
				move_ok = true;
			}
		}
		else { // direction down
		
			if (i != the_list.length - 1) { // if not last item in list
			
				i_new = i + 1;
				move_ok = true;
			}
		}
		
		if (move_ok) {
		
			the_object_to_move = _report_elements.splice(i, 1); // remove the report_element
			_report_elements.splice(i_new, 0, the_object_to_move[0]); // reinsert the report_element

			update_report_element_sort_list();
			the_list.selectedIndex = i_new;
		}
	}
}

function update_report_element_sort_list() {

	var the_list = document.getElementById('sort_report_elements_list');
	
	the_list.options.length = 0;
	
	for (var i = 0; i < _report_elements.length; i++) {
	
		var value = _report_elements[i].name;
		var text = _report_elements[i].label;
	
		the_list.options[i] = new Option(text, value, false, false);
	}
}

// ===========================
// process report element form
// ===========================

function process_report_element_form() {

	var report_element_type = get_active_report_element_type();
	
	var report_element_label = get_value('report_element_name_field');
	var show_header_bar = get_value('show_report_element_header_bar');
	var report_element_filter = get_value('report_element_filter_field');
	
	var only_bottom_level_items_active = false;
	
	// create an id for the report_element_name, the name will be replaced on the
	// server side to be a valid node name
	
	var now = new Date();
	var report_element_name = now.valueOf(); // date in ms
	
	// alert(report_element_name);
	
	// -----------------------------
	// set basic report_element data
	// -----------------------------
	
	// create a new object to be replaced or inserted in _report_elements
	
	var report_element = new Object();
	
	report_element.disabled = false; // the report element becomes checked as default
	report_element.name = report_element_name;
	report_element.type = report_element_type;
	report_element.label = report_element_label;
	report_element.show_header_bar = show_header_bar;
	report_element.filter = report_element_filter;
	
	
	// set default_report_on_zoom
	// set this property only if a default_report_on_zoom has been set
	
	var default_report_on_zoom_support = get_default_report_on_zoom_support();
	
	if (default_report_on_zoom_support) {
	
		var default_report_on_zoom_list = document.getElementById('default_report_on_zoom_list');
		var i = default_report_on_zoom_list.selectedIndex;
		
		if (i > 0) {
		
			report_element.default_report_on_zoom = default_report_on_zoom_list.options[i].value;
		}
	}
	
	// -------------------------------------
	// set specific report_element_type data
	// -------------------------------------
	
	if (report_element_type == 'table' ||
		report_element_type == 'table_with_sub_table' ||
		report_element_type == 'entry_pages' ||
		report_element_type == 'exit_pages' ||
		report_element_type == 'individual_sessions' ||
		report_element_type == 'session_pages' ||
		report_element_type == 'session_users') {
		
		if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {
		
			var main_field = get_selected_main_field();
			
			if (main_field != '') {
			
				report_element.database_field_name = main_field;
				
				if (report_element_type == 'table') {
				
					report_element.omit_table = get_value('omit_table_btn');
				}
			}
			else {
			
				alert(_msg_no_main_field_selected);
				return false;
			}

			if (report_element_type == 'table_with_sub_table') {
		
				var main_field_of_sub_table = get_selected_main_field_of_sub_table();
				
				if (main_field_of_sub_table != '') {
				
					if (main_field_of_sub_table != main_field) {
					
						var sub_table_ending_row = get_value('sub_table_number_of_rows_field');
						
						if (value_is_integer_min_msg(sub_table_ending_row, 1, _msg_invalid_number_of_rows_in_sub_table)) {
						
							var sub_table = new Object();
						
							sub_table.database_field_name = main_field_of_sub_table;
							sub_table.ending_row = sub_table_ending_row;
							sub_table.show_omitted_items_row = get_value('sub_table_show_omitted_items_row_btn');
							sub_table.show_averages_row = get_value('sub_table_show_averages_row_btn');
							sub_table.show_totals_row = get_value('sub_table_show_totals_row_btn');
							sub_table.omit_parenthesized_items = !get_value('sub_table_show_parenthesized_items_btn');
							
							// alert('sub_table.omit_parenthesized_items: ' + sub_table.omit_parenthesized_items);						
							
							report_element.sub_table = sub_table;
						}
						else {
							return false;
						};
					}
					else {
					
						alert(_msg_duplicate_main_fields);
						return false;
					}
				}
				else {
				
					alert(_msg_no_sub_table_main_field_selected);
					return false;
				}
			}
			
			// -------------------
			// handle graph values
			// -------------------
			
			var graphs_object = build_and_validate_graphs_object(main_field); // implemented in graph_options.js
			
			// alert(graphs_object);
						
			if (graphs_object != null) {
			
				// alert(graphs_object.error);
			
				if (graphs_object.error == null) {
					// add the graph_object
				
					report_element.graphs = graphs_object;
				}
				else {
					// some invalid graph_options, error msg is handled in graph_options.js
					return false;
				}
			}
		}
		
		// -----------------------
		// get common table values
		// -----------------------
		
		var ending_row = get_value('number_of_rows_field');
		
		if (value_is_integer_min_msg(ending_row, 1, _msg_invalid_number_of_rows_in_table)) {
		
			report_element.ending_row = ending_row;
			report_element.show_omitted_items_row = get_value('show_omitted_items_row_btn');
			report_element.show_averages_row = get_value('show_averages_row_btn');
			report_element.show_totals_row = get_value('show_totals_row_btn');
			report_element.omit_parenthesized_items = get_value('show_parenthesized_items_btn') ? false : true;
			
			if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {
			
				if (is_hierarchical_field(main_field)) {
					only_bottom_level_items_active = true;
				}
				else if (report_element_type == 'table_with_sub_table') {
					// check the subtable field in case that the main field is not hierarchical
					if (is_hierarchical_field(get_selected_main_field_of_sub_table())) {
						only_bottom_level_items_active = true;
					}		
				}
				
				if (only_bottom_level_items_active) {
					report_element.only_bottom_level_items = get_value('show_only_bottom_level_items_btn');
				}
			}
		}
		else {
			
			return false;
		}
		
		// ---------------
		// get sort values
		// ---------------
		
		// sort_by and sort_direction are defined in _active_sort_by_data array per report_element_type
		
		// alert('sort_by: ' + _active_sort_by_data[h(report_element_type)].sort_by + '\nsort_direction: ' + _active_sort_by_data[h(report_element_type)].sort_direction);

		report_element.sort_by = _active_sort_by_data[h(report_element_type)].sort_by;
		report_element.sort_direction = _active_sort_by_data[h(report_element_type)].sort_direction;
		
		// ------------------
		// add columns object
		// ------------------
		
		if (report_element_type == 'table' || report_element_type == 'table_with_sub_table') {

			if (_temp_table_fields.length > 0) {
				report_element.columns = _temp_table_fields.slice(0);
			}
			else {
				alert(_msg_no_active_field);
				return false;
			}
		}
		else if (report_element_type == 'entry_pages' || report_element_type == 'exit_pages') {
		
			report_element.columns = _temp_entry_exit_pages_fields.slice(0);
		}
		else if (report_element_type == 'session_pages') {
		
			report_element.columns = _temp_session_pages_fields.slice(0);
		}
		else if (report_element_type == 'session_users') {
		
			report_element.columns = _temp_session_users_fields.slice(0);
		}
		else if (report_element_type == 'individual_sessions') {
		
			report_element.columns = _temp_individual_sessions_fields.slice(0);
		}
	}
	
	if (report_element_type == 'log_detail') {
	
		var ending_row = get_value('number_of_rows_field');
		
		if (value_is_integer_min_msg(ending_row, 1, _msg_invalid_number_of_rows_in_table)) {
		
			report_element.ending_row = ending_row;
			report_element.columns = _temp_log_detail_fields.slice(0);
		}
		else {
		
			return false;
		}
	}
	
	// -----------------------
	// save the report element
	// -----------------------
	
	if (_new_report_element_active) {
	
		// add new report element
		_report_elements[_report_elements.length] = report_element;
	
	}
	else {
		// replace the existsing report_element
		
		// Note, transfer the report element header and footer to the edited report element
		
		// alert('header of existsing report element: ' + _report_elements[_active_report_element_index].header);
		
		report_element.header = _report_elements[_active_report_element_index].header;
		report_element.footer = _report_elements[_active_report_element_index].footer;
		
		_report_elements.splice(_active_report_element_index, 1, report_element);
	}
	
	parent.top_frame.switch_toolbar('report');
	parent.top_frame.set_report_section(parent.top_frame._active_report_section);
}


// ===================
// process report_form
// ===================

function process_form() {

	var report_label = strip_whitespace(parent.top_frame.document.getElementById('report_label').value);
	var volatile_path = 'volatile.form_processing';

	// validate report label

	if (!validate_report_label(report_label)) {
		return false;
	}
	
	// check if report elements exist
	
	if (_report_elements.length <= 0) {
	
		alert(_msg_no_report_element_exists);
		return false;
	}
	
	// handle reports menu
	// only available when a new report is created!
	
	if (_form_type == 'new') {
	
		var add_new_report_to_reports_menu = get_value('add_new_report_to_reports_menu_btn');
		
		if (add_new_report_to_reports_menu) {
		
			if (!validate_and_process_reports_menu(volatile_path)) {
				return false;
			}
		}
	}
		
	new_hfe(volatile_path + '.form_type', _form_type);
	new_hfe(volatile_path + '.report_name', _report_name);
	new_hfe(volatile_path + '.report_label', report_label);
	
	// handle show_report_header_bar
	
	var show_report_header_bar = document.getElementById('show_report_header_bar_btn').checked;
	new_hfe(volatile_path + '.show_report_header_bar', show_report_header_bar);
	
	
	// handle report filter
	
	var report_filter = strip_whitespace(document.getElementById('report_filter_field').value);
	
	// alert(report_filter);
	
	if (report_filter != '') {
	
		new_hfe(volatile_path + '.report_filter', report_filter);
	}
	
	
	// handle report header & report footer, they are not editable, simply transfer the global variable
	
	new_hfe(volatile_path + '.report_header', _report_header);
	new_hfe(volatile_path + '.report_footer', _report_footer);
	
	// ----------------------------------------------------
	// assemble report elements from _report_elements array
	// ----------------------------------------------------
	
	for (var i = 0; i < _report_elements.length; i++) {
	
		var report_element_type = _report_elements[i].type;
		var report_element_type_modified = (report_element_type == 'table_with_sub_table') ? 'table' : report_element_type;
	
		report_element_path = 'volatile.form_processing.report_elements.' + i;
		
		// if a report_element_filter property exists then add the filter
		
		if (_report_elements[i].filter != null) {
		
			// save filter only if its not empty
			
			if (_report_elements[i].filter != '') {
		
				new_hfe(report_element_path + '.filter.expression', _report_elements[i].filter);
			}
		}
		
		// if a default_report_on_zoom property exists then add it
		
		if (_report_elements[i].default_report_on_zoom != null) {
			new_hfe(report_element_path + '.default_report_on_zoom', _report_elements[i].default_report_on_zoom);
		}
	
		new_hfe(report_element_path + '.position', i); // used to sort the report elements server side
		new_hfe(report_element_path + '.label', _report_elements[i].label);
		new_hfe(report_element_path + '.show_header_bar', _report_elements[i].show_header_bar);
		new_hfe(report_element_path + '.disabled', _report_elements[i].disabled);
		new_hfe(report_element_path + '.type', report_element_type_modified);
		
		
		// handle report element header
		if (_report_elements[i].header != null && _report_elements[i].header != '') {
			new_hfe(report_element_path + '.header', _report_elements[i].header);
		}
		
		// handle report element footer
		if (_report_elements[i].footer != null && _report_elements[i].footer != '') {
			new_hfe(report_element_path + '.footer', _report_elements[i].footer);
		}
		
		if (_report_elements[i].omit_table != null) {
			new_hfe(report_element_path + '.omit_table', _report_elements[i].omit_table);
		}
		
		if (_report_elements[i].ending_row != null) {
			new_hfe(report_element_path + '.starting_row', 1);
			new_hfe(report_element_path + '.ending_row', _report_elements[i].ending_row);
		}
		
		if (_report_elements[i].show_omitted_items_row != null) {
			new_hfe(report_element_path + '.show_omitted_items_row', _report_elements[i].show_omitted_items_row);
		}
		
		if (_report_elements[i].show_averages_row != null) {
			new_hfe(report_element_path + '.show_averages_row', _report_elements[i].show_averages_row);
		}
		
		if (_report_elements[i].show_totals_row != null) {
			new_hfe(report_element_path + '.show_totals_row', _report_elements[i].show_totals_row);
		}

		if (_report_elements[i].omit_parenthesized_items != null) {
			new_hfe(report_element_path + '.omit_parenthesized_items', _report_elements[i].omit_parenthesized_items);
		}
				
		if (_report_elements[i].only_bottom_level_items != null) {
			new_hfe(report_element_path + '.only_bottom_level_items', _report_elements[i].only_bottom_level_items);
		}

		if (_report_elements[i].sort_by != null) {
			new_hfe(report_element_path + '.sort_by', _report_elements[i].sort_by);
		}
		
		if (_report_elements[i].sort_direction != null) {
			new_hfe(report_element_path + '.sort_direction', _report_elements[i].sort_direction);
		}
		
		if (report_element_type_modified == 'table') {
		
			new_hfe(report_element_path + '.database_field_name', _report_elements[i].database_field_name);
		}
		
		// handle graphs object
		
		if (_report_elements[i].graphs != null) {
		
			var graphs = _report_elements[i].graphs;
			var graphs_path = report_element_path + '.graphs';
			
			if (graphs.graph_type != null) {
				new_hfe(graphs_path + '.graph_type', graphs.graph_type);
			}
			
			if (graphs.sort_direction != null) {
				new_hfe(graphs_path + '.sort_direction', graphs.sort_direction);
			}
			
			if (graphs.sort_all_descending != null) {
				new_hfe(graphs_path + '.sort_all_descending', graphs.sort_all_descending);
			}
			
			if (graphs.bar_line_graph != null) {
			
				var bar_line_graph = _report_elements[i].graphs.bar_line_graph;
				var barl_line_graph_path = report_element_path + '.graphs.bar_line_graph';
				
				for (var name in bar_line_graph) {
				
					// alert('name:' + name + '\nvalue: ' + bar_line_graph[name])
					
					new_hfe(barl_line_graph_path + '.' + name , bar_line_graph[name]);
				}
			}
			
			if (graphs.pie_chart != null) {
			
				var pie_chart = _report_elements[i].graphs.pie_chart;
				var pie_chart_path = report_element_path + '.graphs.pie_chart';
			
				for (var name in pie_chart) {
					new_hfe(pie_chart_path + '.' + name , pie_chart[name]);
				}
			}
		}
		
		// handle sub_table

		if (report_element_type == 'table_with_sub_table') {
		
			var sub_table_ref = _report_elements[i].sub_table;
			
			new_hfe(report_element_path + '.sub_table.ending_row', sub_table_ref.ending_row);
			new_hfe(report_element_path + '.sub_table.show_omitted_items_row', sub_table_ref.show_omitted_items_row);
			new_hfe(report_element_path + '.sub_table.show_averages_row', sub_table_ref.show_averages_row);
			new_hfe(report_element_path + '.sub_table.show_totals_row', sub_table_ref.show_totals_row);
			new_hfe(report_element_path + '.sub_table.omit_parenthesized_items', sub_table_ref.omit_parenthesized_items);
		}

		// handle columns
		
		if (_report_elements[i].columns != null) {
		
			var columns = _report_elements[i].columns;
		
			var is_session = true;
			
			if (report_element_type == 'log_detail') {is_session = false}
		
			if (report_element_type_modified == 'table') {
			
				is_session = false;
			
				// add first column
				
				var new_column = {field_name:_report_elements[i].database_field_name, visible:true};
				
				columns.splice(0, 0, new_column);
				
				if (report_element_type == 'table_with_sub_table') {
				
					var new_column_2 = {field_name:sub_table_ref.database_field_name, visible:true};
					
					columns.splice(1, 0, new_column_2);
				}
			}
			
			for (var k = 0; k < columns.length; k++) {
			
				var columns_path = report_element_path + '.columns.' + k;
				
				var field_name = columns[k].field_name;
				var data_type = is_session ? _session_fields[h(field_name)].data_type : _database_fields[h(field_name)].data_type;
				var display_format_type = is_session ? _session_fields[h(field_name)].display_format_type : _database_fields[h(field_name)].display_format_type;
				var type = (data_type == 'string') ? 'string' : 'number';
				
				new_hfe(columns_path + '.header_label', '');
				new_hfe(columns_path + '.field_name', field_name);
				new_hfe(columns_path + '.type', type);
				new_hfe(columns_path + '.data_type', data_type);
				new_hfe(columns_path + '.display_format_type', display_format_type);
				
				new_hfe(columns_path + '.position', k); // used to sort the columns server side
				
				if (type == 'string') {
				
					new_hfe(columns_path + '.main_column', true);
					new_hfe(columns_path + '.visible', columns[k].visible);
				}
				else {
					new_hfe(columns_path + '.visible', true);
					new_hfe(columns_path + '.show_number_column', columns[k].show_number_column);
					new_hfe(columns_path + '.show_percent_column', columns[k].show_percent_column);
					new_hfe(columns_path + '.show_bar_column', columns[k].show_bar_column);
					new_hfe(columns_path + '.show_graph', columns[k].show_graph);
				}
			}
		}
	}
}

function validate_report_label(report_label) {

	if (report_label != '') {
	
		// verify that report label has no duplicate
		
		var label_is_unique = true;
		var report_label_lowercase = report_label.toLowerCase();
		
		for (var i = 0; i < _reports.length; i++) {
	
			var report_label_in_array = _reports[i].label;
			report_label_in_array = report_label_in_array.toLowerCase();
			
			if (_form_type == 'new') {
			
				if (report_label_in_array == report_label_lowercase) {
				
					label_is_unique = false;
					break;
				}
			}
			else {
			
				var report_name_in_array = _reports[i].name;
			
				if ((report_name_in_array != _report_name) && (report_label_in_array == report_label_lowercase)) {
				
					label_is_unique = false;
					break;
				}
			}
		}
		
		if (label_is_unique) {
			return true;
		}
		else {
		
			var msg = _msg_duplicate_report_name;
			msg = msg.replace(/__PARAM__1__/, report_label);
		
			alert(msg);
			return false;
		}		
	}
	else {
	
		alert(_msg_missing_report_name);
		return false;
	}
}

function validate_and_process_reports_menu(volatile_path) {
	
	var reports_menu_label = get_value('reports_menu_label_field');
	var add_to_menu_group = get_value('add_to_menu_group_btn'); document.getElementById('add_to_menu_group_btn');
	var visible = get_value('show_reports_menu_in_dydnmic_reports_btn');
	var visible_if_files = get_value('show_reports_menu_in_static_reports_btn');
	
	if (reports_menu_label != '') {
	
		if (add_to_menu_group) {
		
			var reports_menu_group_list = document.getElementById('reports_menu_group_list');
			var i = reports_menu_group_list.selectedIndex;
			
			if (i > 0) {
			
				var menu_group_name = reports_menu_group_list.options[i].value;
			}
			else {
				alert(_msg_no_reports_menu_goup_selected);
				return false;
			}
		}
		
		// add reports menu parameters to form
		
		volatile_path = volatile_path + '.reports_menu';
		
		new_hfe(volatile_path + '.reports_menu_label', reports_menu_label);
		new_hfe(volatile_path + '.visible', visible);
		new_hfe(volatile_path + '.visible_if_files', visible_if_files);
		
		if (add_to_menu_group) {
			new_hfe(volatile_path + '.menu_group_name', menu_group_name);
		}
		
		return true;
	}
	else {
		alert(_msg_missing_reports_menu_name);
		return false;
	}
}

// ============
// Reports menu
// ============

function toggle_reports_menu_type() {

	var reports_menu_group_list = document.getElementById('reports_menu_group_list');
	var add_single_menu_btn = document.getElementById('add_single_menu_btn');
	
	reports_menu_group_list.disabled = add_single_menu_btn.checked ? true : false;
}

function toggle_reports_menu_options() {

	var add_new_report_to_reports_menu_btn = document.getElementById('add_new_report_to_reports_menu_btn');
	var disabled = add_new_report_to_reports_menu_btn.checked ? false : true;
	var elements = ['reports_menu_label_field', 'add_single_menu_btn', 'add_to_menu_group_btn', 'reports_menu_group_list', 'show_reports_menu_in_dydnmic_reports_btn', 'show_reports_menu_in_static_reports_btn'];
	
	for (var i = 0; i < elements.length; i++) {
	
		var element = document.getElementById(elements[i]);
		element.disabled = disabled;
	}
	
	if (!disabled) {toggle_reports_menu_type()} // updates the reports group list to be enabled or disabled
}


// =========
// Utilities
// =========

function get_default_report_on_zoom_support() {

	var report_element_type = get_active_report_element_type();

	if (report_element_type == 'table' ||
		report_element_type == 'table_with_sub_table' ||
		report_element_type == 'individual_sessions' ||
		report_element_type == 'session_users') {
		
		return true;
	}
	
	return false;
}

function select_list_item(element_id, item) {

	// selects item in select list
	
	var the_list = document.getElementById(element_id);
	
	if (the_list == null) {
	
		// list may be in top_frame
	
		the_list = parent.top_frame.document.getElementById(element_id);
	}
	
	for (var i = 0; i < the_list.length; i++) {
	
		if (the_list.options[i].value == item) {
		
			the_list.selectedIndex = i;
			break;
		}
	}
}

function get_active_report_element_type() {

	var report_element_type_list = parent.top_frame.document.getElementById('report_element_type_list');
	var i = report_element_type_list.selectedIndex;
	var report_element_type = report_element_type_list.options[i].value;
	
	return report_element_type;
}

function get_selected_main_field() {

	var value = '';
	var main_field_list = document.getElementById('main_field_list');
	var i = main_field_list.selectedIndex;
	if (i > 0) { // if first field then no report element type is selected!
	
		value = main_field_list.options[i].value;
	}
	
	return value;
}

function get_selected_main_field_of_sub_table() {

	var value = '';
	var main_field_of_sub_table_list = document.getElementById('main_field_of_sub_table_list');
	var i = main_field_of_sub_table_list.selectedIndex;
	if (i > 0) { // if first field then no report element type is selected!
	
		value = main_field_of_sub_table_list.options[i].value;
	}
	
	return value;
}

function graphs_property_exists(property_name) {
	
	if (!_new_report_element_active &&
		(_report_elements[_active_report_element_index].graphs != null) &&
		(_report_elements[_active_report_element_index].graphs[property_name] != null)) {
	
		return true;
	}
	
	return false;
}

function bar_line_graph_property_exists(property_name) {

	if (!_new_report_element_active &&
		(_report_elements[_active_report_element_index].graphs != null) &&
		(_report_elements[_active_report_element_index].graphs.bar_line_graph != null) &&
		(_report_elements[_active_report_element_index].graphs.bar_line_graph[property_name] != null)) {
	
		return true;
	}
	
	return false;
}

function pie_chart_property_exists(property_name) {

	if (!_new_report_element_active &&
		(_report_elements[_active_report_element_index].graphs != null) &&
		(_report_elements[_active_report_element_index].graphs.pie_chart != null) &&
		(_report_elements[_active_report_element_index].graphs.pie_chart[property_name] != null)) {
	
		return true;
	}
	
	return false;
}

function get_value(element_id) {

	var element = document.getElementById(element_id);
	var type = element.type;
	var value = '';
	
	if (type == 'text' || type == 'textarea') {
	
		value = strip_whitespace(element.value);
	}
	else {
	
		value = element.checked;
	}
	return value;
}

function new_hfe(name, value) { // new hidden form element

	var sys_form = parent.top_frame.document.getElementById('sys_form');
	new_element = parent.top_frame.document.createElement('input');
	new_element.type = 'hidden';
	new_element.name = name;
	new_element.value = value;
	sys_form.appendChild(new_element);
}

// Enumerate objects
//var names = '';
//for (var name in _temp_table_fields.slice(1,1)) names += name + '\n';
//alert(names);
