
// Reports Editor Graphs Options Function

function set_chrono_graph_type() {
	
	var default_chrono_graph_type_btn = document.getElementById('default_chrono_graph_type_btn');
	var chrono_bar_graph_btn = document.getElementById('chrono_bar_graph_btn');
	var chrono_line_graph_btn = document.getElementById('chrono_line_graph_btn');
	var chrono_pie_chart_btn = document.getElementById('chrono_pie_chart_btn');
	
	var graph_type = _default_chrono_graphs.graph_type;
	var disabled_state = true;
	
	if (default_chrono_graph_type_btn.checked) {
		
		if (graphs_property_exists('graph_type')) {
			
			graph_type = _report_elements[_active_report_element_index].graphs.graph_type;
		}
		
		disabled_state = false;
	}
	
	chrono_bar_graph_btn.disabled = disabled_state;
	chrono_line_graph_btn.disabled = disabled_state;
	chrono_pie_chart_btn.disabled = disabled_state;
	
	if (graph_type == 'bar') {
		chrono_bar_graph_btn.checked = true;
	}
	else if (graph_type == 'line') {
		chrono_line_graph_btn.checked = true;
	}
	else {
		chrono_pie_chart_btn.checked = true;
	}
}

function set_chrono_sort_direction() {

	var default_chrono_graph_sort_direction_btn = document.getElementById('default_chrono_graph_sort_direction_btn');
	var chrono_graph_sort_ascending_btn = document.getElementById('chrono_graph_sort_ascending_btn');
	var chrono_graph_sort_descending_btn = document.getElementById('chrono_graph_sort_descending_btn');
	
	var sort_direction = 'ascending';
	var disabled_state = true;
	
	if (default_chrono_graph_sort_direction_btn.checked) {
		
		if (graphs_property_exists('sort_direction')) {
			sort_direction = _report_elements[_active_report_element_index].graphs.sort_direction;
		}
		
		disabled_state = false;
	}
	
	chrono_graph_sort_ascending_btn.disabled = disabled_state;
	chrono_graph_sort_descending_btn.disabled = disabled_state;
	
	if (sort_direction == 'ascending') {
		chrono_graph_sort_ascending_btn.checked = true;
	}
	else {
		chrono_graph_sort_descending_btn.checked = true;
	}
}

function set_chrono_pie_chart_options() {

	var default_chrono_pie_chart_options_btn = document.getElementById('default_chrono_pie_chart_options_btn');
	var chrono_pie_chart_max_legend_rows_field = document.getElementById('chrono_pie_chart_max_legend_rows_field');
	
	var max_legend_rows = _default_chrono_graphs.pie_chart.max_legend_rows;
	var disabled_state = true;
	
	if (default_chrono_pie_chart_options_btn.checked) {
		
		if (pie_chart_property_exists('max_legend_rows')) {
			
			max_legend_rows = _report_elements[_active_report_element_index].graphs.pie_chart.max_legend_rows;
		}
		
		disabled_state = false;
	}
	
	chrono_pie_chart_max_legend_rows_field.disabled = disabled_state;
	chrono_pie_chart_max_legend_rows_field.value = max_legend_rows;
}

function set_chrono_bar_line_graph_size() {

	var default_chrono_bar_line_graph_size_btn = document.getElementById('default_chrono_bar_line_graph_size_btn');
	var chrono_bar_line_graph_x_axis_length_field = document.getElementById('chrono_bar_line_graph_x_axis_length_field');
	var chrono_bar_line_graph_y_axis_height_field = document.getElementById('chrono_bar_line_graph_y_axis_height_field');
	
	var x_axis_length = _default_chrono_graphs.bar_line_graph.x_axis_length;
	var y_axis_height = _default_chrono_graphs.bar_line_graph.y_axis_height;
	var disabled_state = true;
	
	if (default_chrono_bar_line_graph_size_btn.checked) {
		
		if (bar_line_graph_property_exists('x_axis_length')) {
			x_axis_length = _report_elements[_active_report_element_index].graphs.bar_line_graph.x_axis_length;
		}
		if (bar_line_graph_property_exists('y_axis_height')) {
			y_axis_height = _report_elements[_active_report_element_index].graphs.bar_line_graph.y_axis_height;
		}
		
		disabled_state = false;
	}
	
	chrono_bar_line_graph_x_axis_length_field.value = x_axis_length;
	chrono_bar_line_graph_y_axis_height_field.value = y_axis_height;
	chrono_bar_line_graph_x_axis_length_field.disabled = disabled_state;
	chrono_bar_line_graph_y_axis_height_field.disabled = disabled_state;
}

function set_chrono_pie_chart_size() {

	var default_chrono_pie_chart_size_btn = document.getElementById('default_chrono_pie_chart_size_btn');
	var chrono_pie_chart_x_axis_length_field = document.getElementById('chrono_pie_chart_x_axis_length_field');
	var chrono_pie_chart_y_axis_height_field = document.getElementById('chrono_pie_chart_y_axis_height_field');
	
	var x_axis_length = _default_chrono_graphs.pie_chart.x_axis_length;
	var y_axis_height = _default_chrono_graphs.pie_chart.y_axis_height;
	var disabled_state = true;
	
	if (default_chrono_pie_chart_size_btn.checked) {
		
		if (pie_chart_property_exists('x_axis_length')) {
			x_axis_length = _report_elements[_active_report_element_index].graphs.pie_chart.x_axis_length;
		}
		if (pie_chart_property_exists('y_axis_height')) {
			y_axis_height = _report_elements[_active_report_element_index].graphs.pie_chart.y_axis_height;
		}
		
		disabled_state = false;
	}
	
	chrono_pie_chart_x_axis_length_field.value = x_axis_length;
	chrono_pie_chart_y_axis_height_field.value = y_axis_height;
	chrono_pie_chart_x_axis_length_field.disabled = disabled_state;
	chrono_pie_chart_y_axis_height_field.disabled = disabled_state;
}

function set_graph_type() {
	
	var default_graph_type_btn = document.getElementById('default_graph_type_btn');
	var bar_graph_btn = document.getElementById('bar_graph_btn');
	var line_graph_btn = document.getElementById('line_graph_btn');
	var pie_chart_btn = document.getElementById('pie_chart_btn');
	
	var graph_type = _default_graphs.graph_type;
	var disabled_state = true;
	
	if (default_graph_type_btn.checked) {
		
		if (graphs_property_exists('graph_type')) {
			
			graph_type = _report_elements[_active_report_element_index].graphs.graph_type;
		}
		
		disabled_state = false;
	}
	
	bar_graph_btn.disabled = disabled_state;
	line_graph_btn.disabled = disabled_state;
	pie_chart_btn.disabled = disabled_state;
	
	if (graph_type == 'bar') {
		bar_graph_btn.checked = true;
	}
	else if (graph_type == 'line') {
		line_graph_btn.checked = true;
	}
	else {
		pie_chart_btn.checked = true;
	}
}

function set_graph_sort_direction() {

	var default_graph_sort_direction_btn = document.getElementById('default_graph_sort_direction_btn');
	var graph_sort_all_descending_btn = document.getElementById('graph_sort_all_descending_btn');
	var graph_sort_all_by_field_btn = document.getElementById('graph_sort_all_by_field_btn');
	
	var sort_all_descending = _default_graphs.sort_all_descending;
	var disabled_state = true;
	
	if (default_graph_sort_direction_btn.checked) {
		
		if (graphs_property_exists('sort_all_descending')) {
			sort_all_descending = _report_elements[_active_report_element_index].graphs.sort_all_descending;
		}
		
		disabled_state = false;
	}
	
	graph_sort_all_descending_btn.disabled = disabled_state;
	graph_sort_all_by_field_btn.disabled = disabled_state;
	
	if (sort_all_descending) {
		graph_sort_all_descending_btn.checked = true;
	}
	else {
		graph_sort_all_by_field_btn.checked = true;
	}
}

function set_bar_line_graph_options() {

	var default_bar_line_graph_options_btn = document.getElementById('default_bar_line_graph_options_btn');
	var bar_line_graph_show_remainder_btn = document.getElementById('bar_line_graph_show_remainder_btn');
	var bar_line_graph_show_legend_btn = document.getElementById('bar_line_graph_show_legend_btn');
	var bar_line_graph_max_variables_field = document.getElementById('bar_line_graph_max_variables_field');
	var bar_line_graph_max_legend_rows_field = document.getElementById('bar_line_graph_max_legend_rows_field');
	
	var show_remainder = _default_graphs.bar_line_graph.show_remainder;
	var show_legend = _default_graphs.bar_line_graph.show_legend;
	var max_variables = _default_graphs.bar_line_graph.max_variables;
	var max_legend_rows = _default_graphs.bar_line_graph.max_legend_rows;
	
	var disabled_state = true;
	
	if (default_bar_line_graph_options_btn.checked) {
		
		if (bar_line_graph_property_exists('show_remainder')) {
			show_remainder = _report_elements[_active_report_element_index].graphs.bar_line_graph.show_remainder;
		}
		
		if (bar_line_graph_property_exists('show_legend')) {
			show_legend = _report_elements[_active_report_element_index].graphs.bar_line_graph.show_legend;
		}
		
		if (bar_line_graph_property_exists('max_variables')) {
			max_variables = _report_elements[_active_report_element_index].graphs.bar_line_graph.max_variables;
		}
		
		if (bar_line_graph_property_exists('max_legend_rows')) {
			max_legend_rows = _report_elements[_active_report_element_index].graphs.bar_line_graph.max_legend_rows;
		}
		
		disabled_state = false;
	}
	
	bar_line_graph_show_remainder_btn.disabled = disabled_state;
	bar_line_graph_show_legend_btn.disabled = disabled_state;
	bar_line_graph_max_variables_field.disabled = disabled_state;
	bar_line_graph_max_legend_rows_field.disabled = disabled_state;
	
	bar_line_graph_show_remainder_btn.checked = show_remainder;
	bar_line_graph_show_legend_btn.checked = show_legend;
	bar_line_graph_max_variables_field.value = max_variables;
	bar_line_graph_max_legend_rows_field.value = max_legend_rows;
}

function set_pie_chart_options() {

	var default_pie_chart_options_btn = document.getElementById('default_pie_chart_options_btn');
	var pie_chart_max_variables_field = document.getElementById('pie_chart_max_variables_field');
	var pie_chart_max_legend_rows_field = document.getElementById('pie_chart_max_legend_rows_field');
	
	var max_variables = _default_graphs.pie_chart.max_variables;
	var max_legend_rows = _default_graphs.pie_chart.max_legend_rows;
	
	var disabled_state = true;
	
	if (default_pie_chart_options_btn.checked) {
		
		if (pie_chart_property_exists('max_variables')) {
			max_variables = _report_elements[_active_report_element_index].graphs.pie_chart.max_variables;
		}
		
		if (pie_chart_property_exists('max_legend_rows')) {
			max_legend_rows = _report_elements[_active_report_element_index].graphs.pie_chart.max_legend_rows;
		}
		
		disabled_state = false;
	}

	pie_chart_max_variables_field.disabled = disabled_state;
	pie_chart_max_legend_rows_field.disabled = disabled_state;
	
	pie_chart_max_variables_field.value = max_variables;
	pie_chart_max_legend_rows_field.value = max_legend_rows;
}

function set_bar_line_graph_size() {

	var default_bar_line_graph_size_btn = document.getElementById('default_bar_line_graph_size_btn');
	var bar_line_graph_x_axis_length_field = document.getElementById('bar_line_graph_x_axis_length_field');
	var bar_line_graph_y_axis_height_field = document.getElementById('bar_line_graph_y_axis_height_field');
	
	var x_axis_length = _default_graphs.bar_line_graph.x_axis_length;
	var y_axis_height = _default_graphs.bar_line_graph.y_axis_height;
	var disabled_state = true;
	
	if (default_bar_line_graph_size_btn.checked) {
		
		if (bar_line_graph_property_exists('x_axis_length')) {
			x_axis_length = _report_elements[_active_report_element_index].graphs.bar_line_graph.x_axis_length;
		}
		if (bar_line_graph_property_exists('y_axis_height')) {
			y_axis_height = _report_elements[_active_report_element_index].graphs.bar_line_graph.y_axis_height;
		}
		
		disabled_state = false;
	}
	
	bar_line_graph_x_axis_length_field.value = x_axis_length;
	bar_line_graph_y_axis_height_field.value = y_axis_height;
	bar_line_graph_x_axis_length_field.disabled = disabled_state;
	bar_line_graph_y_axis_height_field.disabled = disabled_state;
}

function set_pie_chart_size() {
	
	var default_pie_chart_size_btn = document.getElementById('default_pie_chart_size_btn');
	var pie_chart_x_axis_length_field = document.getElementById('pie_chart_x_axis_length_field');
	var pie_chart_y_axis_height_field = document.getElementById('pie_chart_y_axis_height_field');
	
	var x_axis_length = _default_graphs.pie_chart.x_axis_length;
	var y_axis_height = _default_graphs.pie_chart.y_axis_height;
	var disabled_state = true;
	
	if (default_pie_chart_size_btn.checked) {
		
		if (pie_chart_property_exists('x_axis_length')) {
			x_axis_length = _report_elements[_active_report_element_index].graphs.pie_chart.x_axis_length;
		}
		if (pie_chart_property_exists('y_axis_height')) {
			y_axis_height = _report_elements[_active_report_element_index].graphs.pie_chart.y_axis_height;
		}
		
		disabled_state = false;
	}
	
	pie_chart_x_axis_length_field.value = x_axis_length;
	pie_chart_y_axis_height_field.value = y_axis_height;
	pie_chart_x_axis_length_field.disabled = disabled_state;
	pie_chart_y_axis_height_field.disabled = disabled_state;
}

function build_and_validate_graphs_object(main_field) {
	
	// builds a final graph opject to be saved in _report_elements[{type:'table', graphs:{}, ...}, ...]
	// 
	// the graphs object is only set if one the options is checked
	// to overwrite the default values.
	
	// Note, if all graph options are set to default then return graphs_object = null;
	// if there is an invalid size option, then return graphs_object.error = true;
	
	var chrono = (main_field == 'date_time' || main_field == 'day_of_week' || main_field == 'hour_of_day') ? true : false;
	
	var graphs_object = new Object();
	var bar_line_graph_object = new Object();
	var pie_chart_object = new Object();
	
	var graphs_set = false;
	var bar_line_graph_set = false;
	var pie_chart_set = false;
	
	if (chrono) {
	
		var default_chrono_graph_type = get_value('default_chrono_graph_type_btn');
		var default_chrono_graph_sort_direction = get_value('default_chrono_graph_sort_direction_btn');
		var default_chrono_pie_chart_options = get_value('default_chrono_pie_chart_options_btn');
		var default_chrono_bar_line_graph_size = get_value('default_chrono_bar_line_graph_size_btn');
		var default_chrono_pie_chart_size = get_value('default_chrono_pie_chart_size_btn')
	
		if (default_chrono_graph_type) {  // if true its custom
			
			graphs_set = true;
			graphs_object.graph_type = get_graph_type(chrono);
			// alert(graphs_object.graph_type);
		}
		
		if (default_chrono_graph_sort_direction) {
			
			graphs_set = true;
			var chrono_graph_sort_descending_btn = document.getElementById('chrono_graph_sort_descending_btn');
			graphs_object.sort_direction = chrono_graph_sort_descending_btn.checked ? 'descending' : 'ascending';
		}
		
		if (default_chrono_pie_chart_options) {
			
			pie_chart_set = true;
			var max_legend_rows = get_value('chrono_pie_chart_max_legend_rows_field');
			
			if (value_is_integer_min_msg(max_legend_rows, 1, _msg_invalid_pie_chart_max_legend_rows)) {
				pie_chart_object.max_legend_rows = max_legend_rows;
			}
			else {
				graphs_object.error = true;
				return graphs_object;
			}			
		}
		
		if (default_chrono_bar_line_graph_size) {
			
			bar_line_graph_set = true;
			var x_axis_length = get_value('chrono_bar_line_graph_x_axis_length_field');
			var y_axis_height = get_value('chrono_bar_line_graph_y_axis_height_field');
			
			if (value_is_integer_min_msg(x_axis_length, _bar_line_graph_x_min, _msg_invalid_bar_line_graph_x_axis_length) &&
				value_is_integer_min_msg(y_axis_height, _bar_line_graph_y_min, _msg_invalid_bar_line_graph_y_axis_height)) {
					
				bar_line_graph_object.x_axis_length = x_axis_length;
				bar_line_graph_object.y_axis_height = y_axis_height;
			}
			else {
				graphs_object.error = true;
				return graphs_object;
			}
		}
		
		
		if (default_chrono_pie_chart_size) {
			
			pie_chart_set = true;
			var x_axis_length = get_value('chrono_pie_chart_x_axis_length_field');
			var y_axis_height = get_value('chrono_pie_chart_y_axis_height_field');
			
			if (value_is_integer_min_msg(x_axis_length, _pie_chart_x_min, _msg_invalid_pie_chart_x_axis_length) &&
				value_is_integer_min_msg(y_axis_height, _pie_chart_y_min, _msg_invalid_pie_chart_y_axis_height)) {
					
				pie_chart_object.x_axis_length = x_axis_length;
				pie_chart_object.y_axis_height = y_axis_height;
			}
			else {
				graphs_object.error = true;
				return graphs_object;
			}
		}		
	}
	else {
		
		// none chrono graphs
		
		var default_graph_type = get_value('default_graph_type_btn');
		var default_graph_sort_direction = get_value('default_graph_sort_direction_btn');
		var default_bar_line_graph_options = get_value('default_bar_line_graph_options_btn');
		var default_pie_chart_options = get_value('default_pie_chart_options_btn');
		var default_bar_line_graph_size = get_value('default_bar_line_graph_size_btn');
		var default_pie_chart_size = get_value('default_pie_chart_size_btn')

		
		if (default_graph_type) {  // if true its custom
			
			graphs_set = true;
			graphs_object.graph_type = get_graph_type(chrono);
			// alert(graphs_object.graph_type);
		}
		
		if (default_graph_sort_direction) {
			
			graphs_set = true;
			var graph_sort_all_by_field_btn = document.getElementById('graph_sort_all_by_field_btn');
			graphs_object.sort_all_descending = graph_sort_all_by_field_btn.checked ? false : true;
		}
		
		if (default_bar_line_graph_options) {
			
			bar_line_graph_set = true;
			
			bar_line_graph_object.show_remainder = get_value('bar_line_graph_show_remainder_btn');
			bar_line_graph_object.show_legend = get_value('bar_line_graph_show_legend_btn');
			
			var max_variables = get_value('bar_line_graph_max_variables_field');
			var max_legend_rows = get_value('bar_line_graph_max_legend_rows_field');

			if (value_is_integer_min_msg(max_variables, 1, _msg_invalid_bar_line_graph_max_variables) &&
				value_is_integer_min_msg(max_legend_rows, 1, _msg_invalid_bar_line_graph_max_legend_rows)) {
					
				bar_line_graph_object.max_variables = max_variables;
				bar_line_graph_object.max_legend_rows = max_legend_rows;
				
			}
			else {
				graphs_object.error = true;
				return graphs_object;
			}
		}
		
		
		if (default_pie_chart_options) {
			
			pie_chart_set = true;
			
			var max_variables = get_value('pie_chart_max_variables_field');
			var max_legend_rows = get_value('pie_chart_max_legend_rows_field');

			if (value_is_integer_min_msg(max_variables, 1, _msg_invalid_pie_chart_max_variables) &&
				value_is_integer_min_msg(max_legend_rows, 1, _msg_invalid_pie_chart_max_legend_rows)) {
					
				pie_chart_object.max_variables = max_variables;
				pie_chart_object.max_legend_rows = max_legend_rows;
			}
			else {
				graphs_object.error = true;
				return graphs_object;
			}
		}
		
		if (default_bar_line_graph_size) {
			
			bar_line_graph_set = true;
			var x_axis_length = get_value('bar_line_graph_x_axis_length_field');
			var y_axis_height = get_value('bar_line_graph_y_axis_height_field');
			
			if (value_is_integer_min_msg(x_axis_length, _bar_line_graph_x_min, _msg_invalid_bar_line_graph_x_axis_length) &&
				value_is_integer_min_msg(y_axis_height, _bar_line_graph_y_min, _msg_invalid_bar_line_graph_y_axis_height)) {
					
				bar_line_graph_object.x_axis_length = x_axis_length;
				bar_line_graph_object.y_axis_height = y_axis_height;
			}
			else {
				graphs_object.error = true;
				return graphs_object;
			}
		}
		
		if (default_pie_chart_size) {
			
			pie_chart_set = true;
			var x_axis_length = get_value('pie_chart_x_axis_length_field');
			var y_axis_height = get_value('pie_chart_y_axis_height_field');
			
			if (value_is_integer_min_msg(x_axis_length, _pie_chart_x_min, _msg_invalid_pie_chart_x_axis_length) &&
				value_is_integer_min_msg(y_axis_height, _pie_chart_y_min, _msg_invalid_pie_chart_y_axis_height)) {
					
				pie_chart_object.x_axis_length = x_axis_length;
				pie_chart_object.y_axis_height = y_axis_height;
			}
			else {
				graphs_object.error = true;
				return graphs_object;
			}
		}
	}
	
	if (graphs_set || bar_line_graph_set || pie_chart_set) {
		
		if (bar_line_graph_set) {
			
			graphs_object.bar_line_graph = bar_line_graph_object;
		}
		
		if (pie_chart_set) {
			
			graphs_object.pie_chart = pie_chart_object;
		}
	}
	else {
		
		graphs_object = null;
	}
	
	return graphs_object;
}

function get_graph_type(chrono) {
	
	var graph_type;
	
	var bar_graph_id = chrono ? 'chrono_bar_graph_btn' : 'bar_graph_btn';
	var line_graph_id = chrono ? 'chrono_line_graph_btn' : 'line_graph_btn';
	
	var bar_graph_btn = document.getElementById(bar_graph_id);
	var line_graph_btn = document.getElementById(line_graph_id);
	
	if (bar_graph_btn.checked) {
		
		graph_type = 'bar';
	}
	else if (line_graph_btn.checked) {
		graph_type = 'line';
	}
	else {
		graph_type = 'pie';
	}
	
	return graph_type;
}