//
// preferences
//


var theList;
var itemsDb = [];  // items work array
var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes

var saveChangesBtn = null;
var undoAllChangesBtn = null;

var validator = new util.Validator();

function getPreferencesData() {
	
	if (!pageInfo.exitActive) {
		
		var url = '?dp+templates.admin_pages.preferences.get_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
}

function getPreferencesDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
		
		// get itemsDb
		itemsDb = dat;
		itemsDbBackup = util.cloneObject(dat);
		
		// Init
		init();
		initItems();
		
		util.showE('form_section');
		
		adminConfig.setItemListSize();
		yEvent.addListener(window, 'resize', adminConfig.setItemListSize);
		
		pageInfo.initComplete = true;
	}
}

function init() {
	
	saveChangesBtn = new util.ToolbarButton('save_changes', savePreferences, toolbarButtonsDb);	
	undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	yEvent.addListener('password:password_expires', 'click', togglePasswordExpires);
	yEvent.addListener('password:prevent_use_of_previous_passwords', 'click', togglePreventUseOfPreviousPasswords);
	
	saveChangesBtn.enable();
	undoAllChangesBtn.enable();
	
	if (pageInfo.permissions.isEdit) {
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	
	// Init help
	util.helpWindow.init('');
	
	// init OptionInfo
	adminConfig.optionInfo.init('item_list', 'list');
	
	// Create the list object
	theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
	});
}

function initItems() {
	
	// Sets all input controls to initial itemsDb values
	// Also used upon Undo Changes

	//
	//	Init item list
	//
	
	// util.showObject(itemsDb);

	theList.init(itemsDb);
	
	// util.showObject(theList);
	
	setItem('i0');
	
	//
	// Init form data
	//
	
	for (var i = 0; i < itemsDb.length; i++) {
		
		var itemType = itemsDb[i].type;
		var itemDat = itemsDb[i].dat;
		
		// alert('itemType: ' + itemType);
		// util.showObject(itemDat);
	
		for (var j = 0; j < itemDat.length; j++) {
			
			var name = itemDat[j].name;
			var value = itemDat[j].value;
			
			if (itemType != 'security_permissions') {
		
				var idPrefix = itemType.indexOf('email_') == -1 ? itemType : 'email';
				var elementId = idPrefix + ':' + name;
				
				if (name == 'security_mode') {
					elementId = (value == 'browse_and_modify') ? 'security:browse_and_modify' : 'security:browse_only';
					value = true;
				}
				
				util.setF(elementId, value);
			}
			else {
				// set permission checkboxes
				var checkboxBitValues = octalToBit(value);
				for (var k = 0; k < checkboxBitValues.length; k++) {
					var elementId = 'security:' + name + ':bit' + k; // k is equal bit number
					util.setF(elementId, checkboxBitValues[k]);
				}
			}
		}
	}
	
	//
	// Set password enabled/disabled field state
	//
	togglePasswordExpires();
	togglePreventUseOfPreviousPasswords();
}

function togglePasswordExpires() {
	// Enable/disable days_until_password_expiration input field
	var isPasswordExpires = util.getF('password:password_expires');
	util.enableE('password:days_until_password_expiration', isPasswordExpires);
}

function togglePreventUseOfPreviousPasswords() {
	// Enable/disable number_of_previous_passwords_to_check input field
	var isPreventUseOfPreviousPasswords = util.getF('password:prevent_use_of_previous_passwords');
	util.enableE('password:number_of_previous_passwords_to_check', isPreventUseOfPreviousPasswords);
}

function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		setItem(itemId);
	}
}

function setItem(itemId) {
	
	theList.selectItem(itemId);
	displayForm(itemId);
}

function displayForm(itemId) {
	
	var item = theList.getSelectedItem();
	var itemType = item.type;
	
	// Hide all forms
	var a = ['miscellaneous', 'server', 'security', 'password', 'security_permissions', 'email_smtp', 'email_miscellaneous', 'email_command_line'];
	for (var i = 0; i < a.length; i++) {
		util.hideE(a[i] + ':form');
	}
	
	util.showE(itemType + ':form');
	util.updateT('item_form_label', item.label);
}

function validateActiveItem() {
	
	// Only validate if isEdit permission
	
	if (pageInfo.permissions.isEdit) {
		
		validator.reset();
		var activeItem = theList.getSelectedItem();
		
		var itemType = activeItem.type;
		
		// For each itemType get a copy of item.dat and override it with form values
		// which will then be saved back to item.dat upon data change.
		
		var formDat = util.cloneObject(activeItem.dat);
		
		// util.showObject(formDat);
		
		// get all formvalues
			
		for (var i = 0; i < formDat.length; i++) {
			
			var name = formDat[i].name;
			
			if (itemType != 'security_permissions') {
				
				var idPrefix = itemType.indexOf('email_') == -1 ? itemType : 'email';
				var elementId = idPrefix + ':' + name;
			
				var formValue;
				
				switch (elementId) {
					
					case 'miscellaneous:temporary_files_lifespan':
						formValue = validator.isInteger(elementId, 0);
						break;
						
					case 'server:web_server_port':
						formValue = validator.isInteger(elementId, 0, 65535);
						break;
						
					case 'server:cgi_directory':
						formValue = validator.isValue(elementId);
						break;
						
					// 2008-06-02 - GMF - Option deprecated
					// case 'server:maximum_cpu_usage_percent':
					// formValue = validator.isInteger(elementId, 1, 100);
					// break;
						
					case 'server:maximum_number_of_threads':
						formValue = validator.isInteger(elementId, 1);
						break;
						
					case 'security:security_mode':
						formValue = util.getF('security:browse_and_modify') ? 'browse_and_modify' : 'browse_only';
						break;
						
					case 'security:server_session_timeout':
						formValue = validator.isInteger(elementId, 0);
						break;
						
					case 'security:administrative_remote_user':
						formValue = validator.isValue(elementId);
						break;
	
					case 'password:days_until_password_expiration':
						// We only validate the form value if expiration is checked!
						if (util.getF('password:password_expires')) {
							formValue = validator.isInteger(elementId, 0, 65535);
						}
						else {
							formValue = util.getF(elementId);
						}
						break;
						
					case 'password:minimum_length':
						formValue = validator.isInteger(elementId, 0, 65535);
						break;
	
					case 'password:number_of_previous_passwords_to_check':
						// We only validate the form value if prevent_use_of_previous_passwords is checked!
						if (util.getF('password:prevent_use_of_previous_passwords')) {
							formValue = validator.isInteger(elementId, 0, 65535);
						}
						else {
							formValue = util.getF(elementId);
						}
						break;
	
					default:
						
						if (elementId == 'email:global_support_email_address' ||
							elementId == 'email:global_actions_email_address' ||
							elementId == 'email:global_actions_return_address' ||
							elementId == 'email:return_address' ||
							elementId == 'email:recipient_address' ||
							elementId == 'email:cc_address' ||
							elementId == 'email:bcc_address') {
												
							// Validate email addresses only if an address is specified
							formValue = (util.getF(elementId) == '') ? '' : validator.isEmailAddresses(elementId);
						}
						else {
							
							formValue = util.getF(elementId);
						}
						break;
				}
				
				formDat[i].value = formValue;
			}
			else {
				
				// get octal value for permissions
				var octalValueOri = formDat[i].value;
				
				var octalSum = 0;
				var bitToOctalMap = [1, 2, 4, 10, 20, 40, 100, 200, 400, 1000];
							
				for (var j = 0; j < 10; j++) {
					
					var elementId = 'security:' + name + ':bit' + j; // j is equal bit number
					if (util.getF(elementId)) {
						// if checked add the corresponding bit value to the sum
						octalSum += bitToOctalMap[j];
					}
				}
				
				// Note, the octalSum must be of type string!
				formDat[i].value = octalSum.toString();
			}
		}
	
			
		if (validator.allValid()) {
			
			// util.showObject(formDat);
			theList.saveItem(formDat);
			// util.showObject(theList);
			return true;
		}
		
		return false;
	}
	
	// No isEdit permission
	return true;
}

function savePreferences() {
	
	if (validateActiveItem()) {
		
		var isModified = theList.getIsModified();
		
		// alert('saveChanges() - isModified: ' + isModified);
		
		if (isModified) {
			
			util.hideE('form_section');
			util.showE('saving_info');
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			
			for (var i = 0; i < itemsDb.length; i++) {
				
				var itemType = itemsDb[i].type;
				var itemDat = itemsDb[i].dat;
				
				// var path = (itemType != 'security_permissions') ? 'v.fp.' + itemType : 'v.fp.security';
				var path = '';
				
				if (itemType.indexOf('email_') != -1) {
					path = 'v.fp.email'
				}
				else if (itemType == 'security_permissions') {
					path = 'v.fp.security';
				}
				else {
					path = 'v.fp.' + itemType;
				}
				
				for (var j = 0; j < itemDat.length; j++) {
					dat += path + '.' + itemDat[j].name + '=' + itemDat[j].value + '&';
				}
			}
			
			dat = dat.replace(/&$/, '');
	
			// alert('dat:\n' + dat);
			
			var url = '?dp+templates.admin_pages.preferences.save_data';	
			util.serverPost(url, dat);
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function savePreferencesRespsonse(languageChanged) {
	
	if (!languageChanged) {
		
		// reset isModified
		theList.resetIsModified();
		
		// the saved work itemsDb becomes now the itemsDbBackup
		itemsDbBackup = util.cloneObject(itemsDb);
	
		util.hideE('saving_info');
		util.showE('form_section');
	}
	else {
		// reload the page to display the new language
		location.reload(true);
	}
}

function undoAllChanges() {
	
	itemsDb = util.cloneObject(itemsDbBackup);
	initItems();
}

function getIsModifiedPage() {
	
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	
	// alert('getIsModifiedPage() - theList.getIsModified(): ' + theList.getIsModified());
	
	if (!validateActiveItem() || theList.getIsModified()) {
		return true;
	}
	
	return false;
}

function octalToBit(octalString) {
	
	var octalToBinaryMap = ['000', '001', '010', '011', '100', '101', '110', '111'];
	var octalNumbers = octalString.split('');
	var binaryString = '';
	for (var i = 0; i < octalNumbers.length; i++) {
		var theOctal = parseInt(octalNumbers[i], 10);
		binaryString += octalToBinaryMap[theOctal];
	}
	
	var binaryArray = binaryString.split('');
	binaryArray.reverse(); // bit0 is now equal array index 0
	
	// map the binary value to checkbox true/false values,(bit0 matches 0 array index)
	var checkboxBits = [];
	for (var i = 0; i < 10; i++) {
		var bitValue = (binaryArray[i] != null) ? binaryArray[i] : 0;
		bitValue = (parseInt(bitValue, 10) == 1);
		checkboxBits[i] = bitValue;
	}
	
	// alert('binaryString: ' + binaryString + '\nbinaryArray reversed: ' + binaryArray + '\ncheckboxBits: ' + checkboxBits);

	return checkboxBits;
}
