//
// duplicateProfile.js
//


var duplicateProfile = {
	
	panel: null,
	validator: null,
	
	sourceProfileName: '',
	existingProfileLabels: [],
	existingProfileNames: [],
	
	init: function() {
		
		var panelObj = {
			panelId: 'duplicate_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.duplicate_profile_title'),
			// left: 100,
			// top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: duplicateProfile.close
		};
		
		duplicateProfile.panel = new util.Panel3(panelObj);
		
		duplicateProfile.validator = new util.Validator();
		
		yEvent.addListener('duplicate_profile:ok_btn', 'click', duplicateProfile.duplicateAndSave);
		yEvent.addListener('duplicate_profile:cancel_btn', 'click', duplicateProfile.close);
	},
	
	open: function(itemId) {
		
		if (!duplicateProfile.panel) {
			duplicateProfile.init();
		}
		
		var theProfile = profiles.profilesDb[h(itemId)];
		
		var profileLabel = theProfile.label;
		var profileInfoText = langVar('lang_admin.profiles.duplicate_profile_info') + ':';
		profileInfoText = profileInfoText.replace(/__PARAM__1/, profileLabel);
		
		util.updateT('duplicate_profile:info_text', profileInfoText);
		
		var defaultProfileLabel = langVar('lang_stats.general.item_copy');
		defaultProfileLabel = defaultProfileLabel.replace(/__PARAM__1/, profileLabel);
		util.setF('duplicate_profile:profile_label', defaultProfileLabel);
		
		// Set sourceProfileName
		duplicateProfile.sourceProfileName = theProfile.name;
		
		// Reset existingProfileLabels and existingProfileNames
		duplicateProfile.existingProfileLabels = [];
		duplicateProfile.existingProfileNames = [];
		
		duplicateProfile.panel.prePositionAtCenter();
		duplicateProfile.panel.open();
		
		var inputElement = util.getE('duplicate_profile:profile_label');
		inputElement.focus();
	},
	
	close: function() {
		
		duplicateProfile.validator.reset();
		duplicateProfile.panel.close();
	},
	
	duplicateAndSave: function() {
		
		var validator = duplicateProfile.validator;
		
		var existingProfileLabels = duplicateProfile.existingProfileLabels;
		var existingProfileNames = duplicateProfile.existingProfileNames;
		
		if (existingProfileLabels.length == 0) {
			
			// Get existingProfileLabels and existingProfileNames
			var profilesDb = profiles.profilesDb;
			for (var i = 0; i < profilesDb.length; i++) {
				var profileItem = profilesDb[i];
				existingProfileLabels[i] = profileItem.label;
				existingProfileNames[i] = profileItem.name;
			}
		}
		
		// util.showObject(existingProfileLabels);
		// util.showObject(existingProfileNames);
			
		var newProfileLabel = validator.isValue('duplicate_profile:profile_label');
		newProfileLabel = validator.isUnique('duplicate_profile:profile_label', existingProfileLabels);
		
		if (validator.allValid()) {
			
			duplicateProfile.close();
			util.hideE('profiles_list_container');
			util.showE('saving_info');
			
			var newProfileName = util.labelToUniqueNodeName(newProfileLabel, existingProfileNames, 'profile');
			
			// alert('newProfileName: ' + newProfileName);
			
			var url = '?dp+templates.admin_pages.profiles.duplicate_profile';
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.source_profile_name=' + duplicateProfile.sourceProfileName + '&';
			dat += 'v.fp.new_profile_name=' + newProfileName + '&';
			dat += 'v.fp.new_profile_label=' + encodeURIComponent(newProfileLabel) ;
			
			util.serverPost(url, dat);
		}
	},
	
	duplicateAndSaveResponse: function(dat) {
		
		// util.showObject(dat);
		
		var errorMessage = dat.errorMessage;
				
		// Update profilesDb and profiles display
		updateNumberOfAllProfiles(dat.numberOfAllProfiles);
		updateProfilesDb(dat.profilesDb);
		updateProfilesDisplay();
				
		if (errorMessage != '') {
			alert(errorMessage);
		}
	}
};
