//
// newProfileInfo.js
//

var newProfileInfo = {
	
	// newProfileItemId: '',
	
	panel: null,
	
	
	init: function() {
		
		var panelObj = {
			panelId: 'new_profile_info:panel',
			panelClassName: 'panel-30',
			panelHeaderLabel: '-',
			zIndex: 20,
			isCover: true,
			closeEvent: newProfileInfo.close
		};
		
		newProfileInfo.panel = new util.Panel3(panelObj);
		
		yEvent.addListener('new_profile_info:close_btn', 'click', newProfileInfo.close);
	},
	
	openViaNewProfileWizard: function(newProfileNodeName, numberOfAllProfiles, profilesDb) {
		
		// This function is called from New Profile Wizard when the profile has been saved.
		// profilesDb is up to date which includes the new profile.
		
		//
		// Close new profile wizard window
		//
		profiles.newProfileWizardWindow.blur() // Hack for Firefox problem which doesn't close the window immediately, though blur moves it to the background!
		profiles.newProfileWizardWindow.close();

		
		//
		// Update profiles.profilesDb
		//
		
		// Note, we can't just set
		// profiles.profilesDb = profilesDb
		// because IE keeps a reference to the New Profile Window which doesn't anymore exist.
		// Further, a simple clone of profilesDb doesn't work either due a somewhat strange structure
		// of profilesDb.
		
		// So we create a new profilesDb and clone each profilesDb object item individually.
		
		var newProfilesDb = [];
		
		for (var i = 0; i < profilesDb.length; i++) {
			
			var profileItem = profilesDb[i];
			// util.showObject(profilesDb[i]);
			newProfilesDb[i] = util.cloneObject(profileItem);
		}
		
		// util.createHash(profiles.profilesDb, 'itemId');
		
		// Update profilesDb and profiles display so that the new profile
		// is actually visible hrough the transparent cover.
		updateNumberOfAllProfiles(numberOfAllProfiles);
		updateProfilesDb(newProfilesDb);
		updateProfilesDisplay();
		
		// Open new profile info panel
		newProfileInfo.open(newProfileNodeName);
	},
	
	open: function(newProfileNodeName) {
		
		// alert('open newProfileInfo for profile: ' + newProfileNodeName);
		
		var profilesDb = profiles.profilesDb;
		var newProfileItemId = '';
		
		// Get profileItemId
		for (var i = 0; i < profilesDb.length; i++) {
			var profileItem = profilesDb[i];
			if (profileItem.name == newProfileNodeName) {
				newProfileItemId = profileItem.itemId;
				break;
			}
		}
		
		var newProfileItem = profilesDb[h(newProfileItemId)];
		
		//
		// Init newProfileInfo panel
		//
		
		if (!newProfileInfo.panel) {
			newProfileInfo.init();
		}
		
		//
		// Get the new profile object in profilesDb
		//
		
		// Keep itemId for new profile delete action
		// newProfileInfo.newProfileItemId = newProfileItem.itemId;
		
		
		// Update the info label
		var label = langVar('lang_admin.profiles.profile_has_been_created');
		label = label.replace(/__PARAM__1/, newProfileItem.label);
		util.updateT('new_profile_info:label', label);
		
		//
		// Handle View Reports, View Config and Delete link
		//
		
		var isViewReportsPermission = newProfileItem.isVR;
		var defaultConfigPageIndex = newProfileItem.dcpi;
		var isViewConfigPermission = (defaultConfigPageIndex > -1);
		// var isDeletePermission = newProfileItem.isDelete;
		
		if (isViewReportsPermission) {
			
			var viewReportsBtn = util.getE('new_profile_info:view_reports_btn');
			var viewReportsUrl = '?dp=reports&p=' + newProfileNodeName;
			if (newProfileItem.df != '') {
				viewReportsUrl += '&df=' + newProfileItem.df;
			}
			viewReportsBtn.href = viewReportsUrl;
		}
		
		if (isViewConfigPermission) {
			
			var viewConfigBtn = util.getE('new_profile_info:view_config_btn');
			var defaultConfigPage = profiles.configPagesDb[defaultConfigPageIndex];
			var viewConfigUrl = '?dp=config&page=' + defaultConfigPage + '&p=' + newProfileNodeName;
			viewConfigBtn.href = viewConfigUrl;
		}
		
		util.showE('new_profile_info:view_reports_btn', isViewReportsPermission);
		util.showE('new_profile_info:view_config_btn', isViewConfigPermission);
		// util.showE('new_profile_info:delete_profile_btn', isDeletePermission);
		
		//
		// Show profiles list and new profile info
		//
	
		util.showE('profiles_list_container');
		
		newProfileInfo.panel.prePositionAtCenter();
		newProfileInfo.panel.open();
	},
	
	close: function() {
		
		newProfileInfo.panel.close();
	}
}
