//
// admin profiles
//


var h = util.h;

var profiles = {
	
	configPagesDb: [], // ['profile_info', 'log_source', ...], required to get the default config page for non-root-admins
	profilesDb: [],
	numberOfLicensedProfiles: 0,
	numberOfAllProfiles: 0, /* This is the number of all profiles,
		regardless if the user has actually access to all of them.
		This may not match the length of profilesDb! */
		
	newProfileBtn: null,
	newProfileWizardWindow: null
}

function updateNumberOfAllProfiles(numberOfAllProfiles) {
	
	profiles.numberOfAllProfiles = numberOfAllProfiles;
}

function updateProfilesDb(profilesDb) {
	
	// A new profilesDb has been loaded, so we need to update profiles.profilesDb and the hash.
	profiles.profilesDb = profilesDb
	util.createHash(profiles.profilesDb, 'itemId');
}

function updateProfilesDisplay() {
	
	// A new profilesDb has been loaded, the number of profiles might have changed.

	util.hideE([
		'profiles_list_container',
		'saving_info',
		'deleting_info',
		'no_profile_info',
		'max_profiles_exceeded_info'
	]);
	
	if (profiles.profilesDb.length > 0) {
		
		createProfilesList();
		util.showE('profiles_list_container');
	}
	else {
		
		util.showE('no_profile_info');
	}
	
	// Check if there is a limit on the number of profiles
	var numberOfLicensedProfiles = profiles.numberOfLicensedProfiles;
	
	// Note, check for number_of_licensed_profiles element existence because the element is not always available
	if (numberOfLicensedProfiles != 0 && (util.getE('licensed_profiles_info') != null)) {
		
		// Update text
		var numberOfAllProfiles = profiles.numberOfAllProfiles;
		util.updateT('licensed_profiles_info:number_of_licensed_profiles', numberOfLicensedProfiles);
		util.updateT('licensed_profiles_info:number_of_used_profiles', numberOfAllProfiles);
		util.showE('licensed_profiles_info');
	
		// If all profiles exceeds number of licensed profiles
		if (numberOfAllProfiles > numberOfLicensedProfiles) {

			util.updateT('max_profiles_exceeded_info:number_of_profiles', numberOfAllProfiles);
			util.updateT('max_profiles_exceeded_info:number_of_licensed_profiles', numberOfLicensedProfiles);
			util.showE('max_profiles_exceeded_info');
		}
	}
	
	util.showE('form_section');
}

function getProfileData() {

	if (!pageInfo.exitActive) {
		
		var url = '?dp+templates.admin_pages.profiles.get_profile_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
}

function getProfileDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
		
		profiles.configPagesDb = dat.configPagesDb;
		profiles.numberOfLicensedProfiles = dat.numberOfLicensedProfiles;
	
		updateNumberOfAllProfiles(dat.numberOfAllProfiles);
		updateProfilesDb(dat.profilesDb);
		
		// util.showObject(profiles.profilesDb);
		
		profiles.newProfileBtn = new util.ToolbarButton('new_profile', createNewProfile, toolbarButtonsDb);
		
		// Init help
		util.helpWindow.init('');
		
		yEvent.addListener('profiles_list_container', 'click', profileLinkActivated);
		profiles.newProfileBtn.enable();
		
		updateProfilesDisplay();
	}
}

function profileLinkActivated(evt) {
	
	// Global event on profiles list table, used for duplicate, rename and delete
	
	var element = evt.target || evt.srcElement;
	var elementId = element.id;
	
	// alert('profileLinkActivated() - elementId: ' + elementId);
	var pattern = /:(duplicate|rename|delete|toggle_invalid_profile_text)/;
	
	// if (elementId.indexOf(':delete:') != -1) {
	if (pattern.test(elementId)) {
		
		var dat = elementId.split(':');
		var itemId = dat[0];
		var operationKeyWord = dat[2];
		
		switch (operationKeyWord) {
			
			case 'rename':
			
				renameProfile.open(itemId);
				break;
			
			case 'duplicate':
			
				duplicateProfile.open(itemId);
				break;
				
			case 'delete':
			
				deleteProfile(itemId);
				break;
				
			case 'toggle_invalid_profile_text':
				
				toggleInvalidProfileText(itemId);
				break;
		}
	}
}

function createNewProfile() {
	
	var width = 760;
 	var height = 550;
	var windowName = 'new_profile_wizard'
	var url = '?dp+templates.new_profile_wizard.index';
	
	// util.newWindow(url, windowName, width, height);
	
	var left = parseInt((screen.availWidth/2) - (width/2), 10);
    var top = parseInt((screen.availHeight/2) - (height/2), 10);
	profiles.newProfileWizardWindow = window.open(url,windowName,'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',status=yes,scrollbars=yes,resizable=yes');
    profiles.newProfileWizardWindow.focus();
}


function deleteProfile(itemId) {
		
	var profilesDb = profiles.profilesDb;
	
	// alert('deleteProfile() - itemId:' + itemId);
	// util.showObject(profilesDb);
	
	var profileItem = profilesDb[h(itemId)];
	var profileLabel = profileItem.label;
	
	var msg = langVar('lang_admin.profiles.confirm_delete_message');
	msg = msg.replace(/__PARAM__1/, profileLabel);
	
	if (confirm(msg)) {
		
		util.hideE('form_section');
		util.showE('deleting_info');
		
		var url = '?dp+templates.admin_pages.profiles.delete_profile';
		
		// -p (profile name) is required by erase_database()!
		// Specify "-p" for valid profiles only, else we get a server error!
		if (profileItem.isValidProfile) {
			url += '+p+' + profileItem.name;
		}
		
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.is_valid_profile=' + profileItem.isValidProfile + '&';
		dat += 'v.fp.profile_name=' + profileItem.name;

		util.serverPost(url, dat);
	}
	
	return false;
}

function deleteProfileResponse(dat) {
	
	updateNumberOfAllProfiles(dat.numberOfAllProfiles);
	updateProfilesDb(dat.profilesDb);
	
	// Update profiles display
	updateProfilesDisplay();
}

function toggleInvalidProfileText(itemId) {
	
	// 	alert('toggleInvalidProfileText()');
	
	var div2Element = util.getE(itemId + ':div2:invalid_profile_text');
	
	if (div2Element.style.display == 'none') {
		
		// div2Element is hidden, display it but set the optimal width before displaying it.
		var div1Region = yDom.getRegion(itemId + ':div1:invalid_profile_text');
		var width = div1Region.width;
		// make sure that we are not too narrow or too wide
		if (width < 260 || width > 500) {
			width = 340;
		}
		
		div2Element.style.width = width + 'px';
		div2Element.style.display = 'block';
	}
	else {
		// div2Element is already displayed, hide it
		div2Element.style.display = 'none';
	}
}

function createProfilesList() {
	
	// createProfilesList is called upon initial page load and when a new profile
	// has been created, so we have to clear any existing list.

	function compareProfileLabels(a, b) {
		var labelA = a.label.toLowerCase();
		var labelB = b.label.toLowerCase();
		if (labelA < labelB) {return -1}
		if (labelA > labelB) {return 1}
		return 0;
	}
	
	var isAdd = pageInfo.permissions.isAdd;
	var isAdminLike = (pageInfo.isRootAdmin || isAdd || pageInfo.permissions.isDelete);
	var profilesDb = profiles.profilesDb;
	
	profilesDb.sort(compareProfileLabels);
	
	// util.showObject(profilesDb);
	
	var table = util.getE('profiles_list_container');
	util.removeChildElements(table);
	
	var tbody = document.createElement('tbody');
	// var addRowBackground = true;
	
	for (var i = 0; i < profilesDb.length; i++) {
		
		var item = profilesDb[i];
		// addRowBackground = !addRowBackground;
		
		createListEntry(
			isAdminLike,
			tbody,
			item.itemId,
			item.isValidProfile,
			item.name,
			item.label,
			item.username,
			item.df,
			item.isVR,
			item.dcpi,
			isAdd,
			item.isRename,
			item.isDelete
		);
	}
	
	table.appendChild(tbody);
}

function addTextLinkCell(tr, imgSrc, href, label) {
			
	var td = util.createE('td');
	var a = util.createE('a', {className:'link-50', href:href});
	var span = util.createE('span');
	var text = util.createT(label);
	var img = util.createE('img', {src:imgSrc, width:16, height:16, alt:label});
	
	util.chainE(tr, td, [a, img, [span, text]]);
}

function addIconLinkCell(tr, imgSrc, itemId, operationKeyWord, title, alt) {
	
	// operationKeyWord is: duplicate | rename | delete

	var anchorId = itemId + ':a:' + operationKeyWord;
	var imageId = itemId + ':img:' + operationKeyWord;
	
	var td = util.createE('td');
	var a = util.createE('a', {id:anchorId, className:'link-50', href:'javascript:;'});
	var img = util.createE('img', {id: imageId, src:imgSrc, width:16, height:16, title:title, alt:alt});
	
	util.chainE(tr, td, [a, img]);
}

function addEmptyCell(tr) {
	
	var td = document.createElement('td');
	var txt = document.createTextNode('\u00a0'); // creates &nbsp;
	td.appendChild(txt);
	tr.appendChild(td);
}

function addInvalidProfileCell(tr, itemId) {
	
	// The invalid profile cell spans four cells of a valid profile
	
	var td = util.createE('td', {colSpan:4, whiteSpace:'normal'});
	
	var anchorId = itemId + ':a:toggle_invalid_profile_text';
	var div1Id = itemId + ':div1:invalid_profile_text';
	var div2Id = itemId + ':div2:invalid_profile_text';
	
	var div1 = util.createE('div', {id:div1Id, whiteSpace:'nowrap', fontWeight:'bold', color:'red'});
	var text1 = util.createT(langVar('lang_admin.profiles.profile_is_v7_profile_short'));
	var a = util.createE('a', {id:anchorId, className:'link-bold-red', href:'javascript:;', marginLeft:'5px'});
	var aText = util.createT(langVar('lang_admin.general.read_more') + ' ...');
	
	var div2 = util.createE('div', {id:div2Id, whiteSpace:'normal', color:'#515151', display:'none'});
	var text2 = util.createT(langVar('lang_admin.profiles.profile_is_v7_profile_long'));
	
	util.chainE(tr, [td, [div1, text1, [a, aText]], [div2, text2]]);
}

function createListEntry(isAdminLike, tbody, itemId, isValidProfile, profileName, profileLabel, username, dateFilter, isViewReports, defaultConfigPageIndex, isAdd, isRename, isDelete) {
	
	// add profileLabel
	var tr = document.createElement('tr');
	tr.id = 'tr:' + itemId;
	
	/*
	if (addRowBackground) {
		tr.style.backgroundColor = '#f9f6f6';
	}
	*/
	
	var td = document.createElement('td');
	var txt = document.createTextNode(profileLabel);
	
	var reportsUrl = '?dp=reports&p=' + profileName;
	if (dateFilter != '') {
		reportsUrl += '&df=' + dateFilter;
	}

	td.appendChild(txt);
	
	if (isAdminLike && username != '') {
		
		var byUserLabel = ' (' + langVar('lang_admin.general.by_user') + ')';
		byUserLabel = byUserLabel.replace(/__PARAM__1/, username);
		
		var span = document.createElement('span');
		span.style.color = 'Gray';
		var spanText = document.createTextNode(byUserLabel);
		
		span.appendChild(spanText);
		td.appendChild(span);
	}
	
	tr.appendChild(td);
	
	
	if (isValidProfile) {
	
		// add View Reports link
		if (isViewReports) {
			addTextLinkCell(tr, imgDb.viewReports.src, reportsUrl, langVar('lang_stats.btn.view_reports'));
		}
		else {
			addEmptyCell(tr);
		}
		
		// add View Config link
		if (defaultConfigPageIndex > -1) {
			
			var defaultConfigPage = profiles.configPagesDb[defaultConfigPageIndex];
			addTextLinkCell(tr, imgDb.viewConfig.src, '?dp=config&page=' + defaultConfigPage + '&p=' + profileName, langVar('lang_stats.btn.view_config'));
		}
		else {
			addEmptyCell(tr);
		}
		
		// add Rename link
		if (isRename) {
			// addAnchorCell(tr, imgDb.listEditItem.src, 'javascript:;', langVar('lang_stats.btn.rename'), itemId, 'rename');
			// addAnchorCell(tr, imgDb.listEditItem.src, 'javascript:;', '', itemId, 'rename');
			addIconLinkCell(tr, imgDb.listEditItem.src, itemId, 'rename', langVar('lang_admin.profiles.rename_profile') + ' "' + profileLabel + '"', langVar('lang_admin.profiles.rename_profile'));
		}
		else {
			addEmptyCell(tr);
		}
	
	
		// add Duplicate link
		if (isAdd) {
			// addAnchorCell(tr, imgDb.listDuplicateItem.src, 'javascript:;', langVar('lang_stats.btn.duplicate'), itemId, 'duplicate');
			// addAnchorCell(tr, imgDb.listDuplicateItem.src, 'javascript:;', '', itemId, 'duplicate');
			addIconLinkCell(tr, imgDb.listDuplicateItem.src, itemId, 'duplicate', langVar('lang_admin.profiles.duplicate_profile') + ' "' + profileLabel + '"', langVar('lang_admin.profiles.duplicate_profile'));
		}
		else {
			addEmptyCell(tr);
		}
	}
	else {
		
		// Invalid profile
		addInvalidProfileCell(tr, itemId);
	}
	
	// add Delete link (we allow to delete invalid profiles!)
	if (isDelete) {
		// addAnchorCell(tr, imgDb.deleteProfile.src, 'javascript:;', langVar('lang_stats.btn.delete'), itemId, 'delete');
		// addAnchorCell(tr, imgDb.deleteProfile.src, 'javascript:;', '', itemId, 'delete');
		addIconLinkCell(tr, imgDb.deleteProfile.src, itemId, 'delete', langVar('lang_admin.profiles.delete_profile') + ' "' + profileLabel + '"', langVar('lang_admin.profiles.delete_profile'));
	}
	else {
		addEmptyCell(tr);
	}
	
	tbody.appendChild(tr);
}
