//
//
// roles.js
//
//


var h = util.h;

// var itemsDb = [];  // items work array
// var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes

var roles = {
	
	isEnterprise: false,
	activeUserNodeName: '',
	usersDb: [], // [{name:"user_1", username:"user 1"}, ...] contains user node name with username, required for the list labels where we indicate "(by user 1)"
	featureMap: [],
	rolesDb: [],
	rolesDbBackup: [],
	rolesUsedInUsersDb: {}, // KHP-RC, get roles which are used in users.cfg
	schedulerActionsDb: [],
	accessDetailsRolesDb: [], 	// Keeps the roles which are shown in Access Details, it is created from rolesDb
								// {"id":"i1", "name":"role_1", "label": "role 1"}, ... 
								// id is the itemId in rolesDb and name is the node name of a role in rolesDb
	deletedRolesDb: [], // Keeps the node names of any deleted role, i.e. ['role_1', 'role_12']
	theList: null,
	validator: null,
	// isModifiedRoles: false,
	isModifiedFeatures: false, // is set in rolesUtil.js and rolesAD.js if features of a single role are modified
	
	saveChangesBtn: null,
	newRoleBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	
	tabs: null,
	activeTabId: null, // admin | reports | config
	noItemFormIsActive: false,
	
	activeCreatedByUser: '', // keeps the active createdByUser value because it is not a form field
	
	// We keep the active Scheduler, User and Save Report Changes access details as global object while a role is edited
	accessDetails: {
		
		scheduler: {
			featureId: '', // featureId is set once upon init only
			isUnlimitedGrants: true,
			items: [] // contains active action names
		},
		users: {
			featureId: '', // featureId is set once upon init only
			isUnlimitedGrants: true,
			items: [] // contains active role names
		},
		
		saveReportChanges: {
			featureId: '', // featureId is set once upon init only
			isView: false
		},
		
		saveReportChangesToProfile: {
			featureId: '', // featureId is set once upon init only
			isView: false
		}
	}
}


/**
*
*
* 
* init functions
*
*
*
*/

function init(isEnterprise) {
	
	//
	// Main init routine
	//
		
	// alert('init roles.js');
	
	roles.validator = new util.Validator();
	
	//
	// init toolbar buttons
	//
	
	roles.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	roles.newRoleBtn = new util.ToolbarButton('new_role', newRole, toolbarButtonsDb);
	roles.duplicateBtn = new util.ToolbarButton('duplicate', duplicateRole, toolbarButtonsDb);
	roles.deleteBtn = new util.ToolbarButton('delete', deleteRole, toolbarButtonsDb);
	roles.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	//
	// Ignore/Disable buttons according RBAC
	//
	
	var permissions = pageInfo.permissions;
	
	if (permissions.isEdit) {
		
		if (!permissions.isAdd) {
			roles.newRoleBtn.disableAndIgnore();
			roles.duplicateBtn.disableAndIgnore();
		}
		
		if (!permissions.isDelete) {
			roles.deleteBtn.disableAndIgnore();
		}
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		roles.saveChangesBtn.disableAndIgnore();
		roles.newRoleBtn.disableAndIgnore();
		roles.duplicateBtn.disableAndIgnore();
		roles.deleteBtn.disableAndIgnore();
		roles.undoAllChangesBtn.disableAndIgnore();
	}
	
	// Init help
	util.helpWindow.init('');
	
	//
	// init tabs
	//
	
	var tabList = ['admin:role_tab', 'reports:role_tab', 'config:role_tab', 'miscellaneous:role_tab'];
	
	roles.tabs = new util.Tabs2(tabList, roleTabActivated);
	
	//
	// Create theList object
	//

	roles.theList = new listcontroller.List(
		{
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
		}
	);
	
	//
	// init form controls
	//
	
	if (isEnterprise) {
		yEvent.addListener('role_label', 'keyup', updateListAndFormLabel);
	}
	
	// yEvent.addListener(['scheduler_details:grants:unlimited', 'scheduler_details:grants:limited'], 'click', toggleSchedulerGrants);
	// yEvent.addListener(['users_details:grants:unlimited', 'users_details:grants:limited'], 'click', toggleUsersGrants);
}

function initMainDisplay() {
	
	// alert('initMainDisplay()');
	
	util.hideE(['form_section', 'roles_form', 'no_item_form', 'loading_info', 'saving_info']);
	
	var firstItemId = roles.theList.getFirstItemId();
	
	// alert('initMainDisplay() - firstItemId: ' + firstItemId);
	
	var isItem = (firstItemId != null) ? true : false;
	
	if (isItem) {
		// select the first item
		setRoleItem(firstItemId);
		displayNoItemForm(false);
	}
	else {
		// no item exists
		displayNoItemForm(true);
	}
	
	util.showE('form_section');
	
	setRoleTab('admin');
}

function getRolesData() {
		
	if (!pageInfo.exitActive) {
		
		var url = '?dp+templates.admin_pages.roles.get_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;

		util.serverPost(url, dat);
	}
}

function getRolesDataResponse(dat) {

	// alert('getRolesDataResponse(): ' + dat);
	
	// temp
	// return false;
		
	if (!pageInfo.exitActive) {
		
		var rolesDb = dat.rolesDb;
		
		roles.activeUserNodeName = dat.activeUserNodeName;
		roles.usersDb = dat.usersDb;
		
		roles.featureMap = dat.featureMap;
		roles.rolesDb = rolesDb;
		roles.rolesDbBackup = util.cloneObject(dat.rolesDb);
		roles.schedulerActionsDb = dat.schedulerActionsDb;
		roles.rolesUsedInUsersDb = dat.rolesUsedInUsersDb;
		
		util.createHash(roles.usersDb, 'name');
		util.createHash(roles.schedulerActionsDb, 'name');
		
		// util.showObject(roles.featureMap);
		
		var isEnterprise = (pageInfo.licensingFeatures == 'enterprise');
		roles.isEnterprise = isEnterprise;
		
		
		init(isEnterprise);
		roles.theList.init(roles.rolesDb);
		rolesUtil.initFeatures(isEnterprise);
		
		if (isEnterprise) {
			
			// Create roles.accessDetailsRolesDb for access detail list
			rolesUtil.updateAccessDetailsRolesDb(rolesDb);
			
			// Init access details panel
			rolesAD.init();
		}
		
		// Init Save Profile Changes Access Details panel
		rolesSRCAD.init();
		
		initMainDisplay();
		
		// Set final toolbar state
		roles.saveChangesBtn.enable();
		roles.undoAllChangesBtn.enable();
		roles.newRoleBtn.enable();
		updateToolbarButtons(); // handles Duplicate and Delete
		
		util.showE('form_section');
		
		adminConfig.setItemListSize();
		yEvent.addListener(window, 'resize', adminConfig.setItemListSize);
		
		pageInfo.initComplete = true;
	}
}


/**
*
*
* 
* display functions
*
*
*
*/


function displayNoItemForm(isDisplayNoItemForm) {
	
	if (isDisplayNoItemForm) {
		util.hideE('roles_form');
		util.showE('no_item_form');
	}
	else {
		util.hideE('no_item_form');
		util.showE('roles_form');
	}

	roles.noItemFormIsActive = isDisplayNoItemForm;
}

function updateToolbarButtons() {
	
	var isItems = roles.theList.isItems();
	roles.deleteBtn.enable(isItems);
	roles.duplicateBtn.enable(isItems);
}

function roleTabActivated() {
	
	// alert('roleTabActivated(): ' + this.id);
	var elementId = this.id;
	var dat = elementId.split(':');
	var tabId = dat[0];
	setRoleTab(tabId);
}

function setRoleTab(tabId) {
	
	// alert('setRoleTab(): ' + tabId);
	
	roles.tabs.setActiveTab(tabId + ':role_tab');
	
	util.hideE(['admin:features:panel', 'reports:features:panel', 'config:features:panel', 'miscellaneous:features:panel']);
	util.showE(tabId + ':features:panel');
	
	roles.activeTabId = tabId;
}

function setRoleItem(itemId) {
	
	roles.theList.selectItem(itemId);
	updateForm();
	
	// Reset isModifiedFeatures
	roles.isModifiedFeatures = false;
}

/**
*
*
* 
* form handling functions
*
*
*
*/

function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		setRoleItem(itemId);
	}
}

function newRole() {
	
	
	if (validateActiveItem()) {
		
		var theList = roles.theList;
	
		var newItemId = theList.getNewItemId();
		var label = langVar('lang_admin.general.new_role');
		
		var newNodeName = rolesUtil.getNewRoleNodeName(roles.rolesDb, roles.deletedRolesDb);
		
		var o = {
			id: newItemId,
			type: '',
			label: label,
			dat: {
				node_name: newNodeName,
				label: label,
				created_by_user: roles.activeUserNodeName,
				features: []
			}
		}
		
		theList.newItem(o);
		
		// Update roles.accessDetailsRolesDb
		if (roles.isEnterprise) {rolesUtil.updateAccessDetailsRolesDb(roles.rolesDb);}
		
		setRoleItem(newItemId);
		updateToolbarButtons();
	}
}

function duplicateRole() {
	
	if (validateActiveItem()) {
		
		var theList = roles.theList;
		
		// Get new node name
		var newNodeName = rolesUtil.getNewRoleNodeName(roles.rolesDb, roles.deletedRolesDb);
		
		// Clone item
		var clonedItemId = theList.cloneItem();
		
		// Give the cloned item a new node name and correct created_by_user value
		theList.setItemDatValue(clonedItemId, 'node_name', newNodeName);
		theList.setItemDatValue(clonedItemId, 'created_by_user', roles.activeUserNodeName);
		
		// Update roles.accessDetailsRolesDb
		if (roles.isEnterprise) {rolesUtil.updateAccessDetailsRolesDb(roles.rolesDb);}
		
		setRoleItem(clonedItemId);
	}
}


function deleteRole() {
	
	// var itemIdToDelete = theList.getSelectedItemId();
	
	// If this role is used in users then confirm delete!
	
	var item = roles.theList.getSelectedItem();
	var itemId = item.id;
	var itemNodeName = item.dat.node_name;
	
	// alert('deleteRole(): ' + itemId);
	
	var roleIsUsedInUsers = (roles.rolesUsedInUsersDb['_' + itemNodeName] != null) ? true : false;
	// var isDelete = roleIsUsedInUsers ? confirm(
	
	var msg = langVar('lang_admin.roles.confirm_delete_role_is_used_in_users');
	
	if (!roleIsUsedInUsers || confirm(msg)) {
		
		//
		// Add node name of deleted item to deletedRolesDb
		//
		
		var deletedRolesDb = roles.deletedRolesDb;
		deletedRolesDb[deletedRolesDb.length] = itemNodeName;
		
		// Update roles list in Users Details
		if (roles.isEnterprise) {
			// rolesUtil.initSimpeFeaturesInUsersDetails();
		}
		
		
		//
		// Delete the item
		//
		
		var nextItemIdToBeSelected = roles.theList.deleteItem();
		
		
		// Update roles.accessDetailsRolesDb
		if (roles.isEnterprise) {rolesUtil.updateAccessDetailsRolesDb(roles.rolesDb);}
				
		//
		// select the next item
		//
		
		if (nextItemIdToBeSelected != null) {
			
			// reset the validator in case that the deleted an item with error indication
			roles.validator.reset();
			setRoleItem(nextItemIdToBeSelected);
		}
		else {
			
			// All items have been deleted
			
			// alert('Last item has been deleted, no more items to select.');
			
			displayNoItemForm(true);
			updateToolbarButtons();
		}
	}
}

function updateListAndFormLabel() {
	
	// Only used in Enterprise
	setTimeout('setListAndFormLabel()', 300);
}

function setListAndFormLabel() {
	
	var theList = roles.theList;
	
	var label = util.getF('role_label');
	if (label == '') {
		label = '-';
	}
	
	// We need to check if the role is from another user
	var item = theList.getSelectedItem(); 
	var createdByUser = item.dat.created_by_user;
	
	if (createdByUser != roles.activeUserNodeName) {
		
		var usersDb = roles.usersDb;
		var username = (usersDb[h(createdByUser)] != null) ? usersDb[h(createdByUser)].username : langVar('lang_admin.roles.unknown_user');
		var byUserLabel = ' (' + langVar('lang_admin.general.by_user') + ')';
		byUserLabel = byUserLabel.replace(/__PARAM__1/, username);
		label += byUserLabel;
	}

	// util.updateT('item_form_label', label);
	theList.updateListLabel(label);
	
	
	// We also need to update the label in accessDetailsRolesDb
	if (roles.isEnterprise) {
		var item = theList.getSelectedItem();
		var nodeName = item.dat.node_name;
		var accessDetailsItem = roles.accessDetailsRolesDb[h(nodeName)];
		accessDetailsItem.label = label;
	}
}


function updateForm() {
	
	// alert('updateForm()');
	
	var isEnterprise = roles.isEnterprise;
		
	if (isEnterprise) {
		
		// Reset access details
		// Values for the active role are set by setFeaturePermissions
		roles.accessDetails.scheduler.isUnlimitedGrants = true;
		roles.accessDetails.scheduler.items = [];
		roles.accessDetails.users.isUnlimitedGrants = true;
		roles.accessDetails.users.items = [];
	}
	
	rolesUtil.resetFeaturePermissions();
	
	var item = roles.theList.getSelectedItem();
	var itemDat = item.dat;
	
	roles.activeCreatedByUser = itemDat.created_by_user;
	
	var features = itemDat.features;
	
	// util.showObject(itemDat);
	
	//
	// Handle role label
	//
	var roleLabel = itemDat.label;
	if (isEnterprise) {
		util.setF('role_label', roleLabel);
	}
	else {
		util.updateT('item_form_label', roleLabel);
	}
	
	// Reset global saveReportChanges and saveReportChangesToProfile settings
	roles.accessDetails.saveReportChanges.isView = false;
	roles.accessDetails.saveReportChangesToProfile.isView = false;
	
	//
	// Update features
	//
	
	var featureMap = roles.featureMap;
	
	for (var i = 0; i < features.length; i++) {
		
		var featureItem = features[i];
		rolesUtil.setFeaturePermissions(featureMap, featureItem, isEnterprise);
	}
	
	// Update Save Report Changes row info display (must occur after setFeaturePermissions()!)
	rolesUtil.updateSaveReportChangesAccessDetailsDisplay();
	
	if (roles.noItemFormIsActive) {
		displayNoItemForm(false);
	}
}

function validateActiveItem() {
	
	// Only validate if isEdit permission and if items
	
	var theList = roles.theList;
	
	if (pageInfo.permissions.isEdit && theList.isItems()) {
	
		// We only validate the item if the label or features have been modified
		
		var isEnterprise = roles.isEnterprise;
		var isModifiedFeatures = roles.isModifiedFeatures;
		
		// get original item
		var oriItem = roles.theList.getSelectedItem();
		var oriItemDat = oriItem.dat;
		var oriLabel = oriItemDat.label;
		var newLabel;
		
		var isModifiedLabel = false;
		
		if (isEnterprise) {
			
			// newLabel = util.getF('role_label');
			// newLabel = util.trim(newLabel);
			// isModifiedLabel = (oriLabel.toLowerCase() != newLabel.toLowerCase());
			isModifiedLabel = true; // We need to validate the label in case of duplicate or new role!
		}
		else {
			newLabel = oriLabel;
		}
		
		// alert('isModifiedLabel: ' + isModifiedLabel);
		
		if (isModifiedLabel || isModifiedFeatures) {
			
			//
			// Validate
			//
			
			var validator = roles.validator;
			validator.reset();
			
			var o = {};
			o.node_name = oriItemDat.node_name;
			
			if (isModifiedLabel) {
				o.label = validator.isValue('role_label');
				o.label = validator.isUnique('role_label', theList.getLookupItems('label'));
			}
			else {
				o.label = oriLabel;
			}
			
			o.created_by_user = roles.activeCreatedByUser;
			
			//
			// Get the features
			//
			
			var features = [];
			
			if (isModifiedFeatures) {
				// Get features from active form
				features = rolesUtil.getActiveFormFeatures(isEnterprise);
			}
			else {
				// Features are not modified, clone the existing once
				features = util.cloneObject(oriItemDat.features);
			}
			
			o.features = features;
			
			if (validator.allValid()) {
				
				theList.saveItem(o);
				
				// TEMP DEBUG
				/*
				var modifiedItemInList = roles.theList.getSelectedItem();
				var modifiedFeatures = modifiedItemInList.dat.features;
				for (var i = 0; i < modifiedFeatures.length; i++) {
					if (modifiedFeatures[i].id == 'f1') {
						util.showObject(modifiedFeatures[i]);
					}
				}
				*/
				
				return true;
			}
		}
		else {
			
			return true;
		}
		
		return false;
	}
	
	// No isEdit permission or no items
	return true;
}


function saveChanges() {
	
	if (validateActiveItem()) {
		
		var theList = roles.theList;
		var isModified = theList.getIsModified();
		
		// alert('saveChanges() - isModified: ' + isModified);

		if (isModified) {
			
			util.hideE('form_section');
			util.showE('saving_info');
			
			var isEnterprise = roles.isEnterprise;

			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			var i;
			
			// var deletedRolesPath = 'v.fp.deleted_roles';
			
			
			//
			//
			// Handle deleted roles
			//
			//
			
			var deletedRolesDb = roles.deletedRolesDb;
			
			if (deletedRolesDb.length > 0) {
				
				for (i = 0; i < deletedRolesDb.length; i++) {
					
					dat += 'v.fp.deleted_roles.' + deletedRolesDb[i] + '=true&';
				}
			}
			else {
				
				dat += 'v.fp.deleted_roles=&';
			}
			
			
			//
			//
			//
			//
			// Handle roles
			//
			//
			//
			//
			
			var rolesDb = roles.rolesDb;
	

			// Create a roles lookup to check if any role defined in access details still exists (Enterprise only)
			var rolesLookup = {};
			if (isEnterprise) {
				
				for (i = 0; i < rolesDb.length; i++) {
					var lookupNodeName = '__' + rolesDb[i].dat.node_name;
					rolesLookup[lookupNodeName] = true;
				}
			}
			
			// util.showObject(rolesLookup);
			
			
			if (rolesDb.length > 0) {
				
				var featureMap = roles.featureMap;
				
				for (i = 0; i < rolesDb.length; i++) {
				
					var itemDat = rolesDb[i].dat;
					var roleName = itemDat.node_name;
					var roleLabel = itemDat.label;
					var createdByUser = itemDat.created_by_user;
					var features = itemDat.features;
					
					var rolePath = 'v.fp.roles.' + roleName;
					var featuresPath = rolePath + '.features';
					
					dat += rolePath + '.label=' + util.getEncodedURIComponent(roleLabel) + '&';
					dat += rolePath + '.created_by_user=' + util.getEncodedURIComponent(createdByUser) + '&';
					
					if (features.length > 0) {
						
						for (var j = 0; j < features.length; j++) {
							
							var featureItem = features[j];
							var featureId = featureItem.id;
							var featureMapItem = featureMap[h(featureId)];
							var categoryName = featureMapItem.category;
							var featureName = featureMapItem.name;
							var hasEdit = featureMapItem.hasEdit;
							var hasAdd = featureMapItem.hasAdd;
							var hasDelete = featureMapItem.hasDelete;
							
							var featureItemPath = featuresPath + '.' + categoryName + '.' + featureName;
							
							dat += featureItemPath + '.view=' + featureItem.isView + '&';
							
							if (hasEdit) {
								dat += featureItemPath + '.edit=' + featureItem.isEdit + '&';
							}
							
							if (hasAdd) {
								dat += featureItemPath + '.add=' + featureItem.isAdd + '&';
							}
							
							if (hasDelete) {
								dat += featureItemPath + '.delete=' + featureItem.isDelete + '&';
							}
							
							var isScheduler = (categoryName == 'admin' && featureName == 'scheduler');
							var isUsers = (categoryName == 'admin' && featureName == 'users');
							
							if (isScheduler || isUsers) {
								
								var numOfAccessDetailsItemsAdded = 0;
								var isUnlimitedGrants = featureItem.isUnlimitedGrants;
								var accessDetailsItems = featureItem.items;
								var accessDetailsItemsName = isScheduler ? 'actions' : 'roles';
								var accessDetailsPath = featureItemPath + '.' + accessDetailsItemsName;
								
								dat += featureItemPath + '.unlimited_grants=' + isUnlimitedGrants + '&';
								
								if (!isUnlimitedGrants && (accessDetailsItems.length > 0)) {
									
									// If we handle users we have to make sure that the role item
									// still exists because it could have been deleted.
									
									for (var k = 0; k < accessDetailsItems.length; k++) {
										
										var accessDetailsItemName = accessDetailsItems[k];
										
										if (isScheduler || (rolesLookup['__' + accessDetailsItemName] != null)) {
										
											dat += accessDetailsPath + '.' + accessDetailsItemName + '=true&';
											numOfAccessDetailsItemsAdded++;
										}
									}
								}
								
								if (numOfAccessDetailsItemsAdded == 0) {
									// No access detail items
									dat += accessDetailsPath + '=&';
								}
							}
						}
					}
					else {
						
						dat += featuresPath + '=&'; 
					}
				}
			}
			else {
				
				dat += 'v.fp.roles=&';
			}
			
			dat = dat.replace(/&$/, '');
			
			//
			//
			// Post data
			//
			//
			
			var url = '?dp+templates.admin_pages.roles.save_data';
			
			util.serverPost(url, dat);
			
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveChangesResponse() {
	
	// Reset data
	roles.rolesDbBackup = util.cloneObject(roles.rolesDb);
	roles.deletedRolesDb = [];
	roles.theList.resetIsModified();
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	// alert('undoAllChanges()');
	roles.rolesDb = util.cloneObject(roles.rolesDbBackup);
	roles.deletedRolesDb = [];
	
	// Update roles list in Users Details
	if (roles.isEnterprise) {
		// rolesUtil.initSimpeFeaturesInUsersDetails();
	}
	
	// alert('rolesDb length after cloning rolesDbBackup: ' + rolesDb.length);
	
	roles.theList.init(roles.rolesDb);
	initMainDisplay();
	updateToolbarButtons();
}

function getIsModifiedPage() {
	
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	
	if (!validateActiveItem() || roles.theList.getIsModified()) {
		return true;
	}
	
	return false;
}
