//
// rolesAD.js, Roles - Access Details Panel
//

var rolesAD = {
	
	panel: null,
	
	// active form data
	featureName: '',
	isUnlimitedGrants: true,
	
	init: function() {
		
		//
		// Init the panel
		//
		
		var panelObj = {
			panelId: 'ad:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 300,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: rolesAD.closePanel
		};
		
		rolesAD.panel = new util.Panel3(panelObj);
		
		var a = ['ad:scheduler:unlimited:btn', 'ad:scheduler:limited:btn', 'ad:users:unlimited:btn', 'ad:users:limited:btn'];
		yEvent.addListener(a, 'click', rolesAD.toggleGrantsEvent);
		
		yEvent.addListener('roles:ad:okay', 'click', rolesAD.saveAccessDetails);
		yEvent.addListener('roles:ad:cancel', 'click', rolesAD.closePanel);
	},
	
	toggleGrantsEvent: function() {
		
		var id = this.id;
		var dat = id.split(':');
		var featureName = dat[1];
		var isUnlimitedGrants = (dat[2] == 'unlimited');
		rolesAD.toggleGrants(featureName, isUnlimitedGrants);
	},
	
	toggleGrants: function(featureName, isUnlimitedGrants) {
		
		// var featureName = rolesAD.featureName;
		
		// alert('featureName: ' + featureName + '\nisUnlimitedGrants: ' + isUnlimitedGrants);
		
		rolesAD.isUnlimitedGrants = isUnlimitedGrants;
		
		var selectElement = util.getE('ad:' + featureName + ':select');
		selectElement.disabled = isUnlimitedGrants;
		
		if (isUnlimitedGrants) {
			selectElement.selectedIndex = -1;
		}
	},
	
	createList: function(featureName, isUnlimitedGrants, items) {
		
		var selectElementId = 'ad:' + featureName + ':select';
		
		var listSource = (featureName == 'scheduler') ? roles.schedulerActionsDb : roles.accessDetailsRolesDb;
		
		util.populateSelect(selectElementId, listSource, 'name', 'label');
		
		if (!isUnlimitedGrants) {
			
			for (var i = 0; i < items.length; i++) {
				util.setF(selectElementId, items[i]);
			}
		}
	},
	
	openPanel: function(featureName, isUnlimitedGrants, items) {
		
		// items are any active actions or roles if isUnlimitedGrants=false
		
		rolesAD.featureName = featureName;
		
		// rolesAD.isUnlimitedGrants = isUnlimitedGrants; IS ALREADY SET BY toggleGrants!
		
		
		// Reset panel
		util.hideE(['ad:scheduler', 'ad:users']);
		util.showE('ad:' + featureName);
	
		var isScheduler = (featureName == 'scheduler');
		
		var defaultSelectedName = isUnlimitedGrants ? 'unlimited' : 'limited';
		util.setF('ad:' + featureName + ':' + defaultSelectedName + ':btn', true);
		
		rolesAD.toggleGrants(featureName, isUnlimitedGrants);
		
		// create the list
		rolesAD.createList(featureName, isUnlimitedGrants, items);
		
		var panelLabel = isScheduler ? langVar('lang_admin.roles.scheduler_access_details') : langVar('lang_admin.roles.users_access_details');
		
		rolesAD.panel.open({label:panelLabel});
	},
	
	
	saveAccessDetails: function() {
		
		var featureName = rolesAD.featureName;
		var isUnlimitedGrants = rolesAD.isUnlimitedGrants;
		
	
		// global access object to which we save the data
		var accessDetails = roles.accessDetails[featureName];
		
		var featureId = accessDetails.featureId;
		
		/*
		var s = 'saveAccessDetails()';
		s += '\nfeatureId: ' + featureId;
		s += '\nfeatureName: ' + featureName;
		s += '\nisUnlimitedGrants: ' + isUnlimitedGrants;
		alert(s);
		*/
		
		
		accessDetails.isUnlimitedGrants = isUnlimitedGrants;
		accessDetails.items = [];
		
		// Update the list in Admin panel
		rolesUtil.resetAccessDetails(featureName);
		
		if (!isUnlimitedGrants) {
			// Get selected values
			var select = util.getE('ad:' + featureName +  ':select');
			var options = select.options;
			
			for (var i = 0; i < options.length; i++) {
				
				if (options[i].selected == true) {
					
					accessDetails.items[accessDetails.items.length] = options[i].value;
				}
			}
			
			// alert('items: ' + accessDetails.items);
			
			// Update the list in Admin panel
			rolesUtil.updateLimitedGrantsDiv(featureName);
			util.showE(featureId + ':limited_grants:div');
		}
		else {
			
			// Update the list in Admin panel
			util.showE(featureId + ':unlimited_grants:div');
		}
		
		roles.isModifiedFeatures = true;
		rolesAD.closePanel();
	},
	
	closePanel: function() {
		
		rolesAD.panel.close();
	}
}
