//
// rolesUtil.js, utility functions for roles.js
//

var rolesUtil = {
	
	/*
	updateFeatureLabelCell: function(featureId, isActive) {
		
		// Higlights the fetaure label cell if isView or any other permission is checked
		var th = util.getE(featureId + ':feature:label:th');
		th.className = isActive ? 'active' : '';
	},
	*/
	
	updatePermissionCell: function(featureId, permissionType, isChecked, isDisabled) {
	
		// isDisabled is an optional argument!
			
		var td = util.getE(featureId + ':' + permissionType + ':td');
		// td.className = isChecked ? 'active' : '';
		
		var input = util.getE(featureId + ':' + permissionType);
		input.checked = isChecked;
		
		if (isDisabled != null) {
			input.disabled = isDisabled;
		}
		
		//
		// Handle Access Details
		//
		
		if (permissionType == 'edit') {
			
			var accessDetails = roles.accessDetails;
			
			if (featureId == accessDetails.scheduler.featureId || featureId == accessDetails.users.featureId) {
				
				// alert('show hide access details div\'s');
				
				var isUnlimtedGrants = true;
				
				if (featureId == accessDetails.scheduler.featureId) {
					isUnlimtedGrants = accessDetails.scheduler.isUnlimitedGrants;
				}
				else {
					isUnlimtedGrants = accessDetails.users.isUnlimitedGrants;
				}
				
							
				var showUnlimitedGrants = (isChecked && isUnlimtedGrants);
				var showLimitedGrants = (isChecked && !isUnlimtedGrants);
				
				/*
				var s = 'featureId: ' + featureId;
				s += '\nisChecked: ' + isChecked;
				s += '\nisUnlimtedGrants: ' + isUnlimtedGrants;
				s += '\nshowUnlimitedGrants: ' + showUnlimitedGrants;
				s += '\nshowLimitedGrants: ' + showLimitedGrants;
				alert(s);
				*/
				
				util.showE(featureId + ':unlimited_grants:div', (isChecked && isUnlimtedGrants));
				util.showE(featureId + ':limited_grants:div', (isChecked && !isUnlimtedGrants));
			}
		}
	},
	
	setPermissionByLabelEvent: function() {
		
		// Invoked by clicking on a feature label
		// If none or not all permissions are checked then check all permissions
		// If all are checked then un-check all permissions
		
		// alert('setPermissionByLabelEvent: ' + this.id);
		
		var featureMap = roles.featureMap;
		roles.isModifiedFeatures = true;
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var featureId = dat[0];
	
		var featureMapItem = featureMap[h(featureId)];
		
		var hasEdit = featureMapItem.hasEdit;
		var hasAdd = featureMapItem.hasAdd;
		var hasDelete = featureMapItem.hasDelete;
		
		//
		// Check the current state, if all are checked
		//
		
		var checkedState = [];
		
		checkedState[0] = util.getF(featureId + ':view');
		
		if (hasEdit) {checkedState[checkedState.length] = util.getF(featureId + ':edit');}
		if (hasAdd) {checkedState[checkedState.length] = util.getF(featureId + ':add');}
		if (hasDelete) {checkedState[checkedState.length] = util.getF(featureId + ':delete');}
		
		var allAreChecked = true;
		var atLeastOneIsChecked = false;
		for (var i = 0; i < checkedState.length; i++) {
			if (checkedState[i] == true) {
				atLeastOneIsChecked = true;
			}
			else {
				allAreChecked = false;
			}
		}
		
		//
		// Set new checkbox state depending on atLeastOneIsChecked and allAreChecked 
		// 
		
		var isSelectAll = !atLeastOneIsChecked || (atLeastOneIsChecked && !allAreChecked);
		
		//
		// We create a pseudo featureItem object which is used
		// to update the permissions of this feature via setFeaturePermissions
		//
		
		// alert('atLeastOneIsChecked: ' + atLeastOneIsChecked + '\nallAreChecked: ' + allAreChecked + '\nisSelectAll: ' + isSelectAll);
		
		var isDisabled = false;
		rolesUtil.updatePermissionCell(featureId, 'view', isSelectAll, isDisabled);
		
		// Set disabled state for edit, add, delete
		isDisabled = !isSelectAll;
		if (hasEdit) {rolesUtil.updatePermissionCell(featureId, 'edit', isSelectAll, isDisabled);}
		if (hasAdd) {rolesUtil.updatePermissionCell(featureId, 'add', isSelectAll, isDisabled);}
		if (hasDelete) {rolesUtil.updatePermissionCell(featureId, 'delete', isSelectAll, isDisabled);}
		
		// Handle Save Report Changes
		if (featureMapItem.name == 'save_report_changes') {
			rolesUtil.handleSaveReportChangesPermissionEvent(isSelectAll);
		}
	},
	
	setPermissionByEvent: function(featureId, permissionType, isChecked) {
		
		// invoked by clicking on a checkbox
		
		var featureMap = roles.featureMap;
		roles.isModifiedFeatures = true;
		
		var elementId = this.id;
		var isChecked = this.checked;
		var dat = elementId.split(':');
		var featureId = dat[0];
		var permissionType = dat[1];
		
		
		var featureMapItem = featureMap[h(featureId)];
		var category = featureMapItem.category;
		var isAdminProfilesFeature = (category == 'admin' && featureMapItem.name == 'profiles') ? true : false;
		
		// util.showObject(featureMapItem);

		// var hasView = featureMapItem.hasView;
		var hasEdit = featureMapItem.hasEdit;
		var hasAdd = featureMapItem.hasAdd;
		var hasDelete = featureMapItem.hasDelete;
		
		//
		// update the checked feature cell (className change)
		//
		
		rolesUtil.updatePermissionCell(featureId, permissionType, isChecked, false);
		
		//
		// update any depending feature cell
		//
		
		var isDisabled;
		
		if (permissionType == 'view') {
			
			// rolesUtil.updateFeatureLabelCell(featureId, isChecked);
			
			if (!isAdminProfilesFeature) {
				
				// enable edit and delete checkboxes
				if (hasEdit) {
					isDisabled = !isChecked;
					rolesUtil.updatePermissionCell(featureId, 'edit', false, isDisabled);
				}
				
				if (hasAdd) {
					isDisabled = true;
					rolesUtil.updatePermissionCell(featureId, 'add', false, isDisabled);
				}
				
				if (hasDelete) {
					isDisabled = true;
					rolesUtil.updatePermissionCell(featureId, 'delete', false, isDisabled);
				}
			}
			else {
				// isAdminProfilesFeature
				isDisabled = !isChecked;
				rolesUtil.updatePermissionCell(featureId, 'add', false, isDisabled);
				rolesUtil.updatePermissionCell(featureId, 'delete', false, isDisabled);
			}
			
			// Handle Save Report Changes
			if (category == 'reports' && featureMapItem.name == 'save_report_changes') {
				rolesUtil.handleSaveReportChangesPermissionEvent(isChecked);
			}
		}
		else if (permissionType == 'edit') {
			
			isDisabled = !isChecked;
			
			if (hasAdd) {
				rolesUtil.updatePermissionCell(featureId, 'add', false, isDisabled);
			}
			
			if (hasDelete) {
				rolesUtil.updatePermissionCell(featureId, 'delete', false, isDisabled);
			}
		}
	},
	
	handleSaveReportChangesPermissionEvent: function(isCheckedSaveReportChanges) {
		
		// Invoked via setPermissionByEvent() or setPermissionByLabelEvent()
		
		// Update global accessDetails for Save Report Changes
		roles.accessDetails.saveReportChanges.isView = isCheckedSaveReportChanges;
		
		// Update Save Report Changes row info display
		rolesUtil.updateSaveReportChangesAccessDetailsDisplay();
	},
	
	setFeaturePermissions: function(featureMap, featureItem, isEnterprise) {
		
		// Set all permissions of the featureItem and handle correct enabled/disabled state
		// Also handle the access details (Scheduler and Users) here!
		
		// Note, we ignore the enabled/diables state, we only care for the checkboxe state.
		// We enable/disable the checkboxes via setFeaturePermissionsDisabledState
		
		var featureId = featureItem.id;
		var featureMapItem = featureMap[h(featureId)];
		var category = featureMapItem.category;
		var featureName = featureMapItem.name;
		// var handleSchedulerDetails = false;
		// var handleUsersDetails = false;
		var handleAccessDetails = (category == 'admin' && (featureName == 'scheduler' || featureName == 'users'));
		var isAdminProfiles = (category == 'admin' && featureName == 'profiles');
		
		// TEMP
		/*
		if (featureName == 'save_report_changes') {
			alert('setFeaturePermissions() for save_report_changes item');
		}
		*/
		 
		if (handleAccessDetails) {
		
			// Set data in global role object
			roles.accessDetails[featureName].isUnlimitedGrants = featureItem.isUnlimitedGrants;
			roles.accessDetails[featureName].items = util.cloneObject(featureItem.items);
		}
		
		var isCheckedView = featureItem.isView;		
		
		if (isCheckedView) {
		
			// rolesUtil.updateFeatureLabelCell(featureId, true);
			rolesUtil.updatePermissionCell(featureId, 'view', true, false);
			
			var hasEdit = featureMapItem.hasEdit;
			var hasAdd = featureMapItem.hasAdd;
			var hasDelete = featureMapItem.hasDelete;
			var isCheckedEdit = false;
			var isDisabled;
			
			if (hasEdit) {
				isCheckedEdit = featureItem.isEdit;
				isDisabled = false;
				
				
				// Update Scheduler and Access Details
				if (isCheckedEdit && handleAccessDetails) {
					
					// If this is not unlimted grants we need to update
					// the limited grants div
					
					if (!featureItem.isUnlimitedGrants) {
						rolesUtil.updateLimitedGrantsDiv(featureName);
					}
					
					// rolesUtil.setInfoCell(featureName);
				}
				
				if (handleAccessDetails) {
					// alert('updatePermissionCell: ' + featureId);
				}
				
				rolesUtil.updatePermissionCell(featureId, 'edit', isCheckedEdit, isDisabled);
			}
			
			if (hasAdd) {
				var isCheckedAdd = featureItem.isAdd;
				isDisabled = !isAdminProfiles ? !isCheckedEdit : false;
				rolesUtil.updatePermissionCell(featureId, 'add', isCheckedAdd, isDisabled);
			}
			
			if (hasDelete) {
				var isCheckedDelete = featureItem.isDelete;
				isDisabled = !isAdminProfiles ? !isCheckedEdit : false;
				rolesUtil.updatePermissionCell(featureId, 'delete', isCheckedDelete, isDisabled);
			}
		}
		
		//
		// Handle Access Details for save_report_changes and save_report_changes_to_profile in global accessDetails object
		//
		
		if (category == 'reports' && featureName == 'save_report_changes') {
			// alert('setFeaturePermissions() for save_report_changes item - GLOBAL VARIABLE SET TO: ' + isCheckedView);
			roles.accessDetails.saveReportChanges.isView = isCheckedView;
		}
		else if (category == 'reports' && featureName == 'save_report_changes_to_profile') {
			// alert('setFeaturePermissions() - saveReportChangesToProfile.isView: ' + isCheckedView);
			roles.accessDetails.saveReportChangesToProfile.isView = isCheckedView;
		}
	},
	
	resetFeaturePermissions: function() {
		
		// Sets all features to its initial state
		
		var featureMap = roles.featureMap;
		
		for (var i = 0; i < featureMap.length; i++) {
			
			var featureMapItem = featureMap[i];
			var featureId = featureMapItem.id;
			// var category = featureMapItem.category;
			
			// rolesUtil.updateFeatureLabelCell(featureId, false);
			rolesUtil.updatePermissionCell(featureId, 'view', false, false);
			
			if (featureMapItem.hasEdit) {
				rolesUtil.updatePermissionCell(featureId, 'edit', false, true);
			}
			
			if (featureMapItem.hasAdd) {
				rolesUtil.updatePermissionCell(featureId, 'add', false, true);
			}
			
			if (featureMapItem.hasDelete) {
				rolesUtil.updatePermissionCell(featureId, 'delete', false, true);
			}
		}
		
		// Reset access details
		rolesUtil.resetAccessDetails('scheduler');
		rolesUtil.resetAccessDetails('users');
	},
	
	addPermissionCell: function(tr, featureId, permissionType, showPermission) {
	
		var td = document.createElement('td');
		td.id = featureId + ':' + permissionType + ':td';
		
		if (showPermission) {
			
			var input = document.createElement('input');
			input.type = 'checkbox';
			input.id = featureId + ':' + permissionType;
			
			yEvent.addListener(input, 'click', rolesUtil.setPermissionByEvent);
		
			td.appendChild(input);
		}
		else {
			
			var txt = document.createTextNode(' ');
			td.appendChild(txt);
		}
			
		tr.appendChild(td);
	},
	
	addFieldCategoriesHeaderCell: function(tr, label, className) {
	
		var th = document.createElement('th');
		
		if (className != '') {
			th.className = className;
		}
		
		var finalLabel = (label != '') ? label : '\u00a0'; // &nbsp;
		var text = document.createTextNode(finalLabel);
		
		th.appendChild(text);
		tr.appendChild(th);
	},
	
	addFieldCategoriesHeaderRow: function(tbody) {
	
		// alert('addFieldCategoriesHeaderRow()');
		
		var tr = document.createElement('tr');
		rolesUtil.addFieldCategoriesHeaderCell(tr, langVar('lang_admin.roles.report_fields_by_category'), 'label');
		rolesUtil.addFieldCategoriesHeaderCell(tr, '', '');
		rolesUtil.addFieldCategoriesHeaderCell(tr, '', '');
		// rolesUtil.addFieldCategoriesHeaderCell(tr, '', '');
		// rolesUtil.addFieldCategoriesHeaderCell(tr, '', '');
	
		tbody.appendChild(tr);
	},
	
	initFeatures: function(isEnterprise) {
	
		//
		//
		// creates featureMap hash and builds all feature checkboxes from the featureMap
		//
		//
		
		var featureMap = roles.featureMap;
		
		util.createHash(featureMap, 'id');
		
		var mainFeatureCategories = ['admin', 'reports', 'config', 'field_categories', 'miscellaneous'];
		
		for (var i = 0; i < mainFeatureCategories.length; i++) {
			
			var category = mainFeatureCategories[i];
			
			//
			// Note, the field_categories items are added to the reports list!
			//
			
			var tableElementId = (category != 'field_categories') ? category + ':features:container' : 'reports:features:container';
			var table = util.getE(tableElementId);
		
			var tbody = document.createElement('tbody');
			var j;
			
			if (category == 'field_categories') {
				
				// Check if we have any enabled field category, if so then
				// add a header row
				
				for (j = 0; j < featureMap.length; j++) {
					
					if (featureMap[j].category == 'field_categories') {
						rolesUtil.addFieldCategoriesHeaderRow(tbody);
						break;
					}
				}
			}
	
			for (j = 0; j < featureMap.length; j++) {
				
				var item = featureMap[j];
				
				if (item.category == category) {
				
					var featureId = item.id;
					var label = item.label;
					
					
					// alert(tbody);
					
					var tr = document.createElement('tr');
					
					
					//
					// add feature cell
					//
					
					var td = document.createElement('td');
					td.className = 'label';
					//td.id = featureId + ':feature:label:td';
					var a = document.createElement('a');
					a.id = featureId + ':feature:label:a';
					a.href = 'javascript:;';
					var featureTxt = document.createTextNode(label);
					a.appendChild(featureTxt);
					td.appendChild(a);
					tr.appendChild(td);
					
					yEvent.addListener(a, 'click', rolesUtil.setPermissionByLabelEvent);
			
					//
					// add access/view cell
					//
					
					rolesUtil.addPermissionCell(tr, featureId, 'view', true);
					
					//
					// add edit, add and delete cell
					//
					
					if (category == 'admin' || category == 'config') {
					
						rolesUtil.addPermissionCell(tr, featureId, 'edit', item.hasEdit);
						rolesUtil.addPermissionCell(tr, featureId, 'add', item.hasAdd);
						rolesUtil.addPermissionCell(tr, featureId, 'delete', item.hasDelete);
					}
					
					
					//
					// add info cell if category is admin or reports
					//
					
					if (category == 'admin' || category == 'reports') {
						
						var td = document.createElement('td');
						// td.id = featureId + ':info:td';
						td.className = 'info-text';
						
						var featureName = item.name;
						
						if (category == 'admin' && (featureName == 'scheduler' || featureName == 'users')) {
							
							rolesUtil.buildAccessDetails(td, featureId, featureName, isEnterprise);
							
							// Remember the featureId in global role object
							roles.accessDetails[featureName].featureId = featureId;
						}
						else if (category == 'reports' && featureName == 'save_report_changes') {

							rolesUtil.buildSaveReportChangesAccessDetails(td);
							
							// Remember the featureId in global role object
							roles.accessDetails.saveReportChanges.featureId = featureId;
							
						}
						else if (category == 'reports' && featureName == 'save_report_changes_to_profile') {
							
							// The save_report_changes_to_profile row is always hidden. We use the checkbox
							// for access like other checkboxes, though we handle it through a sub-window
							// in the save_report_changes row. So we check/uncheck this checkbox via 
							// javascript only.
							
							tr.style.display = 'none';
							// Remember the featureId in global role object
							roles.accessDetails.saveReportChangesToProfile.featureId = featureId;
						}
						else {
							
							// Add &nbsp;
							var infoText = document.createTextNode('\u00a0'); // creates &nbsp;
							td.appendChild(infoText);
						}
						
						tr.appendChild(td);
					}
					
					tbody.appendChild(tr);
				}
			}
			
			table.appendChild(tbody);
		}
	},
	
	
	//
	//
	//
	// Access Details handling (Scheduler and Users)
	//
	//
	//
	
	accessDeatilsButtonActivated: function() {
		
		// alert('accessDeatilsButtonActivated() - id: ' + this.id);
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var featureId = dat[0];
		var featureName = roles.featureMap[h(featureId)].name;
		var accessDetails = roles.accessDetails[featureName];

		// alert('accessDeatilsButtonActivated - featureName: ' + featureName);
		
		rolesAD.openPanel(featureName, accessDetails.isUnlimitedGrants, accessDetails.items);
	},

	buildAccessDetailsLabel: function(text, className) {
		
		var span = document.createElement('span');
		if (className != '') {span.className = className;}
		var text = document.createTextNode(text);
		span.appendChild(text);
		
		return span;
	},
	
	buildAccessDetails: function(td, featureId, featureName, isEnterprise) {
		
		// We create two div's, one for unlimited grants and
		// one for limited grants.
		
		// UNLIMITED GRANTS DIV:
		// <div id="f2:unlimited_grants:div"
		
		// LIMITED GRANTS DIV:
		// <div id="f2:limited_grants:div"
		// <ul id="f2:limited_grants:ul" --> ul containder for access details (action names or role names)
		
		
		var isScheduler = (featureName == 'scheduler');
		
		//
		// Handle unlimited access
		//
		
		var div = document.createElement('div');
		div.id = featureId + ':unlimited_grants:div';
		div.className = 'rbac-access-details-btn';
		
		var br = document.createElement('br');
		
		var mainLabelClassName = isEnterprise ? 'rbac-access-details-btn' : ''; // This className simulates a link which we don't want in Pro
		var mainLabelSpan = rolesUtil.buildAccessDetailsLabel(langVar('lang_admin.roles.unlimited_grants'), mainLabelClassName);
		
		var subLabel = isScheduler ? ' ' + langVar('lang_admin.roles.accesses_all_profiles_and_actions') : ' ' + langVar('lang_admin.roles.accesses_all_profiles_and_roles');
		var subLabelSpan = rolesUtil.buildAccessDetailsLabel(subLabel, 'rbac-access-details-btn-sublabel');
		
		div.appendChild(mainLabelSpan);
		div.appendChild(br);
		div.appendChild(subLabelSpan);

		
		//
		// Handle limited access (This div will only be used in Enterprise, so we keep it in Pro to make it simpler for reset functions, etc.)
		//
		
		var limitedDiv = document.createElement('div');
		limitedDiv.id = featureId + ':limited_grants:div';
		limitedDiv.className = 'rbac-access-details-btn';
		
		var limitedMainLabel = isScheduler ? langVar('lang_admin.roles.limited_grants_with_actions') + ':' : langVar('lang_admin.roles.limited_grants_with_roles') + ':'; 
		var limitedMainLabelSpan = rolesUtil.buildAccessDetailsLabel(limitedMainLabel, 'rbac-access-details-btn');
		
		var ul = document.createElement('ul');
		ul.id = featureId + ':limited_grants:ul';
		ul.className = 'rbac-access-details-btn';
		// ul.style.margin = '0px';
		// ul.style.padding = '0px';
		
		limitedDiv.appendChild(limitedMainLabelSpan);
		limitedDiv.appendChild(ul);
		
		td.appendChild(div);
		td.appendChild(limitedDiv);
		
		if (isEnterprise) {
			yEvent.addListener([div, limitedDiv], 'click', rolesUtil.accessDeatilsButtonActivated);
		}
	},

	resetAccessDetails: function(featureName) {
		
		// Hide the access details div's
		
		var featureId =  roles.accessDetails[featureName].featureId;
		
		// alert('featureName: ' + featureName + '\nfeatureId: ' + featureId);
		
		var divId = featureId + ':unlimited_grants:div';
		var limitedDivId = featureId + ':limited_grants:div';
		util.hideE([divId, limitedDivId]);
	},
	
	updateLimitedGrantsDiv: function(featureName) {
		
		// alert('updateLimitedGrantsDiv: ' + featureName);
		var isScheduler = (featureName == 'scheduler');
		var accessDetails = roles.accessDetails[featureName];
		var featureId = accessDetails.featureId;
		var items = accessDetails.items;
		
		var ul = util.getE(featureId + ':limited_grants:ul');
		
		// Clean up ul element
		while (ul.lastChild != null) {
			var childElement = ul.lastChild;
			ul.removeChild(childElement);
		}
		
		// Define the array from which we get the access details labels
		var labelLookup = isScheduler ? roles.schedulerActionsDb : roles.accessDetailsRolesDb;

		var li;
		var name;
		var lookupItem;
		var label;
		var text;
		
		var numberOfItemsInList = 0;
		
		if (items.length > 0) {
			
			for (var i = 0; i < items.length; i++) {
				
				name = items[i];
				lookupItem = labelLookup[h(name)];
				
				// Make sure that the lookupItem exists (it may not in case of deleted roles!)
				
				if (lookupItem != null) {
					
					li = document.createElement('li');
					li.className = 'rbac-access-details-btn';
					// li.style.margin = '0px';
					// li.style.padding = '0px';
				
					label = lookupItem.label;
					text = document.createTextNode(label);
					
					li.appendChild(text);
					ul.appendChild(li);
					
					numberOfItemsInList++;
				}
			}
		}
		
		if (numberOfItemsInList == 0) {
		
			li = document.createElement('li');
			li.className = 'rbac-access-details-btn';
			li.style.listStyle = 'none';
			li.style.color = 'Red';
			label = isScheduler ? langVar('lang_admin.roles.no_action_defined') : langVar('lang_admin.roles.no_role_defined_or_available');
			text = document.createTextNode(label);
			
			li.appendChild(text);
			ul.appendChild(li);
		}
	},
	
	
	//
	//
	// Save Report Changes Access Details handling
	//
	//
	
	saveReportChangesAccessDetailsActor: function() {
		
		// User clicked on saveReportChangesDetails button
		// alert('saveReportChangesAccessDetailsActor()');
		rolesSRCAD.openPanel();
	},
	
	updateSaveReportChangesAccessDetailsDisplay: function() {
		
		// This updates the info cell depending on the global roles.accessDetails.saveReportChanges
		// and roles.accessDetails.saveReportChangesToProfile paramters
		
		// alert('updateSaveReportChangesAccessDetailsDisplay() - roles.accessDetails.saveReportChanges.isView: ' + roles.accessDetails.saveReportChanges.isView);
		// util.showObject(roles.accessDetails);
		
		var div1Id = 'f:save_report_changes:div';
		var div2Id = 'f:save_report_changes_to_profile:div';
		
		var isSaveReportChanges = roles.accessDetails.saveReportChanges.isView;
		var isSaveReportChangesToProfile = roles.accessDetails.saveReportChangesToProfile.isView;
		
		util.hideE([div1Id, div2Id]);
		
		if (isSaveReportChanges && isSaveReportChangesToProfile) {
			util.showE(div2Id);
		}
		else if (isSaveReportChanges) {
			util.showE(div1Id);
		}
	},
	
	buildSaveReportChangesAccessDetails: function(td) {
		
		// We create two div's, one for Save Changes To User Only
		// and one for Save Changes To Profile
		
		// Save Report Changes To User DIV:
		// <div id="f2:save_report_changes:div"
		
		// Save Report Changes To Profile DIV:
		// <div id="f2:save_report_changes_to_profile:div"
		
		function buildDivWithLabel(id, label, subLabel) {
			
			var div = util.createE('div', {id:id, className:'rbac-access-details-btn', width:'240px'});
			var br = util.createE('br');
			
			var span1 = util.createE('span', {className:'rbac-access-details-btn'});
			var text1 = util.createT(label);
			
			var span2 = util.createE('span', {className: 'rbac-access-details-btn-sublabel'});
			var text2 = util.createT(subLabel);
		
			util.chainE([div, [span1, text1], br, [span2, text2]]);
			
			return div;
		}
		
		var div1 = buildDivWithLabel(
			'f:save_report_changes:div',
			langVar('lang_admin.roles.saving_scope_is_user'),
			langVar('lang_admin.roles.saving_scope_is_user_info_1')
		);
		
		var div2 = buildDivWithLabel(
			'f:save_report_changes_to_profile:div',
			langVar('lang_admin.roles.saving_scope_is_profile'),
			langVar('lang_admin.roles.saving_scope_is_profile_info_1')
		);
		
		util.chainE([td, div1, div2]);
		
		yEvent.addListener([div1, div2], 'click', rolesUtil.saveReportChangesAccessDetailsActor);
	},
	
	//
	//
	// Miscellaneous Utilities
	//
	//

	getActiveFormFeatures: function(isEnterprise) {
		
		//
		// Create features array from active form features
		// 
		
		var featureMap = roles.featureMap;
		var features = [];
		
		for (var i = 0; i < featureMap.length; i++) {
			
			var featureMapItem = featureMap[i];
			var featureId = featureMapItem.id;
			
			var isView = util.getF(featureId + ':view');
			
			if (isView) {
				
				var category = featureMapItem.category;
				var featureName = featureMapItem.name;
				
				var o = {};
				o.id = featureId;
				o.isView = true;
				
				if (featureMapItem.hasEdit) {
					o.isEdit = util.getF(featureId + ':edit');
				}
				
				if (featureMapItem.hasAdd) {
					o.isAdd = util.getF(featureId + ':add');
				}
				
				if (featureMapItem.hasDelete) {
					o.isDelete= util.getF(featureId + ':delete');
				}
				
				if (category == 'admin' && (featureName == 'scheduler' || featureName == 'users')) {
					
					var accessDetails = roles.accessDetails[featureName];
					
					// util.showObject(accessDetails);
					
					o.isUnlimitedGrants = accessDetails.isUnlimitedGrants;
					o.items = util.cloneObject(accessDetails.items);
					
					// util.showObject(o);
				}
				
				// TEMP
				// if (featureName == 'save_report_changes') {
				//	util.showObject(o);
				// }
				
				features[features.length] = o;
			}
		}
		
		return features;
	},
	
	updateAccessDetailsRolesDb: function(rolesDb) {
		
		// Creates a new up to date list accessDetailsRolesDb list
		// which is used to create the access details roles list
		
		roles.accessDetailsRolesDb = [];
		
		for (var i = 0; i < rolesDb.length; i++) {
			var itemDat = rolesDb[i].dat;
			roles.accessDetailsRolesDb[i] = {name: itemDat.node_name, label: itemDat.label};
		}
		
		util.createHash(roles.accessDetailsRolesDb, 'name');
	},
		
	getNewRoleNodeName: function(rolesDb, deletedRolesDb) {
		
		// Returns a new unique node name which does not match
		// any existing or deleted node name in the format role_1, role_2, role_3, ...
		
		//
		// Create a node name lookup
		//
		
		var usedNodeNames = {};
		var nodeName;
		var i;
		
		for (i = 0; i < rolesDb.length; i++) {
			
			nodeName = rolesDb[i].dat.node_name;
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		
		for (i = 0; i < deletedRolesDb.length; i++) {
			
			nodeName = deletedRolesDb[i];
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		
		//
		// Create new node name
		//
		
		var newNodeName = '';
		var isUniqueNodeName = false;
		var count = 1;
		while (!isUniqueNodeName) {
			
			newNodeName = 'role_' + count;
			
			if (usedNodeNames['_' + newNodeName] == null) {
				isUniqueNodeName = true;
			}
			
			count++;
		}
		
		// alert('newNodeName: ' + newNodeName);
		
		return newNodeName;
	}
}
