//
// schedulerActions.js
//

var schedulerActions = {
	
	panel: null,
	validator: null,
	addressControl: null, // email address control for To, Cc and Bcc address
	
	//
	// Active form parameters
	//
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index

	activeAction: '',
	isDatabaseAction: false,
	isProfileList: false, // no profile list has been populated yet
	isExtendedProfilesList: false, // specifies if the active profile list contains All profiles and Profile pattern list entry
	isExtraOptions: false, // specifies if the extra options textarea element row is displayed or not 
	
	isUnlimitedGrants: false,
	
	activeReportsDb: [], // the active reportsDb of the selected profile
		
	activeDF: { // the active date filter object per action
		type: '', // none, relative | custom
		custom: '', // custom expression if type is custom
		relativePrefix: '', // none | recent || last
		relativeDateUnit: '', // year | quarter, month, ...
		relativeDateUnitCount: 1
	},
	
	init: function() {
		
		var sa = schedulerActions;
		
		sa.isUnlimitedGrants = pageInfo.isRootAdmin || pageInfo.permissions.isUnlimitedGrants;
		sa.validator = new util.Validator();
		
		//
		// Init the Action panel
		//
		
		var panelObj = {
			panelId: 'sa:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: sa.closePanel
		};
		
		sa.panel = new util.Panel3(panelObj);
		
		// Create email addressControl
		sa.addressControl = new emailUtil.AddressControl('sa:email_address_control:container', 360);
		
		//
		// Add events
		//
		
		yEvent.addListener('sa:action', 'change', sa.display.selectActionActor);
		yEvent.addListener('sa:profile', 'change', sa.display.selectProfileActor);
		yEvent.addListener('sa:report', 'change', sa.display.selectReportActor);
		yEvent.addListener('sa:generate_report_files:output_format_type', 'change', sa.display.setOutputFormatType);
		
		
		yEvent.addListener('sa:date_filter_text', 'click', schedulerDF.open);
		
		yEvent.addListener(['sa:remove_db_data_by_number_of_days', 'sa:remove_db_data_by_filter_expression'], 'click', sa.display.removeDatabaseDataEvent);
		
		yEvent.addListener('sa:extra_options:toggle_btn', 'click', sa.display.toggleExtraOptions);
	
		yEvent.addListener('sa:okay', 'click', sa.saveItem);
		yEvent.addListener('sa:cancel', 'click', sa.closePanel);
	},
	
	display: {
		
		selectActionActor: function() {
			
			var action = util.getF('sa:action');
			schedulerActions.display.setActionByName(action);
		},
		
		setActionByName: function(action) {
			
			// alert('setActionByName(): ' + action);
			
			var databaseTextPattern = /database/;
			
			var sa = schedulerActions;
			sa.activeAction = action;
			sa.isDatabaseAction = databaseTextPattern.test(action);
			
			// Reset the validator
			sa.validator.reset();
			
			
			// Reset the display
			var displayGroups = [
				'no_action_defined',
				'profile',
				'profile_pattern',
				'remove_database_data',
				'report',
				'export_csv_table',
				'generate_report_files',
				'generate_report_files_output_directory',
				'generate_report_files_output_file',
				'generate_report_files_pdf_not_supported',
				'email',
				'report_language',
				'extra_options',
				'vertical_spacer'
			];
				
				
			for (var i = 0; i < displayGroups.length; i++) {
				util.hideE('sa:' + displayGroups[i] + ':group');
			}
				
			var showExtendedProfileList = false;
			
			//
			// Handle the action
			//
			
			if (action != '') {
				
				util.showE('sa:profile:group');
				
				if (sa.isDatabaseAction) {
					
					// database actions
					showExtendedProfileList = true;
					
					if (action == 'remove_database_data') {
						util.showE('sa:remove_database_data:group');
					}
					util.showE('sa:vertical_spacer:group');
				}
				else {
					
					// report actions
					util.showE('sa:report:group');
					
					if (action == 'generate_report_files') {
						util.showE('sa:generate_report_files:group');
						// sa.display.initOutputFormatType();
						sa.display.setOutputFormatType();
					}
					else if (action == 'export_csv_table') {
						util.showE('sa:export_csv_table:group');
					}
					else {
						util.showE('sa:email:group');
					}
					
					util.showE('sa:report_language:group');
				}
				
				
				// sa.display.resetExtraOptions();
				util.showE('sa:extra_options:group');
			}
			else {
				
				util.showE('sa:no_action_defined:group');
				util.showE('sa:vertical_spacer:group');
			}
			
			//
			//
			// Update the profile list
			//
			//
			
			var profilesDb = [];
			var baseDb = [];
			
			if (sa.isUnlimitedGrants) {
				
				// Update profiles list if required
			
				if (showExtendedProfileList != sa.isExtendedProfilesList || !sa.isProfileList) {
					
					profilesDb = scheduler.profilesDb;
					baseDb[0] = {name:'', label:langVar('lang_admin.scheduler.select_profile_label')};
					
					if (showExtendedProfileList) {
						
						baseDb[1] = {name:'*', label:langVar('lang_admin.scheduler.all_profiles_label')};
						baseDb[2] = {name:'__PROFILE__PATTERN__', label:langVar('lang_admin.scheduler.use_profile_pattern')};
					}
					
					util.populateSelect('sa:profile', baseDb, 'name', 'label');
					util.extendSelect('sa:profile', profilesDb, 'name', 'label');
					
					sa.isProfileList = true;
					sa.isExtendedProfilesList = showExtendedProfileList;
				}
			}
			else if (action != '') {
				
				// The user has limited grants and profiles may vary per action, so we always
				// update the profiles list upon action change!
				// We also don't allow a profile pattern for limited grants
				
				// var actionsDb = scheduler.actionsDb;
				
				// util.showObject(scheduler.actionsDb);
				// alert('action: ' + action);
				
				var superAction = scheduler.actionsDb[h(action)];
				
				// util.showObject(superAction);
				
				var isAllProfiles = superAction.isAllProfiles;
				profilesDb = isAllProfiles ? scheduler.profilesDb : superAction.profiles;
				
				baseDb[0] = {name:'', label:langVar('lang_admin.scheduler.select_profile_label')};
				
				if (showExtendedProfileList && isAllProfiles) {
					baseDb[1] = {name:'*', label:langVar('lang_admin.scheduler.all_profiles_label')};
				}
					
				util.populateSelect('sa:profile', baseDb, 'name', 'label');
				util.extendSelect('sa:profile', profilesDb, 'name', 'label');
			}
			
			// Reset the profile list to Select Profile
			sa.display.setProfileList('');
		},
		
		setTabPane: function(tabId) {
			
			util.hideE(['sa:general:pane', 'sa:email:pane', 'sa:options:pane']);
			util.showE('sa:' + tabId + ':pane');
		},
		
		selectProfileActor: function() {
			
			// activated upon onchange
			var sa = schedulerActions;
			var profileName = util.getF('sa:profile');
			
			sa.display.setProfileList(profileName);
		},
		
		setProfileList: function(profileName) {
			
			var sa = schedulerActions;
			
			if (profileName != '') {
			
				if (sa.isDatabaseAction) {
					
					var profileIsPattern = (profileName == '__PROFILE__PATTERN__');
					util.showE('sa:profile_pattern:group', profileIsPattern);
				}
				else {
					// Report action, we need to update the report list				
					sa.display.setReportList(profileName);
				}
			}
			else {
				sa.display.setReportList('');
			}
			
			// We re-set the form value because setProfileList() could be invoked other than by event
			util.setF('sa:profile', profileName);
		},
		
		selectReportActor: function() {
			
			if (schedulerActions.activeAction == 'generate_report_files') {
				// schedulerActions.display.initOutputFormatType();
				schedulerActions.display.setOutputFormatType();
			}
		},
		
		setReportList: function(profileName) {
			
			// util.disableE('sa:report');
			var disableSelect = false;
			
			var baseDb = [];
			baseDb[0] = {name:'', label:langVar('lang_admin.scheduler.select_report_label')};
			
			if (profileName != '') {
				
				schedulerActions.activeReportsDb = getReportsDb(profileName); // in scheduler.js
				
				// Create hash for activeReportsDb report name
				util.createHash(schedulerActions.activeReportsDb, 'name');
				
				if (schedulerActions.activeAction == 'generate_report_files') {
					baseDb[1] = {name:'*', label:langVar('lang_admin.scheduler.all_reports_label')};
				}
				
				// util.showObject(reportsDb);
				util.populateSelect('sa:report', baseDb, 'name', 'label');
				util.extendSelect('sa:report', schedulerActions.activeReportsDb, 'name', 'label');
			}
			else {
				// No profile selected
				util.populateSelect('sa:report', baseDb, 'name', 'label');
				disableSelect = true;
			}
			
			util.setF('sa:report', '');
			util.disableE('sa:report', disableSelect);
		},
		
		/*
		initOutputFormatType: function() {
			
			// alert('initOutputFormatType()');
			// PDF is only allowed if report is not "All Reports" and
			// if a report contains not more than one report element (due PDF performance)
			
			var reportName = util.getF('sa:report');
			// alert('reportName: ' + reportName);
			var isMultipleReportElements = false;
			var isAllReports = false;
			
			if (reportName != '') {
				
				if (reportName == '*') {
					isAllReports = true;
				}
				else {
					
					var reportItem = schedulerActions.activeReportsDb[h(reportName)];
					// util.showObject(reportItem);
					if (reportItem.numberOfReportElements > 1) {
						isMultipleReportElements = true;
					}
				}
			}
			
			var limitToHTMLOutput = (isAllReports || isMultipleReportElements);
			
			if (limitToHTMLOutput) {
				// Only HTML output format is allowed. Make sure that html is set!
				util.setF('sa:generate_report_files:output_format_type', 'html');
			}
			
			util.disableE('sa:generate_report_files:output_format_type', limitToHTMLOutput);
			
			schedulerActions.display.setOutputFormatType();
		},
		*/
		
		setOutputFormatType: function() {
			
			// Note, PDF is only allowed if report is not "All Reports" and
			// if a report contains not more than one report element (due PDF performance)
			
			var outputFormatType = util.getF('sa:generate_report_files:output_format_type');
			
			// alert('setOutputFormatType() - outputFormatType: ' + outputFormatType);
			var isHTML = (outputFormatType == 'html');
		
			util.hideE(['sa:generate_report_files_output_directory:group',
				'sa:generate_report_files_output_file:group',
				'sa:generate_report_files_pdf_not_supported:group'
			]);
			
			
			if (isHTML) {
				
				util.showE('sa:generate_report_files_output_directory:group');
			}
			else {
				
				var isPDFSupport = false;				
				var reportName = util.getF('sa:report');
				
				if (reportName == '') {
					
					// No report selected yet, assume we support it
					isPDFSupport = true;
				}
				else if (reportName == '*') {
					
					// 'All reports' selected, PDF output not supported
					isPDFSupport = false;
				}
				else {
					
					// Check number of report elements, only reports
					// with <= 1 report element are supported for PDF output.
					
					var reportItem = schedulerActions.activeReportsDb[h(reportName)];
					// util.showObject(reportItem);
					if (reportItem.numberOfReportElements <= 1) {
						isPDFSupport = true;
					}
				}
				
				util.showE('sa:generate_report_files_output_file:group', isPDFSupport);
				util.showE('sa:generate_report_files_pdf_not_supported:group', !isPDFSupport);
			}
		},
		
		updateDateFilterText: function() {
			
			// Updates the date filter text according activeDF
			var df = schedulerActions.activeDF;
			var type = df.type;
			var text = '';
			
			if (type == 'none') {
				
				text = langVar('lang_admin.scheduler.date_filter.entire_date_range');
			}
			else if (type == 'relative') {
								
				var prefix = df.relativePrefix;
				var dateUnit = df.relativeDateUnit;
				var dateUnitCount = df.relativeDateUnitCount;
				
				var param1Label = '';
				var param2Label = '';
				
				var dateUnitLabelsSingular = scheduler.dateUnitLabelsSingular;
				var dateUnitLabelsPlural = scheduler.dateUnitLabelsPlural;
				
				if (prefix != 'none') {
					
					/*
					text = 'Last ' + dateUnitCount + ' ' + dateUnit + 's ';
					
					if (prefix == 'recent') {
						text += 'including ' + dateUnit + ' of schedule execution date'; 
					}
					else {
						// prefix = last
						text += 'excluding ' + dateUnit + ' of schedule execution date';
					}
					*/
					
					if (prefix == 'recent') {
						// text = Last $param1 including $param2 of schedule execution date
						text = langVar('lang_admin.scheduler.date_filter.last_n_date_unit_including');
					}
					else {
						// text = Last $param1 excluding $param2 of schedule execution date
						text = langVar('lang_admin.scheduler.date_filter.last_n_date_unit_excluding');
					}
										
					param2Label = dateUnitLabelsSingular[dateUnit];
					text = text.replace(/__PARAM__2/, param2Label);
				}
				else {
					// text = Latest $param1 relative to end of log date
					text = langVar('lang_admin.scheduler.date_filter.latest_n_date_unit_relative');
				}
				
				// Handle param1Label
				
				if (dateUnitCount > 1) {
					param1Label = dateUnitCount + ' ' + dateUnitLabelsPlural[dateUnit];
				}
				else {
					param1Label = dateUnitCount + ' ' + dateUnitLabelsSingular[dateUnit];
				}
				
				text = text.replace(/__PARAM__1/, param1Label);
			}
			else {
				
				text = df.custom;
			}
			
			util.updateT('sa:date_filter_text', text);
		},
		
		removeDatabaseDataEvent: function() {
			
			// Invoked by radio button event
			var isCustomFilterExpression = util.getF('sa:remove_db_data_by_filter_expression');
			schedulerActions.display.setRemoveDatabaseData(isCustomFilterExpression);
		},
		
		setRemoveDatabaseData: function(isCustomFilterExpression) {
			
			util.disableE('sa:remove_db_data_number_of_days', isCustomFilterExpression);
			util.disableE('sa:remove_db_data_filter_expression', !isCustomFilterExpression);
		},
		
		toggleExtraOptions: function() {
			schedulerActions.display.setIsExtraOptions(!schedulerActions.isExtraOptions);
		},
		
		setIsExtraOptions: function(isExtraOptions) {
			
			schedulerActions.isExtraOptions = isExtraOptions;
			util.showE('sa:extra_options:row', isExtraOptions);
			
			var linkText = isExtraOptions ? langVar('lang_admin.scheduler.remove_extra_options') : langVar('lang_admin.scheduler.add_extra_options');
			util.updateT('sa:extra_options:toggle_btn', linkText);
		}
	},
		
	newItem: function() {
		
		// invoked from scheduler.js
		schedulerActions.mode = 'new';
		var panelLabel = langVar('lang_admin.scheduler.new_action');
		var newItemObj = {};
		schedulerActions.openPanel(panelLabel, newItemObj);
	},
	
	editItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		schedulerActions.mode = 'edit';
		schedulerActions.itemIndex = itemIndex;
		var panelLabel = langVar('lang_admin.scheduler.edit_action');
		
		// alert('editItem with itemIndex: ' + itemIndex);
		schedulerActions.openPanel(panelLabel, item);
	},
	
	
	duplicateItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// alert('duplicateItem with itemIndex: ' + itemIndex);
		// util.showObject(item);
		
		schedulerActions.mode = 'duplicate';
		schedulerActions.itemIndex = itemIndex;
		var panelLabel = langVar('lang_admin.scheduler.edit_duplicated_action');
		schedulerActions.openPanel(panelLabel, item);
	},
	
	openPanel: function(panelLabel, item) {
		
		// Note, the item may be an empty object, in this case we simply
		// set the initial Action form state to "Select Action"
		
		var sa = schedulerActions;
				
		// util.showObject(item);
		
		var isEmpyItem = (item.type == null || item.type == '');
		
		// alert('openPanel: - isEmpyItem:' + isEmpyItem);
		

		//
		// Reset Action form
		//
		
		util.resetF('sa:form');
		sa.display.setActionByName('');
		sa.display.setRemoveDatabaseData(false);
		sa.display.setIsExtraOptions(false);
		
		//
		// Reset df
		//
		
		var dfObj = schedulerActions.activeDF;
		dfObj.type = 'none';
		dfObj.custom = '';
		dfObj.relativePrefix = 'recent'; // We set realtive default date to init the date picker panel
		dfObj.relativeDateUnit = 'year';
		dfObj.relativeDateUnitCount = 1;
		
		//
		// Reset email addresses
		//
		
		sa.addressControl.reset();
		
		//
		// Set data
		//
		
		if (!isEmpyItem) {
			sa.updateForm(item);
		}
		
		//
		// Update date filter text
		//
	
		sa.display.updateDateFilterText();
		
		//
		// Open the panel 
		//
		
		sa.fixPanel(true);
		
		sa.panel.open({label:panelLabel});
	},

	updateForm: function(item) {
		
		// alert('updateForm()');
		// util.showObject(item);
		var sa = schedulerActions;
		var action = item.type;
		
		// alert('updateForm() - action: ' + action);
		
		sa.display.setActionByName(action);
		util.setF('sa:action', action);
		
		var profile = item.profile;
		var profileIsPattern = item.profile_is_pattern;
		
		var isDatabaseAction = sa.isDatabaseAction;
		
		if (isDatabaseAction) {
			
			if (profileIsPattern) {
				profile = '__PROFILE__PATTERN__';
				util.showE('sa:profile_pattern:group', profileIsPattern);
				util.setF('sa:profile_pattern', item.profile);
			}
			
			util.setF('sa:profile', profile);
			
			if (action == 'remove_database_data') {
				
				var filterInfo = item.filter_info;
				var isCustomFilterExpression = !filterInfo.number_of_days_active;
				
				if (!isCustomFilterExpression) {
					util.setF('sa:remove_db_data_by_number_of_days', true);
					util.setF('sa:remove_db_data_number_of_days', filterInfo.number_of_days);
				}
				else {
					util.setF('sa:remove_db_data_by_filter_expression', true);
					util.setF('sa:remove_db_data_filter_expression', item.options.f);
				}
			
				sa.display.setRemoveDatabaseData(isCustomFilterExpression);
			}
		}
		else {
			
			//
			// Report action
			//
			
			util.setF('sa:profile', profile);
			
			var options = item.options;
			
			//
			// Set the report list
			// 
			var reportName = options.rn;
			
			// Update the report list
			sa.display.setReportList(profile);
			util.setF('sa:report', reportName);
			
			//
			// Set Date filter
			//
			
			var dfObj = item.date_filter;
			
			// util.showObject(dfObj);
			
			var dateFilterType = dfObj.type;
			
			if (dateFilterType != 'none') {
				
				// Set activeDF which is then manipulated by schedulerDF.js
				
				var activeDfObj = schedulerActions.activeDF;
				activeDfObj.type = dateFilterType;
				
				if (dateFilterType == 'relative') {
					
					activeDfObj.relativePrefix = dfObj.relative_prefix;
					activeDfObj.relativeDateUnit = dfObj.relative_date_unit;
					activeDfObj.relativeDateUnitCount = dfObj.relative_date_unit_count;
				}
				else {
					activeDfObj.custom = dfObj.custom;
				}
			}
			
			//
			// Set misc. report action options
			// 
			
			if (action == 'export_csv_table') {
				
				util.setF('sa:export_csv_table:output_file', options.of);
			}
			else if (action == 'generate_report_files') {
				
				var outputFormatType = options.oft;
				
				if (outputFormatType == 'html') {
					// HTML
					util.setF('sa:generate_report_files:output_directory', options.od);
				}
				else {
					// PDF
					util.setF('sa:generate_report_files:output_file', options.of);
				}
				
				util.setF('sa:generate_report_files:output_format_type', outputFormatType);
				// sa.display.initOutputFormatType();
				sa.display.setOutputFormatType();
			}
			else {
				
				// send report_by_email
				util.setF('sa:return_address', options.rna);
				
				var emailAddresses = schedulerUtil.actionsEmailToEmailAddressesObject(options);
				sa.addressControl.init(emailAddresses);
				
				// util.setF('sa:recipient_address', options.rca);
				// util.setF('sa:cc_address', options.ca);
				// util.setF('sa:bcc_address', options.ba);
				
				util.setF('sa:report_email_subject', options.res);
			}
			
			// Set language
			util.setF('sa:report_language', item.language);
		}
		
		if (item.extra_options != '') {
		
			sa.display.setIsExtraOptions(true);
			util.setF('sa:extra_options', item.extra_options);
		}
	},
		
	saveItem: function() {
		
		// We save the item object back to the items array in listcontrollerB
		// alert('saveItem()');
		
		var sa = schedulerActions;
		var validator = sa.validator;
		var action = sa.activeAction;
		var o = {};
		
		if (action != '') {
			
			o.type = action;
			
			var profileIsPattern = false;
			var isValidEmailAddresses = true;
			
			o.profile = validator.isValue('sa:profile');
			
			if (o.profile == '__PROFILE__PATTERN__') {
				o.profile = validator.isValue('sa:profile_pattern');
				profileIsPattern = true;
			}
			
			o.profile_is_pattern = profileIsPattern;
			
			if (sa.isDatabaseAction) {
				
				if (action == 'remove_database_data') {
					
					var number_of_days_active = util.getF('sa:remove_db_data_by_number_of_days');
					var number_of_days = 0;
					var f_option;
					
					if (number_of_days_active) {
						// number of days
						number_of_days = validator.isInteger('sa:remove_db_data_number_of_days', 1);
						f_option = '(date_time < now() - 60*60*24*' + number_of_days + ')';
					}
					else {
						// custom filter expression
						f_option = validator.isValue('sa:remove_db_data_filter_expression');
					}
					
					o.options = {f: f_option};
					o.filter_info = {
						number_of_days_active: number_of_days_active,
						number_of_days: number_of_days
					}
				}
			}
			else {
				
				//
				// This is a report action
				//
				
				o.options = {};
				
				var reportName = validator.isValue('sa:report');
				o.options.rn = reportName;
				
				//
				// Get the date filter
				//
				
				var activeDF = schedulerActions.activeDF;
				o.date_filter = {};
				o.date_filter.type = activeDF.type;
				o.date_filter.custom = activeDF.custom;
				o.date_filter.relative_prefix = activeDF.relativePrefix;
				o.date_filter.relative_date_unit = activeDF.relativeDateUnit;
				o.date_filter.relative_date_unit_count = activeDF.relativeDateUnitCount;
				
				//
				// Handle misc. options
				//
				
				switch (action) {
					
					case 'export_csv_table':
						
						o.options.of = validator.isValue('sa:export_csv_table:output_file');
						break;
						
						
					case 'generate_report_files':
					
						var ouputFormatType = util.getF('sa:generate_report_files:output_format_type');
						
						o.options.oft = ouputFormatType;
						
						if (ouputFormatType == 'html') {
							o.options.od = validator.isValue('sa:generate_report_files:output_directory');
						}
						else {
							
							// Output is PDF
							// Make sure we throw a hidden error if output format is PDF but the selected report
							// doesn't support it. Note, the error message is already displayed but we need to
							// prevent the user from saving the form!
							// We simply reset the 'sa:generate_report_files:output_file' field, which will fire an error anyway!
							
							if (reportName != '') {
								
								isPDFOutputSupport = true;
								
								if (reportName == '*') {
									isPDFOutputSupport = false;
								}
								else {
									
									var reportItem = schedulerActions.activeReportsDb[h(reportName)];
									isPDFOutputSupport = (reportItem.numberOfReportElements <= 1);
								}
								
								if (!isPDFOutputSupport) {
									
									// Reset the 'sa:generate_report_files:output_file' so that it throws an error and avoids saving the action
									util.setF('sa:generate_report_files:output_file', '');
								}
							}
							
							o.options.of = validator.isValue('sa:generate_report_files:output_file');
						}
						
						break;
						
						
					case 'send_report_by_email':
					
						o.options.rna = validator.isValue('sa:return_address');
						
						isValidEmailAddresses = sa.addressControl.validate();
						
						if (isValidEmailAddresses) {
							
							var addressControlAddresses = sa.addressControl.getAddresses();
							
							var rca = ''; // To
							var ca = ''; // Cc
							var ba = ''; // Bcc
							
							for (var i = 0; i < addressControlAddresses.length; i++) {
								
								var addressItem = addressControlAddresses[i];
								var address = addressItem.address;
								
								if (addressItem.type == 'to') {
									rca += address + ', ';
								}
								else if (addressItem.type == 'cc') {
									ca += address + ', ';
								}
								else {
									ba += address + ', ';
								}
							}
							
							// Add only defined addresses to options!
							
							if (rca != '') {
								o.options.rca = rca.replace(/(,\s)$/, '');
							}
							
							if (ca != '') {
								o.options.ca = ca.replace(/(,\s)$/, '');
							}
							
							if (ba != '') {
								o.options.ba = ba.replace(/(,\s)$/, '');
							}
							
							// util.showObject(o.options);
						}
						
						o.options.res = validator.isValue('sa:report_email_subject');
						break;
				}
				
				o.language = util.getF('sa:report_language');
			}
			
			// get extra options
			o.extra_options = sa.isExtraOptions ? util.getF('sa:extra_options') : '';
		}
		else {
			o.action = validator.isValue('sa:action');
		}
		
		if (validator.allValid() && isValidEmailAddresses) {
			
			// alert('all valid, save the item');
			
			// Save the item to the actions list (listcontrollerB handles save of the object)
			var sa = schedulerActions;
			schedulerActionsList.list.saveItem(sa.mode, sa.itemIndex, o);
			sa.closePanel();
			
			// Check SMTP server warning
			handleSmtpServerWarning();
		}
	},
	
	closePanel: function() {
		
		var sa = schedulerActions;
		
		sa.validator.reset();
		sa.panel.close();
		sa.fixPanel(false);
	},
	
	fixPanel: function(isFix) {
		
		// IE 6 fix, show/hide select boxes in Scheduler form!
		util.showEV('schedule_date_time:tr', !isFix);
		
		// Firefox fix, change overlow property of underlying actions list to hidden (otherwise form field focus becomes lost!)
		var element = util.getE('scheduler:actions_list:div');
		element.style.overflow = isFix ? 'hidden' : 'scroll';
	},
	
	getReportLabel: function(profile, reportName) {
		
		var profilesDb = scheduler.profilesDb;
		var profileItem = profilesDb[h(profile)];
		
		var reportLabel = '';
		
		if (profileItem != null) {
			var reportNames = profileItem.rN;
			var reportLabels = profileItem.rL;
			var reportNamesDb = scheduler.reportNamesDb;
			var reportLabelsDb =  scheduler.reportLabelsDb;
			
			// We need the index of the reportName in rN of the profile
			for (var i = 0; i < reportNames.length; i++) {
				
				var reportNameIndex = reportNames[i];
				if (reportNamesDb[reportNameIndex] == reportName) {
					
					var reportLabelIndex = reportLabels[i];
					reportLabel = reportLabelsDb[reportLabelIndex];
				}
			}
		}
		
		if (reportLabel == '') {
			reportLabel = langVar('lang_admin.scheduler.unknown_report');
		}
		
		return reportLabel;
		
	},
	
	labelBuilder: function(actionItem) {
		
		// Invoced from listcontrollerB
		// Returns a text label with HTML markupp
		
		// util.showObject(actionItem);
		
		var action = actionItem.type;
		var label = scheduler.actionsDb[h(action)].label;
		
		//
		// Create the label which is displayed within the span element
		//
		
		var subLabel = '(';
		
		var profilesDb = scheduler.profilesDb;
		var profileItem = null;
		var profile = actionItem.profile;
		var profileLabel = '';
		
		if (profile != '*' && !actionItem.profile_is_pattern) {
			
			profileItem = profilesDb[h(profile)];
			profileLabel = (profileItem != null) ? profileItem.label : langVar('lang_admin.scheduler.unknown_profile');
		}
		else {
			
			if (!actionItem.profile_is_pattern) {
				
				profileLabel = langVar('lang_admin.scheduler.all_profiles_label');
			}
			else {
				
				profileLabel = profile;
			}
		}
		
		subLabel += profileLabel + ', ';
		
		
		if (action == 'export_csv_table' || 
			action == 'generate_report_files' || 
			action == 'send_report_by_email') {
				
			var reportName = actionItem.options.rn;
			var reportLabel = schedulerActions.getReportLabel(profile, reportName);
			subLabel += reportLabel + ', ';
			
			// KHP-RC, show date filter label if any
			
			if (action == 'send_report_by_email') {
				
				var recipientAddress = actionItem.options.rca;
				subLabel += recipientAddress + ', ';
			}
		}
		
		
		subLabel = subLabel.replace(/(,\s)$/, ')');
		
		var finalLabel = label + ' <span>' + subLabel + '</span>';
		
		return finalLabel;
	}
}
