//
// schedulerDF.js (Scheduler date filter
//

var schedulerDF = {
	
	panel: null,
	validator: null,
	
	init: function() {
		
		var panelObj = {
			panelId: 'sdf:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.scheduler.date_filter.edit_report_date'),
			left: 400,
			top: 190,
			zIndex: 40,
			isCover: true,
			isSticky: true,
			closeEvent: schedulerDF.closePanel
		};
		
		schedulerDF.validator = new util.Validator();
		
		schedulerDF.panel = new util.Panel3(panelObj);
		
		yEvent.addListener('sdf:meta_type', 'change', schedulerDF.setDateFilterTypeByEvent);
		yEvent.addListener('sdf:relative_date_unit', 'change', schedulerDF.setDateUnitByEvent);
		
		yEvent.addListener('sdf:okay_btn', 'click', schedulerDF.save);
		yEvent.addListener('sdf:cancel_btn', 'click', schedulerDF.closePanel);
	},
	
	open: function() {
		
		// schedulerActions.cover.setZIndex(30);
		
		// Reset form fields
		util.setF('sdf:relative_date_unit_count', 1);
		util.setF('sdf:relative_date_unit', 'year');
		util.setF('sdf:relative_prefix', 'recent');
		util.setF('sdf:custom_date_filter', '');
		
		schedulerDF.updateForm();
		schedulerDF.panel.open();
	},
	
	setDateFilterTypeByEvent: function() {
		
		schedulerDF.setDateFilterTypeByName(this.value);
	},
	
	setDateFilterTypeByName: function(metaType) {
		
		// dateType is:  none | relative_with_prefix | relative_without_prefix | custom
		
		schedulerDF.validator.reset();
		
		util.setF('sdf:meta_type', metaType);
		
		util.hideE(['sdf:group:none', 'sdf:group:relative', 'sdf:group:custom']);
		
		if (metaType == 'none') {
			util.showE('sdf:group:none');
		}
		else if (metaType == 'custom') {
			util.showE('sdf:group:custom');
		}
		else {
			
			var isWithPrefix = (metaType == 'relative_with_prefix');
			
			util.showE('sdf:relative_with_prefix:label', isWithPrefix);
			util.showE('sdf:relative_without_prefix:label', !isWithPrefix);
			util.showEV('sdf:relative_prefix', isWithPrefix);
			util.enableE('sdf:relative_prefix', isWithPrefix);
			
			if (isWithPrefix) {
				
				// update date unit in sdf:relative_prefix element
				schedulerDF.updateRelativePrefixDateUnit();
			}
			
			util.showE('sdf:group:relative');
		}
	},
	
	setDateUnitByEvent: function() {
		
		if (util.getF('sdf:meta_type') == 'relative_with_prefix') {
			schedulerDF.updateRelativePrefixDateUnit();
		}
	},
	
	updateRelativePrefixDateUnit: function() {
		
		// Updates the date unit in
		// 'including __DATE__UNIT__ of schedule date' and
		// 'excluding __DATE__UNIT__ of schedule date'
		
		var dateUnit = util.getF('sdf:relative_date_unit');
		var dateUnitLabelsSingular = scheduler.dateUnitLabelsSingular;
		var dateUnitLabel = dateUnitLabelsSingular[dateUnit];
		
		// 'including __DATE__UNIT__ of schedule execution date';
		var recentPrefixText = langVar('lang_admin.scheduler.date_filter.including_date_unit_of_exec');
		
		// 'excluding __DATE__UNIT__ of schedule execution date'
		var lastPrefixText = langVar('lang_admin.scheduler.date_filter.excluding_date_unit_of_exec');
		
		recentPrefixText = recentPrefixText.replace(/__PARAM__1/, dateUnitLabel);
		lastPrefixText = lastPrefixText.replace(/__PARAM__1/, dateUnitLabel);
		
		var list = [{name:'recent', label:recentPrefixText}, {name:'last', label:lastPrefixText}];
		
		// Get activePrefix which is set again after we re-populate the list 
		var activePrefix = util.getF('sdf:relative_prefix');
		
		util.populateSelect('sdf:relative_prefix', list, 'name', 'label');
		util.setF('sdf:relative_prefix', activePrefix);
	},
	
	updateForm: function() {
		
		var activeDF = schedulerActions.activeDF;
		// util.showObject(activeDF);
		var type = activeDF.type;
		var metaType = '';
		
		if (type == 'none') {
			metaType = type;
		}
		else if (type == 'relative') {
			
			var isPrefix = (activeDF.relativePrefix != 'none');
			var metaType = isPrefix ? 'relative_with_prefix' : 'relative_without_prefix';
			
			util.setF('sdf:relative_date_unit_count', activeDF.relativeDateUnitCount);
			util.setF('sdf:relative_date_unit', activeDF.relativeDateUnit);
			
			if (isPrefix) {
				util.setF('sdf:relative_prefix', activeDF.relativePrefix);
			}
		}
		else {
			// custom
			metaType = type;
			util.setF('sdf:custom_date_filter', activeDF.custom);
		}
		
		schedulerDF.setDateFilterTypeByName(metaType);
	},

	closePanel: function() {

		schedulerDF.panel.close();
		// schedulerActions.cover.setZIndex(10);
	},
	
	save: function() {
		
		var validator = schedulerDF.validator;
		validator.reset();
		
		var type = '';
		var custom = '';
		var relativePrefix = '';
		var relativeDateUnit = '';
		var relativeDateUnitCount = '1';
		
		var metaType = util.getF('sdf:meta_type');
		
		if (metaType == 'none') {
			type = metaType;
		}
		else if (metaType == 'custom') {
			
			type = metaType;
			var custom = validator.isValue('sdf:custom_date_filter');
		}
		else {
			// Relative
			
			var isPrefix = (metaType == 'relative_with_prefix');
			
			// alert('isPrefix: ' + isPrefix);
			
			type = 'relative';
			relativePrefix = isPrefix ? util.getF('sdf:relative_prefix') : 'none';
			relativeDateUnit = util.getF('sdf:relative_date_unit');
			relativeDateUnitCount = validator.isInteger('sdf:relative_date_unit_count', 1);
		}
		
		if (validator.allValid()) {
			
			var activeDF = schedulerActions.activeDF;
			activeDF.type = type;
			activeDF.custom = custom;
			activeDF.relativePrefix = relativePrefix;
			activeDF.relativeDateUnit = relativeDateUnit;
			activeDF.relativeDateUnitCount = relativeDateUnitCount;
			
			// util.showObject(activeDF);
			
			schedulerDF.closePanel();
			
			// Update date text in Actions form
			schedulerActions.display.updateDateFilterText();
		}
	}
}
