//
// admin tasks
//

var tasks = {
	
	viewTaskLogBtn: null,
	taskLogWindow: null,
	
	cancelTaskIsActive: false,
	
	init: function() {
		
		tasks.viewTaskLogBtn = new util.ToolbarButton('view_task_log', tasks.viewTaskLog, toolbarButtonsDb);
		tasks.viewTaskLogBtn.enable();
		
		// Assign single cancel task event
		yEvent.addListener('tasks_list_container', 'click', tasks.cancelTask);
		
		// Init help
		util.helpWindow.init('');
		
		tasks.getTasks();
	},

	getTasks: function() {
		
		if (!tasks.cancelTaskIsActive) {
	
			var url = '?dp+templates.admin_pages.tasks.get_tasks';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			util.serverPost(url, dat);
		}
	},
	
	getTasksResponse: function(dat) {
		
		if (!tasks.cancelTaskIsActive) {
			
			// hide canceling_task_info, which could be shown
			util.hideE('canceling_task_info');
			
			
			var labels = dat.labels;
			var taskItems = dat.taskItems;
			tasks.labels = labels;
		
			var checking_active_tasks_info = document.getElementById('checking_active_tasks_info');
			var no_task_active_info = document.getElementById('no_task_active_info');
			
			checking_active_tasks_info.style.display = 'none';
				
			var tbody = document.getElementById('tasks_list_container');
			
			// Remove any existing task rows
			util.removeChildElements(tbody);
		
			if (taskItems.length > 0) {
			
				no_task_active_info.style.display = 'none';
			
				// build header row
				
				var tr = document.createElement('tr');
		
				tr.appendChild(tasks.build_th(labels.task_id));
				tr.appendChild(tasks.build_th(labels.profile));
				tr.appendChild(tasks.build_th(labels.decsription));
				tr.appendChild(tasks.build_th(labels.time_elapsed, true));
				tr.appendChild(tasks.build_th(labels.complete, true));
				tr.appendChild(tasks.build_th('&nbsp;', true));
				
				tbody.appendChild(tr);
		
				for (var i = 0; i < taskItems.length; i++) {
					
					var item = taskItems[i];
					var taskId = item.task_id;
				
					var tr = document.createElement('tr');
					
					// var is_active_label = item.task_is_active ? 'IS ACTIVE' : 'inactive';
					
					tr.appendChild(tasks.build_td(taskId));
					tr.appendChild(tasks.build_td(item.profile));
					tr.appendChild(tasks.build_description_td(item));
					tr.appendChild(tasks.build_td(item.time_elapsed, true));
					tr.appendChild(tasks.build_td(item.percent_complete, true));
					tr.appendChild(tasks.build_cancel_task_td(taskId));
					
					tbody.appendChild(tr);
				}
				
				// Make sure we show tbody, it could be hidden due cacelTask
				util.showE('tasks_list_container');
			}
			else {
			
				no_task_active_info.style.display = 'block';
			}
			
			setTimeout('tasks.getTasks()', 1500);
		}
	},
	

	build_th: function(label, align_right) {
	
		var th = document.createElement('th');
		
		if (align_right != undefined) {
		
			th.style.textAlign = 'right';
		}
		
		var txt = util.createT(label);
		th.appendChild(txt);
		
		return th;
	},
	
	
	build_td: function(label, align_right) {
	
		// alert('align_right: ' + align_right);
	
		var td = document.createElement('td');
		
		if (align_right != undefined) {
		
			td.style.textAlign = 'right';
		}
		
		var txt = document.createTextNode(label);
		td.appendChild(txt);
		
		return td;
	},
	
	build_description_td: function(taskItem) {
	
		// alert(taskItem.step_label + '\n' + taskItem.step_description);
	
		var td = document.createElement('td');
		td.style.width = '60%';
		td.style.whiteSpace = 'normal';
		var txt = document.createTextNode(taskItem.task_description);
		td.appendChild(txt);
		
		if (taskItem.step_exists) {
			
			var labels = tasks.labels;
		
			var div = document.createElement('div');
			div.style.paddingTop = '5px';
			//div.style.paddingLeft = '7px';
			div.style.fontSize = '0.9em';
					
			// processing step
			
			var processing_step_label = labels.processing_step;
			processing_step_label = processing_step_label.replace(/__PARAM__1/, taskItem.current_step);
			processing_step_label = processing_step_label.replace(/__PARAM__2/, taskItem.number_of_steps);		
			
			var processing_step_txt = document.createTextNode(processing_step_label);
			div.appendChild(processing_step_txt);
			
			
			// step_description
	
			var step_description = taskItem.step_description;
			
			if (step_description.length > 0 && step_description != '-') {
			
				var br = document.createElement('br');
				var step_description_txt = document.createTextNode(step_description);
				
				div.appendChild(br);
				div.appendChild(step_description_txt);
			}
			
			// step_time_elapsed
			
			step_time_elapsed_txt = document.createTextNode(labels.time_elapsed + ': ' + taskItem.step_time_elapsed);
			var br2 = document.createElement('br');
			div.appendChild(br2);
			div.appendChild(step_time_elapsed_txt);
			
			// step_time_remaining
			
			step_time_remaining_txt = document.createTextNode(labels.time_remaining + ': ' + taskItem.step_time_remaining);
			var br3 = document.createElement('br');
			div.appendChild(br3);
			div.appendChild(step_time_remaining_txt);
			
			// step_percent_complete
	
			step_percent_complete_txt = document.createTextNode(labels.complete + ': ' + taskItem.step_percent_complete);
			var br4 = document.createElement('br');
			div.appendChild(br4);
			div.appendChild(step_percent_complete_txt);
	
			td.appendChild(div);
		}
		
		return td;
	},
	
	build_cancel_task_td: function(taskId) {
		
		var anchorId = 'tasks:cancel_task:' + taskId;
		
		var td = util.createE('td');
		var a = util.createE('a', {id:anchorId, href:'javascript:;'});
		var text = util.createT(langVar('lang_stats.btn.cancel_task'));
		
		util.chainE(td, a, text);
		
		return td;
	},
	
	//
	// viewTaskLog handling
	//
	
	viewTaskLog: function() {
		
		var width = yDom.getViewportWidth() - 40;
		var height = yDom.getViewportHeight() - 40;
		
		var features = 'width=' + width + ',height=' + height + ',menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
		
		var url = '?dp+templates.admin_pages.tasks.view_task_log';
			
		tasks.taskLogWindow = window.open(url, 'task_log', features);
		tasks.taskLogWindow.focus();
		
	},
	
	//
	// Cancel Task handling
	//
	
	cancelTask: function(evt) {
		
		var element = evt.target || evt.srcElement;
		var tagName = element.nodeName;
	
		if (tagName == 'A') {
			
			tasks.cancelTaskIsActive = true;
			
			var elementId = element.id;
			var dat = elementId.split(':');
			var taskId = dat[2];
			
			var msg = langVar('lang_admin.tasks.confirm_cancel_task_message');
			msg = msg.replace(/__PARAM__1/, taskId);
 			
			if (confirm(msg)) {
				
				util.hideE('tasks_list_container');
				util.showE('canceling_task_info');
				
				var url = '?dp+templates.admin_pages.tasks.cancel_task';
				var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
				dat += 'v.fp.task_id=' + taskId;
				
				util.serverPost(url, dat);
			}
			else {
				// No confirm, continue with tasks display
				tasks.cancelTaskIsActive = false;
				tasks.getTasks();
			}	
		}
	},
	
	cancelTaskResponse: function(dat) {
		
		// The task has been canceled, continue with tasks display
		
		// alert('cancelTaskResponse()');
		
		tasks.cancelTaskIsActive = false;
		tasks.getTasks();
	}
};















