//
// databaseInfo.js
//


var databaseInfo = {
	
	initGUIDone: false,
	confirmRebuildPanel: null,
	updateDbBtn: null,
	refreshDbBtn: null,
	rebuildDbBtn: null,
	
	// quick permission properties
	isUpdateDbBtn: false,
	// isRefreshDbBtn: false,
	isRebuildDbBtn: false,
	
	databaseServerType: '',
	isRealTimeProcessing: false,
	databaseIsBuilding: false,
	initialBuildDone: false,
	databaseIsReadyForReporting: false,
	dbInfoDat: {},
	
	updateDatabaseId: '',
	rebuildDatabaseId: '',
	
	lockRealTimeProgress: false
};


function initGUI() {
	
	if (pageInfo.permissions.isUpdate) {
		
		databaseInfo.updateDbBtn = new util.CommandLink('database_info:update_database_btn', startUpdateDatabase);
		databaseInfo.isUpdateDbBtn = true;
	}
	
	if (pageInfo.permissions.isBuild) {
		
		databaseInfo.rebuildDbBtn = new util.CommandLink('database_info:rebuild_database_btn', rebuildDatabase);
		databaseInfo.isRebuildDbBtn = true;
		
		var panelObj = {
			panelId: 'database_info:start_rebuild_database:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.database_info.confirm_rebuild_database'),
			left: 400,
			top: 100,
			zIndex: 20,
			isCover: true,
			closeEvent: cancelRebuildDatabase
		};
		
		databaseInfo.confirmRebuildPanel = new util.Panel3(panelObj);
	
		yEvent.addListener('database_info:start_rebuild_btn', 'click', startRebuildDatabase);
		yEvent.addListener('database_info:no_rebuild_btn', 'click', cancelRebuildDatabase);
	}
	
	//
	// init progress.js
	//
	
	progress.decimalDivider = pageInfo.decimalDivider;
	progress.isCancelTaskPermission = pageInfo.permissions.isCancelTask;
	progress.profileName = pageInfo.profileName;
}

function updateGlobalDatabaseInfoParameters(dat) {
	
	databaseInfo.databaseServerType = dat.databaseServerType;
	databaseInfo.isRealTimeProcessing = dat.isRealTimeProcessing;
	databaseInfo.initialBuildDone = dat.initialBuildDone;
	databaseInfo.databaseIsBuilding = dat.databaseIsBuilding;
	databaseInfo.databaseIsReadyForReporting = dat.databaseIsReadyForReporting;
	databaseInfo.dbInfoDat = dat.dbInfoDat;
	
	/*
	util.showObject({isRealTimeProcessing:databaseInfo.isRealTimeProcessing});
	util.showObject({databaseIsBuilding:databaseInfo.databaseIsBuilding});
	util.showObject({initialBuildDone:databaseInfo.initialBuildDone});
	util.showObject({databaseIsReadyForReporting:databaseInfo.databaseIsReadyForReporting});
	*/
}


function getDatabaseInfoData() {
	
	if (!pageInfo.exitActive) {
		
		// Init help
		util.helpWindow.init('');
		
		var url = '?dp+templates.config_pages.database_info.get_db_info_data';
		url += '+p+' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.client_response_function=getDatabaseInfoDataResponse';
		util.serverPost(url, dat);
	}
}

function getDatabaseInfoDataResponse(dat) {
	
	// alert('getDatabaseInfoDataResponse()');
	
	// util.showObject(dat);
	
	updateGlobalDatabaseInfoParameters(dat);
	
	// We need dbInfoDat later for refreshDatabaseInfoData(), so make it global
	
	if (!databaseInfo.initGUIDone) {
		initGUI();
		databaseInfo.initGUIDone = true;
	}
	
	resetDisplay();
	
	if (!databaseInfo.isRealTimeProcessing && databaseInfo.databaseIsBuilding) {
		
		// The database is_updating or is_building, show progress
		progress.calleeListener = generalDatabaseProgressListener;
		progress.initDatabaseProgress();
		util.showE('progress_section');
	}
	else {
		
		updateDatabaseInfoTable();
		updateLogFormatInfo(dat);
		setButtonState();
		util.showE('database_info:info:section');
	}
	
	util.hideE('database_info:loading_info');
	util.showE('form_section');
	
	if (databaseInfo.isRealTimeProcessing) {
		
		// Start to get real time progress
		setTimeout('refreshDatabaseInfoData()', 1500);
	}
}

function setButtonState() {
	
	var enableUpdateDb = false;
	var showNoBuildnfo = false
	
	if (!databaseInfo.isRealTimeProcessing) {
		
		if (databaseInfo.initialBuildDone) {
			enableUpdateDb = true;
		}
		else {
			// There is no database build yet
			showNoBuildnfo = true;
		}
	}
	else {
		
		// real time processing
		if (databaseInfo.databaseIsReadyForReporting) {
			
			// We don't allopw to update the db while it is already building
			enableUpdateDb = !databaseInfo.databaseIsBuilding;
		}
		else {
			// There is no database build yet
			showNoBuildnfo = true;
		}		
	}
	
	util.showE('database_info:not_build_info', showNoBuildnfo);
	
	if (databaseInfo.isUpdateDbBtn) {
		databaseInfo.updateDbBtn.enable(enableUpdateDb);
	}

	
	if (databaseInfo.isRebuildDbBtn) {
		databaseInfo.rebuildDbBtn.enable();
	}
}

function refreshDatabaseInfoData() {
	
	var isRealTimeProcessing = databaseInfo.isRealTimeProcessing;
	
	if (!pageInfo.exitActive && (!isRealTimeProcessing || !databaseInfo.lockRealTimeProgress)) {
		
		if (!isRealTimeProcessing) { 
		
			util.hideE('form_section');
			util.showE('database_info:loading_info');
		}
		
		var url = '?dp+templates.config_pages.database_info.get_db_info_data';
		url += '+p+' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.client_response_function=refreshDatabaseInfoDataResponse';
		
		util.serverPost(url, dat);
	}
}

function refreshDatabaseInfoDataResponse(dat) {
	
	if (!databaseInfo.isRealTimeProcessing || !databaseInfo.lockRealTimeProgress) {
	
		updateGlobalDatabaseInfoParameters(dat);
		updateDatabaseInfoTable();
		setButtonState();
		
		if (!databaseInfo.isRealTimeProcessing) {
			util.hideE('database_info:loading_info');
			util.showE('database_info:info:section');
			util.showE('form_section');
		}
		else {
			// is real time processing
			// Continue to get real time  progress
			setTimeout('refreshDatabaseInfoData()', 1500);
		}
	}
}

function resetDisplay() {
	
	var a = [
		'database_info:info:section',
		'database_info:not_build_info',
		// 'database_info:update_database_completed_info',
		// 'database_info:rebuild_database_completed_info',
		'database_info:database_task_canceled_info',
		'progress_section'
	]
	
	util.hideE(a);
}

function setRealTimeProgress(progressType) {
	
	util.hideE([
		'database_info:progress_animation_stop',
		'database_info:progress_animation_blink',
		'database_info:progress_animation_run'
	]);
	
	switch (progressType) {
		
		case 'init':
			util.showE('database_info:progress_animation_blink');
			break;
			
		case 'active':
			util.showE('database_info:progress_animation_run');
			break;
			
		case 'stop':
			util.showE('database_info:progress_animation_stop');
			break;
	}
}

function updateDatabaseInfoTable() {
	
	var isInternalSql = (databaseInfo.databaseServerType == 'internal_sql');
	util.showE('database_info:current_operation_box', databaseInfo.isRealTimeProcessing);
	util.showE('database_info:database_directory_box', isInternalSql);
	util.showE('database_info:database_name_box', !isInternalSql);
	
	var dbInfoDat = databaseInfo.dbInfoDat;
	
	for (var prop in dbInfoDat) {
		util.updateT('database_info:' + prop, dbInfoDat[prop]);
	}
	
	if (databaseInfo.isRealTimeProcessing) {
		
		var progressType = databaseInfo.databaseIsBuilding ? 'active' : 'stop';
		setRealTimeProgress(progressType);
	}
}

function updateLogFormatInfo(dat) {
	
	var isStandaloneLogFormat = (dat.logFormat.label != null);
	
	function addLabels(theFormat, elementId) {
		
		var mainLabel = theFormat.label;
		util.updateT(elementId, mainLabel);
		
		if (theFormat.infoLabels != null) {
			
			// add one or more info labels in a lighter color
			var infoLabels = theFormat.infoLabels;
			infoLabels.sort();
			
			var element = util.getE(elementId);
			
			for (var i = 0; i < infoLabels.length; i++) {
				
				var br = util.createE('br');
				var span = util.createE('span', {color:'#666666'});
				var text = util.createT('- ' + infoLabels[i]);
				util.chainE([element, br, [span, text]]);
			}
		}
	}
	
	if (isStandaloneLogFormat) {
		
		addLabels(dat.logFormat, 'database_info:log_format');
	}
	else {
		addLabels(dat.syslogFormat, 'database_info:syslog_format');
		addLabels(dat.syslogRequiredFormat, 'database_info:syslog_required_format');
	};
	
	util.showE('database_info:log_format:tr', isStandaloneLogFormat);
	util.showE(['database_info:syslog_format:tr', 'database_info:syslog_required_format:tr'], !isStandaloneLogFormat);
}


//
//
// Update Database
//
//


function startUpdateDatabase() {
	
	
	if (!databaseInfo.isRealTimeProcessing) {
	
		resetDisplay();
		progress.showActionInfo('update_database_init');
		util.showE('progress_section');
	}
	else {
		
		// real time processing
		databaseInfo.lockRealTimeProgress = true;
		
		databaseInfo.updateDbBtn.disable();
		
		if (databaseInfo.isRebuildDbBtn) {
			databaseInfo.rebuildDbBtn.disable();
		}
		
		setRealTimeProgress('init');
		util.updateT('database_info:current_operation', langVar('lang_stats.database_info.update_database_initiated'));
	}
	
	// Issue an update database id
	var d = new Date();
	var updateDatabaseId = 'update_database_' + d.getTime();
	databaseInfo.updateDatabaseId = updateDatabaseId;
	
	var url = '?dp+templates.update_database.start_update_database';
	url += '+p+' + pageInfo.profileName;
	
	var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
	dat += 'v.fp.client_response_function=startUpdateDatabaseResponse&';
	dat += 'v.fp.update_database_id=' + updateDatabaseId;
	
	util.serverPost(url, dat);
}

function startUpdateDatabaseResponse(dat) {
	
	// Get the update database state
	if (dat.updateDatabaseId == databaseInfo.updateDatabaseId) {
		
		if (!databaseInfo.isRealTimeProcessing) {
		
			if (!dat.updateDatabaseCompleted) {
				
				// There must be update database progress
				progress.calleeListener = updateDatabaseProgressListener;
				progress.initDatabaseProgress(dat.taskId);
			}
			else {
				
				// Update completed without any progress
				refreshDatabaseInfoData();
				// util.showE('database_info:update_database_completed_info', isUpdateDatabase);
			}
		}
		else {
			
			// real time processing
			// Restart to get real time processing progress
			databaseInfo.lockRealTimeProgress = false;
			refreshDatabaseInfoData()
		}
	}
}

//
//
//
// Rebuild database
//
//
//

function rebuildDatabase() {
	databaseInfo.confirmRebuildPanel.open();
}

function cancelRebuildDatabase() {
	databaseInfo.confirmRebuildPanel.close();
}

function startRebuildDatabase() {
	
	// alert('startRebuildDatabase()');
	databaseInfo.confirmRebuildPanel.close();
	
	if (!databaseInfo.isRealTimeProcessing) {
	
		resetDisplay();
		progress.showActionInfo('rebuild_database_init');
		util.showE('progress_section');
	}
	else {
		
		// real time processing
		databaseInfo.lockRealTimeProgress = true;
		
		databaseInfo.rebuildDbBtn.disable();
		if (databaseInfo.isUpdateDbBtn) {
			databaseInfo.updateDbBtn.disable();
		}
		
		setRealTimeProgress('init');
		util.updateT('database_info:current_operation', langVar('lang_stats.database_info.rebuild_database_initiated'));
	}
	
	// Issue a rebuild database id
	var d = new Date();
	var rebuildDatabaseId = 'rebuild_database_' + d.getTime();
	databaseInfo.rebuildDatabaseId = rebuildDatabaseId;
	
	var url = '?dp+templates.rebuild_database.start_rebuild_database';
	url += '+p+' + pageInfo.profileName;
	
	var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
	dat += 'v.fp.client_response_function=startRebuildDatabaseResponse&';
	dat += 'v.fp.rebuild_database_id=' + rebuildDatabaseId;
	
	util.serverPost(url, dat);
}

function startRebuildDatabaseResponse(dat) {

	// util.showObject(dat);
	
	// alert('startRebuildDatabaseResponse()');
	// Get the rebuild database state
	if (dat.rebuildDatabaseId == databaseInfo.rebuildDatabaseId) {
		
		if (!databaseInfo.isRealTimeProcessing) {
		
			var taskId = dat.taskId;
			
			// Note, empty task ID is allowed, it is usually handled by progress
			
			progress.calleeListener = rebuildDatabaseProgressListener;
			progress.initDatabaseProgress(taskId);
		}
		else {
			
			// Restart to get real time processing progress
			databaseInfo.lockRealTimeProgress = false;
			refreshDatabaseInfoData()
		}
	}
}


//
//
// Progress listeners (used when not in real time processing mode)
//
//

function generalDatabaseProgressListener(senderState) {
	// alert('rebuildDatabaseProgressListener() - state: ' + state);
	// This function is called when the Database Info page is loaded
	// but update/rebuild database is already active.
	databaseProgressListenerFinal(senderState, false, false);
}

function updateDatabaseProgressListener(senderState) {
	// alert('rebuildDatabaseProgressListener() - state: ' + state);
	databaseProgressListenerFinal(senderState, true, false);
}

function rebuildDatabaseProgressListener(senderState) {
	// alert('rebuildDatabaseProgressListener() - state: ' + state);
	databaseProgressListenerFinal(senderState, false, true);
}

function databaseProgressListenerFinal(senderState, isUpdateDatabase, isRebuildDatabase) {
	
	// Called from one of the above progress listeners
	if (senderState == 'database_task_not_active' || senderState == 'database_progress_complete') {
		resetDisplay();
		refreshDatabaseInfoData();
		// util.showE('database_info:update_database_completed_info', isUpdateDatabase);
		// util.showE('database_info:rebuild_database_completed_info', isRebuildDatabase);
	}
	else if (senderState == 'task_canceled') {
		resetDisplay();
		refreshDatabaseInfoData();
		util.showE('database_info:database_task_canceled_info');
	}
}

