//
// logFilterAction.js
//

// Covers log filter Actions (then) and Alternative Actions (else)

var logFilterAction = {
	
	panel: null,
	validator: null,
	
	//
	// Active form parameters
	//
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index

	// activeOperatorListType: '', // numerical | string | dateTime --> names are equal the property name in conditionOperatorsDb object for quick access

	isAlternativeAction: false, // defines if the current item is an action or an alternative action
	
	init: function() {
		
		logFilterAction.validator = new util.Validator();
	
		var panelObj = {
			panelId: 'lfa:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterAction.closePanel
		};
		
		logFilterAction.panel = new util.Panel3(panelObj);
		
		
		// var addSelectOption = true;
		// logFiltersUtil.populateFullLogFieldsList('lfc:log_fields_list', addSelectOption);
		
		// Set default operator list by resetForm()
		// logFilterAction.resetForm();
		
		
		logFilterActionUtil.initActionForm();
		
		
		//
		// Add events
		//
		
		// yEvent.addListener('lfc:log_fields_list', 'change', logFilterAction.selectLogFieldActor);
			
		yEvent.addListener('lfa:ok_btn', 'click', logFilterAction.saveItem);
		yEvent.addListener('lfa:cancel_btn', 'click', logFilterAction.closePanel);
	},
	
	
	openPanel: function(panelLabel, item) {
		
		// Note, the item may be empty!
		
		if (!logFilterAction.panel) {
			logFilterAction.init();
		}
		
		// Reset the form
		logFilterActionUtil.resetForm();
		
		if (!item.type) {
			// Set initial state (new item)
			logFilterActionUtil.setActionDisplay('');
		}
		else {
			// this is an existing item (edit or duplicate item)
			logFilterActionUtil.updateForm(item);
		}		
		
		logFiltersUtil.fixDivOverflow(true);
		logFilterAction.panel.open({label:panelLabel});
	},
			
	closePanel: function() {
		
		logFilterAction.validator.reset();
		logFiltersUtil.fixDivOverflow(false);
		logFilterAction.panel.close();
	},
	
	//
	// New item handling
	// 
	
	newItem: function(panelLabel) {
		
		logFilterAction.mode = 'new';
		var newItemObj = {};
		logFilterAction.openPanel(panelLabel, newItemObj);
	},

	newActionItem: function() {
		
		// invoked from logFilters.js
		logFilterAction.isAlternativeAction = false;
		logFilterAction.newItem(langVar('lang_admin.log_filters.new_action'));
	},
	
	newAlternativeActionItem: function() {
		
		// invoked from logFilters.js
		logFilterAction.isAlternativeAction = true;
		logFilterAction.newItem(langVar('lang_admin.log_filters.new_alternative_action'));
	},
	
	//
	// Edit item handling
	// 
	
	editItem: function(itemIndex, item, panelLabel) {
		
		logFilterAction.mode = 'edit';
		logFilterAction.itemIndex = itemIndex;
		
		// alert('editItem with itemIndex: ' + itemIndex);
		logFilterAction.openPanel(panelLabel, item);
	},
	
	
	editActionItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		logFilterAction.isAlternativeAction = false;
		logFilterAction.editItem(itemIndex, item, langVar('lang_admin.log_filters.edit_action'));
	},
	
	editAlternativeActionItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		logFilterAction.isAlternativeAction = true;
		logFilterAction.editItem(itemIndex, item, langVar('lang_admin.log_filters.edit_alternative_action'));
	},
	
	//
	// Duplicate item handling
	//
	
	duplicateItem: function(itemIndex, item, panelLabel) {
		
		logFilterAction.mode = 'duplicate';
		logFilterAction.itemIndex = itemIndex;
		logFilterAction.openPanel(panelLabel, item);
	},
	
	
	duplicateActionItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// alert('duplicateItem with itemIndex: ' + itemIndex);
		
		logFilterAction.isAlternativeAction = false;
		logFilterAction.duplicateItem(itemIndex, item, langVar('lang_admin.log_filters.edit_duplicated_action'));
	},
	
	duplicateAlternativeActionItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// alert('duplicateItem with itemIndex: ' + itemIndex);
		
		logFilterAction.isAlternativeAction = true;
		logFilterAction.duplicateItem(itemIndex, item, langVar('lang_admin.log_filters.edit_duplicated_alternative_action'));
	},
	
	
	//
	// Save item
	//
	
	saveItem: function() {
		
		// We save the item object back to the items array in listcontrollerB
		
		var validator = logFilterAction.validator;
		validator.reset();
		
		var obj = {};
		obj.type = validator.isValue('lfa:action_list');
		
		switch (obj.type) {
				
			case 'concatenate':
				
				var concatenateItems = [];
				var isLogField;
				var concatenateValueElementId;
				var literal;
				
				// Check field 0
				isLogField = (util.getF('lfa:concatenate_type_list:0') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:0' : 'lfa:concatenate_value:0';
				literal = validator.isValue(concatenateValueElementId);
				concatenateItems[0] = {is_log_field: isLogField, literal: literal};
				
				// Check field 1
				isLogField = (util.getF('lfa:concatenate_type_list:1') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:1' : 'lfa:concatenate_value:1';
				literal = validator.isValue(concatenateValueElementId);
				concatenateItems[1] = {is_log_field: isLogField, literal: literal};
				
				// Check the optional field 2
				isLogField = (util.getF('lfa:concatenate_type_list:2') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:2' : 'lfa:concatenate_value:2';
				literal = util.getF(concatenateValueElementId);
				if (literal != '') {
					concatenateItems[2] = {is_log_field: isLogField, literal: literal};
				}
				
				// Check the optional field 3
				isLogField = (util.getF('lfa:concatenate_type_list:3') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:3' : 'lfa:concatenate_value:3';
				literal = util.getF(concatenateValueElementId);
				if (literal != '') {
					// There may be no item number 2, so add the item by length property!
					concatenateItems[concatenateItems.length] = {is_log_field: isLogField, literal: literal};
				}
				
				// util.showObject(concatenateItems);
			
				obj.concatenate = concatenateItems;
				
				// Validate result field
				obj.log_field = validator.isValue('lfa:concatenate_log_fields_list:result');
				
				break;
				
			case 'convert_to_lowercase':
			
				obj.log_field = validator.isValue('lfa:convert_to_lowercase:log_fields_list');
				break;
				
			case 'convert_to_uppercase':
			
				obj.log_field = validator.isValue('lfa:convert_to_uppercase:log_fields_list');
				break;
				
			case 'copy':
			
				obj.log_field = validator.isValue('lfa:copy:log_fields_list:from');
				obj.target_log_field = validator.isValue('lfa:copy:log_fields_list:to');
				break;
				
			case 'match_regexp_copy':
			
				obj.log_field = validator.isValue('lfa:match_regexp_copy:log_field_list');
				obj.literal = validator.isRegularExpression('lfa:match_regexp_copy:expression');
				
				var copyToLogFieldItems = [];
				var copyToLogField = '';
				
				// KHP-RC, check for errors if parenthesizes in regular expression don't match the number of selected log fields!
				// var numberOfCopyToItems = 1;
				
				// Check log field 0
				copyToLogField = validator.isValue('lfa:match_regexp_copy:log_fields_list:0');
				copyToLogFieldItems[0] = {log_field: copyToLogField};
				
				// heck log field 1 (optional)
				copyToLogField = util.getF('lfa:match_regexp_copy:log_fields_list:1');
				
				if (copyToLogField != '') {
					
					copyToLogFieldItems[1] = {log_field: copyToLogField};
					
					// heck log field 2 (optional)
					copyToLogField = util.getF('lfa:match_regexp_copy:log_fields_list:2');
					
					if (copyToLogField != '') {
						
						copyToLogFieldItems[2] = {log_field: copyToLogField};
						
						// heck log field 3 (optional)
						copyToLogField = util.getF('lfa:match_regexp_copy:log_fields_list:3');
						
						if (copyToLogField != '') {
							
							copyToLogFieldItems[3] = {log_field: copyToLogField};
						}
					}
				}
				
				obj.copy = copyToLogFieldItems;
			
				break;
				
			case 'find_and_replace':
			
				obj.log_field = validator.isValue('lfa:find_and_replace:log_fields_list');
				obj.literal = validator.isValue('lfa:find_and_replace:find_value');
				obj.literal_2 = util.getF('lfa:find_and_replace:replace_value'); // Is allowed to be empty!
				
				var replaceType = '';
				if (util.getF('lfa:find_and_replace:all_btn')) {
					replaceType = 'all';
				}
				else if (util.getF('lfa:find_and_replace:first_btn')) {
					replaceType = 'first';
				}
				else {
					replaceType = 'last';
				}
				
				obj.replace_type = replaceType;
				
				break;
				
			case 'set':
			
				obj.log_field = validator.isValue('lfa:set:log_fields_list');
				obj.literal = util.getF('lfa:set:value'); // empty value is allowed!
				break;
		}
		
		//
		// Save the item
		//
		
		if (validator.allValid()) {
		
			
			// Save the item to the actions list (listcontrollerB handles save of the object)
			if (!logFilterAction.isAlternativeAction) {
				
				// Save Action item
				logFilterLists.actions.saveItem(logFilterAction.mode, logFilterAction.itemIndex, obj);
			}
			else {
				
				// Save Alternative Action item
				logFilterLists.alternativeActions.saveItem(logFilterAction.mode, logFilterAction.itemIndex, obj);
			}
			
			logFilterAction.closePanel();
		}
		
	},
	
	//
	// Label builder
	//
	
	labelBuilder: function(item, isAlternativeAction) {
		
		// alert('logFilterAction.labelBuilder()');
		
		// Returns a label (with or without HTML markup)
		
		// util.showObject(actionItem);
		
		function getLabel(logFieldName) {
			
			var logFieldItem = logFilters.logFieldsDb[h(logFieldName)];
			var logFieldLabel = '';
			
			if (logFieldItem != null) {
				logFieldLabel = logFieldItem.label;
			}
			else {
				logFieldLabel = '[ ' + langVar('lang_admin.log_filters.unknown_log_field') + ' ]';
			}
			
			return logFieldLabel;
		}
		
		function getConcatenateString(concatenateItems) {
			
			var s = '';
			for (var i = 0; i < concatenateItems.length; i++) {
				var item = concatenateItems[i];
				var literal = item.literal;
				s += ' ';
				s += item.is_log_field ? getLabel(literal) : '"' + literal + '"';
				s += ' +';
			}
			
			s = s.replace(/\+$/, '');
			return s;
		}
		
		function getMatchRegexpCopyString(copyItems) {
			
			var s = '';
			for (var i = 0; i < copyItems.length; i++) {
				s += ' $' + (i+1) + ' ' + langVar('lang_admin.log_filters.match_regexp_and_copy_to_info_2') + ' '; // I.e. "$1 to "
				s += getLabel(copyItems[i].log_field);
				s += ', ';
			}
			
			s = s.replace(/,\s$/, '');
			return s;
		}
		
		var actionPrefix = !isAlternativeAction ? langVar('lang_admin.log_filters.then') : langVar('lang_admin.log_filters.else');
		
		var subLabel = '';
		
		switch (item.type) {
			
			case 'accept':
			
				subLabel = langVar('lang_admin.log_filters.accept_log_entry');
				break;
				
			case 'concatenate':
			
				// I.e.: Concatenate [ "ABC" + "DEF" + Country + City ] and write result to Errors
				// subLabel = 'Concatenate [' +getConcatenateString(item.concatenate) + '] and write result to ' + getLabel(item.log_field); 
				subLabel = langVar('lang_admin.log_filters.concatenate_and_write_info');
				subLabel = subLabel.replace(/__PARAM__1/, '[' +getConcatenateString(item.concatenate) + ']');
				subLabel = subLabel.replace(/__PARAM__2/, getLabel(item.log_field));
				break;
				
			case 'convert_to_lowercase':
			
				// subLabel = 'Convert ' + getLabel(item.log_field) + ' to lowercase';
				subLabel = langVar('lang_admin.log_filters.convert_to_lowercase_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				break;
				
			case 'convert_to_uppercase':
			
				// subLabel = 'Convert ' + getLabel(item.log_field) + ' to uppercase';
				subLabel = langVar('lang_admin.log_filters.convert_to_uppercase_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				break;
				
			case 'copy':
			
				// subLabel = 'Copy ' + getLabel(item.log_field) + ' to ' + getLabel(item.target_log_field);
				subLabel = langVar('lang_admin.log_filters.copy_to_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, getLabel(item.target_log_field));
				break;
				
			case 'match_regexp_copy':
			
				// I.e.: Match in Country the regular expression "[(abc)]" and copy $1 to City
				// subLabel = 'Match in ' + getLabel(item.log_field) + ' the regular expression "' + item.literal + '" and copy ';
				subLabel = langVar('lang_admin.log_filters.match_regexp_and_copy_to_info_1');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, item.literal);
				subLabel+= getMatchRegexpCopyString(item.copy);
				break;
				
			case 'find_and_replace':
			
				// I.e.: Find in Geographic location "Greece" and replace all matches with "GREECE"
				
				if (item.replace_type == 'all') {
					subLabel = langVar('lang_admin.log_filters.find_and_replace_all_matches_info');
				}
				else if (item.replace_type == 'first') {
					subLabel = langVar('lang_admin.log_filters.find_and_replace_first_match_info');
				}
				else {
					subLabel = langVar('lang_admin.log_filters.find_and_replace_last_match_info');
				}
				
				// subLabel = 'Find in ' + getLabel(item.log_field) + ' "' + item.literal + '" ';
				// subLabel += 'and replace all matches with "' + item.literal_2 + '"';
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, item.literal);
				subLabel = subLabel.replace(/__PARAM__3/, item.literal_2);
				break;
			
			case 'reject':
			
				subLabel = langVar('lang_admin.log_filters.reject_log_entry_and_stop_filtering');
				break;
				
			case 'set':
			
				// subLabel = 'Set ' + getLabel(item.log_field) + ' to "' + item.literal + '"';
				subLabel = langVar('lang_admin.log_filters.set_log_field_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, item.literal);
				break;
		}
		
		var label = '<strong>' + actionPrefix + '</strong>: ' + subLabel;
		
		return label;
	},
	
	actionLabelBuilder: function(item) {
		// Invoced from listcontrollerB
		return logFilterAction.labelBuilder(item, false);
	},
	
	alternativeActionLabelBuilder: function(item) {
		// Invoced from listcontrollerB
		return logFilterAction.labelBuilder(item, true);
	}
};


