//
// reportElementMF.js (Report Element Manage Fields)
//

var reportElementMF = {
	
	panel: null,
	
	defaultTabId: '', // defaultTabId in CustomizeReportElement panel
	
	reportElementDb: null, // A reference to the active reportElementDb
	
	/*
	allFieldsDb
	The allFieldsDb object contains all permitted fields for the given report element type,
	it also contains the column state of the active fields (show_column, etc.) and the state
	if the field is active.
	/*
	allFieldsDb = [
		{
		id: i0,
		name: page,
		showColumn: true,
		isActiveField: false --> defines if the field is part of report element columns or not.
		),
		{
		id: i26,
		name: hits
		showColumn: true,
		showPercentColumn: false,
		showBarColumn: false
		isActiveField: true
		},
		...
	*/
	allFieldsDb: [],
	
	/*
	activeFieldsDb
	The activeFields object contains all active field Ids in order. It does not contain any other property.
	activeFields = ['i0', 'i15', 'i18', 'i19', 'i21'];
	*/
	activeFieldsDb: [],
	
	// allFieldsSelectedItemId: '',
	// activeFieldsSelectedItemId: '',
	
	mainReportFieldName: '',
	
	// activeListType defines which of the two lists are active. It is used to handle the Add/Remove button event and label
	activeListType: '', // all_fields | active_fields
	
	init: function() {
		
		//
		// Init the Editor panel
		//
		
		var panelObj = {
			panelId: 'remf:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.report_editor.manage_fields'),
			left: 360,
			top: 145,
			zIndex: 40,
			isCover: true,
			isSticky: true,
			closeEvent: reportElementMF.closePanel
		};
		
		reportElementMF.panel = new util.Panel3(panelObj);
		
		//
		// Add events
		//
		
		yEvent.addListener('remf:all_fields_list', 'click', reportElementMF.allFields.selectActor);
		yEvent.addListener('remf:active_fields_list', 'click', reportElementMF.activeFields.selectActor);
		
		yEvent.addListener('remf:add_remove_btn', 'click', reportElementMF.addRemoveItem);
		
		yEvent.addListener('remf:move_up_btn', 'click', reportElementMF.activeFields.moveItem);
		yEvent.addListener('remf:move_down_btn', 'click', reportElementMF.activeFields.moveItem);
	
		yEvent.addListener('remf:okay_btn', 'click', reportElementMF.saveFields);
		yEvent.addListener('remf:cancel_btn', 'click', reportElementMF.closePanel);
	},
	
	openPanel: function(defaultTabId) {
		
		// defaultTabId is required for Customize Report Element panel upon save.
		reportElementMF.defaultTabId = defaultTabId;
		
		// Reset objects and buttons
		reportElementMF.allFieldsDb = [];
		reportElementMF.activeFieldsDb = [];
		reportElementMF.reportElementDb = {};
		reportElementMF.activeListType = '';
		reportElementMF.allFields.selectedItemId = '';
		reportElementMF.activeFields.selectedItemIndex = -1; // Default is -1!
		util.disableE(['remf:add_remove_btn', 'remf:move_up_btn', 'remf:move_down_btn']);
		
		
		// Get a referenece to the active reportElementDb type and columns
		var metaType = reportElement.activeMetaType;
		var metaTypeLabel = reports.reportElementMetaTypesDb[h(metaType)].label;
		var reportElementType = reportElement.activeReportElementType;
		var reportElementDb = reportElement.activeReportElementDbs[reportElementType];
		
		// alert('metaTypeLabel: ' + metaTypeLabel);
		
		// var activeColumns = reportElementDb.columns;
		// util.showObject(activeColumns);
		
		reportElementMF.reportElementDb = reportElementDb;
		
		// Set main label
		var mainLabel = langVar('lang_admin.report_editor.report_element_type') + ': <strong>' + metaTypeLabel + '</strong>';
		var mainLabelElement = util.getE('remf:main_label');
		mainLabelElement.innerHTML = mainLabel;
		
		// Create allFields and activeFields object
		reportElementMF.createAllFieldsObject(reportElementType, reportElementDb.columns);
		reportElementMF.createActiveFieldsObject(reportElementDb.columns);
		
		// Build initial allFields and activeFields list
		reportElementMF.buildAllFieldsList();
		reportElementMF.buildActiveFieldsList();
		
		reportElementMF.panel.open();
	},
	
	closePanel: function() {
		
		reportElementMF.panel.close();
	},
	
	saveFields: function() {
		
		var allFieldsDb = reportElementMF.allFieldsDb;
		var activeFieldsDb = reportElementMF.activeFieldsDb;
		var numberTextColumns = 0;
		var columns = [];
		
		for (var i = 0; i < activeFieldsDb.length; i++) {
			
			var itemId = activeFieldsDb[i];
			var item = allFieldsDb[h(itemId)];
			
			var columnItem = {};
			columnItem.report_field = item.name;
			columnItem.show_column = item.showColumn;
			
			if(item.isAggregatingField) {
				
				columnItem.show_percent_column = item.showPercentColumn;
				columnItem.show_bar_column = item.showBarColumn;
			}
			else {
				numberTextColumns++;
			}
			
			columns[i] = columnItem;
		}
		
		if (numberTextColumns > 0) {
			
			var reportElementDb = reportElementMF.reportElementDb;
			reportElementDb.columns = columns;
			
			// Re-init the reportElementDb
			var obj = {};
			obj.defaultTabId = reportElementMF.defaultTabId;
			creControl.init(reportElementDb, obj);
			
			reportElementMF.closePanel();
		}
		else {
			
			alert(langVar('lang_admin.report_editor.no_text_field_defined_msg'));
		}
	},
	
	addRemoveItem: function() {
		
		if (reportElementMF.activeListType == 'all_fields') {
			// All fields
			reportElementMF.allFields.addItem();
		}
		else {
			// Active fields
			reportElementMF.activeFields.removeItem();
		}
	},
	

	//
	//
	//
	// allFields list handler
	//
	//
	//
	
	allFields: {
		
		selectedItemId: '',
		
		selectActor: function(evt) {
			
			// Invoked upon list click
			var element = evt.target || evt.srcElement;
	
			if (element.nodeName == 'LI') {
				
				var elementId = element.id;
				var dat = elementId.split(':');
				var itemId = dat[2];
				
				// alert('itemId: ' + itemId);
				reportElementMF.allFields.selectByItemId(itemId, element);
			}
		},
		
		selectByItemId: function(itemId, element) {
			
			// 'element' is optional, respectively it is only given when invoked via selectActor()
			// itemId may be empty, this is the case if no more item exists to select.
			
			function deselectSelectedItem(previousSelectedItemId) {
				var previousSelectedItemElement = util.getE('remf:all_fields_list:' + previousSelectedItemId);
				previousSelectedItemElement.className = '';
			}
			
			// Make allFields the active list if it isn't already
			if (reportElementMF.activeListType != 'all_fields') {
				
				// Set button label
				util.updateT('remf:add_remove_btn', langVar('lang_stats.btn.add') + ' >');
				
				// Deselect any activeFields list item
				reportElementMF.activeFields.deselectSilent();
				
				// Disable activeFields move buttons
				util.disableE(['remf:move_up_btn','remf:move_down_btn']);
							
				// Set list type
				reportElementMF.activeListType = 'all_fields';
			}
			
			var makeItemSelected;
			var previousSelectedItemId = reportElementMF.allFields.selectedItemId;
			
			// alert('previousSelectedItemId: ' + previousSelectedItemId);
			
			if (itemId != '') {

				if (!element) {
					var element = util.getE('remf:all_fields_list:' + itemId);
				}
				
				if (previousSelectedItemId != '') {
					
					if (previousSelectedItemId == itemId) {
						// Deselect the item
						makeItemSelected = false;
					}
					else {
						
						// A different item is already selected, deselect it
						deselectSelectedItem(previousSelectedItemId);
						makeItemSelected = true;
					}
				}
				else {
					makeItemSelected = true;
				}
				
				// alert('makeItemSelected: ' + makeItemSelected);
				element.className = makeItemSelected ? 'selected' : '';
			}
			else {
				// No new item is to select but we deselect any existing item
				makeItemSelected = false;
				if (previousSelectedItemId != '') {
					deselectSelectedItem(previousSelectedItemId);
				}
			}
			
			reportElementMF.allFields.selectedItemId = makeItemSelected ? itemId : '';
			util.enableE('remf:add_remove_btn', makeItemSelected);
		},
		
		deselectSilent: function() {
			
			// deselectSilent is called by activeFields only! It deselects any selected list item
			// without making allFields the active list.
			
			var previousSelectedItemId = reportElementMF.allFields.selectedItemId;
			
			if (previousSelectedItemId != '') {
				var previousSelectedItemElement = util.getE('remf:all_fields_list:' + previousSelectedItemId);
				previousSelectedItemElement.className = '';
				reportElementMF.allFields.selectedItemId = '';
			}
		},
		
		addItem: function() {
				
			// Adds the selected item to activeFields
			var allFieldsDb = reportElementMF.allFieldsDb;
			var selectedItemId = reportElementMF.allFields.selectedItemId;
			var selectedItem = allFieldsDb[h(selectedItemId)];
			
			// Select the next item if one exists, or the previous item if one exists,
			// or no item if this was the last in-active item
			// Create an array with all inactive items, including the selected item to
			// check which is the next selected item.
			
			var inactiveItemIds = [];
			var selectedItemIndex = 0;
			var nextSelectedItemId = '';
			
			for (var i = 0; i < allFieldsDb.length; i++) {
				
				var item = allFieldsDb[i];
				if (!item.isActiveField) {
					var j = inactiveItemIds.length;
					inactiveItemIds[j] = item.id;
					
					if (item.id == selectedItemId) {
						selectedItemIndex = j;
					}
				}
			}
			
			var numInactiveItems = inactiveItemIds.length;
			
			if (numInactiveItems > 1) {
				
				var nextSelectedItemIndex = (selectedItemIndex < numInactiveItems - 1) ? selectedItemIndex + 1 : selectedItemIndex - 1;
				nextSelectedItemId = inactiveItemIds[nextSelectedItemIndex];
			}
			
			//
			// Modify current selectedItem
			//
			
			selectedItem.isActiveField = true;
			
			// Hide the item in allFields list
			util.hideE('remf:all_fields_list:' + selectedItemId);
			
			// Select the next item'
			reportElementMF.allFields.selectByItemId(nextSelectedItemId);
			
			// Add the item to activeFields list
			reportElementMF.activeFields.addItem(selectedItem);
		}
	},
	
	//
	//
	//
	// activeFields list handler
	//
	//
	//
	
	activeFields: {
		
		selectedItemIndex: -1, // -1 is set if no item is selected!
		
		selectActor: function(evt) {
			
			// Invoked upon list click
			var element = evt.target || evt.srcElement;
	
			if (element.nodeName == 'LI') {
				
				var elementId = element.id;
				var dat = elementId.split(':');
				var itemIndex = parseInt(dat[2], 10);
				
				// alert('itemId: ' + itemId);
				reportElementMF.activeFields.selectByItemIndex(itemIndex, element);
			}
		},
		
		selectByItemIndex: function(itemIndex, element) {
						
			// 'element' is optional, respectively it is only given when invoked via selectActor()
			
			function deselectSelectedItem(previousSelectedItemIndex) {
				var previousSelectedItemElement = util.getE('remf:active_fields_list:' + previousSelectedItemIndex);
				previousSelectedItemElement.className = '';
			}
			
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			var makeItemSelected;
			var previousSelectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			
			// Make activeFields the active list if it isn't already
			if (reportElementMF.activeListType != 'active_fields') {
				
				// Set button label
				util.updateT('remf:add_remove_btn', '< ' + langVar('lang_stats.btn.remove'));
				
				// Deselect any allFields list item
				reportElementMF.allFields.deselectSilent();
				
				// Set list type
				reportElementMF.activeListType = 'active_fields';
			}
			
			if (itemIndex != -1) {

				if (!element) {
					var element = util.getE('remf:active_fields_list:' + itemIndex);
				}
				
				if (previousSelectedItemIndex != -1) {
				
					if (previousSelectedItemIndex == itemIndex) {
						// Deselect the item
						makeItemSelected = false;
					}
					else {
						
						// A different item is already selected, deselect it
						deselectSelectedItem(previousSelectedItemIndex);
						makeItemSelected = true;
					}
				}
				else {
					makeItemSelected = true;
				}
				
				// alert('makeItemSelected: ' + makeItemSelected);
				element.className = makeItemSelected ? 'selected' : '';
			}
			else {
				// No new item is to select but we deselect any existing item
				makeItemSelected = false;
				if (previousSelectedItemIndex != -1) {
					deselectSelectedItem(previousSelectedItemIndex);
				}
			}
			
			reportElementMF.activeFields.selectedItemIndex = makeItemSelected ? itemIndex : -1;
			
			// Handle Remove and Move buttons
			reportElementMF.activeFields.setButtonState(makeItemSelected);
		},
		
		setButtonState: function(isSelectedItem) {
			
			// setButtonState() is called within selectByItemIndex,
			// it handles Remove and Move buttons state
			
			var isRemove = false;
			var isMoveUp = false;
			var isMoveDown = false;
			
			// We don't allow remove or move for the first field for session reports only,
			// for type "table" we don't allow to remove the main report field, though we allow to move it.
			// For log_detail anything can be moved/removed.
			
			if (isSelectedItem) {
				
				var reportElementType = reportElement.activeReportElementType;
				var isLogDetail = (reportElementType == 'log_detail');
				var isTable = (reportElementType == 'table');
				var selectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
				
				var activeFieldsDb = reportElementMF.activeFieldsDb;
				var numberOfItems = activeFieldsDb.length;
				
				// util.showObject(activeFieldsDb);
			
				//
				// Handle isRemove
				//
				
				if (reportElementType == 'table') {
					
					// We need to check if this is the main report field or not
					var allFieldsDb = reportElementMF.allFieldsDb;
					var selectedItemId = activeFieldsDb[selectedItemIndex];
					var selectedItem = allFieldsDb[h(selectedItemId)];
					var reportElementDb = reportElementMF.reportElementDb;
					
					// util.showObject(selectedItem);
					
					isRemove = (selectedItem.name != reportElementDb.report_field);
				}
				else if (reportElementType == 'log_detail') {
					
					isRemove = true;
				}
				else {
					
					// Session report elements
					isRemove = (selectedItemIndex > 0);
				}
	
	
				//
				// Handle isMoveUp, isMoveDown
				//
				
				isMoveUp = (selectedItemIndex > 1) || ((isTable || isLogDetail) && selectedItemIndex > 0);
				
				if (selectedItemIndex < (numberOfItems - 1)) {
					
					isMoveDown = (selectedItemIndex > 0) || isTable || isLogDetail;
				}
			}
			
			util.enableE('remf:add_remove_btn', isRemove);
			util.enableE('remf:move_up_btn', isMoveUp);
			util.enableE('remf:move_down_btn', isMoveDown);
		},
		
		deselectSilent: function() {
			
			// deselectSilent is called by allFields only! It deselects any selected list item
			// without making activeFields the active list.
			
			var previousSelectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			
			if (previousSelectedItemIndex != -1) {
				var previousSelectedItemElement = util.getE('remf:active_fields_list:' + previousSelectedItemIndex);
				previousSelectedItemElement.className = '';
				reportElementMF.activeFields.selectedItemIndex = -1;
			}
		},
		
		addItem: function(newAllFieldsItem) {
			
			// Invoked from allFields.addItem(). This adds the given item
			// to the activeFields list.
			
			// util.showObject(newAllFieldsItem, 'activeFields.addItem() - newAllFieldsItem argument');
			
			var newItemId = newAllFieldsItem.id;
			
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			
			// util.showObject(activeFieldsDb, 'activeFields.addItem() - activeFieldsDb');
			
			var insertAtItemIndex = -1;
			
			if (newAllFieldsItem.isAggregatingField) {
				// Insert item as last item in activeFieldsDb
				insertAtItemIndex = activeFieldsDb.length;
			}
			else {
				
				// This is a non-aggregating field. Insert the item 
				// after the last active non-aggregating field
				var allFieldsDb = reportElementMF.allFieldsDb;
				var activeFieldsDbHasAggregatingField = false;

				for (var i = 0; i < activeFieldsDb.length; i++) {
					
					var itemId = activeFieldsDb[i];
					var allFieldsItem = allFieldsDb[h(itemId)];
					
					// alert('allFieldsItem: ' + allFieldsItem);
					// util.showObject(allFieldsItem);
					
					if (allFieldsItem.isAggregatingField) {
						
						// This is the first aggreagting field,
						// we insert the new non-aggregating field at this point.
						
						insertAtItemIndex = i;
						activeFieldsDbHasAggregatingField = true;
						// alert('insertAtItemIndex: ' + insertAtItemIndex);
						break;
					}
				}
				
				if (!activeFieldsDbHasAggregatingField) {
					
					// The activeFieldsDb has no aggregating field yet, so we add the current field as last field
					insertAtItemIndex = activeFieldsDb.length;
				}
			}
			
			// Insert the item			
			activeFieldsDb.splice(insertAtItemIndex, 0, newItemId);
			
			// Rebuild the active fields list
			reportElementMF.buildActiveFieldsList();
		},
		
		removeItem: function() {
			
			// Invoked by remove button, removes the selected item in activeFields list.
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			var allFieldsDb = reportElementMF.allFieldsDb;
			
			var selectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			var selectedItemId = activeFieldsDb[selectedItemIndex];
			
			//var s = 'selectedItemIndex: ' + selectedItemIndex;
			//s += '\nselectedItemId: ' + selectedItemId;
			//alert(s);
			
			
			var nextSelectedItemIndex = -1;
			
			var numberOfItems = activeFieldsDb.length;
			
			// Check which item becomes selected next
			if (numberOfItems > 1) {
				nextSelectedItemIndex = (selectedItemIndex < numberOfItems - 1) ? selectedItemIndex : selectedItemIndex - 1;
			}
			
			// Remove selected li element
			var ul = util.getE('remf:active_fields_list');
			var li = util.getE('remf:active_fields_list:' + selectedItemIndex);
			ul.removeChild(li);
			// We must update the li element Ids so that they match
			// the index number of the activeFieldsDb items!
			var liElementItems = ul.getElementsByTagName('li');
			for (var i = 0; i < liElementItems.length; i++) {
				li = liElementItems[i];
				li.id = 'remf:active_fields_list:' + i;
			}
			
			// Remove selected item from activeFieldsDb
			activeFieldsDb.splice(selectedItemIndex, 1);
			
			// As the item has been removed there is no more selected item,
			// so reset selectedItemIndex!
			reportElementMF.activeFields.selectedItemIndex = -1;
			
			// Re-enable the removed element in allFields list
			util.showE('remf:all_fields_list:' + selectedItemId);
			// Update the allFieldsItem state
			var allFieldsItem = allFieldsDb[h(selectedItemId)];
			allFieldsItem.isActiveField = false;
						
			// Select the next item
			reportElementMF.activeFields.selectByItemIndex(nextSelectedItemIndex);
		},
		
		moveItem: function() {
			
			var isMoveUp = (this.id == 'remf:move_up_btn');
			
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			
			var selectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			var selectedItemId = activeFieldsDb[selectedItemIndex];
			var selectedLiElement = util.getE('remf:active_fields_list:' + selectedItemIndex);
			var selectedTextElement = selectedLiElement.firstChild;
			var selectedLabel = selectedTextElement.nodeValue;
			
			// Get the itemIndex of the element which will be replaced with the selected element
			var nextItemIndex = isMoveUp ? selectedItemIndex - 1 : selectedItemIndex + 1;
			var nextLiElement = util.getE('remf:active_fields_list:' + nextItemIndex);
			var nextTextElement = nextLiElement.firstChild;
			var nextLabel = nextTextElement.nodeValue;
			
			// Update item position in activeFieldsDb
			activeFieldsDb.splice(selectedItemIndex, 1); // Removes selected itemId
			activeFieldsDb.splice(nextItemIndex, 0, selectedItemId); // Re-inserts selected itemId at new position
			
			// Replace the list labels
			var newSelectedTextElement = util.createT(nextLabel);
			var newNextTextElement = util.createT(selectedLabel);
			selectedLiElement.replaceChild(newSelectedTextElement, selectedTextElement);
			nextLiElement.replaceChild(newNextTextElement, nextTextElement);
			
			// Select the next item
			reportElementMF.activeFields.selectByItemIndex(nextItemIndex);
		}
	},
	
	//
	//
	// Utilities
	//
	//
	
	createAllFieldsObject: function(reportElementType, columns) {
		
		function addQueryFieldToAllFieldsDb(queryField) {
			
			var allFieldsDbLen = allFieldsDb.length;
			var isAggregatingField = queryField.isAggregatingField;
			
			// We add most of the query field properties to allFieldsDb for convenience
			
			var obj = {};
			obj.id = 'i' + allFieldsDbLen; // id is used for HTML element IDs
			obj.name = queryField.name;
			obj.label = queryField.label;
			obj.isAggregatingField = isAggregatingField;
			obj.category = queryField.category;
			obj.derivationMethod = queryField.derivationMethod;
			
			obj.isActiveField = false;
			
			//
			// Add field column properties because they will be used
			// as default values and will keep the values of already
			// existing column fields.
			//
			
			obj.showColumn = true;
			
			if (isAggregatingField) {
				obj.showPercentColumn = false;
				obj.showBarColumn = false;
			}
			
			allFieldsDb[allFieldsDbLen] = obj;
		}
		
		var queryFields = reports.queryFieldsDb;
		
		var reportElementType = reportElement.activeReportElementType;
		var isLogDetail = (reportElementType == 'log_detail');
		
		var allFieldsDb = [];
		
		// KHP 04/Oct/2010 - Create a tempColumns object,
		// it is used to verfy if all columns exist in allFieldsDb.
		// If a column is missing for whatever reason in allFieldsDb 
		// then we must add it.
		var tempColumns = util.cloneObject(columns);
		util.createHash(tempColumns, 'report_field');
		
		var i;
		var column;
		var queryField;
		var queryFieldsLen = queryFields.length;
		
		for (i = 0; i < queryFieldsLen; i++) {
			
			queryField = queryFields[i];
			
			// util.showObject(queryField);

			if (!isLogDetail || queryField.reportElementTypeSupport.log_detail) {
				
				addQueryFieldToAllFieldsDb(queryField);
			
				// Mark the added field in tempColumns
				var column = tempColumns[h(queryField.name)];
				if (column != null) {
					column.columnExistsInAllFieldsDb = true;
				}
			}
		}
		
		// util.showObject(tempColumns, 'tempColumns');
		
		// Check if we need to add any column which exists in columns
		// but not in allFieldsDb
		var tempColumnsLen = tempColumns.length;
		for (i = 0; i < tempColumnsLen; i++) {
			
			column =  tempColumns[i];
			
			if (column.columnExistsInAllFieldsDb == null) {
				
				// Add this report field to allFieldsDb
				var reportFieldName = column.report_field;
				queryField = queryFields[h(reportFieldName)];
				addQueryFieldToAllFieldsDb(queryField);
			}
		}
		
		// Set allFieldsDb
		reportElementMF.allFieldsDb = allFieldsDb;
		
		// Create hash
		util.createHash(reportElementMF.allFieldsDb, 'id');
	},
	
	createActiveFieldsObject: function(columns) {
		
		// We create a tempColumns object because we require createHash on which we don't want to use on reportElementDb.
		var tempColumns = util.cloneObject(columns);
		util.createHash(tempColumns, 'report_field');
		// util.showObject(tempColumns);
		
		var i;
		
		//
		// Update allFields according activeFields state
		//
		
		var allFieldsDb = reportElementMF.allFieldsDb;
		
		for (i = 0; i < allFieldsDb.length; i++) {
			
			var allFieldsItem = allFieldsDb[i];
			var reportFieldName = allFieldsItem.name;
		
			// If the reportFieldName already exists in activeFields (equal tempColumns)
			// then update the allFieldsItem
		
			var column = tempColumns[h(reportFieldName)];
			
			if (column) {
				
				var itemId = allFieldsItem.id;
				
				// Add the itemId to the column in tempColumns because we need it for
				// the final activeFieldsDb
				column.id = itemId;
				
				allFieldsItem.isActiveField = true;
				allFieldsItem.showColumn = column.show_column;
				
				if (allFieldsItem.isAggregatingField) {
					allFieldsItem.showPercentColumn = column.show_percent_column;
					allFieldsItem.showBarColumn = column.show_bar_column;
				}
			}
		}
		
		//
		// Create the activeFieldsDb
		//
		
		var activeFieldsDb = [];
		
		for (i = 0; i < tempColumns.length; i++) {
			
			// util.showObject(tempColumns[i]);
			activeFieldsDb[i] = tempColumns[i].id;	
		}
				
		// Set activeFields
		reportElementMF.activeFieldsDb = activeFieldsDb;
	},
	
	buildAllFieldsList: function() {
		
		var allFieldsDb = reportElementMF.allFieldsDb;
		
		var ul = util.getE('remf:all_fields_list');
		util.removeChildElements(ul);
		
		for (var i = 0; i < allFieldsDb.length; i++) {
			
			var allFieldsItem = allFieldsDb[i];
			
			// Hide the list item if the field is already active
			var displayStyle = allFieldsItem.isActiveField ? 'none' : 'list-item';
				
			var elementId = 'remf:all_fields_list:' + allFieldsItem.id;
			var li = util.createE('li', {id:elementId, display:displayStyle});
			var label = util.createT(allFieldsItem.label);
			util.chainE(ul, li, label);
		}
	},
	
	buildActiveFieldsList: function() {
				
		var activeFieldsDb = reportElementMF.activeFieldsDb;		
		
		var allFieldsDb = reportElementMF.allFieldsDb;
		
		// util.showObject(allFieldsDb);
		
		var ul = util.getE('remf:active_fields_list');
		util.removeChildElements(ul);
		
		for (var i = 0; i < activeFieldsDb.length; i++) {
			
			var itemId = activeFieldsDb[i];
						
			var item = allFieldsDb[h(itemId)];
						
			// In activeFields we use the index of activeFieldsDb for the ID!
			var elementId = 'remf:active_fields_list:' + i;
			var li = util.createE('li', {id:elementId});
			var label = util.createT(item.label);
			util.chainE(ul, li, label);
		}
	}
};
