//
// fileManager.js
//

var fileManager = {
	
	
	// pathnameElementId specifies the input field
	// from where the file manager has been opened.
	// The id is required to read and set the field value
	
	// The following two variables are defined in the template
	// UPDATE - HAS BEEN MOVED TO pageInfo
	// pathnameElementId: '', // The element of the pathname field from which the file manager has been initiated.
	// defaultPathname: '', // Any default pathname given in the input element defined by pathnameElementId.
	
	/*
	
	item object (drive, directory or file)
	
		{
			id: i:0,			// The integer in the id defines the depth and index in the hierarchical directory structure array
			
			type: 'directory' 	// drive | directory | file
			label: '_dat',
			pathname: 'C:\_dat',
			
			// Properties if type is drive or directory
			
			isLoaded: false, 	// isLoaded defines if any subitems (located in items array of this object) have 
								// already been loaded.
								// isLoaded is also true if isEmpty is true
								
			items: [], 			// items with other items. An empty array means that the directory is empty
			
			hasSubDir: false,	// hasSubDir is true if this item has any subdirectories
			isEmpty: false,		// isEmpty is true if the drive or directory has no content
		
			isExpanded: false 	// if item is expanded, the property is added when building the tree
			
			// Properties if type is file
			
			size: 330 K, 		// size as string, only available if type is file
		
		}
	*/
	
	rootItemId: 'directory_tree:root', // Note, the root list element id is "tree:li:directory_tree:root"
	
	defaultPathname: '', // The defaultPathname from pageInfo or from mapDrive
	isMapDriveCallee: false,
	
	isInvalidDefaultPathname: false, 	// isInvalidDefaultPathname is set upon getDefinedDirectoryResponse().
										// When we then load the root directories we know that we have to
										// show an alert for the invalid default pathname.
										
	bottomDirectoryItemId: '', // bottomDirectoryItemId is used upon defined pathnames for final directory selection
	
	items: [],  // Hierarchical directory structure
				// [{}, {}, {}, ...]
				
	selectedTreeItemId: '', // i.e. 'i:1:5', selected item in left pane
	selectedListItemId: '', // i.e. 'i:1:5', selected item in right pane
	
	isActorPermission: false, // Set to false while we load items
	
	isLoading: false, // Set to true while loading directories
	
	init: function() {
		
		// alert('init');
		
		// util.showObject(pageInfo);
		
		// Set the panels size
		fileManager.setSize();
		
		yEvent.addListener('file_manager:ok_btn', 'click', fileManager.setPathnameInOpener);
		yEvent.addListener('file_manager:cancel_btn', 'click', fileManager.close);
		
		if (pageInfo.isWin32Platform) {
			
			yEvent.addListener('file_manager:map_drive_btn', 'click', mapDrive.open);
			util.showEV('file_manager:map_drive_btn');
		}
		
		yEvent.addListener(window, 'resize', fileManager.setSize);

		
		// yEvent.addListener('directory_tree:container', 'click', fileManager.directoryTreeActor);
		yEvent.addListener('tree:li:directory_tree:root', 'click', fileManager.directoryTreeActor);
		yEvent.addListener('directory_list:table', 'click', fileManager.listActor);
		
		if (pageInfo.defaultPathname == '') {
			
			fileManager.getRootDirectories();
		}
		else {
			var isMapDriveCallee = false;
			fileManager.getDefinedDirectory(pageInfo.defaultPathname, isMapDriveCallee);
		}
		
		// fileManager.getDirectoryContents(pageInfo.defaultPathname);
	},
	
	setPathnameInOpener: function() {
		
		var itemId = (fileManager.selectedListItemId != '') ? fileManager.selectedListItemId : fileManager.selectedTreeItemId;
		
		if (itemId != '') {
			
			var item = fileManager.itemGetter(itemId);
			var pathname = item.pathname;
			var pathnameElementId = pageInfo.pathnameElementId;
			
			opener.util.fileManagerWindow.setPathnameValue(pathnameElementId, pathname);
			window.close();
		}
		else {
			alert(langVar('lang_admin.file_manager.no_directory_or_file_selected_message'));
		}
	},
	
	close: function() {
		
		window.close();
	},
	
	setIsLoading: function(isLoading) {
		
		fileManager.isLoading = isLoading;
		
		var headerText = isLoading ? langVar('lang_admin.file_manager.loading_info') : langVar('lang_admin.file_manager.select_directory_or_file_info');
		util.updateT('file_manager:header_label', headerText);
		
		util.disableE('file_manager:ok_btn', isLoading);
		
		if (pageInfo.isWin32Platform) {
			
			util.disableE('file_manager:map_drive_btn', isLoading);
		}
	},
	
	
	getRootDirectories: function() {
		
		fileManager.setIsLoading(true);
		
		var url = '?dp+templates.file_manager.get_root_directories';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		
		util.serverPost(url, dat);
	},
	
	getRootDirectoriesResponse: function(dat) {
		
		// alert('getRootDirectoriesResponse: ' + dat);
		
		fileManager.items = dat;
		fileManager.buildTree(fileManager.rootItemId, fileManager.items);
		
		// Show root tree and and set isLoading
		util.showE('tree:ul:' + fileManager.rootItemId);
		
		if (fileManager.isInvalidDefaultPathname) {
			
			// A getDefinedDirectory() call occured before getting the root directories
			// with an invalid default pathname. Show an alert.
			var msg = langVar('lang_admin.file_manager.invalid_path_message');
			msg = msg.replace(/__PARAM__1/, fileManager.defaultPathname);
			alert(msg);
		}
	
		fileManager.setIsLoading(false);
	},
	
	getDefinedDirectory: function(defaultPathname, isMapDriveCallee) {
		
		// Note, this function is also called from mapDrive.js!
		// So we may need to cleanup any existing items in the response function!
		
		// alert('getDefinedDirectory()');
		
		fileManager.defaultPathname = defaultPathname;
		fileManager.isMapDriveCallee = isMapDriveCallee;
		
		fileManager.setIsLoading(true);
		
		var url = '?dp+templates.file_manager.get_defined_directory';
		
		// var pathname = (!isCalledFromMapDrive) ? pageInfo.defaultPathname : mapDrive.defaultPathname;
		pathname = defaultPathname.replace(/\\/g, '__HexEsc__5C');
		
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.pathname=' + encodeURIComponent(pathname);
		
		util.serverPost(url, dat);
	},
	
	getDefinedDirectoryResponse: function(dat) {
		
		// util.showObject(dat);
		
		if (dat.isValidPathname) {
			
			// alert('getDefinedDirectoryResponse() - with valid pathname');
			
			// Clean directory tree and list from any existing items.
			// (Items could exist if getDefinedDirectory() has been
			// initiated by mapDrive.js!
			
			if (fileManager.isMapDriveCallee) {
				util.removeChildElements('tree:li:directory_tree:root');
				util.removeChildElements('directory_list:table');
			}
		
			//
			// Set the root items
			//
		
			fileManager.items = dat.rootItems;
			
			// util.showObject(fileManager.items);
			
			fileManager.buildTree(fileManager.rootItemId, fileManager.items);
			
			//
			// Handle the defined tree items
			//
			
			if (dat.treeStructure.length > 0) {
			
				var treeStructureItemIndex = 0;
				fileManager.createTreeFromDefinedPathname(fileManager.items, dat.treeStructure, treeStructureItemIndex);
				
				// Select bottom directory
				if (fileManager.bottomDirectoryItemId != '') {
					
					// alert('handle bottomDirectoryItemId: ' + fileManager.bottomDirectoryItemId);
					
					// util.showObject({'handle bottomDirectoryItemId':fileManager.bottomDirectoryItemId});
					
					var bottomItem = fileManager.itemGetter(fileManager.bottomDirectoryItemId);
					fileManager.handleActivatedTreeItem(bottomItem, /* isImageActor */ false , /* isAnchorActor */ true);
				}
			}
			
			// Show root tree and isLoading
			util.showE('tree:ul:' + fileManager.rootItemId);
			fileManager.setIsLoading(false);
			
		}
		else {
			
			if (!fileManager.isMapDriveCallee) {
			
				// Invalid default pathname.
				// Get the root directories
				fileManager.isInvalidDefaultPathname = true;
				fileManager.getRootDirectories();
			}
			else {
				
				// Map drive did not succeed!
				// We don't need getRootDirectories() because it should already exist
				var msg = langVar('lang_admin.file_manager.invalid_path_message');
				
				msg = msg.replace(/__PARAM__1/, fileManager.defaultPathname);
				alert(msg);
				fileManager.setIsLoading(false);
			}
		}
	},
	
	getDirectoryItems: function(item, isImageActor, isAnchorActor) {
		
		// isImageActor and isAnchorActor are required for the response,
		// so that we know how the directory item has been activated
		
		//
		// Lock user interactions
		//
		fileManager.setIsLoading(true);
		
		var url = '?dp+templates.file_manager.get_directory_items';
		
		var pathname = item.pathname;
		pathname = pathname.replace(/\\/g, '__HexEsc__5C');
		
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.item_id=' + encodeURIComponent(item.id) + '&';
		dat += 'v.fp.is_image_actor=' + isImageActor + '&';
		dat += 'v.fp.is_anchor_actor=' + isAnchorActor + '&';
		dat += 'v.fp.pathname=' + encodeURIComponent(pathname);
		
		util.serverPost(url, dat);
	},
	
	getDirectoryItemsResponse: function(dat) {
		
		var itemId = dat.itemId;
		var item = fileManager.itemGetter(itemId);
		
		if (dat.isValidPathname) {
			
			var isImageActor = dat.isImageActor;
			var isAnchorActor = dat.isAnchorActor;
			
			var items = dat.items;
			item.isLoaded = true;
			item.items = items;
			
			if (item.hasSubDir) {
				
				// build the items
				fileManager.buildTree(itemId, items);
			}
			
			fileManager.handleActivatedTreeItem(item, isImageActor, isAnchorActor);
		}
		else {
			var msg = langVar('lang_admin.file_manager.pathname_is_not_anymore_valid_msg');
			msg = msg.replace(/__PARAM__1/, item.pathname);
			alert(msg);
		}
		
		//
		// Unlock user interactions
		//
		
		fileManager.setIsLoading(false);
	},
	
	
	//
	//
	// Select functions
	//
	//
	
	directoryTreeActor: function(evt) {
		
		// Initiated upon click on directory tree item
		
		// alert('directoryTreeActor()');
		
		if (!fileManager.isLoading) {
		
			var element = evt.target || evt.srcElement;
			var elementId = element.id;
			
			var isImageActor = (elementId.indexOf(':img:actor:') != -1);
			var isAnchorActor = (elementId.indexOf(':a:actor:') != -1);
			
			if (isImageActor || isAnchorActor) {
				
				// alert('directoryTreeActor() - elementId: ' + elementId);
				
				// Get the item 
				var item = fileManager.itemGetter(elementId);
				
				if (item.isLoaded) {
					fileManager.handleActivatedTreeItem(item, isImageActor, isAnchorActor);
				}
				else {
					// Load the item
					fileManager.getDirectoryItems(item, isImageActor, isAnchorActor);
				}
			}
			else if (elementId == 'a:directory_tree:root') {
				
				// Handle root item
				// alert('Handle root item');
				// We ignore the root item
			}
		}
	},
	
	handleActivatedTreeItem: function(item, isImageActor, isAnchorActor) {
		
		// Invoked from directoryTreeActor when items are already loaded or
		// after items have been loaded by getDirectoryItemsResponse()
		
		// At this point all subitems of the given item are loaded!
		
		// util.showObject(item);
		
		var itemId = item.id;
		var directoryImage;
		// var isExpanded = item.isExpanded;
		// alert('item: ' + item.label);
		
		// We distinguish between
		// a.) Directory with subdirectories (expand and directory icon)
		// b.) Directory with files only (directory icon only)
		
		if (item.hasSubDir) {
			
			// Item with subdirectories, respectively with expand icon
			
			directoryImage = util.getE('tree:img:actor:' + itemId);
			
			if (!item.isExpanded) {
			
				// We expand the current item.
				// If isAnchorActor is true then we also select this item
				
				directoryImage.src = imgDb.fmCollapseDir.src;
				util.showE('tree:ul:' + itemId);
				item.isExpanded = true;
				
				if (isAnchorActor) {
					
					fileManager.selectDirectoryItem(itemId, item.items);
				}
			}
			else {
				
				// The item is already expanded
			
				if (isImageActor) {
					
					//
					// Collapse tree
					//
					
					// Note, we have to check if any subitem is displayed in the list,
					// if yes, then we have to clear the list and show the list for the collapsed item.
					
					directoryImage.src = imgDb.fmExpandDir.src;
					util.hideE('tree:ul:' + itemId);
					item.isExpanded = false;
					
					if (itemId != fileManager.selectedTreeItemId) {
						
						// Check if a child item of the current item is selected.
						// We can do that with the itemId. If the current itemId
						// is i.e. "i:0:1:2" and the already selected itemId starts
						// with the same string, i.e. "i:0:1:2:3" then we know that
						// we have to move the child child selection to the current
						// item.
						
						var selectedTreeItemId = fileManager.selectedTreeItemId;
						
						if (selectedTreeItemId.indexOf(itemId + ':') != -1) {
							
							// Move selection to current item
							fileManager.selectDirectoryItem(itemId, item.items);
						}
					}
				}
				else {
					
					// isAnchorActor
					// Select the item.
					// Don't check for active selection because the item could
					// be semi-selected, so we simply re-select it in case that
					// it is already selected.
					
					fileManager.selectDirectoryItem(itemId, item.items);
				}
			}
		}
		else {
			
			// Item with files only
			// Select or re-select this item, even if it is already selected
			// because the item could be semi-selected.
			
			// alert('Handle item with files only');
			fileManager.selectDirectoryItem(itemId, item.items);
		}
	},
	
	clearAllSelectedItems: function() {
		
		// Clears any selected item and clears the items list in right pane
		
		if (fileManager.selectedTreeItemId != '') {
			
			var anchorElement = util.getE('tree:a:actor:' + fileManager.selectedTreeItemId);
			anchorElement.className = '';
			fileManager.selectedTreeItemId = '';
		}
		
		// Simply reset selectedListItemId because the list is cleared anyway
		fileManager.selectedListItemId = '';
		
		// Remove all items from the list
		util.removeChildElements('directory_list:table');
	},
	
	selectDirectoryItem: function(itemId, items) {
		// Clear all selections
		fileManager.clearAllSelectedItems();
					
		// Select the item
		var anchorElement = util.getE('tree:a:actor:' + itemId);
		anchorElement.className = 'active';
		fileManager.selectedTreeItemId = itemId;
					
		// Build the items list
		fileManager.buildItemsList(items);
	},
	
	deselectListItem: function() {
		
		// deselects any selected item in right pane
		if (fileManager.selectedListItemId != '') {
			var element = util.getE('list:a:actor:' + fileManager.selectedListItemId);
			element.className = '';
		}
	},
	
	listActor: function(evt) {
		
		// Initiated if a list item is clicked
		
		if (!fileManager.isLoading) {
		
			var element = evt.target || evt.srcElement;
			var elementId = element.id;
			
			if (elementId.indexOf('list:a:actor:i:') != -1) {
				
				// Deselect any selected list item
				fileManager.deselectListItem();
				
				var substringIndex = elementId.lastIndexOf('i:');
				var itemId = elementId.substring(substringIndex);
				
				// alert('listActor() - itemId: ' + itemId);
				
				fileManager.selectedListItemId = itemId;
				element.className = 'active';
				
				// Make the selected directory item semi-selected
				var activeTreeElement = util.getE('tree:a:actor:' + fileManager.selectedTreeItemId);
				activeTreeElement.className = 'semi-active';
				
				// Note that selectedTreeItemId and selectedListItemId have now a value.
				// Upon Okay we first check for a selectedListItemId and use that one to get
				// the pathname, else we use the selectedTreeItemId for the pathname.
			}
		}
	},
	
	itemGetter: function(itemElementIdOrItemId) {
		
		// Get a reference to the array item of itemElementId
		
		// itemElementId is in the format: 	"tree:img:actor:i:0:1:3"
		// itemId is in the format:			"i:0:1:3"
		// What is of our interest are the integer numbers after "i:"
		
		// Get a string with the numbers only
		var substringIndex = itemElementIdOrItemId.lastIndexOf('i:');
		var cleanedUpString = itemElementIdOrItemId.substring(substringIndex + 2);
		
		// alert('cleanedUpString: ' + cleanedUpString);
		
		var dat = cleanedUpString.split(':');
		
		// alert('dat: ' + dat);
		
		var item = fileManager.items[parseInt(dat[0], 10)]; // item in root tree
		
		// Loop down to the item if item is not in root tree
		for (var i = 1; i < dat.length; i++) {
			
			var itemIndex = parseInt(dat[i], 10);
			item = item.items[itemIndex];
		}
		
		// util.showObject(item);
		
		return item;
	},
	
	//
	//
	// Create tree from defined pathname functions
	//
	//
	
	fixPathnameOfTypeDrive: function(pathname) {
		
		// Returns a clean drivename on Windows systems.
		// This problem is supposed to exist only in Windows and it is only a problem for pre-defined pathnames!
		// There are differences of how we get the drive between C++  get_directory_contents() and get_file_info(),
		// once we get it with a trailing backslash and once not.
		// I.e. we may get "c:" and "C:\"
		
		if (pageInfo.isWin32Platform) {
			
			pathname = pathname.toUpperCase();
			var lastChar = pathname.substring(pathname.length - 1);
			if (lastChar != '\\') {
				pathname += '\\';
			}
		}
		
		return pathname;
	},
	
	createTreeFromDefinedPathnameFixIds: function(parentItemId, items) {
		
		for (var i = 0; i < items.length; i++) {
			
			var item = items[i];
			item.id = parentItemId + ':' + i;
		}
	},
	
	createTreeFromDefinedPathname: function(items, treeStructure, treeStructureItemIndex) {
	
		// At this point the rootItems are already build.
		// treeStructure contains each subtree with invalid
		// item Id's. All item Ids needs to be fixed to present
		// the tree depth.
		
		var item;
		var itemId;
		var itemType;
		var itemPathname;
		var treeItem = treeStructure[treeStructureItemIndex];
		var treeItemType = treeItem.type;
		var treeItemPathname = treeItem.pathname;
		
		var isWin32Platform = pageInfo.isWin32Platform;
		
		if (isWin32Platform) {
			// Windows pathnames are case insensitive, so we need to convert them before
			// we check the pre-defined path with itemPathname's
			treeItemPathname = treeItemPathname.toLowerCase();
		}
				
		// util.showObject({'treeItemPathname 1':treeItemPathname});
		
		// var itemHasSubDir;
		// var itemIsEmpty;
		
		// var isImageActor = true;
		// var isAnchorActor = false;
		
		// Track the last itemId of drive or directory
		// var bottomDirectoryItemId = '';
		
		if (treeItemType == 'drive') {
			treeItemPathname = fileManager.fixPathnameOfTypeDrive(treeItemPathname);
		}
		
		// alert('treeItemType: ' + treeItemType + '\ntreeItemPathname: ' + treeItemPathname);
		
		if (treeItemType != 'file') { // is not the last item
		
			for (var i = 0; i < items.length; i++) {
				
				item = items[i];
				itemType = item.type;
				
				// util.showObject(item, 'OK I');
				
				if (itemType != 'file') {
					
					itemPathname = item.pathname;
					
					// alert('itemPathname: ' + itemPathname);
					
					if (isWin32Platform) {
						itemPathname = itemPathname.toLowerCase();
					}
					
					if (itemType == 'drive') {
						itemPathname = fileManager.fixPathnameOfTypeDrive(itemPathname);
					}
					
					// alert('itemPathname: ' + itemPathname);
					
					// util.showObject({itemPathname:itemPathname, treeItemPathname:treeItemPathname});
					
					if (itemPathname == treeItemPathname) {
						
						// We found the item where we insert the items of the treeStructure item
						
						// alert('found pathname: ' + treeItemPathname);
						
						itemId = item.id;
						
						fileManager.bottomDirectoryItemId = itemId; // We remember this itemId for final directory item selection
						
						// Insert the items from the treeStructure item
						item.items = treeItem.items;
						
						// Fix the iserted item Ids
						fileManager.createTreeFromDefinedPathnameFixIds(itemId, item.items);
						
						// Mark this item as loaded
						item.isLoaded = true;
						
						// Build the subdirectries
						if (item.hasSubDir) {
							
							// build the items
							fileManager.buildTree(itemId, item.items);
							
							// expand the items (Set isImageActor to true so that the right pane directory list is not affected)
							fileManager.handleActivatedTreeItem(item, /* isImageActor */ true , /* isAnchorActor */ false);
							// item.isExpanded = true;
						}
						
						// Check if there are other items in the treeStructure,
						// if yes recursively call createTreeFromDefinedPathname.
						if (treeStructureItemIndex < (treeStructure.length - 1)) {
							fileManager.createTreeFromDefinedPathname(item.items, treeStructure, treeStructureItemIndex + 1);
						}
						
						// Exit the loop because we found the item 
						break;
					}
				}
			}
		}
			
		// alert('Handle bottomDirectoryItemId selection: ' + bottomDirectoryItemId);
	},
	
	//
	//
	// Builder functions
	//
	//
	
	buildTree: function(parentItemId, items) {
		
		// Default display style is none
		
		var ulId = 'tree:ul:' + parentItemId;
		var ul = util.createE('ul', {id:ulId, display:'none'});
		
		for (var i = 0; i < items.length; i++) {
			
			var item = items[i];
			
			if (item.type != 'file') {
				
				// Add default isExpanded property
				
				item.isExpanded = false;
				fileManager.buildTreeItem(ul, item);
			}
		}
		
		var parentListElement = util.getE('tree:li:' + parentItemId);
		parentListElement.appendChild(ul);
	},
	
	buildTreeItem: function(ul, item) {
	
		// The item is a drive or directory 
		var itemId = item.id;
		var label = item.label;
		var itemHasSubdirectories = item.hasSubDir;
		
		// Don't make the list item an actor because the li element would also fire upon white space on the left!
		// Beside that a list item has nested lists!
		// So only image and anchor elements become actors upon which an action is taken when clicking the element. 
		
		var liId = 'tree:li:' + itemId;
		var li = util.createE('li', {id:liId});
		
		var imgRef = itemHasSubdirectories ? imgDb.fmExpandDir : imgDb.fmOpenDir;
		
		var imgId = 'tree:img:actor:' + itemId;
		var img = util.createE('img', {id:imgId, src:imgRef.src, width:imgRef.width, height:imgRef.height, alt:''});
		
		var aId = 'tree:a:actor:' + itemId;
		var a = util.createE('a', {id:aId, href:'javascript:;'});
		var aText = util.createT(label);
		
		util.chainE(ul, [li, img, [a, aText]]);
	},
	
	 buildItemsList: function(items) {
	 	
	 	var table = util.getE('directory_list:table');
	 	
	 	if (items.length > 0) {
	 		
	 		// We create two tbody elements, directories on top followed by files
	 		// because items are not ordered by directories/files!
	 		
	 		var tbodyDir = util.createE('tbody');
	 		var tbodyFiles = util.createE('tbody');
	 		
	 		for (var i = 0; i < items.length; i++) {
	 			
	 			var item = items[i];
	 			
	 			if (item.type != 'file') {
	 				fileManager.buildItemsListItem(tbodyDir, item, true);
	 			}
	 			else {
	 				fileManager.buildItemsListItem(tbodyFiles, item, false);
	 			}
	 		}
	 		
	 		util.chainE([table, tbodyDir, tbodyFiles]);
	 	}
	 	else {
	 		
	 		// Empty directory
	 		var tbody = util.createE('tbody');
	 		var tr =  util.createE('tr');
	 		var td =  util.createE('td');
	 		var text = util.createT(langVar('lang_admin.file_manager.no_directory_or_files_info'));
	 		
	 		util.chainE(table, tbody, tr, td, text);
	 	}
	},
	
	buildItemsListItem: function(tbody, item, isDirectory) {
		
		var tr = util.createE('tr');
		
		var imgRef = isDirectory ? imgDb.fmDirectory : imgDb.fmFile;
		
		
		var tdImage = util.createE('td', {width:imgRef.width + 'px', paddingLeft:0, paddingRight:0});
		// tdImage.style.width = imgRef.width + ''; // KHP-RC createE() does not support with property or there is some conflict with image width!
		
		var tdLabel = util.createE('td');
		var tdSize = util.createE('td');
		
		
		var img = util.createE('img', {src:imgRef.src, width:imgRef.width, height:imgRef.height, alt:''});
		
		var aId = 'list:a:actor:' + item.id;
		var a = util.createE('a', {id:aId, href:'javascript:;'});
		var label = util.createT(item.label);
		
		var sizeText = isDirectory ? '&nbsp;' : item.size;
		var size = util.createT(sizeText);
		
		util.chainE(tbody, [tr, [tdImage, img], [tdLabel, [a, label]], [tdSize, size]]);
	},
	
	setSize: function() {
		
		// Set directory tree and list height
		var viewportHeight = yDom.getViewportHeight();
		var headerRegion = yDom.getRegion('file_manager_header');
		var height = (viewportHeight - headerRegion.height - 5) + 'px';
		
		var treeElement = util.getE('tree:li:directory_tree:root');
		var listElement = util.getE('directory_list:div');
		
		treeElement.style.height = height;
		listElement.style.height = height;
	}
};

