//
// customizeRE.js - customize report element
//


var customizeRE = {
	
	panel: null,
	defaultTabId: '', // graphs | table
		
	// Active report element data
	shortReportElementId: '',
	reportElementName: '',
	reportElementType: '',
	totalRows: 0,
	reportElementDb: {}, // contains the active report element data
	
	initCreObjectDone: false,
	
	// Quick access to check which panels are available
	isGraphs: false,
	isGraphOptions: false,
	isTable: false,
	isPivotTable: false
}

customizeRE.init = function() {
	
	var panelObj = {
		panelId:"cre:panel",
		panelClassName: 'panel-50',
		panelHeaderLabel: langVar('lang_stats.customize_report_element.customize_report_element'),
		zIndex: 20,
		isCover: true,
		closeEvent: customizeRE.close
	};
			
	customizeRE.panel = new util.Panel3(panelObj);
	
	var okBtn = new util.Button2('cre:save_btn', 'btn-50', customizeRE.save);
	var cancelBtn = new util.Button2('cre:cancel_btn', 'btn-50', customizeRE.close);
}

customizeRE.open = function(e) {
	
	var id = e.id;
	var dat = id.split(':');
	var shortReportElementId = dat[0];
	var defaultTabId = (dat[2] == 'table') ? 'table' : 'graphs'; // This parameter depends if the CRE panel has been opened within the graphs or table section
	var reportElement = reportInfo.reportElements[h(shortReportElementId)];
	var reportElementName = reportElement.name;
	
	// customizeRE.defaultTabIsTable = defaultTabIsTable;
	customizeRE.defaultTabId = defaultTabId;
	customizeRE.shortReportElementId = shortReportElementId;
	customizeRE.reportElementName = reportElementName;
	customizeRE.reportElementType = reportElement.reportElementType;
	customizeRE.totalRows = reportElement.totalRows;
	
	// alert('shortReportElementId: ' + shortReportElementId + '\nreportElementName: ' + reportElementName);
		
	// Initialize panel
	if (customizeRE.panel == null) {
		customizeRE.init();
	}
	
	// util.hideE(['cre:tab_bar', 'cre:sub_panels']);
	util.hideE('cre:cre_forms_object');
	util.showE('cre:loading_info');
		
	customizeRE.getReportElementData(reportElementName);
	
	// Get position
	customizeRE.panel.prePositionAtCenter();
	customizeRE.panel.open();
}

customizeRE.close = function() {
	
	customizeRE.panel.close();
}

customizeRE.getReportElementData = function(reportElementName) {
	
	var url = '?dp+statistics.customize_report_element.get_report_element_data';
	url += '+p+' + reportInfo.profileName;
	
	var loadDefaultGraphsDb = !customizeRE.initCreObjectDone; // We load defaultGraphsDb only once!
	
	// KHP 10/Aug/2010 - Get session_id on server side!	
	// var dat = 'v.sys.session_id=' + reportInfo.sessionId;
	
	var dat = 'v.sys.page_token=' + reportInfo.pageToken;
	dat += '&v.sys.report_info_id=' + reportInfo.reportInfoId;
	dat += '&v.sys.report_name=' + reportInfo.reportName;
	dat += '&v.sys.report_element_name=' + reportElementName;
	dat += '&v.sys.load_default_graphs=' + loadDefaultGraphsDb;
	
	util.serverPost(url, dat);
}

customizeRE.getReportElementDataResponse = function(dat) {

	// alert('customizeRE.getReportElementDataResponse');
	
	// Verify if we got the right report element
	if (dat.reportInfoId == reportInfo.reportInfoId && dat.reportElementName == customizeRE.reportElementName) {
		
		var reportElementDb = dat.reportElementDb;
		customizeRE.reportElementDb = reportElementDb;
		
		if (!customizeRE.initCreObjectDone) {
			
			//
			//
			// Init Customize Report Element Object
			//
			//
			
			var defaultGraphsDb = dat.defaultGraphsDb;
			var queryFieldsDb = reportInfo.queryFieldsDb;
			var isCustomizeInReports = true;
			var isPivotTablePermission = reportInfo.permissions.isCREPivotTable;
			var isGraphOptionsPermission = reportInfo.permissions.isCREGraphOptions;
			var hideLogDetailSortingMessage = reportInfo.hideLogDetailSortingMessage;
			
			
			creControl.initCreObject(
				queryFieldsDb,
				defaultGraphsDb,
				isCustomizeInReports,
				isPivotTablePermission,
				isGraphOptionsPermission,
				hideLogDetailSortingMessage
			);

			customizeRE.initCreObjectDone = true;
		}
		
		//
		//
		// Init Report Element Db 
		//
		//
		
		var obj = {
			defaultTabId: customizeRE.defaultTabId,
			totalRows: customizeRE.totalRows
		};
		
		creControl.init(reportElementDb, obj);
		
		util.hideE('cre:loading_info');
		util.showE('cre:cre_forms_object');
	}
}

customizeRE.save = function() {
	
	// Note, save_re_data does not require that all report element data are send,
	// it is sufficient to send only data which have been manipulated.
	
	// Save changes to reportElementDb
	creControl.saveChanges();
	
	var reportElementDb = customizeRE.reportElementDb;
	
	// util.showObject(reportElementDb);

	var permissions = reportInfo.permissions;
	var isGraphs = reportElementDb.show_graphs;
	var isGraphOptions = (isGraphs && permissions.isCREGraphOptions);
	var isTable = reportElementDb.show_table;
	var isPivotTable = (isTable && permissions.isCREPivotTable && (reportElementDb.type == 'table'));

	var url = '?dp+statistics.customize_report_element.save_re_data';
	url += '+p+' + reportInfo.profileName;
	
	var i;
	var prop;
	
	// KHP 10/Aug/2010 - Get session_id on server side!
	// var dat = 'v.sys.session_id=' + reportInfo.sessionId;
	
	var dat = 'v.sys.page_token=' + reportInfo.pageToken;
	dat += '&v.sys.web_browser_session_id=' + reportInfo.webBrowserSessionId;
	dat += '&v.sys.report_info_id=' + reportInfo.reportInfoId;
	dat += '&v.sys.report_name=' + reportInfo.reportName;
	dat += '&v.sys.report_element_name=' + customizeRE.reportElementName;
	// dat += '&v.sys.is_save_changes_persistent=' + util.getF('cre:save_changes_persistent');
	
	var rePath = '&v.sys.report_element';
	
	// We use a default startingRow and endingRow if we have only graphs and no table
	var startingRow = 1;
	var endingRow = 10;
		
	if (isTable) {
		
		var tableOptionsProp = [
			// 'omit_parenthesized_items',
			'show_remainder_row',
			'show_averages_row',
			'show_min_row',
			'show_max_row',
			'show_totals_row',
			'number_of_rows'
		];
		
		for (i = 0; i <  tableOptionsProp.length; i++) {
			prop = tableOptionsProp[i];
			dat += rePath + '.' + prop + '=' + reportElementDb[prop];
		}
		
		// Note, don't save starting_row and ending_row within report_element,
		// we save it in 'v.sys' because they are a session setting only!
		startingRow = reportElementDb.starting_row;
		endingRow = reportElementDb.ending_row;
	}
	
	// Use for graphs and table
	dat += '&v.sys.starting_row=' + startingRow;
	dat += '&v.sys.ending_row=' + endingRow;
	
	// TEMP
	// alert('startingRow: ' + startingRow + '\nendingRow: ' + endingRow);
	// return false;
	
	// Always send sort_by and sort_direction because it can also be set if there are only graphs
	dat += rePath + '.sort_by=' + reportElementDb.sort_by;
	dat += rePath + '.sort_direction=' + reportElementDb.sort_direction;

	if (isPivotTable) {
		
		var pivotTableObj = reportElementDb.pivot_table;
		// util.showObject(pivotTableObj);
		for (prop in pivotTableObj) {
			dat += rePath + '.pivot_table.' + prop + '=' + pivotTableObj[prop];
		}
	}
	
	// alert('Revise customizeRE.isGraphOptions!');
	// return false;
	
	if (isGraphOptions) {
		
		var graphsObj = reportElementDb.graphs;
		// util.showObject(graphsObj);
		for (prop in graphsObj) {
			dat += rePath + '.graphs.' + prop + '=' + graphsObj[prop];
		}
	}
	
	//
	//
	// Get column/fields data
	//
	//
	
	var isAtLeastOneColumnChecked = false; // Required for log detail report because it allows to uncheck all text columns
	var isAtLeastOneGraphChecked = false; // Required if no table is active, in this case one graph must be checked
	var columns = reportElementDb.columns;
	
	for (i = 0; i < columns.length; i++) {
		
		var columnItem = columns[i];
		var columnsPath = '&v.sys.report_element.columns.' + i;
		var showColumn = columnItem.show_column;
		
		if (showColumn) {isAtLeastOneColumnChecked = true;}
		
		dat += columnsPath + '.position=' + i;
		dat += columnsPath + '.report_field=' + columnItem.report_field;
		dat += columnsPath + '.show_column=' + showColumn;
		
		if (columnItem['show_percent_column'] != null) {
			
			var showGraph = columnItem.show_graph;
			
			// This must be an aggregating field
			dat += columnsPath + '.show_percent_column=' + columnItem.show_percent_column;
			dat += columnsPath + '.show_bar_column=' + columnItem.show_bar_column;
			dat += columnsPath + '.show_graph=' + showGraph;
			
			if (showGraph) {isAtLeastOneGraphChecked = true;}
		}
	}
	
	if (isTable && isAtLeastOneColumnChecked || isGraphs && isAtLeastOneGraphChecked) {
		
		util.serverPost(url, dat);
	}
	else {
		alert(langVar('lang_stats.customize_report_element.no_column_checked_msg'));
	}
}

customizeRE.saveResponse = function() {

	customizeRE.close();
	newReport.getReportByCustomizeReportElement();
}


