//
// reports - databaseInfo.js
//


var databaseInfo = {
	
	panel: null,
	confirmRebuildPanel: null,
	
	initOnDataLoadDone: false,
	
	isRealTimeProcessing: null,
	databaseIsBuilding: null,
	lastModificationTimeLocalTime: '',
		
	updateDatabaseId: '',
	rebuildDatabaseId: '',
	
	isProcessing: false, // Used to lock the cancel database info panel once update/rebuild started
	
	init: function() {
		
		var panelObj = {
			panelId: 'database_info:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.database_info.database_info'),
			left: 300,
			top: 80,
			zIndex: 20,
			isCover: true,
			closeEvent: databaseInfo.close
		};
		
		databaseInfo.panel = new util.Panel3(panelObj);
		yEvent.addListener('database_info:cancel_btn', 'click', databaseInfo.close);
		yEvent.addListener(['database_info:modified:request_report_btn', 'database_info:already_building:request_report_btn'], 'click', databaseInfo.requestReport);
	},
	
	initOnDataLoad: function() {
		
		// This initialization has to be done after we received database info data!
		
		var permissions = reportInfo.permissions;
		
		if (permissions.isUpdateDatabase && (!databaseInfo.isRealTimeProcessing || !databaseInfo.databaseIsBuilding)) {
			yEvent.addListener('database_info:update_database_btn', 'click', databaseInfo.startUpdateDatabase);
			// databaseInfo.updateDbBtn = new util.CommandLink('database_info:update_database_btn', databaseInfo.startUpdateDatabase);
		}
		else {
			util.hideE('database_info:update_database_btn');
		}
		
		//
		// init rebuild
		//
		
		if (permissions.isBuildDatabase) {
			
			yEvent.addListener('database_info:rebuild_database_btn', 'click', databaseInfo.openConfirmRebuild);
			// databaseInfo.rebuildDbBtn = new util.CommandLink('database_info:rebuild_database_btn', databaseInfo.openConfirmRebuild);
			
			var confirmRebuildPanelObj = {
				panelId: 'confirm_rebuild_database:panel',
				panelClassName: 'panel-50',
				panelHeaderLabel: langVar('lang_stats.database_info.confirm_rebuild_database'),
				left: 280,
				top: 100,
				zIndex: 40,
				isCover: true,
				closeEvent: databaseInfo.closeConfirmRebuild
			};
			
			databaseInfo.confirmRebuildPanel = new util.Panel3(confirmRebuildPanelObj);
			
			yEvent.addListener('confirm_rebuild_database:ok_btn', 'click', databaseInfo.startRebuildDatabase);
			yEvent.addListener('confirm_rebuild_database:cancel_btn', 'click', databaseInfo.closeConfirmRebuild);
		}
		else {
			util.hideE('database_info:rebuild_database_btn');
		}
	},
	
	open: function() {
		
		if (!databaseInfo.panel) {
			databaseInfo.init();
		}
		
		databaseInfo.isProcessing = false;
		
		// Upon each opening we load fresh database info data
		// due realtime processing. Though even without realtime processing
		// the database info state could have changed.
		databaseInfo.getDbInfoData();
		databaseInfo.setDisplay('loading');
		databaseInfo.panel.open();
	},
	
	
	close: function() {
	
		if (!databaseInfo.isProcessing) {
			databaseInfo.panel.close();
		}
	},
	
	getDbInfoData: function() {
		
		var url = '?dp+templates.statistics.database_info.get_db_info_data';
		url += '+p+' + reportInfo.profileName;
		var dat = 'v.sys.page_token=' + reportInfo.pageToken;
		util.serverPost(url, dat);
	},
	
	getDbInfoDataResponse: function(dat) {
		
		var isRealTimeProcessing = dat.isRealTimeProcessing;
		var databaseIsBuilding = dat.databaseIsBuilding;
		
		databaseInfo.isRealTimeProcessing = isRealTimeProcessing;
		databaseInfo.databaseIsBuilding = databaseIsBuilding;
		
		if (!databaseInfo.initOnDataLoadDone) {
			databaseInfo.initOnDataLoad();
			databaseInfo.initOnDataLoadDone = true;
		}
				
		if (!databaseIsBuilding || isRealTimeProcessing) {
		
			var dbInfoDat = dat.dbInfoDat;
			
			// Build database info table
			var container = util.getE('database_info:main:container');
			util.removeChildElements(container);
			var table = util.createE('table', {className:'report-database-info-grid', cellSpacing:0});
			var tbody = util.createE('tbody');
			
			for (var i = 0; i < dbInfoDat.length; i++) {
				
				var item = dbInfoDat[i];
				databaseInfo.buildDbInfoRow(tbody, item.label, item.value);
				
				if (item.name == 'last_modification_time_localtime') {
					// Keep its value which is required in case of real time processing
					databaseInfo.lastModificationTimeLocalTime = item.value;
				}
			}
			
			util.chainE(container, table, tbody);
			
			databaseInfo.setDisplay('info_table');
		}
		else {
			
			// The database is already updating or building
			databaseInfo.setDisplay('already_building');
		}
	},
	
	//
	//
	// Display functions
	//
	//
	
	setDisplay: function(displayState) {
		
		var a = [
			'database_info:loading_info',
			'database_info:main:section',
			'database_info:processing_initiated',
			'database_info:already_building'
		];
		
		util.hideE(a);
		
		var isProcessing = false;
		var cancelButtonLabel = langVar('lang_stats.btn.close');
		
		switch (displayState) {
			
			case 'loading':
				cancelButtonLabel = langVar('lang_stats.btn.cancel');
				util.showE('database_info:loading_info');
				break;
				
			case 'info_table':

				var showDatabaseIsModified = false;
				if (databaseInfo.isRealTimeProcessing) {
					showDatabaseIsModified = databaseInfo.lastModificationTimeLocalTime != reportInfo.lastModificationTimeLocalTime;
				}
				util.showE('database_info:modified:section', showDatabaseIsModified);
				util.showE('database_info:main:section');
				
				break;
				
			case 'database_processing_initiated':
			
				isProcessing = true;
				util.showE('database_info:processing_initiated');
				break;
			
				
			case 'already_building':
				
				util.showE('database_info:already_building');
				break;
		}
		
		databaseInfo.isProcessing = isProcessing;
		util.showEV('database_info:cancel_btn', !isProcessing);
		util.updateT('database_info:cancel_btn', cancelButtonLabel);
	},
	
	updateDisplay: function(stateLabel) {
		
		util.updateT('database_info:processing_initiated:label', stateLabel);
	},
	
	//
	//
	// Request report
	//
	//
	
	requestReport: function() {
		
		newReport.request();
		databaseInfo.panel.close();
	},
	
	//
	//
	// Update database
	//
	//
	
	startUpdateDatabase: function() {
		
		databaseInfo.setDisplay('database_processing_initiated');
		databaseInfo.updateDisplay(langVar('lang_stats.database_info.init_update_database'));
		
		// Issue an update database id
		var d = new Date();
		var updateDatabaseId = 'update_database_' + d.getTime();
		databaseInfo.updateDatabaseId = updateDatabaseId;
		
		var url = '?dp+templates.update_database.start_update_database';
		url += '+p+' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.client_response_function=databaseInfo.startUpdateDatabaseResponse&';
		dat += 'v.fp.update_database_id=' + updateDatabaseId;
		
		util.serverPost(url, dat);
	},
	
	startUpdateDatabaseResponse: function(dat) {
		
		// Get the update database state
		if (dat.updateDatabaseId == databaseInfo.updateDatabaseId) {
			
			// setTimeout('databaseInfo.getUpdateDatabaseState()', 1200);
			
			if (!dat.updateDatabaseCompleted) {
			
				// There must be update database progress
				databaseInfo.updateDisplay(langVar('lang_stats.database_info.update_database_started'));
			}
			else {
				
				// Update completed without any progress
				databaseInfo.updateDisplay(langVar('lang_stats.database_info.update_database_completed'));
			}
			
			newReport.request();
		}
	},
	
	/*
	getUpdateDatabaseState: function() {
		
		var url = '?dp+templates.update_database.get_update_database_state';
		url += '+p+' + reportInfo.profileName;
		
		var dat = 'v.fp.client_response_function=databaseInfo.getUpdateDatabaseStateResponse';
		dat += '&v.fp.update_database_id=' + databaseInfo.updateDatabaseId;
		
		util.serverPost(url, dat);
	},
	
	getUpdateDatabaseStateResponse: function(dat) {
		
		if (dat.updateDatabaseId == databaseInfo.updateDatabaseId) {
			
			var updateDatabaseState = dat.updateDatabaseState;
			
			// alert('getUpdateDatabaseStateResponse() - updateDatabaseState: ' + updateDatabaseState);
			
			switch (updateDatabaseState) {
				
				case 'updating':
					databaseInfo.updateDisplay(langVar('lang_stats.database_info.update_database_started'));
					newReport.request();
					break;
					
				case 'update_complete':
					// Update completed without any progress
					databaseInfo.updateDisplay(langVar('lang_stats.database_info.update_database_completed'));
					newReport.request();
					break;
				
				case 'error':
					
					var errorMessage = dat.errorMessage;
					// KHP-RC - Revise error handling and display
					alert('getUpdateDatabaseStateResponse()\n' + errorMessage);
					break;
					
				default:
					// We got no state yet, continue with getUpdateDatabaseState
					setTimeout('databaseInfo.getUpdateDatabaseState()', 1200);
					break;
			}
		}
	},
	*/
	
	//
	//
	// Rebuild database
	//
	//
	
	startRebuildDatabase: function() {
		
		databaseInfo.confirmRebuildPanel.close();
		
		databaseInfo.setDisplay('database_processing_initiated');
		databaseInfo.updateDisplay(langVar('lang_stats.database_info.init_build_database'));
		
		// Issue a rebuild database id
		var d = new Date();
		var rebuildDatabaseId = 'rebuild_database_' + d.getTime();
		databaseInfo.rebuildDatabaseId = rebuildDatabaseId;
		
		var url = '?dp+templates.rebuild_database.start_rebuild_database';
		url += '+p+' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.client_response_function=databaseInfo.startRebuildDatabaseResponse&';
		dat += 'v.fp.rebuild_database_id=' + rebuildDatabaseId;
		
		util.serverPost(url, dat);
	},
	
	startRebuildDatabaseResponse: function(dat) {
		
		// Get the rebuild database state
		if (dat.rebuildDatabaseId == databaseInfo.rebuildDatabaseId) {
			// setTimeout('databaseInfo.getRebuildDatabaseState()', 1200);
			databaseInfo.updateDisplay(langVar('lang_stats.database_info.rebuild_database_started'));
			
			// We assume there is database build progress and request a new report
			newReport.request();
		}
	},
	
	/*
	getRebuildDatabaseState: function() {
		
		var url = '?dp+templates.rebuild_database.get_rebuild_database_state';
		url += '+p+' + reportInfo.profileName;
		
		var dat = 'v.fp.client_response_function=databaseInfo.getRebuildDatabaseStateResponse';
		dat += '&v.fp.rebuild_database_id=' + databaseInfo.rebuildDatabaseId;
		
		util.serverPost(url, dat);
	},
	
	getRebuildDatabaseStateResponse: function(dat) {
		
		if (dat.rebuildDatabaseId == databaseInfo.rebuildDatabaseId) {
			
			var rebuildDatabaseState = dat.rebuildDatabaseState;
			
			// alert(rebuildDatabaseState);
			// databaseInfo.setDisplay('Initializing build database, please wait.');
			
			switch (rebuildDatabaseState) {
				
				case 'erasing_database': 
				
					// Continue to get rebuildDatabaseState
					databaseInfo.updateDisplay(langVar('lang_stats.database_info.erasing_existing_database'));
					setTimeout('databaseInfo.getRebuildDatabaseState()', 1200);
					break;
					
				case 'building_initialized':
				
					// Continue to get rebuildDatabaseState
					// Keep erasing database text
					databaseInfo.updateDisplay(langVar('lang_stats.database_info.erasing_existing_database'));
					setTimeout('databaseInfo.getRebuildDatabaseState()', 1200);
					break;
					
				case 'building':
				
					// There must be progress
					// var writingTaskId = dat.writingTaskId;
					// init final progress
					// progress.calleeListener = rebuildDatabaseProgressListener;
					// progress.initDatabaseProgress(writingTaskId);
					databaseInfo.updateDisplay(langVar('lang_stats.database_info.rebuild_database_started'));
					newReport.request();
					// alert('Database is building, we should reload the report');
					
					break;
					
				case 'error':
				
					var errorMessage = dat.errorMessage;
				
					// KHP-RC - Revise error handling and display
					alert('getRebuildDatabaseStateResponse()\n' + errorMessage);
				
					break;
					
				default:
					// We got no state yet, continue to get rebuildDatabaseState
					setTimeout('databaseInfo.getRebuildDatabaseState()', 1200);
					break;
			}
		}
	},
	
	*/
	
	//
	//
	// Confirm rebuild database
	//
	//
	
	openConfirmRebuild: function() {
		databaseInfo.confirmRebuildPanel.open();
	},
	
	closeConfirmRebuild: function() {
		databaseInfo.confirmRebuildPanel.close();
	},
	
	//
	//
	// Utilities
	//
	//
		
	
	buildDbInfoRow: function(tbody, label, value) {
		
		var tr = util.createE('tr');
		var th = util.createE('th', {whiteSpace:'nowrap'});
		var td = util.createE('td');
		var thText = util.createT(label + ':');
		var tdText = util.createT(value);
		
		util.chainE(tbody, [tr, [th, thText], [td, tdText]]);
	}
}


