//
// exportTable.js
//


var exportTable = {
	
	panel: null,
	// validator: null,
	reportElementName: '',
	totalRows: 0,
	
	csvFile: '', // Active exported csv directory path with file name (received from server)
	csvFilerefArgument: '', // The exported file string required by the C++ filref to get the actual href once the exported file exists on disk.
	taskId: '', // Active taskId (pid) of exporting process on server side
	
	init: function() {
		
		yEvent.addListener('export_table:ok_btn', 'click', exportTable.startExport);
		yEvent.addListener('export_table:cancel_btn', 'click', exportTable.close);
		yEvent.addListener('export_table:close_btn', 'click', exportTable.close);
		
		var panelObj = {
			panelId:"export_table:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.export.export_table'),
			width: 500,
			zIndex: 20,
			isCover: true,
			closeEvent: exportTable.close
		};
		
		exportTable.panel = new util.Panel3(panelObj);
		exportTable.validator = new util.Validator();
	},
	
	open: function(e) {
				
		// alert('exportTable.open()');
		
		var reportElements = reportInfo.reportElements;
		
		if (exportTable.panel == null) {exportTable.init();}

		//
		// Get report element reference
		// 
	
		var elementId = e.id;
		var dat = elementId.split(':');
		var shortReportElementId = dat[0];
		
		var reportElement = reportElements[h(shortReportElementId)];
		
		var isPivotTable = reportElement.isPivotTable;
		
		var startingRow = 0;
		var endingRow = 0;
		var totalRows = 0;
		
		if (!isPivotTable) {
			
			startingRow = reportElement.startingRow;
			endingRow = reportElement.endingRow;
			totalRows = reportElement.totalRows;
		}
		else {
			
			// Pivot table, used row numbers of flat table!
			
			startingRow = 1;
			endingRow = reportElement.totalRowsOfFlatTable;
			totalRows = reportElement.totalRowsOfFlatTable;
		}
		
		
		// Set gloabl variables which are used upon export
		exportTable.totalRows = totalRows;
		exportTable.reportElementName = reportElement.name;
				
		//
		// Update form
		//
		
		util.hideE(['export_table:progress', 'export_table:complete']);
		util.showE('export_table:options');
		
		util.setF('export_table:rows:all_btn', true);
		util.updateT('export_table:rows:total_info', '(' + totalRows + ')');
		
		util.setF('export_table:rows:range_field', startingRow + '-' + endingRow);
		util.setF('export_table:export_aggregation_rows_btn', false);

		
		//
		// Get panel display position
		//
		
		exportTable.panel.prePositionAtCenter();
		exportTable.panel.open();
	},
	
	startExport: function() {
		
		//
		// validate rows
		//
		
		var totalRows = exportTable.totalRows;
		var startingRow;
		var endingRow;
		
		var export_all_rows = util.getF('export_table:rows:all_btn');
		
		var isValidRowNumbers = false;
		
		if (export_all_rows) {
			startingRow = 1;
			endingRow = totalRows;
			isValidRowNumbers = true;
		}
		else {
			
			// Get startingRow and endingRow
			
			var rangeValue = util.getF('export_table:rows:range_field');
			
			// remove white space
			rangeValue = rangeValue.replace(/\s/g, '');
			
			if (rangeValue.indexOf('-') != -1) {
				
				var rangeValueSplit = rangeValue.split('-');
				startingRow = rangeValueSplit[0];
				endingRow = rangeValueSplit[1];
			}
			else {
				// No range, treat single number as endingRow
				startingRow = 1;
				endingRow = rangeValue;
			}
			
			// Validate startingRow and endingRow
			
			if (util.isInteger(startingRow, 1, totalRows) && util.isInteger(endingRow, 1, totalRows)) {
				
				if (parseInt(startingRow, 10) <= parseInt(endingRow, 10)) {
					isValidRowNumbers = true;
				}
			}
		}
		
		// alert('Export rows: ' + startingRow + '-' + endingRow);
		
		//
		// Check if the table with sepcified options has already been exported
		//
		
		if (isValidRowNumbers) {
			
			var exportActiveAggregationRows = util.getF('export_table:export_aggregation_rows_btn');
		
			util.hideE('export_table:options');
			util.showE('export_table:progress');
			
			var url = '?dp+statistics.export.export_from_gui_init';
			url += '+p+' + reportInfo.profileName;
			
			var dat = 'v.sys.page_token=' + reportInfo.pageToken + '&';
			dat += 'v.sys.report_job_id=' + reportInfo.reportJobId + '&';
			dat += 'v.sys.report_name=' + reportInfo.reportName + '&';
			dat += 'v.sys.report_element_name=' + exportTable.reportElementName + '&';
			dat += 'v.sys.starting_row=' + startingRow + '&';
			dat += 'v.sys.ending_row=' + endingRow + '&';
			dat += 'v.sys.export_active_aggregation_rows=' + exportActiveAggregationRows;
			
			util.serverPost(url, dat);
		}
		else {
			
			alert('Invalid range in number of rows.');
		}
	},
	
	startExportResponse: function(dat) {
	
		// alert('export done, csvFileHref: ' + dat.csvFileHref);
		
		exportTable.csvFile = dat.csvFile;
		exportTable.csvFilerefArgument = dat.csvFilerefArgument;
		exportTable.taskId = dat.taskId;
		
		exportTable.checkExportComplete();
	},
	
	checkExportComplete: function() {
		
		var url = '?dp+statistics.export.check_export_complete';
		url += '+p+' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.csv_file=' + exportTable.csvFile + '&';
		dat += 'v.fp.csv_fileref_argument=' + exportTable.csvFilerefArgument + '&';
		dat += 'v.fp.task_id=' + exportTable.taskId;
		
		// alert('checkExportComplete()\n' + dat);
		
		util.serverPost(url, dat);
	},
	
	checkExportCompleteResponse: function(dat) {
		
		if (dat.isComplete) {
			
			var csvFileHref = dat.csvFileHref;
			
			// alert('Export is complete, file exists!');
			
			var downloadLink = util.getE('export_table:download_link');
			downloadLink.href = dat.csvFileHref;
			util.hideE('export_table:progress');
			util.showE('export_table:complete');
		}
		else {
			// Repeat check 
			setTimeout("exportTable.checkExportComplete()", 500);
		}
	},
	
	close: function() {
		
		// exportTable.validator.reset();
		exportTable.panel.close();
	}
}
