//
// globalFilter
//


var globalFilter = {
	
	// Note, each time the window is opened we load a fresh filter set
	// because we don't know if the filter set has been changed in another
	// tab or window between two openings.
	
	panel: null,
	tabs: null,
	newItemBtn: null,
	activeTabId: '',
	isJustAddedFilterItems: false,
	justAddedFilterItems: [],
	savedFilterItems: [],
	savedFilterGroups: [],
	recentlyAddedFilterItems: [],
	itemIdCount: 0,
	
	// button objects for which we require enabled/disabled state
	saveCheckedAsGroupBtn: null,
	savedSortBtn: null,
	savedDeselectAllBtn: null,
	savedSelectAllBtn: null,
	justAddedDeselectAllBtn: null,
	justAddedSelectAllBtn: null,
	recentlyAddedDeselectAllBtn: null,
	recentlyAddedSelectAllBtn: null,				
	
	// isModified indicates that we have to send and re-assamble 
	// the corresponding filters, else we only send the isActive state
	// to the server.
	isModifiedSavedFilterItems: false,
	isModifiedSavedFilterGroups: false,
	isModifiedRecentlyAddedFilterItems: false,
	
	isModifiedUnsavedFilters: false, // set to true upon Edit only
	isModifiedSavedFilters: false, // set to true upon Edit only
	addedFilterItemStringsDb: [], // used upon Saved Checked Items As only
		
	getNewItemId: function() {
		return 'i' + globalFilter.itemIdCount++;
	},
	
	init: function() {
		
		var panelObj = {
			panelId:'global_filter:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.global_filter.filters'),
			left: 20,
			top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: globalFilter.close
		};
		
		globalFilter.panel = new util.Panel3(panelObj);
			
		// Init tabs
		globalFilter.tabs = new util.Tabs2(['gf:just_added_filter_items:tab', 'gf:saved_filters:tab', 'gf:recently_added_filter_items:tab'], globalFilter.tabActivated);

		// Init buttons
		yEvent.addListener('gf:saved_filters:new_item_btn', 'click', globalFilter.newFilterItem);
		yEvent.addListener('gf:saved_filters:new_group_btn', 'click', globalFilter.newFilterGroup);
		
		globalFilter.saveCheckedAsGroupBtn = new util.CommandLink('gf:saved_filters:save_checked_as_group_btn', globalFilter.saveCheckedAsNewGroup);
		globalFilter.savedSortBtn = new util.CommandLink('gf:saved_filters:sort_btn', globalFilter.sortSavedFilters);
		globalFilter.savedDeselectAllBtn = new util.CommandLink('gf:saved_filters:deselect_all_btn', globalFilter.deselectAll);
		globalFilter.savedSelectAllBtn = new util.CommandLink('gf:saved_filters:select_all_btn', globalFilter.selectAll);
		
		globalFilter.justAddedDeselectAllBtn = new util.CommandLink('gf:just_added_filter_items:deselect_all_btn', globalFilter.deselectAll);
		globalFilter.justAddedSelectAllBtn =  new util.CommandLink('gf:just_added_filter_items:select_all_btn', globalFilter.selectAll);
	
		globalFilter.recentlyAddedDeselectAllBtn = new util.CommandLink('gf:recently_added_filter_items:deselect_all_btn', globalFilter.deselectAll);
		globalFilter.recentlyAddedSelectAllBtn =  new util.CommandLink('gf:recently_added_filter_items:select_all_btn', globalFilter.selectAll);
		
		yEvent.addListener('global_filter:save_btn', 'click', globalFilter.saveFiltersDb);
		yEvent.addListener('global_filter:cancel_btn', 'click', globalFilter.close);
	},
	
	open: function() {
		
		globalFilter.getFiltersDb();
				
		// Reset the filterItemIdCount
		globalFilter.itemIdCount = 0;
		
		if (globalFilter.panel == null) {
			// Initialize the global filter panel
			globalFilter.init();
		}
	
		
		// Set isJustAddedFilterItems
		// globalFilter.isJustAddedFilterItems = (zoomControl.justAddedFilterItems.length > 0) ? true : false;
		
		// hide the tab bar until all data are loaded
		util.hideE('gf:tab_bar');
		
		util.hideE(['gf:just_added_filter_items:panel', 'gf:saved_filters:panel', 'gf:recently_added_filter_items:panel']);
		util.showE('gf:loading_info');

		globalFilter.panel.open();
	},
	
	close: function() {
		
		globalFilter.panel.close();
	},
	
	disableForm: function(isCoverOn) {
		
		globalFilter.enableDisableForm(true);
	},
	
	enableForm: function() {
		
		globalFilter.enableDisableForm(false);
	},
	
	enableDisableForm: function(isDisable) {
		
		// Covers the form with a transparent image when subform is opened.
		// Further, Firefox has a problem with the underlying filter item div's.
		// The problem is caused by the div overflow setting where form fields
		// above the div don't anymore show focus on form fields. We solve this
		// by setting the div overflow to 'hidden' while a subform is open.
		
		// Firefox fix
		var gfArea = util.getE('filter_section:data');
		var divElements = gfArea.getElementsByTagName('div');
		for (var i = 0; i < divElements.length; i++) {
			if (divElements[i].className == 'filter-items-panel-body') {
				divElements[i].style.overflow = isDisable ? 'hidden' : 'scroll';
			}
		}
	},
	
	setControlsState: function() {
		
		// updates the state of number of items and enables disables conrol buttons
				
		if (globalFilter.isJustAddedFilterItems) {
			var activeJustAddedItemsNum = globalFilter.getNumberOfActiveItems(globalFilter.justAddedFilterItems);
			util.updateT('gf:just_added_filter_items:active_item_count', activeJustAddedItemsNum);
		}
		
		var activeSavedFiltersNum = globalFilter.getNumberOfActiveItems(globalFilter.savedFilterItems);
		activeSavedFiltersNum += globalFilter.getNumberOfActiveItems(globalFilter.savedFilterGroups);
		util.updateT('gf:saved_filters:active_item_count', activeSavedFiltersNum);
		
		var activeRecentlyAddedItemsNum = globalFilter.getNumberOfActiveItems(globalFilter.recentlyAddedFilterItems);
		util.updateT('gf:recently_added_filter_items:active_item_count', activeRecentlyAddedItemsNum);
		
		
		//
		// Enable/Disable buttons
		//
		
		var activeTabId = globalFilter.activeTabId;
		var activeTabHasItems = false;
		
		if (activeTabId == 'gf:saved_filters:tab') {
			
			if (activeSavedFiltersNum > 0) {
				// Allow to save single items as new group because the item could already be a group
				// or a single item to which other items are added manually.
				globalFilter.saveCheckedAsGroupBtn.enable();
			}
			else {
				globalFilter.saveCheckedAsGroupBtn.disable();
			}
			
			// Check if there are any items in the list
			if (globalFilter.savedFilterItems.length > 0 || globalFilter.savedFilterGroups.length > 0) {
				activeTabHasItems = true;
			}
			
			globalFilter.savedSortBtn.enable(activeTabHasItems);
			globalFilter.savedDeselectAllBtn.enable(activeTabHasItems);
			globalFilter.savedSelectAllBtn.enable(activeTabHasItems);
		}
		else if (activeTabId == 'gf:just_added_filter_items:tab') {
			
			if (globalFilter.justAddedFilterItems.length > 0) {
				activeTabHasItems = true;
			}
			globalFilter.justAddedDeselectAllBtn.enable(activeTabHasItems);
			globalFilter.justAddedSelectAllBtn.enable(activeTabHasItems);
		}
		else {
			// gf:recently_added_filter_items:tab
			
			if (globalFilter.recentlyAddedFilterItems.length > 0) {
				activeTabHasItems = true;
			}
			globalFilter.recentlyAddedDeselectAllBtn.enable(activeTabHasItems);
			globalFilter.recentlyAddedSelectAllBtn.enable(activeTabHasItems);
		}
	},
	
	getNumberOfActiveItems: function(items) {
		
		var numberOfActiveItems = 0;
		
		for (var i = 0; i < items.length; i++) {
			if (items[i].isActive) {
				numberOfActiveItems++;
			}
		}
		
		return numberOfActiveItems;
	},
	
	tabActivated: function() {
		
		var tabId = this.id;
	
		util.hideE(['gf:just_added_filter_items:panel', 'gf:saved_filters:panel', 'gf:recently_added_filter_items:panel']);
		
		globalFilter.tabs.setActiveTab(tabId);
		
		if (tabId == 'gf:just_added_filter_items:tab') {
			util.showE('gf:just_added_filter_items:panel');
		}
		else if (tabId == 'gf:saved_filters:tab') {
			util.showE('gf:saved_filters:panel');			
		}
		else {
			util.showE('gf:recently_added_filter_items:panel');
		}
		
		globalFilter.activeTabId = tabId;
		globalFilter.setControlsState();
	},
	
	getFiltersDb: function() {
		
		var url = '?dp+statistics.filters.global_filter.get_filters_db';
		url += '+p+' + reportInfo.profileName;
		
		var dat = 'v.sys.page_token=' + reportInfo.pageToken + '&';
		
		if (!zoomControl.isZoomItems) {
		
			dat += 'v.sys.is_zoom_items=false&';
			dat += 'v.sys.active_filter_id=' + reportInfo.filterId;
		}
		else {
			var zoomInfoId = zoomControl.getZoomInfoId();
			dat += zoomControl.getZoomItemsDat();
		}
		
		util.serverPost(url, dat);
	},
	
	getFiltersDbResponse: function(dat) {
		
		// alert('getFiltersDbResponse:\n' + dat);
		
		// util.showObject(dat, 'getFiltersDbResponse()');
		
		util.hideE('gf:loading_info');
		
		/*
		var isJustAddedFilterItems = globalFilter.isJustAddedFilterItems;
		var justAddedFilterItems = [];
		
		if (isJustAddedFilterItems) {
			// Get justAddedFilterItems from report.js
			// For some reason justAddedFilterItemsOri is not recogized as Array by util.isArray(), so it doesn't become cloned.
			// Hence we clone the objects!
			var justAddedFilterItemsOri = zoomControl.justAddedFilterItems;
			for (var i = 0; i < justAddedFilterItemsOri.length; i++) {
				justAddedFilterItems[i] = util.cloneObject(justAddedFilterItemsOri[i]);
			}
		}
		*/
		
		var justAddedFilterItems = dat.justAddedFilterItems;
		var savedFilterItems = dat.savedFilterItems;
		var savedFilterGroups = dat.savedFilterGroups;
		var recentlyAddedFilterItems = dat.recentlyAddedFilterItems;
		
		var isJustAddedFilterItems = (justAddedFilterItems.length > 0);
		globalFilter.isJustAddedFilterItems = isJustAddedFilterItems;
		
		globalFilter.justAddedFilterItems = justAddedFilterItems;
		globalFilter.savedFilterItems = savedFilterItems;
		globalFilter.savedFilterGroups = savedFilterGroups;
		globalFilter.recentlyAddedFilterItems = recentlyAddedFilterItems;
		
		// Before we build the lists we have to add a unique object id
		// to each filter item and have to add labels to all filter items
		// which are not groups and not expression items.
		
		globalFilter.prepareFilterItems(justAddedFilterItems);
		globalFilter.prepareFilterItems(savedFilterItems);
		globalFilter.prepareFilterItems(recentlyAddedFilterItems);
		
		// Handle filterGroups
		
		if (savedFilterGroups.length > 0) {
			
			// Add itemId to groups and handle filterItems in group
			// We also add an isExpanded property which indicates
			// the expanded state.
			
			for (var i = 0; i < savedFilterGroups.length; i++) {
				
				savedFilterGroups[i].id = globalFilter.getNewItemId();
				savedFilterGroups[i].isExpanded = false;
				var filterItems = savedFilterGroups[i].items;
				globalFilter.prepareFilterItems(filterItems);
			}
		}
		
		// Create hashes to access filters by itemId
		
		if (isJustAddedFilterItems) {
			util.createHash(justAddedFilterItems, 'id');
		}
		util.createHash(savedFilterItems, 'id');
		util.createHash(savedFilterGroups, 'id');
		util.createHash(recentlyAddedFilterItems, 'id');
		
		//
		//
		// Build the filterItem lists
		//
		//
				
		if (isJustAddedFilterItems) {
			globalFilter.buildUnsavedFilterRows('just_added_fi', 'gf:just_added_filter_items:container', justAddedFilterItems);
		}
		
		globalFilter.buildSavedFilterRows(savedFilterItems, savedFilterGroups);
		globalFilter.buildUnsavedFilterRows('recently_added_fi', 'gf:recently_added_filter_items:container', recentlyAddedFilterItems);		
		
		//
		// Set initial tab state and set the item list width
		//
		
		util.hideE(['gf:just_added_filter_items:panel', 'gf:saved_filters:panel', 'gf:recently_added_filter_items:panel']);
		
		var activeTabId;
		var activePanelId;
		var containerRegion;
		
		if (justAddedFilterItems.length > 0) {
			activeTabId = 'gf:just_added_filter_items:tab';
			globalFilter.tabs.show('gf:just_added_filter_items:tab');
			activePanelId = 'gf:just_added_filter_items:panel';
		}
		else {
			activeTabId = 'gf:saved_filters:tab';
			globalFilter.tabs.hide('gf:just_added_filter_items:tab');
			activePanelId = 'gf:saved_filters:panel';
		}
		
		globalFilter.tabs.setActiveTab(activeTabId);
		globalFilter.activeTabId = activeTabId;
	
	
		// Show the tabs bar and panel
		util.showE('gf:tab_bar');
		util.showE(activePanelId);
		
		
		// The item list table width must be set due IE quirks. We set the table to the div container width minus scrollbar witdh
		containerRegion = yDom.getRegion(activePanelId);
		var tableWidth = (containerRegion.right - containerRegion.left - 24) + 'px';
		globalFilter.setTableWidth('gf:just_added_filter_items:container', tableWidth);
		globalFilter.setTableWidth('gf:saved_filters:container', tableWidth);
		globalFilter.setTableWidth('gf:recently_added_filter_items:container', tableWidth);
		
		
		// Set controls state
		globalFilter.setControlsState();
	},
	
	prepareFilterItems: function(filterItems) {
		
		// Add itemId and label to filterItem object if the filterItem is not an expression
		
		for (var i = 0; i < filterItems.length; i++) {
			filterItems[i].id = globalFilter.getNewItemId();
			globalFilter.addFilterItemLabel(filterItems[i]);
			// util.showObject(filterItems[i]);
		}
	},
	
	addFilterItemLabel: function(filterItem) {
		
		var filterType = filterItem.filterType;
		
		// We ignore the label if filterType is expression!
		
		if (filterType != 'expression') {
			
			var isNegated = filterItem.isNegated;
			var itemValue = filterItem.itemValue;
			var label = '';
		
			switch (filterType) {
				
				case 'field':
				
					var queryFieldsDb = reportInfo.queryFieldsDb;
				
					var fieldName = filterItem.fieldName;
					var expressionType = filterItem.expressionType;
					var queryFieldItem = queryFieldsDb[h(fieldName)];
					var isAggregatingField = queryFieldItem.isAggregatingField;
					var fieldLabel = queryFieldItem.label;
					var operator = '';
					
					// alert('expressionType: ' + expressionType);
					
					if (!isAggregatingField) {
						
						if (expressionType == 'regexp') {
							operator = !isNegated ? langVar('lang_stats.global_filter.field_matches_regular_expression') : langVar('lang_stats.global_filter.field_not_matches_regular_expression');
						}
						else if (expressionType == 'wildcard') {
							operator = !isNegated ? langVar('lang_stats.global_filter.field_matches_wildcard') : langVar('lang_stats.global_filter.field_not_matches_wildcard');
						}
						else {
							operator = !isNegated ? langVar('lang_stats.global_filter.field_is') : langVar('lang_stats.global_filter.field_is_not');
							
							var fieldCategory = queryFieldItem.category;
							
							if (fieldCategory == 'day_of_week' || fieldCategory == 'hour_of_day') {
								
								// item_value is integer
								var i = itemValue;
								itemValue = (fieldCategory == 'day_of_week') ? lang.weekdays[i - 1] : lang.hours[i];
							}
						}
					}
					else {
						
						// Aggregating field with numerical value
						operator = (expressionType == 'lt') ? langVar('lang_stats.global_filter.field_is_less_than') : langVar('lang_stats.global_filter.field_is_greater_than');
					}
					
					label = fieldLabel + " " + operator + " '" + itemValue + "'";
					break;
					
				case 'session_contains': 
				
					label = !isNegated ? langVar('lang_stats.global_filter.session_contains_page_with_wildcard_expression') : langVar('lang_stats.global_filter.session_contains_not_page_with_wildcard_expression');
					label += " '" + itemValue + "'";
					break;
					
				case 'session_start':
				
					label = !isNegated ? langVar('lang_stats.global_filter.session_start_is') : langVar('lang_stats.global_filter.session_start_is_not');
					label += " '" + itemValue + "'";
					break;
			}
			
			filterItem.label = label;
		}
	},
	
	updateCheckboxState: function(filters, idPrefix) {
		
		// Sets the isActive state of each checkbox (IE does not set the state upon checkbox creation)
		
		// We don't need to cover filterItems in filterGroups because they don't have a checkbox!
		for (var i = 0; i < filters.length; i++) {
			var item = filters[i];
			var itemId = item.id;
			var isActive = item.isActive;
			var elementId = idPrefix + ':cb:' + itemId;
			util.setF(elementId, isActive);
			
			// Fix IE image display problem if filter group
			
			if (idPrefix == 'saved_fg') {
				
				var imgId = idPrefix + ':img:' + itemId;
				var groupHasItems = (item.items.length) > 0 ? true : false;
				setTimeout("globalFilter.updateGroupImage('" + imgId + "'," + groupHasItems + ")", 10);
			}
		}
	},
	
	updateGroupImage: function(imgId, groupHasItems) {
		
		var img = util.getE(imgId);
		img.src = groupHasItems ? imgDb.gfCollapsed.src : imgDb.gfEmptyGroup.src;
	},
	
	buildUnsavedFilterRows: function(idPrefix, containerId, filterItems) {
		
		// Build the unsaved filter rows. We clean up the container from any
		// existing rows, sort the filterItems Array and build the rows
		
		globalFilter.removeFilterRows(containerId);
		
		if (filterItems.length > 0) {
			
			// Sort the filterItems
			filterItems.sort(globalFilter.compareLabels);
			
			// Create the rows
			var tbody = util.getE(containerId);
			
			for (var i = 0; i < filterItems.length; i++) {
				
				var item = filterItems[i];
				var tr = globalFilter.buildFilterRow(idPrefix, item.id, item.label);
				tbody.appendChild(tr);
			}
			
			globalFilter.updateCheckboxState(filterItems, idPrefix);
		}
	},
	
	buildSavedFilterRows: function(savedFilterItems, savedFilterGroups) {
		
		// Build the saved filter rows. This function is also used upon sorting the filter
		// rows. We clean the container from any existing rows, sort the
		// savedFilterItems and savedFilterGroups and then rebuild the rows.
		
		// Cleanup container
		globalFilter.removeFilterRows('gf:saved_filters:container');
		var item;
		var tr;
		
		var tbody = util.getE('gf:saved_filters:container');
		// var tbodyId = 'gf:saved_filters:container';
		
		if (savedFilterItems.length > 0) {
			
			// Sort the array
			savedFilterItems.sort(globalFilter.compareLabels);
			
			// Create the rows
			for (var i = 0; i < savedFilterItems.length; i++) {
				item = savedFilterItems[i];
				
				tr = globalFilter.buildFilterRow('saved_fi', item.id, item.label);
				tbody.appendChild(tr);
				
				// globalFilter.buildFilterRow(tbodyId, 'saved_fi', item.id, item.label);
			}
			
			globalFilter.updateCheckboxState(savedFilterItems, 'saved_fi');
		}
		
		if (savedFilterGroups.length > 0) {
			
			// Sort the filter groups
			savedFilterGroups.sort(globalFilter.compareLabels);
			
			// Create the group rows
			for (var i = 0; i < savedFilterGroups.length; i++) {
				
				item = savedFilterGroups[i];
				var groupHasItems = (item.items.length > 0) ? true : false;
				
				tr = globalFilter.buildFilterRow('saved_fg', item.id, item.label, groupHasItems);
				tbody.appendChild(tr);
				
				// setTimeout("globalFilter.buildFilterRow('" + tbodyId "', 'saved_fg', '" + item.id + "', '" + item.label + "', " + groupHasItems + ")", 3000);
				
				
				
				// Create the item rows
				var subItems = item.items;
				
				// sort the sub items
				subItems.sort(globalFilter.compareLabels);
			
				for (var j = 0; j < subItems.length; j++) {
					
					var subItem = subItems[j];
					var tr2 = globalFilter.buildFilterRow('saved_fgfi', subItem.id, subItem.label);
					tbody.appendChild(tr2);
				}
			}
			
			globalFilter.updateCheckboxState(savedFilterGroups, 'saved_fg');
		}
	},
	
	buildFilterRow: function(idPrefix, itemId, itemLabel, groupHasItems) {
		
		// alert('itemId: ' + itemId + '\nlabel: ' + itemLabel);
		
		// Builds an item row and returns a tr element reference
		
		// idPrefix is: just_added_fi | saved_fi | saved_fg | saved_fgfi (filter item in filter group) | recently_added_fi
		
		// The idPrefix will be used for item ids which will have the format:
		// just_added_fi:row:i0
		// just_added_fi:cb:i0
		// just_added_fi:move:i0
		// just_added_fi:delete:i0
		// saved_fi:row:i1
		// saved_fi:cb:i1
		// saved_fi:edit:i1
		// saved_fi:delete:i1
		
		// Note, for a saved filterItem we also add an id to the label so that we can update the label upon edit!
		// i.e.: saved_fi:label:i1
		
		// var tbody = util.getE(tbodyId);
		
		var isSavedFilterItem = (idPrefix == 'saved_fi') ? true : false;
		var isSavedFilterGroup = (idPrefix == 'saved_fg') ? true : false;
		var isSavedFilterItemInGroup = (idPrefix == 'saved_fgfi') ? true : false;
		var isSavedFilter = (isSavedFilterItem || isSavedFilterGroup || isSavedFilterItemInGroup) ? true : false;
				
		// Note, items are checked in a separate function due IE bug
		
		var tr = document.createElement('tr');
		tr.id = idPrefix + ':row:' + itemId;
		
		//
		// Add expand/collapse cell for filter groups
		//
		
		if (isSavedFilter) {
			
			var td = document.createElement('td');
			td.style.width = '14px';
			
			
			
			if (!isSavedFilterGroup) {
				// Add empty cell
				var tempTxt = document.createTextNode(' ');
				td.appendChild(tempTxt);
			}
			else {
				// This is a filter group, add icon
				
				// Due an IE bug we need to delay image creation, give the td an ID so that we can
				// add the image later
				
				// var cellId = 'img_ref:' + itemId;
				// var imgId = idPrefix + ':img:' + itemId;
				
		
				var img = document.createElement('img');
				img.id = idPrefix + ':img:' + itemId;
				img.src = groupHasItems ? imgDb.gfCollapsed.src : imgDb.gfEmptyGroup.src;
				img.alt = '';
				img.width = 31;
				img.height = 15;
				td.appendChild(img);
				
				if (groupHasItems) {
					yEvent.addListener(img, 'click', globalFilter.expandCollapseGroup);
				}
				
				// setTimeout("globalFilter.buildGroupImage('" + cellId "'," + imgId + "'," + groupHasItems + ")", 10);
			}
			
			tr.appendChild(td);
		}
		
		//
		// Add the checkbox cell
		//
		
		var td2 = document.createElement('td');
		td2.style.width = '14px';
		
		if (!isSavedFilterItemInGroup) {
	
			var input = document.createElement('input');
			var inputId = idPrefix + ':cb:' + itemId;
			input.id = inputId;
			input.type = 'checkbox';
			input.value = '';
			
			td2.appendChild(input);
			
			yEvent.addListener(input, 'click', globalFilter.toggleFilterActiveState);
			
			// if this is an empty group disable the checkbox
			if (isSavedFilterGroup && !groupHasItems) {
				input.disabled = true;
			}
		}
		else {
			// Filter items in a group don't have checkboxes
			var tempTxt3 = document.createTextNode(' ');
			td2.appendChild(tempTxt3);
		}
		
		tr.appendChild(td2);

		
		//
		// Add the label cell
		//
		
		var td3 = document.createElement('td');
		td3.style.whiteSpace = 'normal';
		var labelTxt = document.createTextNode(itemLabel);
		
		if (!isSavedFilterItemInGroup) {
			
			// Add the label
			
			var label = document.createElement('label');
			label.id = idPrefix + ':label:' + itemId;
			label.htmlFor = inputId;
			
			label.appendChild(labelTxt);
			td3.appendChild(label);
		}
		else {
			
			// Filter item in filter group, add simple text and hide tr
			var span = document.createElement('span');
			span.id = idPrefix + ':label:' + itemId;
			span.appendChild(labelTxt);
			td3.appendChild(span);
			
			tr.style.display = 'none';
		}		
		
		tr.appendChild(td3);
		
		//
		// Add the controls cell
		//
		
		var td4 = document.createElement('td');
		td4.className = 'filter-item-controls';
		var a1;
		var a1Txt;
		var separatorLine1 = document.createTextNode(' | ');
		
		if (!isSavedFilter) {
			// just added item or recently added item, add Move to Saved
			a1 = document.createElement('a');
			a1.href = 'javascript:;';
			a1.id = idPrefix + ':move:' + itemId;
			a1Txt = document.createTextNode(langVar('lang_stats.global_filter.move_to_saved'));
			a1.appendChild(a1Txt);
			td4.appendChild(a1);
			td4.appendChild(separatorLine1);
			
			yEvent.addListener(a1, 'click', globalFilter.moveFilterItem);
		}
		else if (!isSavedFilterGroup) {
			// saved filter item, add Edit
			a1 = document.createElement('a');
			a1.href = 'javascript:;';
			a1.id = idPrefix + ':edit:' + itemId;
			a1Txt = document.createTextNode(langVar('lang_stats.btn.edit'));
			a1.appendChild(a1Txt);
			td4.appendChild(a1);
			td4.appendChild(separatorLine1);
			
			yEvent.addListener(a1, 'click', globalFilter.editFilterItem);
		}
		else {
			// saved filter group, add Add, Rename
			
			a1 = document.createElement('a');
			a1.href = 'javascript:;';
			a1.id = idPrefix + ':add:' + itemId;
			a1Txt = document.createTextNode(langVar('lang_stats.global_filter.add_new_item'));
		
			var separatorLine2 = document.createTextNode(' | ');
		
			var a2 = document.createElement('a');
			a2.href = 'javascript:;';
			a2.id = idPrefix + ':edit:' + itemId;
			var a2Txt = document.createTextNode(langVar('lang_stats.btn.edit'));
			
			a1.appendChild(a1Txt);
			a2.appendChild(a2Txt);
			
			td4.appendChild(a1);
			td4.appendChild(separatorLine1);
			td4.appendChild(a2);
			td4.appendChild(separatorLine2);
			
			yEvent.addListener(a1, 'click', globalFilter.newFilterItemInGroup);
			yEvent.addListener(a2, 'click', globalFilter.editFilterGroup);
		}
		
		// Add Delete control
		
		var a3 = document.createElement('a');
		a3.href = 'javascript:;';
		a3.id = idPrefix + ':delete:' + itemId;
		var a3Txt = document.createTextNode(langVar('lang_stats.btn.delete'));
		
		a3.appendChild(a3Txt);
		td4.appendChild(a3);
		
		yEvent.addListener(a3, 'click', globalFilter.deleteFilter);
		
		tr.appendChild(td4);
		
		// tbody.appendChild(
		
		return tr;
	},
	
	/*
	buildGroupImage: function(cellId, imgId, groupHasItems) {
		
		// Set via timout due IE bug whic h does not always display the image
		
		var td = util.getE(cellId);
		var img = document.createElement('img');
		img.id = imgId;
		img.src = groupHasItems ? imgDb.gfCollapsed.src : imgDb.gfEmptyGroup.src;
		img.alt = '';
		img.width = 31;
		img.height = 15;
		td.appendChild(img);
		
		if (groupHasItems) {
			yEvent.addListener(img, 'click', globalFilter.expandCollapseGroup);
		}
	},
	*/
	
	removeFilterRows: function(containerId) {
		
		// removes any existing filter row
		
		var tbody = util.getE(containerId);
		
		if (tbody.lastChild != null) {
			
			// remove all events
			// var checkboxes = tbody.getElementsByTagName('input');
			// for (var i = 0; i < checkboxes.length; i++) {
				// yEvent.removeListener(checkboxes[i], 'click', globalFilter.toggleFilter);
			// }
			
			// remove all rows
			while (tbody.lastChild != null) {
				var row = tbody.lastChild;
				tbody.removeChild(row);
			}
		}
	},
	
	insertSavedFilterRow: function(idPrefix, item, groupItemId, groupHasItems) {
		
		// idPrefix is: saved_fi | saved_fg | saved_fgfi (filter item in filter group)
		// groupHasItems is optional, it is only given for groups
		
		// saved_fi and saved_fg are inserted as first row
		// saved_fgfi (filter item in filter group) is inserted as first row in the group
		
		var itemId = item.id;
		var itemLabel = item.label;
		var tr = globalFilter.buildFilterRow(idPrefix, itemId, itemLabel, groupHasItems);
		
		var tbody = util.getE('gf:saved_filters:container');
		
		if (idPrefix != 'saved_fgfi') {
			
			if (tbody.firstChild != null) {
				
				var firstTr = tbody.firstChild;
				tbody.insertBefore(tr, firstTr);
			}
			else {
				
				tbody.appendChild(tr);
			}
		}
		else {
			// We insert the row as first row in the filter group
			
			var groupTr = util.getE('saved_fg:row:' + groupItemId);
			
			if (groupTr.nextSibling != null) {
				
				var nextTr = groupTr.nextSibling;
				tbody.insertBefore(tr, nextTr);
			}
			else {
				tbody.appendChild(tr);
			}
		}
		
		// update the checkbox state
		if (idPrefix != 'saved_fgfi') {
			util.setF(idPrefix + ':cb:' + itemId, item.isActive);
		}
		

	},

	moveFilterItem: function() {
		
		// Moves an unsaved filter item to saved filter items
		
		// alert('moveFilterItem: ' + this.id);
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var idPrefix = dat[0];
		var itemId = dat[2];
		var containerId;
		var rowId = idPrefix + ':row:' + itemId;
		var newItem = {};
		
		if (idPrefix == 'just_added_fi') {
			containerId = 'gf:just_added_filter_items:container';
			newItem = util.cloneObject(globalFilter.justAddedFilterItems[h(itemId)]);
			util.deleteArrayObject(globalFilter.justAddedFilterItems, 'id', itemId);
		}
		else {
			// move recently_added_fi
			containerId = 'gf:recently_added_filter_items:container';
			newItem = util.cloneObject(globalFilter.recentlyAddedFilterItems[h(itemId)]);
			util.deleteArrayObject(globalFilter.recentlyAddedFilterItems, 'id', itemId);
		}
		
		// We need to check if the item already exists in savedFilterItems,
		// if it already exists we only set the isActive state
		
		var savedFilterItems = globalFilter.savedFilterItems;
		var isExistingItem = false;
		var existingItem;
		var newItemString = globalFilter.getFilterItemString(newItem);
		
		for (var i = 0; i < savedFilterItems.length; i++) {
			var existingItemString = globalFilter.getFilterItemString(savedFilterItems[i]);
			if (newItemString == existingItemString) {
				isExistingItem = true;
				existingItem = savedFilterItems[i];
				break;
			}
		}
		
		// delete justAddedItem row
		var tbody = util.getE(containerId);
		var row = util.getE(rowId);
		tbody.removeChild(row);
		
		
		if (!isExistingItem) {
	
			// give the new item a new id
			var newItemId = globalFilter.getNewItemId();
			newItem.id = newItemId;
			
			// Insert newItem object in saved filter items and create new row
			
			savedFilterItems[savedFilterItems.length] = newItem;
			// update hash
			util.createHash(savedFilterItems, 'id');
			
			// Insert new row in saved filters as first row
			
			globalFilter.insertSavedFilterRow('saved_fi', newItem);
			globalFilter.isModifiedSavedFilterItems = true;
		}
		else {
			// The item already exists in savedFilterItems. We set the existing
			// item to isActive only in case that the moved item is active. Else
			// we keep the isActive state of the existing item.
			
			if (newItem.isActive) {
				existingItem.isActive = true;
			}
		}
		
		// Set controls state
		globalFilter.setControlsState();
	},
	
	sortSavedFilters: function() {
		
		globalFilter.buildSavedFilterRows(globalFilter.savedFilterItems, globalFilter.savedFilterGroups);
	},
	
	newFilterItem: function() {
		
		globalFilter.createNewFilterItem(false, '');
	},
	
	newFilterItemInGroup: function() {
		
		// alert('newFilterItemInGroup: ' + this.id);
		var elementId = this.id;
		var dat = elementId.split(':');
		var groupItemId = dat[2];
		
		globalFilter.createNewFilterItem(true, groupItemId);
	},
	
	
	createNewFilterItem: function(isItemInGroup, groupItemId) {
		
		var isActive = isItemInGroup ? false : true;
		var isNew = true;
		
		var item = {
			id: '', // new ID is assigned upon saving the item
			isNegated: false,
			filterType: 'field',
			fieldName: '',
			expressionType: '',
			itemValue: ''
		};
		
		filterItem.open(item, isActive, isNew, isItemInGroup, groupItemId);
	},
	
	editFilterItem: function() {
	
		// alert('editFilterItem: ' + this.id);
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var idPrefix = dat[0];
		var itemId = dat[2];
		var isItemInGroup = (idPrefix == 'saved_fgfi') ? true : false;
		// util.showObject(globalFilter.savedFilterItems);
		
		var item;
		var isActive = false;
		var isNew = false;
		var groupItemId = '';
		
		if (!isItemInGroup) {
		
			// var item = util.getArrayObject(globalFilter.savedFilterItems, 'id', itemId);
			var savedFilterItems = globalFilter.savedFilterItems;
			
			var item = savedFilterItems[h(itemId)];
			isActive = item.isActive;
		}
		else {
			// This is an item in group
			
			var savedFilterGroups = globalFilter.savedFilterGroups;
			isItemInGroup = true;
			// get the groupID and item
			
			for (var i = 0; i < savedFilterGroups.length; i++) {
				var items = savedFilterGroups[i].items;
				for (var j = 0; j < items.length; j++) {
					if (items[j].id == itemId) {
						groupItemId = savedFilterGroups[i].id;
						item = items[j];
					}
				}
			}
		}
		
		// alert('groupItemId: ' + groupItemId);
		// util.showObject(item);
		
		filterItem.open(item, isActive, isNew, isItemInGroup, groupItemId);
	},
	
	saveFilterItem: function(item, isNew, isItemInGroup, groupItemId) {
		
		// Invoked from filterItem.js!
		// If not isNew then item replaces the existing item (in this case item contains the original itemId!)
		
		// Add the label
		globalFilter.addFilterItemLabel(item);
		
		
		// Handle itemId
		var itemId;
		if (!isNew) {
			itemId = item.id;
		}
		else {
			itemId = globalFilter.getNewItemId();
			item.id = itemId;
		}
		
		if (!isItemInGroup) {
		
			var savedFilterItems = globalFilter.savedFilterItems;
			
			// If not new item replace the existing item and update the label
			if (!isNew) {
				
				// Get the index of the item to be replaced
				var itemIndex = util.getArrayObjectIndex(savedFilterItems, 'id', itemId);
				
				// alert('itemIndex: ' + itemIndex);
				
				savedFilterItems.splice(itemIndex, 1, item);
				var labelId = 'saved_fi:label:' + itemId;
				util.updateT(labelId, item.label);
			}
			else {
				
				// Insert new item as first item in array
				savedFilterItems.splice(0, 0, item);
				
				// Insert new item row
				globalFilter.insertSavedFilterRow('saved_fi', item);
				
				// util.showObject(item);
			}
			
			// Update hash.
			util.createHash(savedFilterItems, 'id');
			
			globalFilter.isModifiedSavedFilterItems = true;
		
			// check savedFilterItems
			/*
			for (var i = 0; i < savedFilterItems.length; i++) {
				util.showObject(savedFilterItems[i]);
			}
			*/
			
		}
		else {
			
			// This is an item in a group
			var savedFilterGroups = globalFilter.savedFilterGroups;
			var groupItem = savedFilterGroups[h(groupItemId)];
			var groupItems = groupItem.items;
			
			if (!isNew) {
				
				// Get the index of the item to be replaced
				var itemIndex = util.getArrayObjectIndex(groupItems, 'id', itemId);
				
				groupItems.splice(itemIndex, 1, item);
				var labelId = 'saved_fgfi:label:' + itemId;
				util.updateT(labelId, item.label);
			}
			else {
				
				// Insert new item as first item in group
				groupItems.splice(0,0, item);
				
				// Insert new item row
				globalFilter.insertSavedFilterRow('saved_fgfi', item, groupItemId);
				
				// Handle group expansion
				if (groupItems.length > 1) {
					
					// expand the group if it is not yet expanded 
					if (!groupItem.isExpanded) {
						globalFilter.expandCollapseGroupById(groupItemId);
					}
				}
				else {
					// first item has been added to group, update group state
					globalFilter.updateGroupState(groupItemId, false);
				}
				
				// Show the item row
				util.showE('saved_fgfi:row:' + itemId);
			}
			
			// Update hash.
			util.createHash(savedFilterGroups, 'id');
			
			globalFilter.isModifiedSavedFilterGroups = true;
		}
		
		// Update control state
		globalFilter.setControlsState();
	},
	
	newFilterGroup: function() {
		
		filterGroup.open('', '', true, false);
	},
	
	
	editFilterGroup: function() {
		
		// alert('editFilterGroup: ' + this.id);
		var elementId = this.id;
		var dat = elementId.split(':');
		var itemId = dat[2];
		var savedFilterGroups = globalFilter.savedFilterGroups;
		var groupLabel = savedFilterGroups[h(itemId)].label;
		
		filterGroup.open(itemId, groupLabel, false, false);
	},
	
	saveFilterGroup: function(itemId, groupName, groupLabel, isNew) {
		
		var savedFilterGroups = globalFilter.savedFilterGroups;
		
		if (!isNew) {
			
			var group = savedFilterGroups[h(itemId)];
			group.name = groupName;
			group.label = groupLabel;
			// Update label
			util.updateT('saved_fg:label:' + itemId, groupLabel);
		}
		else {
			
			var newGroupId = globalFilter.getNewItemId();
			var newGroup = {
				id: newGroupId,
				name: groupName,
				label: groupLabel,
				isActive: false,
				items: []
			};
			
			//
			// Add newGroup to savedFilterGroups
			// 
			
			savedFilterGroups[savedFilterGroups.length] = newGroup;
			// update hash
			util.createHash(savedFilterGroups, 'id');
			
			
			// Create the group row
			var groupHasItems = false;
			globalFilter.insertSavedFilterRow('saved_fg', newGroup, '', groupHasItems);
		}
			
		globalFilter.isModifiedSavedFilterGroups = true;
	},
	
	deleteFilter: function() {
		
		// Delete filter item or group
		// alert('deleteFilter: ' + this.id);
		var elementId = this.id;
		var dat = elementId.split(':');
		var idPrefix = dat[0];
		var itemId = dat[2];
		var rowElementId = idPrefix + ':row:' + itemId;
		var containerId = 'gf:saved_filters:container'; // default for all saved filters
		
		var filtersArray;
		
		switch (idPrefix) {
			
			case 'just_added_fi':
				containerId = 'gf:just_added_filter_items:container';
				filtersArray = globalFilter.justAddedFilterItems;
				break;
			
			case 'saved_fi':
				filtersArray = globalFilter.savedFilterItems;
				globalFilter.isModifiedSavedFilterItems = true;
				break;
				
			case 'saved_fg':
				filtersArray = globalFilter.savedFilterGroups;
				
				// delete all filter item rows of the group before we delete the group object and group row
				var savedFilterGroups = globalFilter.savedFilterGroups;
				var tbodyOfGroupItems = util.getE('gf:saved_filters:container');
				var items = savedFilterGroups[h(itemId)].items;
				
				for (var i = 0; i < items.length; i++) {
					var groupItemRowId = 'saved_fgfi' + ':row:' + items[i].id;
					var groupItemRow = util.getE(groupItemRowId);
					tbodyOfGroupItems.removeChild(groupItemRow);
				}
				
				globalFilter.isModifiedSavedFilterGroups = true;
				break;
				
			case 'saved_fgfi': // filter item in filter group
				
				// We need to get the items array of the filterGroup, find it
				var savedFilterGroups = globalFilter.savedFilterGroups;
				for (var i = 0; i < savedFilterGroups.length; i++) {
					var savedFilterGroup = savedFilterGroups[i];
					var items = savedFilterGroup.items;
					for (var j = 0; j < items.length; j++) {
						if (items[j].id == itemId) {
							filtersArray = items;
							var filterGroupItemId = savedFilterGroup.id;
							break;
						}
					}
				}
				
				// if this is the last item in the group we need to update
				// the folder icon and disable the checkbox
				if (filtersArray.length == 1) {
					globalFilter.updateGroupState(filterGroupItemId, true);
				}
				
				globalFilter.isModifiedSavedFilterGroups = true;
				break;
				
			case 'recently_added_fi':
				containerId = 'gf:recently_added_filter_items:container';
				filtersArray = globalFilter.recentlyAddedFilterItems;
				globalFilter.isModifiedRecentlyAddedFilterItems = true;
				break;
		}
		
		// Delete the row
		var tbody = util.getE(containerId);
		var row = util.getE(rowElementId);
		tbody.removeChild(row);
		
		// Delete the object in corresponding filters array
		util.deleteArrayObject(filtersArray, 'id', itemId);
		
		// Update controls
		
		globalFilter.setControlsState();
	},
	
	updateGroupState: function(itemId, isDisable) {
		// Invoked if 
		// a.) The last item in a group becomes deleted.
		// We need to display the empty group folder icon and disable the checkbox
		// b.) The first item is added to a group
		// We automatically expand the group, display the expanded group folder
		// and enable the checkbox
		
		var savedFilterGroups = globalFilter.savedFilterGroups;
		var group = savedFilterGroups[h(itemId)];
		var imgId = 'saved_fg:img:' + itemId;
		// var img = util.getE(imgId);
		var input = util.getE('saved_fg:cb:' + itemId);
		
		if (isDisable) {
		
			group.isActive = false;
			group.isExpaned = false;
			// img.src = imgDb.gfEmptyGroup.src;
			input.checked = false;
			input.disabled = true;
		}
		else {
			group.isExpaned = true;
			// img.src = imgDb.gfExpanded.src;
			input.disabled = false;
		}
		
		setTimeout("globalFilter.updateGroupStateImage('" + imgId + "'," + isDisable + ")", 10);
	},
	
	updateGroupStateImage: function(imgId, isDisable) {
		// IE does not display the image if it is set without delay
		var img = util.getE(imgId);
		
		if (isDisable) {
			yEvent.removeListener(img, 'click', globalFilter.expandCollapseGroup);
			img.src = imgDb.gfEmptyGroup.src;
		}
		else {
			yEvent.addListener(img, 'click', globalFilter.expandCollapseGroup);
			img.src = imgDb.gfExpanded.src;
		}
	
		
		// img.src = isDisable ? imgDb.gfEmptyGroup.src : imgDb.gfExpanded.src;
	},
	
	expandCollapseGroup: function() {
		
		// alert('expandCollapseGroup(): ' + this.id);
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var itemId = dat[2];
		
		globalFilter.expandCollapseGroupById(itemId);
	},
	
	expandCollapseGroupById: function(itemId) {
		
		var savedFilterGroups = globalFilter.savedFilterGroups;
		var group = savedFilterGroups[h(itemId)];
		var isExpanded = group.isExpanded;
		var items = group.items;
		
		var img = util.getE('saved_fg:img:' + itemId);
		img.src = isExpanded ? imgDb.gfCollapsed.src : imgDb.gfExpanded.src;
		
		for (var i = 0; i < items.length; i++) {
			// util.showObject(items[i]);
			var rowId = 'saved_fgfi:row:' + items[i].id;
			util.showE(rowId, !isExpanded);
		}
		
		group.isExpanded = !isExpanded;
	},
	
	//
	//
	//
	// Handle Save Checked as New Group
	//
	//
	//
	
	
	saveCheckedAsNewGroup: function() {
		
		filterGroup.open('', '', true, true);
	},
	
	
	
	saveCheckedAs: function() {
				
		var filterLabel = util.getF('save_checked_filters_as_name');
		
		// alert('Filter name');
		
		if (filterLabel != '') {
			
			// Check for duplicate filter name
			
			isDuplicateLabel = false;
			var filterNameItems = [];
			
			var savedFilterGroups = globalFilter.savedFilterGroups;
			
			filterLabelLowerCase = filterLabel.toLowerCase();
			
			for (var i = 0; i < savedFilterGroups.length; i++) {
				
				var existingFilterLabel = savedFilterGroups[i].label;
				
				if (existingFilterLabel.toLowerCase() == filterLabelLowerCase) {
					isDuplicateLabel = true;
				}
				
				filterNameItems[i] = savedFilterGroups[i].name;
			}
			
			
			if (!isDuplicateLabel) {
				
				var filterName = util.labelToUniqueNodeName(filterLabel, filterNameItems, 'filter');
				globalFilter.saveCheckedFilters(filterName, filterLabel);
			}
			else {
				
				if (confirm(langVar('lang_stats.global_filter.confirm_existing_filter_replacement_message'))) {
				
					// KHP-RC, Delete existing filter
					alert('Replace existing filter');
					
					return false;
				}
			}
		}
		else {
			
			alert(langVar('lang_stats.global_filter.missing_filter_name_message'));
		}
	},
		
	collectCheckedFilterItems: function(newFilterItemsByString, newFilterItems, theFilters, isFilterGroups) {
		
		for (var i = 0; i < theFilters.length; i++) {
			
			if (theFilters[i].isActive) {
				
				if (!isFilterGroups) {
					globalFilter.addCheckedFilterItem(newFilterItemsByString, newFilterItems, theFilters[i]);
				}
				else {
					
					// Add each item of the filter group
					var items = theFilters[i].items;
					
					for (var j = 0; j < items.length; j++) {
						
						globalFilter.addCheckedFilterItem(newFilterItemsByString, newFilterItems, items[j]);
					}
				}
			}
		}
		
		// util.showObject(newFilterItems);
	},
	
	addCheckedFilterItem: function(newFilterItemsByString, newFilterItems, filterItem) {
		
		// Adds the filterItem to newFilterItems if it doesn't yet exist
		// Create string of item to check for duplicates. Note, we ignore the isNegated state in the string
	
		var filterType = filterItem.filterType;
		var s = filterType;
		
		if (filterType == 'field') {
			s += filterItem.fieldName;
			s += filterItem.expressionType;
		}
		else if (filterType == 'expression') {
			s += filterItem.label;
		}
		
		s += filterItem.itemValue;
		
		// Check if item already exists
		var itemExists = false;
		for (var i = 0; i < newFilterItemsByString.length; i++) {
			if (s == newFilterItemsByString[i]) {
				itemExists = true;
				break;
			}
		}
		
		// Add item if it does not yet exist
		if (!itemExists) {
			
			var newFilterItem = util.cloneObject(filterItem);
			
			// give the item a new id
			newFilterItem.id = globalFilter.getNewItemId();
			
			newFilterItems[newFilterItems.length] = newFilterItem;
			newFilterItemsByString[newFilterItemsByString.length] = s;
		}
	},
	
	saveCheckedAsNewGroupProcessing: function(groupName, groupLabel) {
		
		// Create new group from checked saved filter items and filter groups.
		
		var newFilterItemsByString = [];
		var newFilterItems = [];
		
		var savedFilterItems = globalFilter.savedFilterItems;
		var savedFilterGroups = globalFilter.savedFilterGroups;
		
		globalFilter.collectCheckedFilterItems(newFilterItemsByString, newFilterItems, savedFilterItems, false);
		globalFilter.collectCheckedFilterItems(newFilterItemsByString, newFilterItems, savedFilterGroups, true);

		// util.showObject(newFilterItemsByString);
		
		// Sort the new Items
		savedFilterItems.sort(globalFilter.compareLabels);
	
		//
		// Setup new filter group
		//
		
		var newGroupId = globalFilter.getNewItemId();
		var newGroup = {
			id: newGroupId,
			name: groupName,
			label: groupLabel,
			isActive: false,
			items: newFilterItems
		};
		
		
		//
		// Add newGroup to savedFilterGroups
		// 
		
		savedFilterGroups[savedFilterGroups.length] = newGroup;
		// update hash
		util.createHash(savedFilterGroups, 'id');
		
		
		// Create the group row
		var groupHasItems = true;
		globalFilter.insertSavedFilterRow('saved_fg', newGroup, '', groupHasItems);
		
		// Create the filter item rows of the group.
		// Insert them in reverse order because items are inserted as ascendant of the group!
		// alert(newFilterItems.length);
		// util.showObject(newFilterItems);
		
		for (var i = newFilterItems.length - 1; i >= 0; i--) {
			
			// util.showObject(newFilterItems[i]);
			globalFilter.insertSavedFilterRow('saved_fgfi', newFilterItems[i], newGroupId);
		}
		
		globalFilter.isModifiedSavedFilterGroups = true;
				
		// util.hideE('save_checked_filters_as_section');
	},
		
	
	toggleFilterActiveState: function() {
		
		// alert(this.id);
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var idPrefix = dat[0];
		var itemId = dat[2];
		
		var isChecked = this.checked;
		
		var filtersArray;
		
		switch (idPrefix) {
			
			case 'just_added_fi':
				filtersArray = globalFilter.justAddedFilterItems;
				break;
			
			case 'recently_added_fi':
				filtersArray = globalFilter.recentlyAddedFilterItems;
				break;
				
			case 'saved_fg':
				filtersArray = globalFilter.savedFilterGroups;
				break;
				
			default:
				filtersArray = globalFilter.savedFilterItems;
				break;
		}
		
		var item = filtersArray[h(itemId)];
		item.isActive = isChecked;
		
		globalFilter.setControlsState();
	},
	
	
	saveFiltersDbAddItem: function(pathName, item, isItemInGroup) {
		
		var dat = '';
		var filterType = item.filterType;
		
		if (!isItemInGroup) {
			
			dat += pathName + '.is_active=' + item.isActive + '&';
		}
		
		dat += pathName + '.filter_type=' + filterType + '&';
		
		if (filterType == 'field') {
			
			dat += pathName + '.field_name=' + item.fieldName + '&';
			dat += pathName + '.expression_type=' + item.expressionType + '&';
		}
		
		if (filterType != 'expression') {
			
			dat += pathName + '.is_negated=' + item.isNegated + '&';
		}
		else {
			
			dat += pathName + '.label=' + encodeURIComponent(item.label) + '&';
		}
		
		dat += pathName + '.item_value=' + encodeURIComponent(item.itemValue) + '&';
		
		return dat;
	},
	
	saveFiltersDb: function() {
		
		var url = '?dp+statistics.filters.global_filter.save_filters_db';
		url += '+p+' + reportInfo.profileName;
		
		var justAddedFilterItems = globalFilter.justAddedFilterItems;
		var savedFilterItems = globalFilter.savedFilterItems;
		var savedFilterGroups = globalFilter.savedFilterGroups;
		var recentlyAddedFilterItems = globalFilter.recentlyAddedFilterItems;
			
		isModifiedSavedFilterItems = globalFilter.isModifiedSavedFilterItems;
		isModifiedSavedFilterGroups = globalFilter.isModifiedSavedFilterGroups;
		isModifiedRecentlyAddedFilterItems = globalFilter.isModifiedRecentlyAddedFilterItems;
		
		var dat = 'v.sys.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.sys.is_modified_saved_filter_items=' + isModifiedSavedFilterItems + '&';
		dat += 'v.sys.is_modified_saved_filter_groups=' + isModifiedSavedFilterGroups + '&';
		dat += 'v.sys.is_modified_recently_added_filter_items=' + isModifiedRecentlyAddedFilterItems + '&';
		
		// 
		// 
		// Handle justAddedFilterItems
		//
		// 
		
		if (globalFilter.isJustAddedFilterItems && justAddedFilterItems.length > 0) {
			
			for (var i = 0; i < justAddedFilterItems.length; i++) {
				var item = justAddedFilterItems[i];
				dat += globalFilter.saveFiltersDbAddItem('v.sys.just_added_filter_items.' + i, item, false);
			}
		}
		else {
			dat += 'v.sys.just_added_filter_items=&';
		}
		
		// 
		// 
		// Handle savedFilterItems
		//
		// 
		
		// If not modified we only send the active items, else we send all items.
		
		var savedFilterItemsDat = '';
		
		for (var i = 0; i < savedFilterItems.length; i++) {
			
			var item = savedFilterItems[i];
			if (isModifiedSavedFilterItems || item.isActive) {
				savedFilterItemsDat += globalFilter.saveFiltersDbAddItem('v.sys.saved_filter_items.' + i, item, false);
			}
		}
		
		dat += (savedFilterItemsDat != '') ? savedFilterItemsDat : 'v.sys.saved_filter_items=&';
		
		// alert('savedFilterItemsDat length: ' + savedFilterItemsDat.length + '\nstring: ' + savedFilterItemsDat);
		
		// 
		// 
		// Handle savedFilterGroups
		//
		// 
		
		// If not modified we only send the group name and is_active node, else we send all details
		
		var savedFilterGroupsDat = '';
		
		for (var i = 0; i < savedFilterGroups.length; i++) {
			
			var filterGroup = savedFilterGroups[i];
			var isActive = filterGroup.isActive;
			
			if (isModifiedSavedFilterGroups || isActive) {
				
				var group_path = 'v.sys.saved_filter_groups.' + i;
				
				savedFilterGroupsDat += group_path + '.name=' + filterGroup.name + '&';
				savedFilterGroupsDat += group_path + '.is_active=' + isActive + '&';
				
				if (isModifiedSavedFilterGroups) {
					
					// We send all details
					savedFilterGroupsDat += group_path + '.label=' + filterGroup.label + '&';
					
					var items = filterGroup.items;
					
					// Note, we allow to save empty filterGroups!
					
					if (items.length > 0) {
						for (var j = 0; j < items.length; j++) {
							var item = items[j];
							var itemPath = group_path + '.filter_items.' + j;
							savedFilterGroupsDat += globalFilter.saveFiltersDbAddItem(itemPath, item, true);
						}
					}
					else {
						
						savedFilterGroupsDat += group_path + '.filter_items=&';
					}
				}
			}
			
			// alert('savedFilterGroupsDat per iteration length: ' + savedFilterGroupsDat.length + '\nstring: ' + savedFilterGroupsDat);
		}
		
		dat += (savedFilterGroupsDat != '') ? savedFilterGroupsDat : 'v.sys.saved_filter_groups=&';
		
		
		// 
		// 
		// Handle recentlyAddedFilterItems
		//
		// 
		
		// If not modified we only send the active items, else we send all items.
		
		var recentlyAddedFilterItemsDat = '';
		
		for (var i = 0; i < recentlyAddedFilterItems.length; i++) {
			
			var item = recentlyAddedFilterItems[i];
			
			if (isModifiedRecentlyAddedFilterItems || item.isActive) {
				recentlyAddedFilterItemsDat += globalFilter.saveFiltersDbAddItem('v.sys.recently_added_filter_items.' + i, item, false);
			}
		}
		
		dat += (recentlyAddedFilterItemsDat != '') ? recentlyAddedFilterItemsDat : 'v.sys.recently_added_filter_items=&';
		
		
		//
		//
		// Send data
		//
		//
		
		// TEMP TEST
		
		// stringLength = dat.length;
		// var s = dat.substring(stringLength -100);
		// alert('dat lengh: ' + stringLength + '\nLast 100 characters:' + s);
		
		dat = dat.replace(/&$/, '');
		
		// alert(dat);
		
		util.serverPost(url, dat);
	},
	
	saveFiltersDbResponse: function(filterId) {
		
		// alert('saveFiltersDbResponse, filterId: ' + filterId);

		globalFilter.panel.close();
				
		if (newReport.filterId != filterId) {
			
			// Apply the filter
			newReport.filterId = filterId;
			newReport.request();
		}
	},
	
	selectAll: function() {
		
		globalFilter.selectDeselectAll(this.id, true);
	},
	
	deselectAll: function() {
		
		globalFilter.selectDeselectAll(this.id, false);
	},
	
	selectDeselectAll: function(elementId, checkItems) {
		
		var dat = elementId.split(':');
		var domain = dat[1];
		
		if (domain == 'just_added_filter_items') {
			
			globalFilter.checkUncheckItems(globalFilter.justAddedFilterItems, 'just_added_fi', checkItems);
		}
		else if (domain == 'saved_filters') {
			
			globalFilter.checkUncheckItems(globalFilter.savedFilterItems, 'saved_fi', checkItems);
			globalFilter.checkUncheckItems(globalFilter.savedFilterGroups, 'saved_fg', checkItems);
		}
		else {
			// recently_added_filter_items
			globalFilter.checkUncheckItems(globalFilter.recentlyAddedFilterItems, 'recently_added_fi', checkItems);
		}
		
		// just_added_fi | saved_fi | saved_fg
		
		globalFilter.setControlsState();
	},
	
	checkUncheckItems: function(items, idPrefix, checkItems) {
		
		for (var i = 0; i < items.length; i++) {
			items[i].isActive = checkItems;
			util.setF(idPrefix + ':cb:' + items[i].id , checkItems);
		}
	},
	
	getFilterItemString: function(filterItem) {
		
		// returns a filterItem as string without isActive state,
		// it is used to check for existing filter items.
		
		var filterType = filterItem.filterType;
		var s = filterType;
		
		if (filterType == 'field') {
			s += filterItem.fieldName;
			s += filterItem.expressionType;
		}
		
		if (filterType == 'expression') {
			s += filterItem.label;
		}
		else {
			s += filterItem.isNegated;
		}
		
		s += filterItem.itemValue;
	
		return s;
	},
	
	getGroupValuesByKey: function(key, activeItemId) {
		
		// Invoked from filterGroup.js!
		// Create an array of group labels or group names with all labels/names, except for activeItemId.
		// activeItemId is empty '' for new groups
		
		var savedFilterGroups = globalFilter.savedFilterGroups;
		var a = [];
		
		for (var i = 0; i < savedFilterGroups.length; i++) {
			if (savedFilterGroups[i].id != activeItemId) {
				var s = savedFilterGroups[i][key];
				a[a.length] = s;
			}
		}
		
		return a;
	},
	
	setTableWidth: function(tbodyId, tableWidth) {
		
		// Sets the width of the table of tbodyId. We use the elementId of tbody to avoid a separate tableID
		var tbody = util.getE(tbodyId);
		var table = tbody.parentNode;
		table.style.width = tableWidth;
	},
	
	compareLabels: function(a, b) {
		// used by array sort() 
		var labelA = a.label.toLowerCase();
		var labelB = b.label.toLowerCase();
		
		// alert('compareLabels\nlabelA: ' + labelA + '\nlabelB: ' + labelB);
		
		if (labelA < labelB) {
			return -1;
		}
		else if (labelA > labelB) {
			return 1;
		}
		else {
			return 0;
		}
	}
};
