//
// macroItem.js (Create New Macro panel)
//
//

var macroItem = {
	
	panel: null,
	validator: null,
	
	activeMacro: {},
	
	/*
		
		name: '', 	// macro node name, is set after saving the macro
		label: '',
		
		
		rn: '', 	// report_name
		df: '', 	// date_filter
		fi: '', 	// filter_id
		f: '', 		// url/command_line filter
		fc: '' 		// filters_comment
	},
	*/
	
	init: function() {
	
		var panelObj = {
			panelId: 'macro_item:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.macros.create_new_macro'),
			left: 100,
			top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: macroItem.close
		};
		
		macroItem.panel = new util.Panel3(panelObj);
		macroItem.validator = new util.Validator();
		
		yEvent.addListener(['macro_item:open_report_btn', 'macro_item:apply_date_btn', 'macro_item:apply_filters_btn'], 'click', macroItem.updateSaveButtonState);
		
		yEvent.addListener('macro_item:ok_btn', 'click', macroItem.saveMacroItem);
		yEvent.addListener('macro_item:cancel_btn', 'click', macroItem.close);
	},
	
	open: function() {
		
		if (!macroItem.panel) {
			macroItem.init();
		}
		
		macroItem.validator.reset();
		
		macroItem.updateForm();
		macroItem.updateSaveButtonState();
		
		macroItem.panel.open();
	},
	
	close: function() {
		
		macroItem.panel.close();
	},
	
	updateSaveButtonState: function() {
		
		// We allow to save a Macro only if one of the actions is checked.
		var makeEnabled = util.getF('macro_item:open_report_btn') || util.getF('macro_item:apply_date_btn') || util.getF( 'macro_item:apply_filters_btn'); 
		util.enableE('macro_item:ok_btn', makeEnabled);
	},
	
	updateForm: function() {
		
		// Reset/set form data
		
		var isDateTimeSupport = reportInfo.isDateTimeSupport;
		
		util.setF('macro_item:label', '');
		util.setF('macro_item:open_report_btn', true);
		
		util.setF('macro_item:apply_date_btn', isDateTimeSupport);
		util.setF('macro_item:apply_filters_btn', true);
		
		var isDateFilter = (isDateTimeSupport && reportInfo.dateFilter != '');
		var isFilters = (reportInfo.filterId != '' || reportInfo.commandLineFilter != '');
		
		util.showE('macro_item:apply_date_section', isDateTimeSupport);
		
		util.showEV('macro_item:entire_date_range_label', !isDateFilter);
		util.showEV('macro_item:no_filters_label', !isFilters);
	},
	
	
	saveMacroItem: function() {
		
		var validator = macroItem.validator;
		
		validator.reset();
		
		//
		// Reset activeMacro object
		//
		var activeMacro = {};
		
		var label = validator.isValue('macro_item:label');
		activeMacro.name = '';
		activeMacro.label = label;
		
		//
		// Check if the report name is part of the macro
		//
		
		if (util.getF('macro_item:open_report_btn')) {
			activeMacro.rn = reportInfo.reportName;
		}
		
		//
		// Check if the date filter is part of the macro
		//
		
		if (util.getF('macro_item:apply_date_btn')) {
			// KHP-RC, we need to distinguish between relative and absolute dates
			activeMacro.df = reportInfo.dateFilter;
		}
		
		//
		// Check if the filters are part of the macro
		//
		
		if (util.getF('macro_item:apply_filters_btn')) {
		
			activeMacro.fi = reportInfo.filterId;
			activeMacro.f = reportInfo.commandLineFilter;
			activeMacro.fc = reportInfo.commandLineFilterComment;
		}
	
		if (validator.allValid()) {
			
			macroItem.activeMacro = activeMacro;
		
			// Check for duplicate label
			var macrosDb = reportInfo.macros;
			
			var isDuplicateLabel = false;
			var isReplaceExistingMacro = false;
			var existingMacroName = '';
			
			for (var i = 0; i < macrosDb.length; i++) {
				
				if (macrosDb[i].label == label) {
					existingMacroName = macrosDb[i].name;
					isDuplicateLabel = true;
					isReplaceExistingMacro = confirm(langVar('lang_stats.macros.confirm_macro_replacement_message'));
					break;
				}
			}
			
			if (!isDuplicateLabel || isReplaceExistingMacro) {
			
				//
				// Save the macro
				//
			
				var url = '?dp+statistics.macros.save_macro_item';
				url += '+p+' + reportInfo.profileName;
				
				var dat = 'v.sys.page_token=' + reportInfo.pageToken;
				dat += '&v.sys.is_replace_existing_macro=' + isReplaceExistingMacro;
				dat += '&v.sys.existing_macro_name=' + existingMacroName;
				
				// Add the new macro item object
				
				for (prop in activeMacro) {
					dat += '&v.sys.new_macro_item.' + prop + '=' + encodeURIComponent(activeMacro[prop]);
				}
				
				util.serverPost(url, dat);
			}
		}
	},
	
	saveMacroItemResponse: function(dat) {
		
		var isReplaceExistingMacro = dat.isReplaceExistingMacro;
		var replacementFailed = false; // In case that the item has not been replaced
		
		var newMacroName = dat.newMacroName;
		
		var activeMacro = macroItem.activeMacro;
		var macrosDb = reportInfo.macros;
		
		var newMacroItem = util.cloneObject(activeMacro);
		newMacroItem.name = newMacroName;
		
		if (isReplaceExistingMacro) {
			
			// Find replaceIndex
			var replaceIndex = -1;
			
			for (var i = 0; i < macrosDb.length; i++) {
				
				if (macrosDb[i].name == newMacroName) {
					replaceIndex = i;
					break;
				}
			}
			
			if (replaceIndex != -1) {
				macrosDb.splice(replaceIndex, 1, newMacroItem);
			}
			else {
				replacementFailed = true;
			}
		}
		
		
		if (!isReplaceExistingMacro || replacementFailed) {
			
			// Add new macro as last item
			macrosDb[macrosDb.length] = newMacroItem;
		}
		
		// Update Macros list
		report.macros.updateList();
		
		macroItem.panel.close();
	}
}
