//
// manageMacros.js
//
//

var manageMacros = {
	
	panel: null,
	moveControl: null,
	macrosDb: [],
	
	selectedItemIndex: -1,
	isDisabledOkBtn: true,
	
	init: function() {
	
		var panelObj = {
			panelId: 'manage_macros:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.macros.manage_macros'),
			left: 100,
			top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: manageMacros.close
		};
		
		manageMacros.panel = new util.Panel3(panelObj);
		manageMacros.moveControl = new util.MoveControl('macros_move_control', manageMacros.moveItem);
		
		
		yEvent.addListener('manage_macros:table', 'click', manageMacros.itemActivated);
		
		yEvent.addListener('manage_macros:ok_btn', 'click', manageMacros.saveMacros);
		yEvent.addListener('manage_macros:cancel_btn', 'click', manageMacros.close);
	},
	
	open: function() {
		
		if (!manageMacros.panel) {
			manageMacros.init();
		}

		manageMacros.updateForm();
		// manageMacros.updateSaveButtonState();
		
		
		manageMacros.panel.open();
	},
	
	close: function() {
		
		manageMacros.panel.close();
	},
	
	
	updateForm: function() {
		
		// Get a clone of reportInfo.macros
		var macrosDbOri = reportInfo.macros;
		var isMacroItems = (macrosDbOri.length > 0);
		var macrosDb = isMacroItems ? util.cloneObject(macrosDbOri) : [];
		
		manageMacros.macrosDb = macrosDb;
		manageMacros.selectedItemIndex = -1;
		
		util.showE('manage_macros:table', isMacroItems);
		util.showE('manage_macros:no_macros_info', !isMacroItems);
		
		// Disable the ok button until something becomes edited
		util.disableE('manage_macros:ok_btn');
		manageMacros.isDisabledOkBtn = true;
		
		if (isMacroItems) {
			manageMacros.buildList();
		}
	},
	
	setIsModifiedState: function() {
		
		// Enable the OK button if it is not yet enabled
		if (manageMacros.isDisabledOkBtn) {
			util.enableE('manage_macros:ok_btn');
			manageMacros.isDisabledOkBtn = false;
		}
	},
	
	itemActivated: function(evt) {
		
		var element = evt.target || evt.srcElement;
		// var elementId = element.id;
		
		// alert('listcontrollerB.List.prototype.itemListActivated - elementId: ' + elementId);
		// alert('element.nodeName: ' + element.nodeName);
		
		var tagName = element.nodeName;
		
		if (tagName == 'TH' || tagName == 'A') {
			
			// alert('tagName: ' + tagName);
			
			var tbody;
			
			// Get the row/item index of the clicked item
			var trElement;
			if (tagName == 'TH') {
				trElement = element.parentNode;
			}
			else {
				tdElement = element.parentNode;
				trElement = tdElement.parentNode;
			}
			
			var itemIndex = 0;
			var previousTrElement = trElement.previousSibling;
			
			while (previousTrElement) {
				itemIndex += 1;
				previousTrElement = previousTrElement.previousSibling;
			}
			
			// alert('itemIndex: ' + itemIndex);
			
			var selectedItemIndex = manageMacros.selectedItemIndex;
			
			
			if (tagName == 'TH') {
				
				// Select/Deselect the item
				
				if (selectedItemIndex == itemIndex) {
					
					// Deselect current row
					trElement.className = '';
					manageMacros.selectedItemIndex = -1;
				}
				else {
					
					if (selectedItemIndex != -1) {
						
						// Deselect previous selected row
						tbody = util.getE('manage_macros:tbody');
						var allRows = tbody.getElementsByTagName('tr');
						var selectedRow = allRows[selectedItemIndex];
						selectedRow.className = '';
					}
					
					// Select activated row
					trElement.className = 'manage-macros-select';
					
					manageMacros.selectedItemIndex = itemIndex;
				}
			}
			else {
				
				// Delete the item
				
				// Delete row
				tbody = util.getE('manage_macros:tbody');
				tbody.removeChild(trElement);
				
				// Delete object
				manageMacros.macrosDb.splice(itemIndex, 1);
				
				// Reset selectedItemIndex if the deleted row was selected
				if (selectedItemIndex == itemIndex) {
					manageMacros.selectedItemIndex = -1;
				}
				
				manageMacros.setIsModifiedState();
			}
			
			//
			// Update moveControl state
			//
			
			manageMacros.moveControl.setState(manageMacros.selectedItemIndex, manageMacros.macrosDb.length);
		}
	},
	
	moveItem: function(direction) {
		
		// Invoked from moveControl
		// var direction = manageMacros.moveControl.getMoveDirection(this.id);
		var selectedItemIndex = manageMacros.selectedItemIndex;
		var macrosDb = manageMacros.macrosDb;
		
		// alert('moveItem() - direction: ' + direction);
		
		var movedItemIndex = 0;
		var isUpDirection = false;
		
		switch (direction) {
			
			case 'top': 
				movedItemIndex = 0;
				isUpDirection = true;
				break;
				
			case 'up':
				movedItemIndex = selectedItemIndex - 1;
				isUpDirection = true;
				break;
				
			case 'down':
				movedItemIndex = selectedItemIndex + 1;
				break;
				
			case 'bottom':
				movedItemIndex = macrosDb.length - 1;
				break;
		}
		
		// Move the object in macrosDb
		
		var movedObjArray = macrosDb.splice(selectedItemIndex, 1);
		var movedObj = movedObjArray[0];
		macrosDb.splice(movedItemIndex, 0, movedObj);
		
		//
		// Update the row labels
		//
		
		var updateRowIndexStart = isUpDirection ? movedItemIndex : selectedItemIndex;
		var updateRowIndexEnd = isUpDirection ? selectedItemIndex : movedItemIndex;
		
		var tbody = util.getE('manage_macros:tbody');
		var thElements = tbody.getElementsByTagName('th');
	
		for (var i = updateRowIndexStart; i <= updateRowIndexEnd; i++) {
			
			var th = thElements[i];
			var thText = th.firstChild;			
			thText.nodeValue = macrosDb[i].label;
		}
		
		//
		// Update row selection
		//
		
		var trElements = tbody.getElementsByTagName('tr');
		var tr = trElements[selectedItemIndex];
		tr.className = '';
		
		var trMoved = trElements[movedItemIndex];
		trMoved.className = 'manage-macros-select';
		
		manageMacros.selectedItemIndex = movedItemIndex;
		
		//
		// Update move button state
		//
		manageMacros.moveControl.setState(movedItemIndex, macrosDb.length);
		
		manageMacros.setIsModifiedState();
	},
	
	
	saveMacros: function() {
		
		// alert('saveMacros()');
		
		var macrosDb = manageMacros.macrosDb;
		var dat = 'v.sys.page_token=' + reportInfo.pageToken + '&';
		
		if (macrosDb.length > 0) {
			
			for (var i = 0; i < macrosDb.length; i++) {
				
				var macroItem = macrosDb[i];
				
				// Update macro item name
				macroItem.name = i;
				
				var path = 'v.sys.modified_macros.' + i;
				
				// Add position node for sorting --> position is covered by name property!
				// dat += path + '.position=' + i + '&';
				
				for (var prop in macroItem) {
				
					dat += path + '.' + prop + '=' + encodeURIComponent(macroItem[prop]) + '&';
				}
			}
			
			dat = dat.replace(/&$/, '');
		}
		else {
			dat += 'v.sys.modified_macros=';
		}
		
		var url = '?dp+statistics.macros.save_macros';
		url += '+p+' + reportInfo.profileName;
		
		util.serverPost(url, dat);
	},
	
	saveMacrosResponse: function() {
				
		// Update reportInfo.macros and the macros list with the latest macros object
		
		var macrosDb = util.cloneObject(manageMacros.macrosDb);
		
		reportInfo.macros = macrosDb;
		report.macros.updateList();
		
		manageMacros.close();
	},
	
	
	//
	//
	// List utilities
	//
	//
	
	buildList: function() {
		
		var macrosDb = manageMacros.macrosDb;
		var table = util.getE('manage_macros:table');
		
		// Clean up items list
		util.removeChildElements(table);
		
		var tbodyId = 'manage_macros:tbody';
		var tbody = util.createE('tbody', {id:tbodyId});
		
		for (var i = 0; i < macrosDb.length; i++) {
			
			var itemLabel = macrosDb[i].label;
			
			var tr = util.createE('tr');
			var th = util.createE('th');
			var thText = util.createT(itemLabel);
			
			var td = util.createE('td');
			var a = util.createE('a', {href:'javascript:;'});
			var aText = util.createT(langVar('lang_stats.btn.delete'));
			
			util.chainE(tbody, [tr, [th, thText], [td, [a, aText]]])
		}
		
		util.chainE(table, tbody);
	}
}
