//
// smtp.js (Used in emailReport.js, handles SMTP server editing)
//

var smtp = {
	
	panel: null,
	validator: null
	
};

smtp.init = function() {
	
	var panelObj = {
		panelId:'smtp:panel',
		panelClassName: 'panel-50',
		panelHeaderLabel: langVar('lang_stats.email_report.edit_smtp_server'),
		left: 160,
		top: 70,
		zIndex: 40,
		isCover: true,
		closeEvent: smtp.close
	};

	smtp.panel = new util.Panel3(panelObj);
	smtp.validator = new util.Validator();
	
	smtp.buildForm();
	
	// yEvent.addListener('smtp:ok_btn', 'click', smtp.save);
	// yEvent.addListener('smtp:cancel_btn', 'click', smtp.close);
	
	var okBtn = new util.Button2('smtp:ok_btn', 'btn-50', smtp.save);
	var cancelBtn = new util.Button2('smtp:cancel_btn', 'btn-50', smtp.close);
}

smtp.open = function() {
	
	if (smtp.panel == null) {
		smtp.init();
	}
	else {
		
		// panel has already been opened
		smtp.validator.reset();
	}
	
	// Fix Fireforx overflow bug
	emailReport.addressControl.freezeOverflow();
	
	
	// Set default values
	util.setF('smtp_server', emailReport.smtpServer);
	util.setF('smtp_username', emailReport.smtpUsername);
	util.setF('smtp_password', emailReport.smtpPassword);
	
	smtp.panel.open();
}

smtp.save = function() {
	
	var validator = smtp.validator;
	
	validator.reset();
	var smtpServer = validator.isValue('smtp_server');
	
	if (validator.allValid()) {
		
		emailReport.isSMTPServerEdit = true;
		emailReport.smtpServer = smtpServer;
		emailReport.smtpUsername = util.getF('smtp_username');
		emailReport.smtpPassword = util.getF('smtp_password');
		
		smtp.close();
	}
}

smtp.close = function() {
	
	smtp.panel.close();
	
	emailReport.addressControl.freezeOverflow(false);
}

smtp.buildForm = function() {
	
	var container = util.getE('smtp:container');
	var table = util.createE('table', {cellspacing:0});
	var tbody = util.createE('tbody');
	
	smtp.buildFormRow(tbody, langVar('lang_stats.email_report.smtp_server'), 'smtp_server', 'text', 260, true);
	smtp.buildFormRow(tbody, langVar('lang_stats.email_report.username'), 'smtp_username', 'text', 260, false);
	smtp.buildFormRow(tbody, langVar('lang_stats.email_report.password'), 'smtp_password', 'password', 260, false);
	
	util.chainE(container, table, tbody);
}
	
smtp.buildFormRow = function(tbody, label, id, inputType, inputWidth, isSmtpServerField) {
	
	var tr = util.createE('tr');
	var th = util.createE('th');
	var td = util.createE('td');
	var text = util.createT(label + ':');
	var input =  util.createE('input', {id:id, value:'', type:inputType, width:inputWidth + 'px'});
	
	var lastElement;
	
	if (isSmtpServerField) {
		lastElement = util.createE('div', {id:id + ':error', className:'form-error'});
	}
	else {
		// lastElement = util.createT(' (optional)');
		// TEMP due optional text after input where type is password!
		// KHP-RC, revise above Temp solution
		lastElement = util.createE('span');
	}
	
	util.chainE(tbody, [tr, [th, text], [td, input, lastElement]]);
}
