//
// adminConfig.js
//

adminConfig = {
	
	// getIsModifiedPageHandler is set to a function in Admin and Config pages
	// which checks if a page has been modified or not.
	getIsModifiedPageHandler: null,
	
	init: function() {
		
		// alert('init Admin Config, isAdminPage: ' + pageInfo.isAdminPage);
		
		var navigationElements = ['product_bar', 'admin_config_navbar'];
		
		if (pageInfo.isAdminPage) {
			// init admin nav bar
			util.showE('admin_config_navbar');
			yEvent.addListener('product_support_btn', 'click', adminConfig.openSupportPage);
		}
		else {
			
			// init config nav bar
			
			// Note, the Config - More Options menu may exist or not, it depends on licensing features and RBAC permissions,
			// so we only initialize it if the element exists.
			var moreOptionsBtn = util.getE('admin_config_navbar:more_options:btn');
			
			if (moreOptionsBtn != null) {
				// Enable dropDownMenu
				util.dropDownMenu.add('admin_config_navbar:more_options:btn', 'admin_config_navbar:more_options:ul');
			}
			
			// Add the more_options menu to navigationElements
			navigationElements[navigationElements.length] = 'admin_config_navbar:more_options:ul';
		}
		
		// Assign exitPage event to all header links
		yEvent.addListener(navigationElements, 'click', adminConfig.navigateToPage);
	},
	
	navigateToPage: function(evt) {
		
		// User clicked a link in navigation section.
		// Check for unsaved changes if this is a link which leads to another admin or config page
		
		yEvent.preventDefault(evt);
		
		var element = evt.target || evt.srcElement;

		// The clicked element may be a SPAN or other inline element, so we have to check the parent for anchor as well
		var parentElement = element.parentNode;
	
		if (element.nodeName == 'A' || parentElement.nodeName == 'A') {
			
			var theAnchorElement = (element.nodeName == 'A') ? element : parentElement;
			
			// alert('adminConfig.navigateToPage()');
			var href = theAnchorElement.href;
			
			// alert('anchorHref: ' + anchorHref);
			
			if (href.indexOf('?dp=') != -1 && adminConfig.getIsExitPagePermission()) {
				
				// Follow the link
				location.href = href;
			}
		}
	},
	
	// exitPage: function(anchorHref) {
	getIsExitPagePermission: function() {
		
		// alert('adminConfig.getIsExitPagePermission()');
		
		// Note that we don't need to check for unsaved pages as long as
		// pageInfo.initComplete is set to false!
		
		var activePage = pageInfo.page;
		var exitThePage = true;
		
		if (!pageInfo.initComplete || pageInfo.saveActive) {
			
			// We assume that changes are saved in the background,
			// so we allow to exit the active page if saveActive is true
			exitThePage = true;
			
			// Set pageInfo.exitActive to true so that the page
			// knows it doesn't need to display anything in case
			// that page data are yet loading.
			pageInfo.exitActive = true;
		}
		else {
			
			// Check for unsaved page changes
			// KHP 27/April/2010, "pageInfo.isModified" is no longer available,
			// it has been replaced with the adminConfig.isModifiedPageHandler property
			// if (pageInfo.isModified != null && pageInfo.isModified()) {
			if (adminConfig.getIsModifiedPageHandler != null && adminConfig.getIsModifiedPageHandler()) {
				
				exitThePage = confirm(langVar('lang_admin.general.confirm_unsaved_page_exit'));
			}
			else {
				
				exitThePage = true;
			}
		}
		
		if (exitThePage) {
				
			var menuSectionId = 'admin_config_navbar';
			
			// KHP-RC, instead of hiding the admin_config_toolbar we should disable the toolbar buttons!
			if (util.getE('admin_config_toolbar')) {util.hideEV('admin_config_toolbar');}
			if (util.getE('form_section')) {util.hideE('form_section');}
			if (util.getE('loading_info')) {util.hideE('loading_info');}
			if (util.getE('saving_info')) {util.hideE('saving_info');}
			
			return true;
		}
		
		return false;
	},
	
	setItemListSize: function() {
		
		var activePage = pageInfo.page;
		
		var itemList = util.getE('item_list');
		var itemListBody = util.getE('item_list_body');
		var itemForm = util.getE('item_form');
		
		var clientHeight = YAHOO.util.Dom.getClientHeight();
		var itemFormPos = YAHOO.util.Dom.getXY(itemForm);
		var itemFormY = itemFormPos[1];
		var itemListHeight = clientHeight - itemFormY - 50; // 50 for 50px bottom space
		var itemListWidth = 254; // default
		
		var hasMoveControl = false; // default
		
		var moveButtonsWidth = 13 + 23 + 13; // includes the margins
		
		switch (activePage) {
			
			case 'scheduler':
				// itemListWidth = 285;
				hasMoveControl = true;
				break;
				
			case 'log_filters':
				hasMoveControl = true;
				break;
				
			case 'log_source':
				hasMoveControl = true;
				break;
				
			case 'reports':
				itemListWidth = 275;
				hasMoveControl = true;
				break;
				
			case 'xrefs':
				hasMoveControl = true;
				break;
			
			case 'report_fields':
				hasMoveControl = true;
				break;
		}
		
		var itemListPos = YAHOO.util.Dom.getXY(itemList);
		var itemListBodyPos = YAHOO.util.Dom.getXY(itemListBody);
		var itemListHeaderHeight = itemListBodyPos[1] - itemListPos[1];
		
		// set itemForm left margin
		var itemFormLeftMargin = hasMoveControl ? moveButtonsWidth + itemListWidth + 20 : itemListWidth + 40; // 40 for 20px left margin and 20px right margin
		itemForm.style.marginLeft = itemFormLeftMargin + 'px';
		
		// set itemListMoveButtons size
		if (hasMoveControl) {
			var moveControl = util.getE('item_list_move_control');
			moveControl.style.left = '13px';
			moveControl.style.top = itemFormY + 'px';
		}
		
		// set itemList size
		var itemListLeft = hasMoveControl ? moveButtonsWidth : 20;
		itemList.style.left = itemListLeft + 'px';
		itemList.style.top = itemFormY + 'px';
		itemList.style.width = itemListWidth + 'px';
		itemList.style.height = itemListHeight + 'px';
		
		// alert('itemListHeight: ' + itemListHeight);
		// alert('itemListHeaderHeight: ' + itemListHeaderHeight);
		
		// set itemListBody height
		itemListBody.style.height = (itemListHeight - itemListHeaderHeight) + 'px';
		
		// adjust copyright_info position
		var copyright_info = util.getE('copyright_info');
		copyright_info.style.position = 'absolute';
		copyright_info.style.top = (clientHeight - 40) + 'px';
	},
	
	optionInfo: {
		
		isOpen: false,
		activeElementId: '',
		referenceElementId: '',
		formType: '',
		
		init: function(referenceElementId, formType) { // formType is 'list', 'single' or 'wizard'
			
			adminConfig.optionInfo.formType = formType;
			adminConfig.optionInfo.referenceElementId = referenceElementId;
			
			// alert('adminConfig.optionInfo.formType: ' + adminConfig.optionInfo.formType);
			
			// The elementId of an option info icon has the format "option info path" followed by ":option_info",
			// i.e. "profile.database.fields.suppress_top:option_info"
			
			// Add event listener to all images where elementId ends with ":option_info"
			
			/*
			var contentSection;
			
			if (util.getE('form_section')) {
				contentSection = util.getE('form_section');
			}
			else {
				// KHP-RC, remove - we changed all content_section to the above form_section
				contentSection = util.getE('content_section');
			}
			*/
			
			
			var images = document.getElementsByTagName('img');
			var pattern = /:option_info/;
			
			yEvent.addListener('close_option_info_btn', 'click', adminConfig.optionInfo.close);
			
			for (var i = 0; i < images.length; i++) {
				
				var elementId = images[i].id;
				
				if (pattern.test(elementId)) {
				
					yEvent.addListener(elementId, 'click', adminConfig.optionInfo.display);
				}
			}
			
			//
			// handle external help in option_info display
			//
			
			yEvent.addListener('option_info_body_section', 'click', adminConfig.optionInfo.displayExternalHelp);
		},
		
		open: function() { // opens optionInfo window
			
			// alert('adminConfig.optionInfo.open()');
			// set OptionInfo window position and size
			
			// var ref = util.getE(adminConfig.optionInfo.referenceElementId);
			var ref = YAHOO.util.Dom.getRegion(adminConfig.optionInfo.referenceElementId);
			var left = 0;
			var top = 0;
			var width = 240;
			var height = 280;
			
			switch(adminConfig.optionInfo.formType) {
				
				case 'single':

					left = ref.right - 300;
					top = ref.top - 3;
					break;
				
				case 'list':
				
					left = ref.left - 10;
					top = ref.top - 10;
					width = ref.right - ref.left - 6;
					height = ref.bottom - ref.top - 70;
					break;
				
				case 'wizard':
				
					left = ref.left - 10;
					top = ref.top - 10;
					break;
			}
			
			var option_info_section = util.getE('option_info_section');
			var option_info_body_section = util.getE('option_info_body_section');
			option_info_section.style.top = top + 'px';
			option_info_section.style.left = left + 'px';
			option_info_section.style.width = width + 'px';
			option_info_body_section.style.height = height + 'px';
			util.showE('option_info_section');
			
			adminConfig.optionInfo.isOpen = true;
		},
		
		display: function() { // display option
			
			var elementId = this.id;
			
			// alert('adminConfig.optionInfo.display() - elementId: ' + elementId);
			
			if (adminConfig.optionInfo.isOpen) {
				
				// unmark active option icon
				adminConfig.optionInfo.toggleImage(adminConfig.optionInfo.activeElementId, false);
			}
			else {
				// open optionInfo window
				adminConfig.optionInfo.open();
			}
	
			// alert('showOption: ' + elementId);
			var dat = elementId.split(':');
			var optionInfoPath = dat[0];
						
			var url = '?dp+templates.util.option_info.get_option_info';
			var dat = 'volatile.option_info_path=' + optionInfoPath;
			
			// mark icon as active
			adminConfig.optionInfo.toggleImage(elementId, true);
			
			adminConfig.optionInfo.activeElementId = elementId;
			
			// reset current display
			var optionInfoBodySection = util.getE('option_info_body_section');
			optionInfoBodySection.innerHTML = '...';
			
			util.serverPost(url, dat);
		},		
		
		displayResponse: function(dat) { // server response
		
			// alert(dat);
			var optionInfoBodySection = util.getE('option_info_body_section');
			optionInfoBodySection.innerHTML = dat;
		},
		
		displayExternalHelp: function(evt) {
			
			// User clicked in option info window.
			// If this is an anchor then open an external help window, else ignore the event.
			
			yEvent.preventDefault(evt);
			
			var element = evt.target || evt.srcElement;
			var tagName = element.nodeName;
			
			if (tagName == 'A') {
				
				var url = element.href;
					
				var width = yDom.getViewportWidth() - 40;
				var height = yDom.getViewportHeight() - 40;
				var features = 'width=' + width + ',height=' + height + ',menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
				
				var theWindow = window.open(url, 'help', features);
				theWindow.focus();
			}
		},
		
		close: function() {
			
			util.hideE('option_info_section');
			
			// unmark active option icon
			adminConfig.optionInfo.toggleImage(adminConfig.optionInfo.activeElementId, false);
			
			adminConfig.optionInfo.isOpen = false;
		},
		
		toggleImage: function(elementId, isActive) {
			
			var isIE6 = util.userAgent.isIE6;
			var img = util.getE(elementId);
			var imgSrc = isActive ? imgDb.optionInfoActive.src : imgDb.optionInfo.src;
			
			if (!isIE6) {
				img.src = imgSrc;
			}
			else {
				// IE6 only
				img.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + imgSrc + "', sizingMethod='scale')";
			}
		}
	},
	
	openSupportPage: function(evt) {
		
		yEvent.preventDefault(evt);
		
		
		// alert('yEvent: ' + yEvent + '\nevt:' + evt);
		
		
		// var url = '?dp=support';// does not work with preventDefault!
		var url = '?dp+templates.admin_pages.support.support_page';
		
		var width = yDom.getViewportWidth() - 120;
		var height = yDom.getViewportHeight() - 60;
		var features = 'width=' + width + ',height=' + height + ',location=yes,menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
		
		var supportWindow = window.open(url, 'support', features);
		supportWindow.focus();
	}
}

window.onload = adminConfig.init;
