//
//
// creFilters.js (Customize Report Element Advanced, used in Config Reports Element Editor only)
//
//

var creFilters = {
	
	tableFilterExpression: '', // keeps the active tableFilterExpression when switching between report element types
	
	init: function() {
		
		yEvent.addListener('cre_obj:filters:filter_expression:show_available_fields_btn', 'click', reportsUtil.viewAvailableReportFilterFields.open);
		yEvent.addListener('cre_obj:filters:filter_expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);
		
		yEvent.addListener('cre_obj:filters:table_filter_expression:show_available_fields_btn', 'click', reportsUtil.viewAvailableReportTableFilterFields.open);
		yEvent.addListener('cre_obj:filters::table_filter_expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);
	},
	
	updateForm: function(reportElementDb, constructionType, isLogDetail) {
		
		// Reset global tableFilterExpression
		creFilters.tableFilterExpression = '';
		
		util.setF('cre_obj:filters:date_filter', reportElementDb.date_filter);
		util.setF('cre_obj:filters:filter_expression', reportElementDb.filter_expression);
		
		var tableFilterExpression = (constructionType == 'standard') ? reportElementDb.table_filter_expression : '';
		util.setF('cre_obj:filters:table_filter_expression', tableFilterExpression);
	},
	
	setConstructionTypeDependencies: function(constructionType, isLogDetail) {
		
		// Called from creControl upon metaType change
		
		// KHP 29/Sep/2010 - we allow table filter expressions in log_detail report elements
		var isTableFilterExpSupport = (constructionType == 'standard');
		
		var currentTableFilterExpression = util.getF('cre_obj:filters:table_filter_expression');
		
		if (!isTableFilterExpSupport) {
			
			if (currentTableFilterExpression != '') {
				
				// Save expression in global tableFilterExpression and cclear the expression field
				
				creFilters.tableFilterExpression = currentTableFilterExpression;
				util.setF('cre_obj:filters:table_filter_expression', '');
			}
		}
		else {
			
			if (currentTableFilterExpression == '' && creFilters.tableFilterExpression != '') {
				
				// Restore the table filter expression which has been set upon a supported report element
				util.setF('cre_obj:filters:table_filter_expression', creFilters.tableFilterExpression);
				creFilters.tableFilterExpression = '';
			}
		}
		
		util.enableE('cre_obj:filters:table_filter_expression', isTableFilterExpSupport);
	},
	
	saveChanges: function(reportElementDb, constructionType, isLogDetail) {
		
		// Called from creControl, save changes to the given
		reportElementDb.date_filter = util.getF('cre_obj:filters:date_filter');
		reportElementDb.filter_expression = util.getF('cre_obj:filters:filter_expression');
		
		if (constructionType == 'standard') {
			reportElementDb.table_filter_expression = util.getF('cre_obj:filters:table_filter_expression');
		}
	}
};





