//
//
// creGraphs.js (Customize Report Element Graphs Class, used in Reports and Reports Editor)
//
// Note, the sort by list for graphs is part of the graphs panel, so it is handled in graph options
// because most of the data required by sort by already exists in graph options and we don't want
// to duplicate this data here.
// However, graphs contains a reference to the graphOptions object to handle sort_by integrity
//
//

CreGraphs = function(queryFieldsDb) {
		
	// Manages the graphs form controls
	
	var graphFieldsContainerId = 'cre_obj:graphs:fields_container';
	this.graphFieldsContainerId = graphFieldsContainerId;
	
	this.queryFieldsDb = queryFieldsDb; // A reference to all report fields from where we get the Field labels
	this.reportElementDb = {}; // A reference to the active report element data.
							   // reportElementDb keeps the state of any action taken in the Graphs
							   // The variable is set upon this.build()
							   
	// this.graphsDb = {}; // A reference to the active graphs object
	
	this.graphOptionsRef = null; // A reference to the graphOptions object to call graphOptions.checkSortByIntegrity()
							   
	this.isTable = false; // Set upon this.init()
	
	
	// this.metaGraphTypePriorTabChange = ''; // Set upon init(), it is used to check whether the meta graph type
										   // changed in graph options. If it changed we may need to update
										   // sort by and/or show legend in the Graphs tab.
	
	
	var idPrefix = util.getUniqueElementId();
	this.idPrefix = idPrefix; // Used as prefix in all element Id's (checkboxes, etc.) and as self reference id
	
	// util.showObject(this.reportElementDb);
	
	
	yEvent.addListener('cre_obj:graphs:select_deselect_all_btn', 'click', this.selectDeselectAllActor, this);
	
	// Assign single table event
	yEvent.addListener(graphFieldsContainerId, 'click', this.itemActivated, this);
}

CreGraphs.prototype = {
	
	setGraphOptionsReference: function(graphOptionsRef) {
		this.graphOptionsRef = graphOptionsRef;
	},
	
	init: function(reportElementDb) {
	
		// Field list element ID scheme (prefix:index:type:elementName), index matches the array position
		// sort colum: ueid_20:0:sort:td --> should be an image!
		// label column: re_field_list:0:label:td --> used to set the sort direction
		
		//
		// Init
		//
		
		// var metaGraphType = graphsDb.metaGraphType;
		
		this.reportElementDb = reportElementDb;
		// this.graphsDb = graphsDb;
		
		var isTable = reportElementDb.show_table;
		this.isTable = isTable;
		
		// this.metaGraphTypePriorTabChange = metaGraphType;
		
		var queryFieldsDb = this.queryFieldsDb;
		var columns = reportElementDb.columns;
		
		this.buildGraphFields(queryFieldsDb, columns);
	},
	
	
	//
	//
	//
	// Graphs list handling
	//
	//
	//
	//
	
	
	itemActivated: function(evt, self) {
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		
		if (elementId != '') {
			
			// alert('creUtil.Graphs.prototype.itemActivated(): ' + elementId);
			
			var dat = elementId.split(':');
			var idPrefix = dat[0];
			var objectIndex = parseInt(dat[1], 10);
			var type = dat[2];
			
			// alert('idPrefix: ' + idPrefix);
	
			// var self = creUtil.TableColumnsSelfReferences[idPrefix]; // self is equal this in terms of the TableColumns object!
			var reportElementDb = self.reportElementDb;
			var column = reportElementDb.columns[objectIndex];
			
			// alert('list.idPrefix: ' + list.idPrefix);
			// util.showObject(item);
			
			var isAggregatingField = (column.show_percent_column != null);
			
			var isChecked;
			
			if (isAggregatingField) {
				
				if (type == 'graph_label') {
					
					// User clicked on the text label (note, no label element exists, so the checkbox
					// does not automatically set its state by clicking on the text)
				
					var graphInput = util.getE(idPrefix + ':' + objectIndex + ':graph');
					isChecked = graphInput.checked;
					graphInput.checked = !isChecked;
					column.show_graph = !isChecked;
				}
				else if (type == 'graph') {
					
					isChecked = util.getF(idPrefix + ':' + objectIndex + ':' + type);
					column.show_graph = isChecked;
				}
				
				self.graphOptionsRef.checkSortByIntegrity();
			}
		}
	},
	
	selectDeselectAllActor: function(evt, self) {
		
		var reportElementDb = self.reportElementDb;
		var columns = reportElementDb.columns;
		var idPrefix = self.idPrefix;
		
		//
		// Check if we check or uncheck all fields
		//
		
		var makeAllChecked = false;
		var i;
		var column;
		var isAggregatingField;
		
		for (i = 0; i < columns.length; i++) {
			
			column = columns[i];
			isAggregatingField = (column.show_percent_column != null);
				
			if (isAggregatingField && !column.show_graph) {
				
				makeAllChecked = true;
				break;
			}
		}
		
		// alert('makeAllChecked: ' + makeAllChecked);
		
		
		//
		// Check or uncheck all fields
		//
		
		for (i = 0; i < columns.length; i++) {
			
			column = columns[i];
			isAggregatingField = (column.show_percent_column != null);
			
			// alert('isAggregatingField: ' + isAggregatingField);
	
			if (isAggregatingField) {
	
				column.show_graph = makeAllChecked;
				util.setF(idPrefix + ':' + i + ':graph', makeAllChecked);
			}
		}
	},
	

	//
	//
	// Graph fields handling
	//
	//
	
	buildGraphFields: function(queryFieldsDb, columns) {
		
		var table = util.getE(this.graphFieldsContainerId);
		
		// Clean up the list
		while (table.firstChild != null) {
			var n = table.firstChild;
			table.removeChild(n);
		}
		
		
		var tbody = document.createElement('tbody');
		var i;
		
		var column;
		var isAggregatingField;
		
		for (i = 0; i < columns.length; i++) {
			
			column = columns[i];
			var reportField = column.report_field;
			var reportFieldLabel = queryFieldsDb[h(reportField)].label;
			isAggregatingField = (column.show_percent_column != null);
			
			var tr = document.createElement('tr');
			this.addCheckboxCell(tr, i, 'graph', '');
			this.addLabelCell(tr, i, reportFieldLabel);
			
			tbody.appendChild(tr);
		}
		
		table.appendChild(tbody);
		
		//
		// Upadate the checkbox state
		//
		
		var idPrefix = this.idPrefix;
		
		for (i = 0; i < columns.length; i++) {
			
			column = columns[i];
			isAggregatingField = (column.show_percent_column != null);
		
			var input = util.getE(idPrefix + ':' + i + ':graph');
			
			if (isAggregatingField) {
				input.checked = columns[i].show_graph;
			}
			else {
				// Text field, disable checkbox and label
				input.disabled = 'disabled';
				
				var labelTd = util.getE(idPrefix + ':' + i + ':graph_label');
				labelTd.className = 'label disabled';
			}
		}
	},

	
	addLabelCell: function(tr, index, label) {
		
		var td = document.createElement('td');
		td.id = this.idPrefix + ':' + index + ':graph_label';
		td.className = 'label';
			
		var text = document.createTextNode(label);
		
		util.chainE(tr, td, text);
	},
	
	addCheckboxCell: function(tr, index, type, label) {
		
		var td = document.createElement('td');
		
		var id = this.idPrefix + ':' + index + ':' + type;
		
		var input = document.createElement('input');
		input.id = id;
		input.type = 'checkbox';
		
		if (!util.userAgent.isIE) {
			// Give checkbox default margin
			input.style.margin = '3px';
		}
		
		td.appendChild(input);
		
		if (label != '') {
			
			var labelElement = document.createElement('label');
			labelElement.htmlFor = id;
			var text = document.createTextNode(' ' + label);
			labelElement.appendChild(text);
			
			td.appendChild(labelElement);
		}
	
		tr.appendChild(td);
	}
}
















