//
//
// crePivotTable.js (Customize Report Element PivotTable Class, used in Reports and Reports Editor)
//
//


CrePivotTable = function(queryFieldsDb) {
	
	this.queryFieldsDb = queryFieldsDb; // A reference to all report fields from where we get the Field labels
	this.reportElementDb = {}; // A reference to the active report element data.
	
	// Init the GUI
	yEvent.addListener('cre_obj:pivot_table:show_pivot_table', 'click', this.toggleShowPivotTable, this);
	yEvent.addListener('cre_obj:pivot_table:sort_different', 'click', this.toggleSortDifferent, this);
	
	// populate rows list
	var rows = [5,10,20,50,100,200,500];
	var rowsList = [];
	for (var i = 0; i < rows.length; i++) {
		rowsList[i] = {name:rows[i], label:rows[i]};
	}
	util.populateSelect('cre_obj:pivot_table:number_of_rows', rowsList, 'name', 'label');
	
	// populate sort direction
	creUtil.buildSortDirectionList('cre_obj:pivot_table:sort_direction');
};

CrePivotTable.prototype = {
	
	init: function(reportElementDb) {
	
		this.reportElementDb = reportElementDb;
	
		//
		// Handle report fields list
		//
		var mainReportFieldName = reportElementDb.report_field;
		var fieldList = [{name:'', label:langVar('lang_stats.customize_report_element.select_field')}];
	
		var queryFieldsDb = this.queryFieldsDb;
		var pivotTable = reportElementDb.pivot_table;
		var pivotReportFieldName = pivotTable.report_field;
		
		// util.showObject(pivotTable);
	
		for (var i = 0; i < queryFieldsDb.length; i++) {
			
			var reportField = queryFieldsDb[i];
			
			if (!reportField.isAggregatingField) {
				var reportFieldName = reportField.name;
				var category = reportField.category;
				var isNonSessionField = (category.indexOf('session_') == -1);
			
				if (isNonSessionField && reportFieldName != mainReportFieldName) {
					fieldList[fieldList.length] = {name:reportFieldName, label:reportField.label};
				}
			}
		}
		
		util.populateSelect('cre_obj:pivot_table:report_field', fieldList, 'name', 'label');
		util.setF('cre_obj:pivot_table:report_field', pivotReportFieldName);
		
		//
		// Handle number of rows
		//
		util.setF('cre_obj:pivot_table:number_of_rows', pivotTable.number_of_rows);
		
		//
		// Handle sort by
		//
		
		var sortBy = pivotTable.sort_by;
		var sortDirection = pivotTable.sort_direction;
		var isSortDifferent = (sortBy != '');
		
		var sortByList = this.getSortByList(this.queryFieldsDb, reportElementDb.columns);
		
		var sortBySelected = '';
		if (sortBy != '') {
			if (sortBy != pivotReportFieldName) {
				sortBySelected = sortBy;
			}
			else {
				sortBySelected = '_SELECTED__DRILL_DOWN_FIELD_';
			}
		}
		
		util.populateSelect('cre_obj:pivot_table:sort_by', sortByList, 'name', 'label');
		
		util.setF('cre_obj:pivot_table:sort_different', isSortDifferent);
		util.setF('cre_obj:pivot_table:sort_by', sortBySelected);
		util.setF('cre_obj:pivot_table:sort_direction', sortDirection);
		this.sortDifferent(isSortDifferent);
		
		
		//
		// Set aggregation rows
		//
		util.setF('cre_obj:pivot_table:show_averages_row', pivotTable.show_averages_row);
		util.setF('cre_obj:pivot_table:show_min_row', pivotTable.show_min_row);
		util.setF('cre_obj:pivot_table:show_max_row', pivotTable.show_max_row);
		
		//
		// Handle show pivot table
		//
		
		var isShowPivotTable = pivotTable.show_pivot_table;
		util.setF('cre_obj:pivot_table:show_pivot_table', isShowPivotTable);
		this.showPivotTable(isShowPivotTable);
	},
	
	toggleShowPivotTable: function(evt, self) {
	
		var isShowPivotTable = this.checked;
		self.showPivotTable(isShowPivotTable);
	},
	
	toggleSortDifferent: function(evt, self) {
	
		var isSortDifferent = this.checked;
		self.sortDifferent(isSortDifferent);
	},
	
	showPivotTable: function(isShowPivotTable) {
		
		var a = [
			'cre_obj:pivot_table:report_field',
			'cre_obj:pivot_table:number_of_rows',
			'cre_obj:pivot_table:show_averages_row',
			'cre_obj:pivot_table:show_min_row',
			'cre_obj:pivot_table:show_max_row',
			'cre_obj:pivot_table:sort_different'
		];
		
		util.enableE(a, isShowPivotTable);
		
		// Update Sort By section
		var isSortDifferent = isShowPivotTable ? util.getF('cre_obj:pivot_table:sort_different') : false;
		// alert('isSortDifferent: ' + isSortDifferent);
		this.sortDifferent(isSortDifferent);
	},
	
	sortDifferent: function(isSortDifferent) {
		
		util.enableE(['cre_obj:pivot_table:sort_by', 'cre_obj:pivot_table:sort_direction'], isSortDifferent);
	},
	
	getSortByList: function(queryFieldsDb, columns) {
		
		// Note, the second list item in sort by sorts the 'selected drill down field'
		var list = [{name:'', label:langVar('lang_stats.customize_report_element.select_field')}, {name:'_SELECTED__DRILL_DOWN_FIELD_', label:langVar('lang_stats.customize_report_element.selected_drill_down_field')}];
	
		// Add any enabled aggregating column
		
		for (var i = 0; i < columns.length; i++) {
			var column = columns[i];
			if (column.show_percent_column != null) {
				
				if (column.show_column ||
					column.show_percent_column ||
					column.show_bar_column) {
					var fieldName = column.report_field;
					var fieldLabel = queryFieldsDb[h(fieldName)].label;
					list[list.length] = {name:fieldName, label:fieldLabel};
				}
			}
		}
		
		return list;
	},
	
	saveChanges: function() {
		
		// Saves active pivot table data to pivot table object in reportElementDb
		
		// We always save the "show_pivot_table" value.
		// All other properties are only saved if
		// show_pivot_table is true and if a report field is selected.
		
		var pivotTable = this.reportElementDb.pivot_table;
		var reportFieldName = util.getF('cre_obj:pivot_table:report_field');
		var isShowPivotTable = (util.getF('cre_obj:pivot_table:show_pivot_table') && (reportFieldName != ''));
		
		// alert('reportFieldName: ' + reportFieldName);
		
		pivotTable.show_pivot_table = isShowPivotTable;
		
		if (isShowPivotTable) {
		
			// Save all other data to pivot table object
			pivotTable.report_field = reportFieldName;
			pivotTable.number_of_rows = util.getF('cre_obj:pivot_table:number_of_rows');
			pivotTable.show_averages_row = util.getF('cre_obj:pivot_table:show_averages_row');
			pivotTable.show_min_row = util.getF('cre_obj:pivot_table:show_min_row');
			pivotTable.show_max_row = util.getF('cre_obj:pivot_table:show_max_row');
			
			var sortBy = util.getF('cre_obj:pivot_table:sort_by');
			var isSortDifferent = (util.getF('cre_obj:pivot_table:sort_different') && (sortBy != ''));
			var sortDirection = '';
			
			if (isSortDifferent) {
				
				if (sortBy == '_SELECTED__DRILL_DOWN_FIELD_') {
					sortBy = reportFieldName;
				}
				
				sortDirection = util.getF('cre_obj:pivot_table:sort_direction');
			}
			else {
				sortBy = '';
				sortDirection = 'descending';
			}
			
			pivotTable.sort_by = sortBy;
			pivotTable.sort_direction = sortDirection;
		}
		
		// util.showObject(pivotTable);
	}
};
