// 
// logDetailSortingMsg
//

var logDetailSortingMsg = function() {
	
	var GD = { // General global data
		panel: null,
		
		isReportsGUI: false,
		isColumnsSort: false,
		
		hideMessage: false,
		
		// Variables required for the 
		// the callee response
		
		reportElementName: '',
		sortBy: '',
		sortDirection: ''
	};
	
	function init() {
		
		var panelObj = {
			panelId: 'log_detail_sorting_msg:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.log_detail_sorting.label'),
			zIndex: 60,
			isCover: true,
			closeEvent: logDetailSortingMsg.closeSimple
		};
		
		GD.panel = new util.Panel3(panelObj);
	
		yEvent.addListener('log_detail_sorting_msg:continue_btn', 'click', continueSorting);
		yEvent.addListener('log_detail_sorting_msg:cancel_btn', 'click', closeAdvanced);
		
		yEvent.addListener('log_detail_sorting_msg:ok_btn', 'click', closeAdvanced);
	}
	
	function setDisplay() {
		
		util.showE('log_detail_sorting_msg:msg_in_reports', GD.isReportsGUI);
		util.showE('log_detail_sorting_msg:msg_in_config', !GD.isReportsGUI);
		util.showE('log_detail_sorting_msg:click_continue_to_sort', GD.isColumnsSort);
		
		util.showE('log_detail_sorting_msg:continue_btn_section', GD.isColumnsSort);
		util.showE('log_detail_sorting_msg:ok_btn_section', !GD.isColumnsSort);
	}
	
	function openViaColumnsSort(isReportsGUI, reportElementName, sortBy, sortDirection) {
		
		// Opened in Reports upon sort column click
		GD.isReportsGUI = isReportsGUI;
		GD.isColumnsSort = true;
		GD.reportElementName = reportElementName;
		GD.sortBy = sortBy;
		GD.sortDirection = sortDirection;
		
		open();
	}
	
	function openViaCustomizeReportElement(isReportsGUI) {
		
		// Opened in reports or Config via sort by change in Customize Report Element
		
		GD.isReportsGUI = isReportsGUI;
		GD.isColumnsSort = false;
		
		open();
	}
	
	function open() {
		
		// If "Don't show this message again ..." hasn't been checked yet
		if (!GD.hideMessage) {
		
			if (GD.panel == null) {
				init();
			}
			
			setDisplay();
			GD.panel.prePositionAtCenter();
			GD.panel.open();
		}
	}
	
	function closeSimple() {
		
		// Closes the window via close icon only.
		// The "Don't show message again" state is ignored.
		
		// Close the panel
		GD.panel.close();
	}
	
	function closeAdvanced() {
		
		// Closes the window via button but not via close icon.
		// This considers the checked state of "Don't show message again"
		
		// Don't show message again if checked.
		if (util.getF('log_detail_sorting_msg:hide_msg_btn')) {
			setHideLogDetailSortingMessage();
		}
		
		// Close the panel
		GD.panel.close();
	}
	
	function continueSorting() {
		
		// Only possible when called via openViaColumnsSort(), continue
		// the actual sort operation in reports.
		
		// Don't show message again if checked.
		if (util.getF('log_detail_sorting_msg:hide_msg_btn')) {
			setHideLogDetailSortingMessage();
		}
		
		// Continue sort operation in newReport.js
		newReport.sortColumnContinued(GD.reportElementName, GD.sortBy, GD.sortDirection);

		// Close the panel
		GD.panel.close();
	}
	
	function setHideLogDetailSortingMessage() {
		
		// This sets hide_log_detail_sorting_message_in_reports on the server side.
		// users_cache.[user node name].peferences.hide_log_detail_sorting_message_in_reports = true
		var info = GD.isReportsGUI ? reportInfo : pageInfo;
		var profileName = info.profileName;
		var pageToken = info.pageToken;
		GD.hideMessage = true;
		
		var url = '?dp+util.log_detail_sorting.hide_log_detail_sorting_msg';
		url += '+p+' + profileName;
		var dat = 'v.fp.page_token=' + pageToken + '&';
		dat += 'v.fp.is_reports_gui=' + GD.isReportsGUI;
		
		util.serverPost(url, dat);
	}
	
	function setHideLogDetailSortingMessageResponse() {
		// Server response, no action required
	} 
	
	//
	//
	// Return global properties and methods (accessible from outside the logDetailSortingMsg namespace)
	//
	//
	
	return {
		openViaColumnsSort: openViaColumnsSort,
		openViaCustomizeReportElement: openViaCustomizeReportElement,
		setHideLogDetailSortingMessageResponse: setHideLogDetailSortingMessageResponse
	}
}();



