//
// admin licensing
//


var licensing = {
	
	// Editor functions only
	
	panel: null,
	validator: null,
	
	isCollapsedLicenseKey: true,
	
	init: function() {
		
		licensing.validator = new util.Validator();
		
		//
		// Init the Action panel
		//
		
		var panelObj = {
			panelId: 'edit_license:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.licensing.add_or_change_license_key'),
			left: 200,
			top: 100,
			zIndex: 20,
			isCover: false,
			isSticky: true,
			closeEvent: licensing.closePanel
		};
		
		licensing.panel = new util.Panel3(panelObj);
		
		yEvent.addListener('edit_license:expand_collapse_license_key_field_btn', 'click', licensing.toggleLicenseKeyFieldHeight);
	
		yEvent.addListener('edit_license:save_btn', 'click', licensing.saveLicense);
		yEvent.addListener('edit_license:cancel_btn', 'click', licensing.closePanel);
	},
	
	setSavingState: function(isValidationState) {
		
		util.showEV('edit_license:saving_info', isValidationState);
		util.disableE(['edit_license:key', 'edit_license:save_btn', 'edit_license:cancel_btn'], isValidationState);
	},
	
	toggleLicenseKeyFieldHeight: function() {
        
        var textarea = util.getE('edit_license:key');
        var isCollapsedLicenseKey = licensing.isCollapsedLicenseKey;
        
        textarea.rows = isCollapsedLicenseKey ? 13 : 2;
        var buttonLabel = isCollapsedLicenseKey ? langVar('lang_admin.licensing.collapse_license_field') : langVar('lang_admin.licensing.expand_license_field'); 
        util.updateT('edit_license:expand_collapse_license_key_field_btn', buttonLabel);
        
        licensing.isCollapsedLicenseKey = !isCollapsedLicenseKey;
    },
	
	openPanel: function() {
		
		if (!licensing.panel) {
			licensing.init();
		}
		
		// Reset form
		licensing.setSavingState(false);
		licensing.validator.reset();
		
		util.setF('edit_license:key', '');
	
		licensing.panel.open();
		
		var element = util.getE('edit_license:key');
		element.focus();
	},
	
	closePanel: function() {
		licensing.panel.close();
	},
	
	saveLicense: function() {
		
		var licenseKey = licensing.validator.isValue('edit_license:key');
		
		if (licensing.validator.allValid()) {
			
			licensing.setSavingState(true);
			
			var url = '?dp+templates.admin_pages.licensing.save_license';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.license_key=' + encodeURIComponent(licenseKey);
	
			util.serverPost(url, dat);
		}
	},
	
	saveLicenseResponse: function(dat) {
		
		if (dat.isValid) {
			
			// Reload licensing page
			location.reload(true);
			
		}
		else {
			
			// Show error
			licensing.setSavingState(false);
			// Show custom error message and invoke allValid(), else the error isn't shown
			licensing.validator.isCustom('edit_license:key', dat.errorMsg);
			licensing.validator.allValid();
		}
	}
};

function initPage(dat) {
	
	if (pageInfo.permissions.isEdit) {
		yEvent.addListener('licensing:change_key_btn', 'click', licensing.openPanel);
	}
	
	util.updateT('licensing:key', dat.licenseKey);
	util.updateT('licensing:type', dat.type);
	util.updateT('licensing:number_of_profiles', dat.numberOfProfiles);
	util.updateT('licensing:expiration', dat.expiration);
	
	var sublicenses = dat.sublicenses;
	
	if (sublicenses.length > 0) {
		
		// Show sublicenses below the licenseKey
		var container = util.getE('licensing:key_section');
		
		for (var i = 0; i < sublicenses.length; i++) {
			
			var div = util.createE('div', {padding:'0 0 3px 12px', color:'#8b8b8b'});
			var text = util.createT('- ' + sublicenses[i]);
			
			util.chainE(container, div, text);
		}
	}

	util.showE('form_section');
}

function getLicensingData() {
	
	if (!pageInfo.exitActive) {
		
		var url = '?dp+templates.admin_pages.licensing.get_licensing_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		
		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}

function getLicensingDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
		initPage(dat);
	}
}

