//
// admin my account
//


var myAccount = {
	
	validator: null,
	passwordValidationRules: {}, // contains password validation rules as in preferences.cfg, it is used by passwordUtil.js
	isNewPassword: false,
	
	init: function() {
		
		if (pageInfo.permissions.isEdit) {
		
			myAccount.validator = new util.Validator();
			
			var saveChangesBtn = new util.ToolbarButton('save_changes', myAccount.saveChanges, toolbarButtonsDb);	
			saveChangesBtn.enable();
			
			yEvent.addListener(['my_account:change_password_btn', 'my_account:cancel_change_password_btn'], 'click',  myAccount.toggleChangePassword);
		}
		
		// Init help
		util.helpWindow.init('');
	},
	
	getMyAccountData: function() {
		
		if (!pageInfo.exitActive) {
		
			var url = '?dp+templates.admin_pages.my_account.get_my_account_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			util.serverPost(url, dat);
		}
	},
	
	getMyAccountDataResponse: function(dat) {
	
		if (!pageInfo.exitActive) {
			
			myAccount.passwordValidationRules = dat.passwordValidationRules;
			
			myAccount.init();
			
			util.hideE('my_account:general_error_section');
			
			util.setF('my_account:username', dat.username);
			util.disableE('my_account:username');
			
			if (pageInfo.permissions.isEdit) {
			
				util.setF('my_account:password', '');
				util.setF('my_account:password_2', '');
				
				util.hideE('my_account:password_section');
				util.showE('my_account:change_password_section');
			}
			
			util.showE('my_account:form');
			util.showE('form_section');
		}
	},
	
	toggleChangePassword: function() {
		
		var makeActive = !myAccount.isNewPassword;
		
		util.showE('my_account:password_section', makeActive);
		util.showE('my_account:change_password_section', !makeActive);
		
		if (!makeActive) {
			// Reset any form error
			util.hideE('my_account:general_error_section');
			myAccount.validator.reset();
		}
		
		myAccount.isNewPassword = makeActive;
	},
	
	saveChanges: function() {
		
		if (myAccount.isNewPassword) {
		
			var validator = myAccount.validator;
			validator.reset();
			
			var password = validator.isValue('my_account:password');
			var password2 = validator.isValue('my_account:password_2');
			
			if (password != '') {
				
				// Check password by passwordValidation
				var passwordCheck = passwordUtil.validatePassword(myAccount.passwordValidationRules, password);
				var customErrorMessage;
				
				// util.showObject(myAccount.passwordValidationRules);
				// util.showObject(passwordCheck);
				
				if (!passwordCheck.isValid) {
				
					customErrorMessage = passwordCheck.errorMessage;
					validator.isCustom('my_account:password', customErrorMessage);
				}
				else if (password != password2) {
					
					// alert(newPassword + '\n' + newPassword2);
					customErrorMessage = langVar('lang_stats.my_account.invalid_password2_message');
					validator.isCustom('my_account:password_2', customErrorMessage);
				}
			}
			
			
			if (validator.allValid()) {
				
				var msg = langVar('lang_stats.my_account.auto_logout_info');
				
				if (confirm(msg)) {

					util.hideE('form_section');
					util.showE('saving_info');
					
					var url = '?dp+templates.admin_pages.my_account.save_my_account';
					var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
					dat += 'v.fp.password=' + encodeURIComponent(password);
					
					util.serverPost(url, dat);
				}
			}
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	},
	
	saveChangesResponse: function(dat) {
		
		if (dat.isValid) {
			location.href = '?dp=login';
		}
		else {

			alert(dat.errorMessage);
			util.updateT('my_account:general_error', dat.errorMessage);
			util.showE('my_account:general_error_section');
		
			util.hideE('saving_info');
			util.showE('form_section');
		}
	}
};

