//
// rootAdmin.js
//

var rootAdmin = {
	
	validator: null,
	usernameItems: {}, // ["username 1", "username 2", ...] contains all non-root-admin usernames

	oriUsername: '', // The current active username
	oriLanguage: '',// The current active language
	
	isNewUsername: false,
	isNewPassword: false,
	
	init: function() {
		
		rootAdmin.validator = new util.Validator();
			
		var saveChangesBtn = new util.ToolbarButton('save_changes', rootAdmin.saveChanges, toolbarButtonsDb);	
		saveChangesBtn.enable();
		
		yEvent.addListener(['root_admin:change_password_btn', 'root_admin:cancel_change_password_btn'], 'click',  rootAdmin.toggleChangePassword);
		
		// Init help
		util.helpWindow.init('');
	},
	
	getRootAdminData: function() {
		
		if (!pageInfo.exitActive) {
			
			var url = '?dp+templates.admin_pages.root_admin.get_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			util.serverPost(url, dat);
		}
	},
	
	getRootAdminDataResponse: function(dat) {
		
		if (!pageInfo.exitActive) {
			
			rootAdmin.init();
		
			rootAdmin.usernameItems = dat.usernameItems;
			var username = dat.username;
			var language = dat.language;
			
			rootAdmin.oriUsername = username;
			rootAdmin.oriLanguage = language;
			
			// Set form values
			util.resetF('root_admin:form');
			util.setF('root_admin:username', username);
			util.setF('root_admin:language', language);
			
			util.hideE('root_admin:password_section');
			
			util.showE('root_admin:form');
			util.showE('form_section');
		}
	},
	
	toggleChangePassword: function() {
		
		var makeActive = !rootAdmin.isNewPassword;
		
		util.showE('root_admin:password_section', makeActive);
		util.showE('root_admin:change_password_section', !makeActive);
		
		if (!makeActive) {
			// Reset any form error
			rootAdmin.validator.reset();
		}
		
		rootAdmin.isNewPassword = makeActive;
	},

	saveChanges: function() {
		
		var validator = rootAdmin.validator;
		validator.reset();
		
		var isCaseSensitive = true;
		var username = validator.isValue('root_admin:username');
		username = validator.isUnique('root_admin:username', rootAdmin.usernameItems, isCaseSensitive);
		
		var language = util.getF('root_admin:language');

		var isNewPassword = rootAdmin.isNewPassword;
		var isNewUsername = (username != rootAdmin.oriUsername);
		var isNewLanguage = (language != rootAdmin.oriLanguage);
		
		rootAdmin.isNewUsername = isNewUsername; // isNewUsername is required upon save changes response!
		
		if (isNewUsername ||
			isNewPassword ||
			isNewLanguage) {
				
			var password = '';
			var password2 = '';
			
			if (isNewPassword) {
			
				password = validator.isValue('root_admin:password');
				password2 = validator.isValue('root_admin:password_2');
				
				if (password != '' && (password != password2)) {
					
					// Show custom error messsage
					var customErrorMessage = langVar('lang_stats.my_account.invalid_password2_message');
					validator.isCustom('root_admin:password_2', customErrorMessage);
				}
			}
			
			if (validator.allValid()) {
				
				var msg = langVar('lang_stats.my_account.auto_logout_info');
				
				if ((!isNewUsername && !isNewPassword) || confirm(msg)) {
				
					util.hideE('form_section');
					util.showE('saving_info');
					
					var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
					dat += 'v.fp.is_new_username=' + isNewUsername + '&';
					dat += 'v.fp.is_new_password=' + isNewPassword + '&';
					dat += 'v.fp.username=' + encodeURIComponent(username) + '&';
					dat += 'v.fp.password=' + encodeURIComponent(password) + '&';
					dat += 'v.fp.language=' + language;
					
					var url = '?dp+templates.admin_pages.root_admin.save_data';
					util.serverPost(url, dat);
				}
			}
		}
		else {
			
			// No changes to save
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	},
	
	saveChangesResponse: function() {
		
		if (rootAdmin.isNewUsername || rootAdmin.isNewPassword) {
			
			// Re-login required!
			// location.href = '?dp=logout'; --> Does not succed to call logout, due authentication state not authenticated!
			location.href = '?dp=login';
		}
		else {
			
			// The language changed, reload required
			location.reload(true);
		}
	}
}

