//
// dbFieldsUtil.js
//

var dbFieldsUtil = {
	
	derivationMethodActor: function() {
		
		var derivationMethod = util.getF('db_fields:derivation_method');
		var isSessionField = (derivationMethod == 'session_field');
		
		if (!isSessionField) {
			var logField = '';
			util.setF('db_fields:log_field', logField);
			dbFieldsUtil.updateLogFieldsForm(logField);
			dbFieldsUtil.setAlwaysIncludeBottomLevelItemsDisplay('', logField);
		}
		else {
			var sessionField = '';
			util.setF('db_fields:session_field', sessionField);
			dbFieldsUtil.updateSessionFieldsForm(sessionField);
		}
		
		util.showE('db_fields:log_field_section', !isSessionField);
		util.showE('db_fields:session_field_section', isSessionField);
		// util.hideE('db_fields:source_database_field_section');
	},
	
	logFieldActor: function() {
		
		var logField = util.getF('db_fields:log_field');
		var databaseFieldType = util.getF('db_fields:type');
		dbFieldsUtil.updateLogFieldsForm(logField);
		dbFieldsUtil.setAlwaysIncludeBottomLevelItemsDisplay(databaseFieldType, logField);
	},
	
	updateLogFieldsForm: function(logField) {
		
		var isLogField = (logField != '');
		util.showE('db_fields:field_details_section', isLogField);
	},
	
	sessionFieldActor: function() {
		var sessionField = util.getF('db_fields:session_field');
		dbFieldsUtil.updateSessionFieldsForm(sessionField);
	},
	
	updateSessionFieldsForm: function(sessionField) {
		
		var isSessionField = (sessionField != '');
		var sourceDatabaseField = '';
		
		dbFieldsUtil.handleSourceDatabaseFieldDisplay(sessionField, sourceDatabaseField);
		util.showE('db_fields:field_details_section', isSessionField);
	},

	getIsSourceDatabaseFieldSupport: function(sessionField) {
		
		var isSourceDatabaseFieldSupport = (sessionField == 'sessions' || sessionField == 'session_begin' || sessionField == 'session_end');
		return isSourceDatabaseFieldSupport;
	},
	
	handleSourceDatabaseFieldDisplay: function(sessionField, sourceDatabaseField) {
		
		var isSourceDatabaseFieldSupport = dbFieldsUtil.getIsSourceDatabaseFieldSupport(sessionField);
		
		if (isSourceDatabaseFieldSupport) {
			
			// Update list box with up to date database fields where derivation_method is equal session_field.
			
			var itemsDb = dbFields.itemsDb;
			var selectedItemId = dbFields.theList.getSelectedItemId();
			var selectItems = [];
			selectItems[0] = {name:'', label:'--- ' + langVar('lang_admin.database_fields.select_source_database_field') + ' ---'};
		
			for (var i = 0; i < itemsDb.length; i++) {
				
				var item = itemsDb[i];
				var itemDat = item.dat;
				
				if (itemDat.derivation_method == 'session_field' && (item.id != selectedItemId)) {
				
					selectItems[selectItems.length] = {name:itemDat.node_name, label:itemDat.label};
				}
			}
			
			util.populateSelect('db_fields:source_database_field', selectItems, 'name', 'label');
			util.setF('db_fields:source_database_field', sourceDatabaseField);
		}
		
		util.showE('db_fields:source_database_field_section', isSourceDatabaseFieldSupport);
	},
	
	
	typeActor: function() {
		
		var type = util.getF('db_fields:type');
		var logField = util.getF('db_fields:log_field');
		
		util.showE('db_fields:integer_bits_section', (type != "float"));
		util.showE(['db_fields:sql_field_length_section', 'db_fields:supress_label_section', 'db_fields:supress_top_section', 'db_fields:supress_bottom_section'], (type == 'string'));
		dbFieldsUtil.setAlwaysIncludeBottomLevelItemsDisplay(type, logField);
	},
	
	getIsHierarchicalDatabaseField: function(dbFieldType, logFieldName) {
		
		// util.showObject({dbFieldType:dbFieldType, logFieldName:logFieldName}, 'getIsHierarchicalDatabaseField()');
		// alert('logFieldName: ' + logFieldName);
		
		var isHierarchicalDatabaseField = false;
		
		if (dbFieldType == 'string' && logFieldName != '') {
			
			var logFieldItem = dbFields.logFieldsDb[h(logFieldName)];
			var logFieldType = logFieldItem.type;
			
			isHierarchicalDatabaseField = (logFieldType != 'flat' && logFieldType != 'agent');
		}
		
		return isHierarchicalDatabaseField;
	},
	
	setAlwaysIncludeBottomLevelItemsDisplay: function(dbFieldType, logFieldName) {
		
		// Show always_include_bottom_level_items section if the log field is hierarchical, else hide the section
		var isHierarchicalDatabaseField = dbFieldsUtil.getIsHierarchicalDatabaseField(dbFieldType, logFieldName);
		util.showE('db_fields:always_include_bottom_level_items_section', isHierarchicalDatabaseField);
	},

	//
	// updateListLabel
	//
	
	updateListLabelActor: function() {
		
		setTimeout('dbFieldsUtil.updateListLabel()', 300);
	},
	
	updateListLabel: function() {
		
		var label =  util.getF('db_fields:label');
		
		if (label == '') {
			label = '-';
		}
		
		dbFields.theList.updateListLabel(label);
	}
};
