//
// logFilterActionUtil.js
//


var logFilterActionUtil = {
	
	initActionForm: function() {
		
		var i;
		
		//
		// Populate log field lists (lists with string and numerical fields)
		//
		var allLogFieldsLists = [
			'lfa:concatenate_log_fields_list:0',
			'lfa:concatenate_log_fields_list:1',
			'lfa:concatenate_log_fields_list:2',
			'lfa:concatenate_log_fields_list:3',
			'lfa:concatenate_log_fields_list:result',
			'lfa:copy:log_fields_list:from',
			'lfa:copy:log_fields_list:to',
			'lfa:match_regexp_copy:log_field_list',
			'lfa:match_regexp_copy:log_fields_list:0',
			'lfa:match_regexp_copy:log_fields_list:1',
			'lfa:match_regexp_copy:log_fields_list:2',
			'lfa:match_regexp_copy:log_fields_list:3',
			'lfa:set:log_fields_list'
		];
		
		for (i = 0; i < allLogFieldsLists.length; i++) {
			logFiltersUtil.populateFullLogFieldsList(allLogFieldsLists[i], true);
		}
		
		//
		// Populate log field lists (lists with string fields only)
		//
		var stringLogFieldsLists = [
			'lfa:convert_to_lowercase:log_fields_list',
			'lfa:convert_to_uppercase:log_fields_list',
			'lfa:find_and_replace:log_fields_list'
		];
		
		for (i = 0; i < stringLogFieldsLists.length; i++) {
			logFiltersUtil.populateStringLogFieldsList(stringLogFieldsLists[i], true);
		}
		
		
		yEvent.addListener('lfa:action_list', 'change', logFilterActionUtil.setActionActor);
		
		
		yEvent.addListener(
			[
			'lfa:concatenate_type_list:0',
			'lfa:concatenate_type_list:1',
			'lfa:concatenate_type_list:2',
			'lfa:concatenate_type_list:3',
			],
			'change',
			logFilterActionUtil.toggleConcatenateType
		);

		
		
		
	},
	
	setActionActor: function() {
		// Invoked by select event
		var actionType = util.getF('lfa:action_list');
		logFilterActionUtil.setActionDisplay(actionType);
	},
	
	setActionDisplay: function(actionType) {
		
		var action_sections = [
			'lfa::section', // first option - Select Action
			'lfa:accept:section',
			'lfa:concatenate:section',
			'lfa:convert_to_lowercase:section',
			'lfa:convert_to_uppercase:section',
			'lfa:copy:section',
			'lfa:match_regexp_copy:section',
			'lfa:find_and_replace:section',
			'lfa:reject:section',
			'lfa:set:section'
		];
		
		util.hideE(action_sections);
		util.showE('lfa:' + actionType + ':section');
	},
	
	
	toggleConcatenateType: function() {
		// Toggles between value field and log fields list
		var elementId = this.id;
		var dat = elementId.split(':');
		var itemNumber = dat[2];
		var isSetToLogFieldList = (util.getF(elementId) == 'log_field');
		
		util.showE('lfa:concatenate_value:' + itemNumber, !isSetToLogFieldList);
		util.showE('lfa:concatenate_log_fields_list:' + itemNumber, isSetToLogFieldList);
	},
	
	toggleConcatenateField: function() {
		// Enables/disables additional concatenation fields
		
		
	},

	resetForm: function() {
		
		util.resetF('lfa:form');
		
		var i;
		
		// Reset concatenation fields
		for (var i = 0; i < 4; i++) {
			util.hideE('lfa:concatenate_log_fields_list:' + i);
			util.showE('lfa:concatenate_value:' + i);
		}
	},
	
	updateForm: function(item) {
		
		var actionType = item.type;
		util.setF('lfa:action_list', actionType);
		logFilterActionUtil.setActionDisplay(actionType);
		
		var i;
		
		switch (item.type) {
				
			case 'concatenate':
				
				var concatenateItems = item.concatenate;
				var isLogField;
				var concatenateTypeValue;
				var concatenateValueElementId;
				
				// util.showObject(concatenateItems);
				
				for (i = 0; i < concatenateItems.length; i++) {
					
					// util.showObject(concatenateItems[i]);
					
					isLogField = concatenateItems[i].is_log_field;
					concatenateTypeValue = isLogField ? 'log_field' : 'value';
					concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:' + i : 'lfa:concatenate_value:' + i;
					util.setF('lfa:concatenate_type_list:' + i, concatenateTypeValue);
					util.setF(concatenateValueElementId, concatenateItems[i].literal);
					
					util.showE('lfa:concatenate_log_fields_list:' + i, isLogField);
					util.showE('lfa:concatenate_value:' + i, !isLogField);
				}
				
				// Set result field
				util.setF('lfa:concatenate_log_fields_list:result', item.log_field);
				
				break;
				
			case 'convert_to_lowercase':
			
				util.setF('lfa:convert_to_lowercase:log_fields_list', item.log_field);
				break;
				
			case 'convert_to_uppercase':
			
				util.setF('lfa:convert_to_uppercase:log_fields_list', item.log_field);
				break;
				
			case 'copy':
			
				util.setF('lfa:copy:log_fields_list:from', item.log_field);
				util.setF('lfa:copy:log_fields_list:to', item.target_log_field);
				break;
				
			case 'match_regexp_copy':
			
				util.setF('lfa:match_regexp_copy:log_field_list', item.log_field);
				util.setF('lfa:match_regexp_copy:expression', item.literal);
				
				var copyToLogFieldItems = item.copy;
				for (i = 0; i < copyToLogFieldItems.length; i++) {
					util.setF('lfa:match_regexp_copy:log_fields_list:' + i, copyToLogFieldItems[i].log_field);
				}
			
				break;
				
			case 'find_and_replace':
			
				util.setF('lfa:find_and_replace:log_fields_list', item.log_field);
				util.setF('lfa:find_and_replace:find_value', item.literal);
				util.setF('lfa:find_and_replace:replace_value', item.literal_2);
				
				var replaceType = item.replace_type;
				util.setF('lfa:find_and_replace:' + replaceType + '_btn', true);
			
				break;
				
			case 'set':
			
				util.setF('lfa:set:log_fields_list', item.log_field);
				util.setF('lfa:set:value', item.literal);
				break;
		}
	}

};


