//
// logFilterComment.js
//

var logFilterComment = {
	
	panel: null,
	
	init: function() {
		
		var panelObj = {
			panelId: 'log_filter_comment:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.btn.comment'),
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterComment.close
		};
		
		logFilterComment.panel = new util.Panel3(panelObj);
		
		yEvent.addListener('log_filter_comment:ok_btn', 'click', logFilterComment.save);
		yEvent.addListener('log_filter_comment:cancel_btn', 'click', logFilterComment.close);
	},

	open: function() {
		
		if (!logFilterComment.panel) {
			logFilterComment.init();
		}
		
		var theComment = logFilters.activeComment;
		
		// Convert <br /> tags to new line
		theComment = theComment.replace(/<br\s\/>/g, '\n');
		
		util.setF('log_filter_comment:comment', theComment);
		logFiltersUtil.fixDivOverflow(true);
		logFilterComment.panel.open();
	},
	
	close: function() {
		
		logFiltersUtil.fixDivOverflow(false);
		logFilterComment.panel.close();
	},
	
	save: function() {
		
		var comment = util.getF('log_filter_comment:comment');
		
		// Escape newline and carriage return with <br /> tags
		comment = comment.replace(/\n/g, '<br />'); // newline
		comment = comment.replace(/\r/g, '<br />'); // carriage return
		
		logFilters.activeComment = comment;
		
		logFilterComment.close();
		logFiltersUtil.comment.updateDisplay(comment);
	}
};


