//
// logFiltersUtil.js
//

var logFiltersUtil = {
	
	filterType: {
		
		toggleDisplay: function() {
			
			// Invoked by select element only
			var filterType = util.getF('log_filters:type');
			logFiltersUtil.filterType.setDisplay(filterType);
			
		},
		
		updateDisplay: function(filterType) {
			
			util.setF('log_filters:type', filterType);
			logFiltersUtil.filterType.setDisplay(filterType);
		},
		
		setDisplay: function(filterType) {
			
			// Reset any errors
			logFilters.validator.reset();
			util.hideE('log_filters:structured:error'); // resets any structured filter error
			
			var isExpression = (filterType == 'expression');
			
			util.showE('log_filters:expression:section', isExpression);
			util.showE('log_filters:structured:section', !isExpression);
			
			logFilters.activeFilterType = filterType;
		}
	},
	
	boolOperator: {
		
		setSectionDisplay: function(numberOfConditionalItems) {
			
			// We show the boolean operator section if there is more than one condition in the list
			// alert('boolOperator.updateDisplay(): ' + numberOfConditionalItems);
			
			var showSection = (numberOfConditionalItems > 1);
			util.showE('log_filters:boolean_operator:section', showSection);
		},
		
		toggleOperator: function() {
			var operator = util.getF('log_filters:boolean_operator');
			logFiltersUtil.boolOperator.setOperatorDisplay(operator);
		},
		
		setOperatorDisplay: function(operator) {
			var isCustomOperator = (operator == 'custom');
			util.showEV('log_filters:boolean_operator_sequence:example', isCustomOperator);
			util.showE('log_filters:boolean_operator_sequence:section', isCustomOperator);
		}
	},
	
	
	boolOperatorSequence: {
		
		getSequenceLetterByItemNumber: function(itemNumber) {
			
			// KHP-RC, if itemNumber is greater letter sequence length then get the right letter, i.e. AA, BB
			var theLetter = logFilters.sequenceLettersDb[itemNumber];
			
			// alert('getSequenceLetterByItemNumber - itemNumber: ' + itemNumber + '\ntheLetter: ' + theLetter);
			
			return theLetter;
		},
		
		validate: function(sequence, numberOfConditionItems) {
			
			// Returns the object "obj"
			/*
			var obj = {
				sequence: '', // A cleaned-up representation of the sequence to be saved in items dat
				isError: false,
				errorMsg: ''
			}
			*/
			
			var i;
			
			var cleanedUpSequence = '';
			
			var boolOrWord = logFilters.boolOrWord;
			var boolAndWord = logFilters.boolAndWord;
			var numberOfOpeningBraces = 0;
			var numberOfClosingBraces = 0;
			var numberOfOperators = 0;
			var invalidLetters = []; // Tracks any invalid letter
			
			/*
			Create a letterState object where we look up the letters in the sequence
			and where we track the number of found letters. We can use this object
			to check if the sequence has duplicate letters.
	
			letterState = {
				_A = 0 // We count the occurance of each found letter
				_B = 0
				_C = 0
				_D = 0
			}
			*/ 
			
			var sequenceLettersDb = logFilters.sequenceLettersDb;
			var letterState = {};
			
			for (i = 0; i < numberOfConditionItems; i++) {
				var theEscapedLetter = '_' + util.getRepetitionSequenceLetter(sequenceLettersDb, i);
				letterState[theEscapedLetter] = 0;
			}
			
			// util.showObject(letterState);
			
			// alert('boolOperatorSequence in original language: ' + sequence);

			// Replace all braces with a space so that we can split the sequence
			sequence = sequence.replace(/\(/g, ' ( ');
			sequence = sequence.replace(/\)/g, ' ) ');
			
			// alert('sequence after we replaced braces with spaces: ' + sequence);
			
			var sequenceSplit = sequence.split(' ');
			
			// alert('sequence after split: ' + sequenceSplit);
			
			for (i = 0; i < sequenceSplit.length; i++) {
				
				var sequenceItem = sequenceSplit[i];
				
				if (sequenceItem != '') {
					
					// alert('sequenceItem: "' + sequenceItem + '"');
					
					switch (sequenceItem) {
						
						case '(':
							
							cleanedUpSequence += '(';
							numberOfOpeningBraces++;
							break;
						
						case ')':
						
							cleanedUpSequence += ')';
							numberOfClosingBraces++;
							break;
							
						case boolOrWord: 
							
							cleanedUpSequence += ' ' + boolOrWord + ' ';
							numberOfOperators++;
							break;
							
						case boolAndWord: 
						
							cleanedUpSequence += ' ' + boolAndWord + ' ';
							numberOfOperators++;
							break;
							
						default:
						
							// This must be an item letter
							var escapedSequenceItem = '_' + sequenceItem;
							
							if (letterState[escapedSequenceItem] != null) {
								
								cleanedUpSequence += sequenceItem;
								
								// alert('letter found: "' + escapedSequenceItem + '"');
								// The letter is valid.
								// Count the occurence of this letter in letterState
								letterState[escapedSequenceItem] = letterState[escapedSequenceItem] + 1;
							}
							else {
								// This must be an invalid letter
								// alert('letter not found: "' + escapedSequenceItem + '"');
								invalidLetters[invalidLetters.length] = sequenceItem;
							}
						
							break;
					}
				}
			}
			
			// util.showObject(letterState);
			/*
			alert('invalidLetters: ' + invalidLetters);
			
			var tempS = 'ValidationInfo:';
			tempS += '\nnumberOfOpeningBraces: ' + numberOfOpeningBraces;
			tempS += '\nnumberOfClosingBraces: ' + numberOfClosingBraces;
			tempS += '\nnumberOfOperators: ' + numberOfOperators;
			
			alert(tempS);
			*/
			
			//
			//
			// Check for any errors in validation variables
			//
			//
			
			var isError = false;
			var errorMsg = langVar('lang_admin.log_filters.invalid_bool_operator_sequence') + ' ';
			
			if (invalidLetters.length > 0) {
				isError = true;
				// errorMsg += 'The letter "' + invalidLetters + '" is not a valid sequence letter.';
				errorMsg += langVar('lang_admin.log_filters.invalid_sequence_letter_msg');
				errorMsg = errorMsg.replace(/__PARAM__1/, invalidLetters);
			}
			else if (numberOfOpeningBraces != numberOfClosingBraces) {
				isError = true;
				errorMsg += langVar('lang_admin.log_filters.invalid_number_of_braces');
			}
			else if (numberOfOperators > 1 && numberOfOpeningBraces == 0) {
				isError = true;
				errorMsg += langVar('lang_admin.log_filters.no_braces_defined_msg');
			}
			else if (numberOfOperators != (numberOfConditionItems - 1)) {
				isError = true;
				errorMsg += langVar('lang_admin.log_filters.invalid_number_of_bool_operators_msg');
			}
			else {
				
				// Check for valid letters
				var missingLetters = '';
				var duplicateLetters = '';
				
				for (var prop in letterState) {
					
					var numberOfLetterItems = letterState[prop];
					
					if (numberOfLetterItems < 1) {
						missingLetters += prop.replace(/_/, '') + ', ';
					}
					else if (numberOfLetterItems > 1) {
						duplicateLetters += prop.replace(/_/, '') + ', ';
					}
				}
				
				if (missingLetters != '') {
					isError = true;
					missingLetters = missingLetters.replace(/,\s$/, '');
					// errorMsg += 'The letter "' + missingLetters + '" is missing.';
					errorMsg += langVar('lang_admin.log_filters.missing_sequence_letter_msg');
					errorMsg = errorMsg.replace(/__PARAM__1/, missingLetters);
				}
				
				if (duplicateLetters != '') {
					isError = true;
					duplicateLetters = duplicateLetters.replace(/,\s$/, '');
					// errorMsg += 'The letter "' + duplicateLetters + '" is a duplicate.';
					errorMsg += langVar('lang_admin.log_filters.duplicate_sequence_letter_msg');
					errorMsg = errorMsg.replace(/__PARAM__1/, duplicateLetters);
				}
			}
			
			var obj = {
				sequence: cleanedUpSequence,
				isError: isError,
				errorMsg: errorMsg
			}
			
			return obj;
		},
		
		convertNumericalToLetterFormat: function(numberOfConditions, numericalSequence) {
			
			var boolOrWord = logFilters.boolOrWord;
			var boolAndWord = logFilters.boolAndWord;
			var sequenceLettersDb = logFilters.sequenceLettersDb;
			
			// Replace all English ' or ' words with the local language ' or ' words
			var letterSequence = numericalSequence.replace(/\sor\s/g, ' ' + boolOrWord + ' ');
			
			// Replace all English ' and ' words with the local language ' and ' words
			var letterSequence = letterSequence.replace(/\sand\s/g, ' ' + boolAndWord + ' ');
			
			for (var i = 0; i < numberOfConditions; i++) {
				
				var numericalPresentation = '__IntEsc__' + i + '__'; // i.e. "__IntEsc__0__"
				var numericalPresentationPattern = new RegExp(numericalPresentation);
				var letterPresentation = util.getRepetitionSequenceLetter(sequenceLettersDb, i);				
				letterSequence = letterSequence.replace(numericalPresentationPattern, letterPresentation);
			}
			
			// alert('letterSequence: ' + letterSequence);
			
			return letterSequence;
		},
		
		convertLetterToNumericalFormat: function(numberOfConditions, letterSequence) {
			
			var sequenceLettersDb = logFilters.sequenceLettersDb;
			
			var orPattern = new RegExp(' ' + logFilters.boolOrWord + ' ', 'g');
			var andPattern = new RegExp(' ' + logFilters.boolAndWord + ' ', 'g');
			
			var numericalSequence = '';
			
			numericalSequence = letterSequence.replace(orPattern, ' or ');
			numericalSequence = numericalSequence.replace(andPattern, ' and ');
			
			//
			// Convert the letters to numbers
			// Note, we must start conversion with higher numbers
			// so that i.e. "AA" becomes converted prior "A"
			
			for (var i = numberOfConditions - 1; i >= 0; i--) {
				
				var theLetter = util.getRepetitionSequenceLetter(sequenceLettersDb, i);	
				var theLetterPattern = new RegExp(theLetter);
				numericalSequence = numericalSequence.replace(theLetterPattern, '__IntEsc__' + i + '__');
			}
			
			// alert('numericalSequence: ' + numericalSequence);
			
			return numericalSequence;
		}
	},
	
	comment: {
		
		updateDisplay: function(theComment) {
			
			// theComment may contain HTML tags, i.e. <br />,
			// so we use innerHTML for comment display!
			
			var isComment = (theComment != '');
			
			var buttonLabel = isComment ? langVar('lang_admin.log_filters.edit_comment') : langVar('lang_admin.log_filters.add_comment');
			util.updateT('log_filters:comment:add_edit_btn_1', buttonLabel);
			util.updateT('log_filters:comment:add_edit_btn_2', buttonLabel);
			
			// util.updateT('log_filters:comment:display', theComment);
			var commentElement = util.getE('log_filters:comment:display');
			commentElement.innerHTML = theComment;
			
			util.showE('log_filters:comment:display', isComment);
			
			// util.showE('log_filters:comment:add_btn', !isComment);
			// util.showE('log_filters:comment:edit_btn', isComment);
			
			logFilters.activeComment = theComment;
		}
	},
	
	//
	// Log fields list utilities
	//
	
	populateFullLogFieldsList: function(elementId, addSelectOption) {
		// Populates the given Select Element with log field items
		logFiltersUtil.populateLogFieldsList(elementId, addSelectOption, true, true);
	},
	
	populateStringLogFieldsList: function(elementId, addSelectOption) {
		// Populates the given Select Element with log field items of type string
		logFiltersUtil.populateLogFieldsList(elementId, addSelectOption, true, false);
	},
	
	populateLogFieldsList: function(elementId, addSelectOption, isStringFields, isNumericalFields) {
		
		var logFields = [];
		
		if (isStringFields && isNumericalFields) {
			logFields = logFilters.logFieldsDb;
		}
		else if (isStringFields) {
			logFields = logFilters.logFieldsOfTypeStringDb;
		}
		
		if (addSelectOption) {
			
			var selectOptionDb = [{name:'', label:langVar('lang_admin.log_filters.select_log_field')}];
			util.populateSelect(elementId, selectOptionDb, 'name', 'label');
			util.extendSelect(elementId, logFields, 'name', 'label');
		}
		else {
			
			util.populateSelect(elementId, logFields, 'name', 'label');
		}
	},

	fixDivOverflow: function(isFix) {
		
		// Firefox has a problem with the underlying filter item div's.
		// The problem is caused by the div overflow setting where form fields
		// above the div don't anymore show focus on form fields. We solve this
		// by setting the div overflow to 'hidden' while a subform is open.
		
		var element = util.getE('log_filters:structured:list:div');
		element.style.overflow = isFix ? 'hidden' : 'scroll';
	},
	
	
	viewAvailableExpressionFields: { // View Available Log Fields panel in Expression Log Filter
		
		fieldsPanel: null,
		
		init: function() {
			
			// Create the available expression fields list
			
			var availableExprFieldsDb = [];
			var logFieldsDb = logFilters.logFieldsDb;
			for (var i = 0; i < logFieldsDb.length; i++) {
				var logFieldItem = logFieldsDb[i];
				availableExprFieldsDb[i] = {label:logFieldItem.label, name:logFieldItem.name};
			}
			

			var viewExprFieldsObj = {
				panelId: 'view_log_filter_expression_fields:panel',
				tbodyId: 'view_log_filter_expression_fields:tbody',
				panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
				availableExpressionFieldsDb: availableExprFieldsDb
				// left: 0
			};
			
			logFiltersUtil.viewAvailableExpressionFields.fieldsPanel = new AvailableExprFields(viewExprFieldsObj);
			
			yEvent.addListener('view_log_filter_expression_fields:close_btn', 'click', logFiltersUtil.viewAvailableExpressionFields.close);
		},
		
		open: function() {
			logFiltersUtil.viewAvailableExpressionFields.fieldsPanel.open();
		},
		
		close: function() {
			logFiltersUtil.viewAvailableExpressionFields.fieldsPanel.close();
		}
	}
};


