//
// logProcessing
//

var logProcessing = {
	
	theList: null,
	itemsDb: [], // items work array
	itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
	
	validator: null,
	
	saveChangesBtn: null,
	undoAllChangesBtn: null,
	
	activeItemType: '',
	isPositionedDSListMoveControl: false
}

function init() {
	
	logProcessing.validator = new util.Validator();
	
	
	// init distributed servers list and panel
	logProcessingDSList.init();
	logProcessingDS.init();
	

	// init toolbar buttons
	logProcessing.saveChangesBtn = new util.ToolbarButton('save_changes', saveLogProcessing, toolbarButtonsDb);		
	logProcessing.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	var isEdit = pageInfo.permissions.isEdit;
	
	if (isEdit) {
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		
		logProcessing.saveChangesBtn.disableAndIgnore();
		logProcessing.undoAllChangesBtn.disableAndIgnore();
	}
	
	// Create theList object
	logProcessing.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
	});
	
	// init OptionInfo
	adminConfig.optionInfo.init('item_list', 'list');
	
	// KHP 08/Dec/2010 - Distributed Processing exists only in enterprise
	if (pageInfo.licensingFeatures == 'enterprise') {
		yEvent.addListener('dlp:method', 'change', distributedMethodActor);
		yEvent.addListener('dlp:add_server_btn', 'click', logProcessingDS.newItem);
	}
}

function initItems() {
	
	// Sets all input controls to initial itemsDb values
	// Also used upon Undo Changes

	/*
		Init item list
	*/
	
	var itemsDb = logProcessing.itemsDb;

	logProcessing.theList.init(itemsDb);
	
	/*
		Init form data
	*/
	
	for (var i = 0; i < itemsDb.length; i++) {
		
		var item = itemsDb[i];
		var itemType = item.type;
		var itemDat = item.dat;
		
		// util.showObject(itemDat);
		
		switch (itemType) {
			
			case 'output':
			
				util.setF('lp_output:field_delimiter', itemDat.field_delimiter);
				util.setF('lp_output:output_date_time_format', itemDat.output_date_time_format);
				util.setF('lp_output:empty_output_value', itemDat.empty_output_value);
				util.setF('lp_output:suppress_output_header', itemDat.suppress_output_header);
			
				break;
			
			case 'distributed_processing':
				
				util.setF('dlp:method', itemDat.method);
				util.setF('dlp:starting_port_auto', itemDat.starting_port_auto);
				util.setF('dlp:number_of_servers', itemDat.number_of_servers);
				util.setF('dlp:file_by_file', itemDat.file_by_file);
				
				// Compose servers list
				logProcessingDSList.list.compose(itemDat.servers);
				
				setDistributedMethodDisplay(itemDat.method);
			
				break;
			
			case 'charset_conversion':
			
				convertCharset.update(
					itemDat.convert_log_data_charset.value,
					itemDat.convert_log_data_from_charset.value,
					itemDat.convert_log_data_to_charset.value
				);

				break;
				
			default:
			
				for (var prop in itemDat) {
				
					var value = itemDat[prop].value;
					var type = itemDat[prop].type;
					util.setF(prop, value);
					
					if (type == 'bytes') {
						util.setF(prop + ':unit', itemDat[prop].bytesUnit);
					}
				}
		}
	}
	
	setItem('i0');
}

function initDistributedProcessingDisplay() {
	
	util.showE('dlp:listed:section');
	// Position the server list move control
	// We need to give it some time, else we don't get the right list position
	var s = 'dlp:server_list:div';
	setTimeout('logProcessingDSList.moveControl.setPosition("' + s + '")', 250);
}

function getLogProcessingData() {
	
	if (!pageInfo.exitActive) {
		
		var url = '?dp+templates.config_pages.log_processing.get_log_processing_data';
		url += '+p+' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		
		// Init help
		util.helpWindow.init('');
		
		util.serverPost(url, dat);
	}
}

function getLogProcessingDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
		
		// util.showObject(dat);
		
		// get itemsDb
		logProcessing.itemsDb = dat.items;
		logProcessing.itemsDbBackup = util.cloneObject(dat.items);
		
		init();		
		convertCharset.init(dat.charset);
		initItems();
		
		logProcessing.saveChangesBtn.enable();
		logProcessing.undoAllChangesBtn.enable();

		util.showE('form_section');
		
		// IE 7 requires the form_section to be displayed before setItemListSize()
		adminConfig.setItemListSize();
		yEvent.addListener(window, 'resize', adminConfig.setItemListSize);
		
		pageInfo.initComplete = true;
	}
}

function distributedMethodActor() {
	
	var method = util.getF('dlp:method');
	setDistributedMethodDisplay(method);
	checkDistributedMethodServerMoveControlPosition();
}

function setDistributedMethodDisplay(method) {
	
	// method is: one_processor | some_processors | all_processors | listed_servers
	
	// alert('setDistributedMethodDisplay() - method: ' + method);
	
	util.hideE(['dlp:starting_port_auto:section', 'dlp:number_of_servers:section', 'dlp:listed:section']);
	
	// Nothing is shown for one_processor!
	
	if (method == 'all_processors') {
		util.showE('dlp:starting_port_auto:section');
	}
	else if (method == 'some_processors') {
		util.showE('dlp:starting_port_auto:section');
		util.showE('dlp:number_of_servers:section');
	}
	else if (method == 'listed_servers') {
		util.showE('dlp:listed:section');
	}
	
	resetDistributedServerListError();
}

function checkDistributedMethodServerMoveControlPosition() {
	
	if (!logProcessing.isPositionedDSListMoveControl &&
	(logProcessing.activeItemType == 'distributed_processing') &&
	(util.getF('dlp:method') == 'listed_servers')) {
	
		// Position the server list move control
		// We need to give it some time, else we don't get the right list position
		var s = 'dlp:server_list:div';
		setTimeout('logProcessingDSList.moveControl.setPosition("' + s + '")', 250);
		logProcessing.isPositionedDSListMoveControl = true;
	}
}

function resetDistributedServerListError() {
	
	util.hideE('dlp:server_list:error');
}

function itemActivated(itemId) {
	
	if (validateActiveItem()) {		
		setItem(itemId);
	}
}

function setItem(itemId) {
	
	var theList = logProcessing.theList;
	
	theList.selectItem(itemId);
	
	// display the form
	util.hideE([
		'log_processing:general:form',
		'log_processing:threads_and_sizes:form',
		'log_processing:output:form',
		'log_processing:distributed_processing:form',
		'log_processing:charset_conversion:form'
	]);
	
	var item = theList.getSelectedItem();
	var itemType = item.type;
	util.updateT('item_form_label', item.label);
	
	logProcessing.activeItemType = itemType;
	util.showE('log_processing:' + itemType + ':form');
	
	if (itemType == 'distributed_processing') {
		checkDistributedMethodServerMoveControlPosition();
	}
}

function validateActiveItem() {
	
	// Only validate items if isEdit permission
	
	if (pageInfo.permissions.isEdit) {
	
		var validator = logProcessing.validator;
		
		validator.reset();
		resetDistributedServerListError();
		
		var theList = logProcessing.theList;
		var activeItem = theList.getSelectedItem();
		// var activeItemDat = activeItem.dat;
		
		var isDistributedServersListError = false;
		var activeItemType = activeItem.type;
		
		// util.showObject(activeItem, 'validateActiveItem() START');
		
		var o = {};
		
		if (activeItemType != 'distributed_processing' && activeItemType != 'output') {
			// Clone the active item dat and set its values. (We clone it to keep
			// item dat properties such as type and bytesUnit)
			o = util.cloneObject(activeItem.dat);
		}
		
		switch (activeItemType) {
			
			// Validate and override the cloned object with the active form values
					
			case 'general':
				
				// set date_offset to 0 if empty
				var dateOffset = util.getF('date_offset');
				o.date_offset.value = (dateOffset == 0 || dateOffset == '') ? 0 : validator.isFloat('date_offset', -23.9, 23.9);
				o.default_log_date_year.value = util.getF('default_log_date_year');
				o.ignore_regexp_for_skip_checksum.value = util.getF('ignore_regexp_for_skip_checksum');
				
				// get all checkbox values
				for (var prop in o) {			
					if (o[prop].type == 'boolean') {
						o[prop].value = util.getF(prop);
					}
				}
		
				break;
				
			case 'threads_and_sizes':
		
				// 2008-11-29 - GMF - Deprecated	
				// o.threads.value = validator.isInteger('threads', 0);
				
				o.thread_data_block_size.value = validator.isInteger('thread_data_block_size', 1);
				o.thread_data_block_size.bytesUnit = util.getF('thread_data_block_size:unit');
				
				o.read_block_size.value = validator.isInteger('read_block_size', 1);
				o.read_block_size.bytesUnit = util.getF('read_block_size:unit');
				
				o.maximum_read_block_size.value = validator.isInteger('maximum_read_block_size', 1);
				o.maximum_read_block_size.bytesUnit = util.getF('maximum_read_block_size:unit', 1);
				
				// KHP 30/Dec/2010 - log_entry_pool_size is no longer used
				// o.log_entry_pool_size.value = validator.isInteger('log_entry_pool_size', 1);
	
				break;
							
			case 'distributed_processing':
			
				// distributedMethod is: one_processor | some_processors | all_processors | listed_servers
	
				var distributedMethod = util.getF('dlp:method');
				var startingPortAuto = '';
				var numberOfServers = 2;
				var servers = logProcessingDSList.list.getItemsClone();
				
				// Keep the startingPortAuto value and numberOfServers value in all cases, if any, regardless of the distributedMethod
				if (distributedMethod == 'all_processors' || distributedMethod == 'some_processors') {
				
					startingPortAuto = validator.isValue('dlp:starting_port_auto');
					
					if (distributedMethod == 'some_processors') {
						// the minimum number_of_servers is 2
						numberOfServers = validator.isInteger('dlp:number_of_servers', 2);
					}
				}
				else {
					
					// Get startingPortAuto value
					startingPortAuto = util.getF('dlp:starting_port_auto');
					
					if (distributedMethod == 'listed_servers' && servers.length == 0) {
	
						// No servers defined, throw custom error message
						isDistributedServersListError = true;
						util.updateT('dlp:server_list:error', langVar('lang_admin.log_processing.distributed.no_server_defined_error_msg'));
						util.showE('dlp:server_list:error');
					}
				}
				
				o.method = distributedMethod;
				o.starting_port_auto = startingPortAuto;
				o.number_of_servers = numberOfServers;
				o.servers = servers;
				o.file_by_file = util.getF('dlp:file_by_file');
			
				break;
				
			case 'charset_conversion':
	
				o.convert_log_data_charset.value = util.getF('convert_charset');
				o.convert_log_data_from_charset.value = util.getF('convert_from_list:charset');
				o.convert_log_data_to_charset.value = util.getF('convert_to_list:charset');
				
				if (o.convert_log_data_charset.value) {
					
					// validate charset
					
					if (o.convert_log_data_from_charset.value == '' || o.convert_log_data_to_charset.value == '') {
						
						validator.isCustom('convert_charset', langVar('lang_admin.charset_conversion.no_charsets_defined_msg'));
					}
					else if (o.convert_log_data_from_charset.value == o.convert_log_data_to_charset.value) {
						
						validator.isCustom('convert_charset', langVar('lang_admin.charset_conversion.duplicate_charset_msg'));
					}
				}
				
				break;
				
			case 'output':
			
				o.field_delimiter = util.getF('lp_output:field_delimiter');
				o.output_date_time_format = util.getF('lp_output:output_date_time_format');
				o.empty_output_value = util.getF('lp_output:empty_output_value');
				o.suppress_output_header = util.getF('lp_output:suppress_output_header');
				
				break;
		}
		
		if (validator.allValid() && !isDistributedServersListError) {
			
			// util.showObject(o, 'validateActiveItem() before saveItem()');
			theList.saveItem(o);
			return true;
		}
		
		return false;
	}
	else {
		
		return true;	
	}
}

function undoAllChanges() {
	
	logProcessing.itemsDb = util.cloneObject(logProcessing.itemsDbBackup);
	initItems();
}

function saveLogProcessing() {

	if (validateActiveItem()) {
		
		var isModified = logProcessing.theList.getIsModified();
		
		if (isModified) {
			
			util.hideE('form_section');
			util.showE('saving_info');
			
			var itemsDb = logProcessing.itemsDb;
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			var path = 'v.fp.log_processing';
			
			for (var i = 0; i < itemsDb.length; i++) {
				
				var item = itemsDb[i];
				var itemType = item.type;
				var itemDat = item.dat;
				
				switch(itemType) {
					
					case 'output': 
					
						dat += path + '.output.field_delimiter=' + encodeURIComponent(itemDat.field_delimiter) + '&';
						dat += path + '.output.output_date_time_format=' + encodeURIComponent(itemDat.output_date_time_format) + '&';
						dat += path + '.output.empty_output_value=' + encodeURIComponent(itemDat.empty_output_value) + '&';
						dat += path + '.output.suppress_output_header=' + itemDat.suppress_output_header + '&';
						
						break;
					
					case 'distributed_processing':
					
						// util.showObject(itemDat);
					
						dat += path + '.distributed.method=' + itemDat.method + '&';
						dat += path + '.distributed.starting_port_auto=' + encodeURIComponent(itemDat.starting_port_auto) + '&';
						dat += path + '.distributed.number_of_servers=' + itemDat.number_of_servers + '&';
						dat += path + '.distributed.file_by_file=' + itemDat.file_by_file + '&';
						
						var distributedServers = itemDat.servers;
						
						if (distributedServers.length > 0) {
							
							for (var j = 0; j < distributedServers.length; j++) {
								
								var distributedServerItem = distributedServers[j];
								
								dat += path + '.distributed.servers.' + j + '.position=' + j + '&';
								dat += path + '.distributed.servers.' + j + '.hostname=' + encodeURIComponent(distributedServerItem.hostname) + '&';
								dat += path + '.distributed.servers.' + j + '.port=' + encodeURIComponent(distributedServerItem.port) + '&';
								dat += path + '.distributed.servers.' + j + '.spawn=' + distributedServerItem.spawn + '&';
							}
						}
						else {
							
							dat += path + '.distributed.servers=&';
						}
						
						break;
					
					default:
					
						for (var prop in itemDat) {
							
							var value = itemDat[prop].value;
							var type = itemDat[prop].type;
							
							if (type == 'bytes' && itemDat[prop].bytesUnit != 'bytes') {
								// Add bytes unit to value
								value += itemDat[prop].bytesUnit;
							}
							
							dat += path + '.' + prop + '=' + encodeURIComponent(value) + '&';
						}
				}
			}
			
			// var pattern = /&$/;
			dat = dat.replace(/&$/, '');
			
			var url = '?dp+templates.config_pages.log_processing.save_log_processing_data';
			url += '+p+' + pageInfo.profileName;
			util.serverPost(url, dat);
			pageInfo.saveActive = true;
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveLogProcessingResponse() {
	
	// reset isModified
	logProcessing.theList.resetIsModified();
	
	// the saved work itemsDb becomes now the itemsDbBackup
	logProcessing.itemsDbBackup = util.cloneObject(logProcessing.itemsDb);
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function getIsModifiedPage() {

	// Before checking isModified we need to validate the form!
	if (!validateActiveItem() || logProcessing.theList.getIsModified()) {
		return true;
	}
	return false;
}
