 //
// logProcessingDSList.js (Log Processing Distributed Server List)
//

var logProcessingDSList = {
	
	moveControl: null,
	list: null,
	
	init: function() {
		
		//
		// Create the  list object
		//
		
		var obj = {
			name: 'servers',
			tbodyElementId: 'dlp:server_list:tbody',
			noItemText: langVar('lang_admin.log_processing.distributed.no_server_defined'),
			isDefaultItem: true,
			listChangeNotificationFunction: logProcessingDSList.listChangeNotification,
			editItemFunction: logProcessingDS.editItem,
			duplicateItemFunction: logProcessingDS.duplicateItem,
			labelBuilderFunction: logProcessingDS.labelBuilder
		}
		
		logProcessingDSList.list = new listcontrollerB.List(obj);
		logProcessingDSList.moveControl = new util.MoveControl('dlp_server_list_move_control', logProcessingDSList.moveItem);
	},
	
	listChangeNotification: function(listName, selectedItemIndex, numberOfItems) {
		// Called from wide item list controller upon list change
		// Set button state of move control
		logProcessingDSList.moveControl.setState(selectedItemIndex, numberOfItems);
		
		// Reset any inidficated server list error in logProcessing.js
		resetDistributedServerListError();
	},
	
	moveItem: function() {
		
		// Invoked from move buttons
		var direction = logProcessingDSList.moveControl.getMoveDirection(this.id);
		// Move item in list
		logProcessingDSList.list.moveItem(direction);
	}
}
