//
// log source
//


var theList;
var itemsDb = [];  // items work array
var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes


var validator = new util.Validator();
// var yEvent = YAHOO.util.Event;

var logSource = {
	
	saveChangesBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	isEditPermission: false
}

function init() {
	
	//
	// init toolbar buttons
	//
	
	logSource.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	logSource.newItemBtn = new util.ToolbarButton('new_log_source', newItem, toolbarButtonsDb);
	logSource.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
	logSource.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
	logSource.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	var permissions = pageInfo.permissions;

	if (permissions.isEdit) {
		
		if (!permissions.isAdd) {
			logSource.newItemBtn.disableAndIgnore();
			logSource.duplicateBtn.disableAndIgnore();
		}
		
		if (!permissions.isDelete) {
			logSource.deleteBtn.disableAndIgnore();
		}
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		
		logSource.saveChangesBtn.disableAndIgnore();
		logSource.newItemBtn.disableAndIgnore();
		logSource.duplicateBtn.disableAndIgnore();
		logSource.deleteBtn.disableAndIgnore();
		logSource.undoAllChangesBtn.disableAndIgnore();
	}
	
	//
	// Create theList object
	//
	
	theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated,
		isSwitch1: true,
		isMoveControl: true
	});
	
	
	//
	// misc
	//
	
	yEvent.addListener('label', 'blur', updateFormLabel);
	yEvent.addListener('log_source_type', 'change', setLogSourceTypeDisplay);
	
	yEvent.addListener('local:browse_btn', 'click', browseLocalLogSource);
	yEvent.addListener('show_matching_files_btn', 'click', showMatchingFiles);
	yEvent.addListener('close_matching_files_btn', 'click', closeMatchingFiles);
	
	// init OptionInfo
	adminConfig.optionInfo.init('item_list', 'list');
}

function initItemList() {
	
	theList.init(itemsDb);
	
	// select the first item
	var firstItemId = theList.getFirstItemId();
	setItem(firstItemId);
}

function getLogSourceData() {
	
	if (!pageInfo.exitActive) {
	
		var url = '?dp+templates.config_pages.log_source.get_data';
		url += '+p+' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
	
		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}

function getLogSourceDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
		itemsDb = dat;
		itemsDbBackup = util.cloneObject(dat);
		
		init();
		initItemList();
		
		// Set final toolbar state
		logSource.saveChangesBtn.enable();
		logSource.undoAllChangesBtn.enable();
		logSource.newItemBtn.enable();
		logSource.duplicateBtn.enable();
		
		util.showE('form_section');
		// IE 7 the form_section to be displayed for setItemListSize()
		adminConfig.setItemListSize();
		yEvent.addListener(window, 'resize', adminConfig.setItemListSize);
		pageInfo.initComplete = true;
	}
}

function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		setItem(itemId);
	}
}

function setItem(itemId) {
	
	closeMatchingFiles();
	
	// Select active item in list and displays the form	
	theList.selectItem(itemId);
	updateForm(itemId);
	
	// Set delete button
	var makeEnabled = (theList.getNumberOfItems() > 1);
	logSource.deleteBtn.enable(makeEnabled);
}

function newItem() {
	
	if (validateActiveItem()) {
	
		var newItemId = theList.getNewItemId();
		var label = langVar('lang_admin.general.new_log_source');
		
		var newLogSource = {
			id: newItemId,
			type: '',
			switch1: true,
			label: label,
			dat: {
				label: label,
				type: 'local',
				process_subdirectories: false,
				pattern_is_regular_expression: false
			}
		}
		
		theList.newItem(newLogSource);
		
		setItem(newItemId);
	}
}

function duplicateItem() {
		
	if (validateActiveItem()) {

		var clonedItemId = theList.cloneItem();
		setItem(clonedItemId);
	}
}

function deleteItem() {
	
	var nextItemIdToBeSelected = theList.deleteItem();
	validator.reset();
	setItem(nextItemIdToBeSelected);
}


function updateForm(itemId) {
	
	util.resetF('log_source_form');
	
	var item = theList.getSelectedItem();
	var itemDat = item.dat;
	var logSourceType = itemDat.type;
	var logSourceListType = (logSourceType != 'odbc') ? logSourceType : itemDat.server.type;
	var label = itemDat.label;
		
	util.setF('log_source_type', logSourceListType);
	util.setF('label', label);
	
	// Set form elements, element ids are a combination of Type:NodeName
	if (logSourceType != 'odbc') {
		for (var prop in itemDat) {
			if (prop != 'type' && prop != 'label') {
				var elementId = logSourceType + ':' + prop;
				util.setF(elementId, itemDat[prop]);
			}
		}
	}
	else {
		// set odbc type
		var serverDat = itemDat.server;
		for (var prop in serverDat) {
			if (prop != 'type') { // Server type is already set log source type list!
				var elementId = 'odbc' + ':' + prop;
				util.setF(elementId, serverDat[prop]);
			}
		}
		util.setF('odbc:query', itemDat.query);
	}
	
	// util.updateT('item_form_label', label);
	setLogSourceTypeDisplay();
}

function updateFormLabel() {
		
	var item = theList.getSelectedItem();
	var itemLabel = item.dat.label;
	var formFieldLabel = util.getF('label');

	if (itemLabel != formFieldLabel) {
		// update item list label and form label
		// util.updateT('item_form_label', formFieldLabel);
		theList.updateListLabel(formFieldLabel);
	}
}

function setLogSourceTypeDisplay() {
	
	closeMatchingFiles();
	
	var logSourceType = util.getF('log_source_type');
	if (logSourceType.indexOf('odbc') != -1) {
		logSourceType = 'odbc';
	}
	util.hideE(['local_section', 'ftp_section', 'sftp_section', 'http_section', 'odbc_section', 'command_section', 'matching_files_btn_section']);
	util.showE(logSourceType + '_section');
	if (logSourceType != 'command' && logSourceType != 'odbc') {
		util.showE('matching_files_btn_section');
	}
}

function validateActiveItem() {
	
	// Don't validate if there is no edit permission
	
	if (pageInfo.permissions.isEdit) {
	
		validator.reset();
		var o = {};
		o.label = validator.isValue('label');
		o.label = validator.isUnique('label', theList.getLookupItems('label'));
		
		var logSourceType = util.getF('log_source_type');
		
		if (logSourceType.indexOf('odbc') != -1) {
			var serverType = logSourceType;
			logSourceType = 'odbc';
		}
	
		o.type = logSourceType;
		
		switch (o.type) {
			
			case 'local':
				o.pathname = validator.isValue('local:pathname');
				o.process_subdirectories = util.getF('local:process_subdirectories');
				o.pattern_is_regular_expression = util.getF('local:pattern_is_regular_expression');
				break;
			
			case 'ftp':
				// Note, the ftp_username and ftp_password are optional, don't validate!
				o.hostname = validator.isValue('ftp:hostname');
				o.username = util.getF('ftp:username');
				o.password = util.getF('ftp:password');
				o.pathname = validator.isValue('ftp:pathname');
				o.process_subdirectories = util.getF('ftp:process_subdirectories');
				o.pattern_is_regular_expression = util.getF('ftp:pattern_is_regular_expression');
				o.use_passive = util.getF('ftp:use_passive');
				break;
				
			case 'sftp':
				// Note, the sftp_username and sftp_password are optional, don't validate!
				o.hostname = validator.isValue('sftp:hostname');
				o.username = util.getF('sftp:username');
				o.password = util.getF('sftp:password');
				o.pathname = validator.isValue('sftp:pathname');
				o.process_subdirectories = util.getF('sftp:process_subdirectories');
				o.pattern_is_regular_expression = util.getF('sftp:pattern_is_regular_expression');
				break;
				
			case 'http':
				o.hostname = validator.isValue('http:hostname');
				o.pathname = validator.isValue('http:pathname');
				break;
				
			case 'odbc':
				// Are the odbc username and password optional?
				var server = {};
				server.type = serverType;
				server.dsn = validator.isValue('odbc:dsn');
				server.username = util.getF('odbc:username');
				server.password = util.getF('odbc:password');
				server.database_name = validator.isValue('odbc:database_name');
				o.server = server;
				o.query = validator.isValue('odbc:query');
				break;
				
			case 'command':
				o.command = validator.isValue('command:command');		
				break;
		}
		
		if (validator.allValid()) {
			theList.saveItem(o);
			return true;
		}
		
		return false;
	}
	else {
		
		// No edit permission, don't validate at all
		return true;
	}
}

function saveChanges() {
	
	if (validateActiveItem()) {
		
		var isModified = theList.getIsModified();
		
		// alert('saveChanges() - isModified: ' + isModified);
		
		if (isModified) {
			
			var atLeastOneLogSourceActive = false;
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			
			for (var i = 0; i < itemsDb.length; i++) {

				var item = itemsDb[i];
				var itemDat = item.dat;
				
				var path = 'v.fp.source.' + i + '.';
				
				dat += path + 'position=' + i + '&';
				dat += path + 'disabled=' + !item.switch1 + '&';
				
				if (itemDat.type != 'odbc') {
					for (var prop in itemDat) {
						dat += path + prop + '=' + encodeURIComponent(itemDat[prop]) + '&';
					}
				}
				else {
					// odbc log source
					dat += path + 'label=' + encodeURIComponent(itemDat.label) + '&';
					dat += path + 'type=odbc&';
					dat += path + 'query=' + encodeURIComponent(itemDat.query) + '&';
					
					var serverDat = itemDat.server;
					
					for (var prop in serverDat) {
						dat += path + 'server.' + prop + '=' + encodeURIComponent(serverDat[prop]) + '&';
					}
				}
				
				if (item.switch1) {atLeastOneLogSourceActive = true;}
			}
			
			dat = dat.replace(/&$/, '');
			
			if (atLeastOneLogSourceActive) {
				
				util.hideE('form_section');
				util.showE('saving_info');

				var url = '?dp+templates.config_pages.log_source.save_data';
				url += '+p+' + pageInfo.profileName;
				util.serverPost(url, dat);
			}
			else {
				
				alert(langVar('lang_admin.log_source.no_log_source_active'));
			}
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveChangesResponse() {
	
	// reset isModified
	theList.resetIsModified();
	
	// the saved work itemsDb becomes now the itemsDbBackup
	itemsDbBackup = util.cloneObject(itemsDb);
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	itemsDb = util.cloneObject(itemsDbBackup);
	initItemList();
	validator.reset();
}

function getIsModifiedPage() {
	
	if (!validateActiveItem() || theList.getIsModified()) {
		return true;
	}
	return false;
}

/*
	Browse local log source
*/

function browseLocalLogSource() {
	
	closeMatchingFiles();
	util.fileManagerWindow.open('local:pathname');
}


/*
	Show matching files
*/


function showMatchingFiles() {
	
	if (validateActiveItem()) {
		
		var container = util.getE('matching_files_body_section');
		util.removeChildElements(container);
		
		var mainElement = util.getE('matching_files_section');
		mainElement.style.top = '310px';
		mainElement.style.left = '210px';
		mainElement.style.width = '600px';
		mainElement.style.display = 'block';
		
		// util.showE('matching_files_section');
		
		var item = theList.getSelectedItem();
		var itemDat = item.dat;
		var itemValue;
		
		var url = '?dp+templates.util.matching_files.get_matching_files';
		url += '+p+' + pageInfo.profileName;

		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		var path = 'v.fp.log_source.0.';
		var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]
		
		// dat += path + 'type=' + item.type + '&';
		
		for (var prop in itemDat) {
			
			itemValue = itemDat[prop];
			
			if (pattern.test(itemValue)) {
				itemValue = encodeURIComponent(itemValue);
			}
			
			dat += path + prop + '=' + itemValue + '&';
		}
		
		dat = dat.replace(/&$/, '');
	
		util.serverPost(url, dat);
	}
}

function showMatchingFilesResponse(dat) {
	
	var container = util.getE('matching_files_body_section');
	var label = dat.label;
	var files = dat.files;
	
	// alert(label + '\n' + files);
	
	// add label
	var h = document.createElement('h5');
	var text = document.createTextNode(label);
	h.appendChild(text);
	container.appendChild(h);
	
	// add files
	for (var i = 0; i < files.length; i++) {
	
		// var span = document.createTextNode('br');
		var text = document.createTextNode(files[i]);
		var br = document.createElement('br');
		container.appendChild(text);
		container.appendChild(br);
	}
}

function closeMatchingFiles() {
	
	util.hideE('matching_files_section');
}
