//
//
// reportElement.js (Report Element Editor)
//
//

var reportElement = {
	
	panel: null,
	
	// tabs: null, // KHP 20/Oct/2008 - add new general tab items
	// tabIds: ['display_options', 'filters', 'header_footer'], // KHP 20/Oct/2008 - add new general tab items
	// tabPanelIds: [], // generated upon init // KHP 20/Oct/2008 - add new general tab items
	
	// validator: null,
	
	// Customize report element objects
	// graphs: null,
	// graphOptions: null,
	// tableColumns: null,
	// tableOptions: null,
	// pivotTable: null,
	
	// defaultColumnsDb
	// Created upon init, it contains the default columns per report element type.
	// The default columns are cloned to activeReportElement.types by initActiveReportElementDbs()
	
	defaultColumnsDb: {
		
		table: [],
		log_detail: [],
		entry_pages: [],
		exit_pages: [],
		session_pages: [],
		session_users: [],
		individual_sessions: []
	},
	
	
	//
	//
	// Active form parameters
	//
	//
	
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index

	labelOri: '',
	activeMetaType: '',
	activeReportElementType: '',
	activeReportElementDbs: {},
	activeDisplay: '', // '' | graphs | table | graphs_and_table
	
	activeGraphsDb: {}, // contains the active graphs object (default graphs overriden by any report element graphs data)
			  	// graphsDb is used by 'graphs' and 'graphOptions'!


	/*
	activeReportElementDbs: { // initialized via initActiveReportElementDbs()
		
		overview: {},
		table: {},
		log_detail: {},
		...

		activeReportElementDbs keeps the active reportElementDb per report element type.
		So if we switch between table and log_detail we are able to maintain state between
		different report element types. If we change i.e. a table report element from file_type to
		page_directory then we only replace the report field and the first column
		of the active "table" types and then update the Customize Report Element objects accordingly.
	},
	*/
	
	
	// newItemObj is used for common properties
	// upon New Report Element or when editing an empty Report Element object
	
	newItemObj: {
		
		// Set common properties only so that
		// we can set/reset the initial form values
		// which are not covered by Customize Report Element objects
		label: langVar('lang_admin.report_editor.new_report_element'),
		label_ori: '',
		show_header_bar: false,
		type: '',
		description: '',
		header:'',
		footer: '',
		date_filter: '',
		filter_expression: '',
		table_filter_expression: '',
		show_graphs: true,
		show_table: true
	},
	
	init: function() {
		
		//
		// Init the Editor panel
		//
		
		var panelObj = {
			panelId: 'ree:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 330,
			top: 120,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: reportElement.closePanel
		};
		
		reportElement.panel = new util.Panel3(panelObj);
		
		// Create report element meta types list
		util.populateSelect('ree:report_element_meta_type', [{name:'', label:langVar('lang_admin.report_editor.select_report_element_type')}], 'name', 'label');
		util.extendSelect('ree:report_element_meta_type', reports.reportElementMetaTypesDb, 'name', 'label');
		
		
		//
		// Init Customize Report Element object
		//
		var isCustomizeInReports = false;
		var isPivotTablePermission = true; // is always true in Config
		var isGraphOptionsPermission = true; // is always true in Config
		
		var hideLogDetailSortingMessage = pageInfo.hideLogDetailSortingMessage;
		
		creControl.initCreObject(
			reports.queryFieldsDb,
			reports.defaultGraphsDb,
			isCustomizeInReports,
			isPivotTablePermission,
			isGraphOptionsPermission,
			hideLogDetailSortingMessage
		);
				
			
		//
		// Add events
		//
		
		yEvent.addListener('ree:report_element_meta_type', 'change', reportElement.display.metaTypeActor);
		yEvent.addListener('ree:report_element_display', 'change', reportElement.display.reportElementDisplayActor);
		
	
		yEvent.addListener('ree:okay_btn', 'click', reportElement.saveItem);
		yEvent.addListener('ree:cancel_btn', 'click', reportElement.closePanel);
		
		//
		// Create default column objects
		//
		
		reportElement.defaultColsUtil.create();
	},
	
	display: {
		
		//
		//
		// Main display
		//
		//
		
		/*
		tabActivated: function(tabId) {
			
			alert('tabId: ' + tabId);
			
			if (!util.isObject(tabId)) { // isObject has be addded due an IE problem as described in creControl.js!
				reportElement.display.setTabPanel(tabId);
			}
		},
		
		setTabPanel: function(tabId) {
			
			util.hideE(reportElement.tabPanelIds);
			
			if (tabId != '') {
				reportElement.tabs.setActiveTab(tabId);
				util.showE('ree:' + tabId + ':panel');
			}
		},
		*/
		
		//
		//
		// Report Element meta type
		//
		//
		
		metaTypeActor: function() {
			
			var metaType = util.getF('ree:report_element_meta_type');
			reportElement.display.setMetaType(metaType);
		},
		
		setMetaType: function(metaType) {
			
			// alert('setMetaType() - metaType: ' + metaType);
			
			if (reportElement.activeMetaType != '') {

				// Save current data to Customize Report Element objects because
				// the customize report element objects become re-initialized.
				creControl.saveChanges();
			}
			
			var reportElementType = '';
			
			var reportElementDisplay = '';
			var enableReportElementDisplayList;
			// var showTableFilterExpression = false;
			
			if (metaType != '') {
				
				showCreObjectPanel = true;
				
				var metaTypeItem = reports.reportElementMetaTypesDb[h(metaType)];
				reportElementType = metaTypeItem.type;
				var constructionType = creUtil.getConstructionType(reportElementType);
				
				// alert('reportElementType: ' + reportElementType);
				
				var reportElementDb = reportElement.activeReportElementDbs[reportElementType];
				
				// util.showObject(reportElementDb);
				
				if (constructionType == 'standard') {
					
					if (reportElementType != 'log_detail') {
						
						// showTableFilterExpression = true;
						
						if (reportElementType == 'table') {
							
							//
							// We need to update the default reportElementDb
							//
							
							var reportFieldName = metaTypeItem.name;
							reportElementDb.report_field = reportFieldName;
							
							// reportElementDb.columns[0].report_field = reportFieldName;
							
							reportElement.display.setMainColumn(reportElementDb, reportFieldName); 
						}
						
						//
						// Check default reportElementDisplay
						//
						
						var showGraphs = reportElementDb.show_graphs;
						var showTable = reportElementDb.show_table;
						
						if (showGraphs && showTable) {
							reportElementDisplay = 'graphs_and_table';
						}
						else if (showGraphs) {
							reportElementDisplay = 'graphs';
						}
						else {
							reportElementDisplay = 'table';
						}
						
						enableReportElementDisplayList = true;
					}
					else {
						
						// Log detail report
						reportElementDisplay = 'table';
						enableReportElementDisplayList = false;
					}
				}
				else {
					
					reportElementDisplay = 'table';
					enableReportElementDisplayList = false;
				}
				
				//
				// Update the Customize Report Element object
				//
				
				var obj = {}; // no obj paramters are required upon init() in Config, so we specify an empty object
				creControl.init(reportElementDb, obj);
			}
			else {
				
				// No meta type is selected
				reportElementDisplay = 'table';
				enableReportElementDisplayList = false;
				showCreObjectPanel = false;
				
				// Update the tab sequence because we don't init a reportElementDb
				creControl.updateTabSequence();
			}
			
			reportElement.activeMetaType = metaType;
			reportElement.activeReportElementType = reportElementType;
						
			util.setF('ree:report_element_display', reportElementDisplay);
			util.enableE('ree:report_element_display', enableReportElementDisplayList);
			
			//util.showE('ree:table_filter_expression:section', showTableFilterExpression);
			
			util.hideE('ree:no_report_element_selceted'); // hides the no report element selected error message
			
			util.showEV('ree:customize_report_element:object', showCreObjectPanel);
		},
		
		setMainColumn: function(reportElementDb, reportFieldName) {
			
			// This sets the report field of the main column by considering corrupted 
			// report elements where the main column is not the first column.
			
			// reportElementDb.columns[0].report_field = reportFieldName;
			
			var columns = reportElementDb.columns;
			var firstColumn = columns[0];
			
			// util.showObject(firstColumn, 'firstColumn');
			
			if (firstColumn.report_field != reportFieldName) {
				
				var i;
			
				if (firstColumn.report_field == '') {
					
					// Report field is not yet set, set first column now.
					
					firstColumn.report_field = reportFieldName;
					
					// Make sure that the set report_field does not exist in any other column.
					// We don't check the set 1st column, so i = 1
					for (i = 1; i < columns.length; i++) {
						
						if (columns[i].report_field == reportFieldName) {
							// Remove the column
							columns.splice(i, 1);
						}
					}
				}
				else {
										
					// Check if a column with the report field name already exists
					var reportFieldNameExists = false;
					
					for (i = 1; i < columns.length; i++) {
						
						if (columns[i].report_field == reportFieldName) {
							reportFieldNameExists = true;
							break;
						}
					}
					
					// Set reportFieldName in 1st column if it doesn't exist in other column
					if (!reportFieldNameExists) {
						firstColumn.report_field = reportFieldName;
					}
				}
			}
		},
		
		//
		//
		// Report Element display (graphs, table or graphs_and_table)
		//
		//
		
		reportElementDisplayActor: function() {
			
			// Update the active reportElementDb.show_graphs and reportElementDb.show_table property
			// and update the tab squence
			
			var reportElementDisplay = util.getF('ree:report_element_display');
			var showGraphs = false;
			var showTable = false;
			
			switch (reportElementDisplay) {
				case 'graphs':
					showGraphs = true;
					break;
				case 'table':
					showTable = true;
					break;
				case 'graphs_and_table':
					showGraphs = true;
					showTable = true;
					break;
			}
			
			var reportElementType = reportElement.activeReportElementType;
			var reportElementDb = reportElement.activeReportElementDbs[reportElementType];
			
			reportElementDb.show_graphs = showGraphs;
			reportElementDb.show_table = showTable;
			
			creControl.updateTabSequence();
			
			if (showGraphs) {
				// We need to save and re-init the graph options
				// because graphs sorting depends if a table is displayed or not.
				creControl.saveAndReInitGraphOptions();
			}
		}
	},
	
	newItem: function() {
		// invoked from report.js
		reportElement.mode = 'new';
		
		var newItemObj = util.cloneObject(reportElement.newItemObj);
		reportElement.initForm(newItemObj);
	},
	
	editItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		reportElement.mode = 'edit';
		reportElement.itemIndex = itemIndex;
		
		// If there is no item yet then create one now.
		if (!item.type) {
			item = util.cloneObject(reportElement.newItemObj);
		}
		
		// util.showObject(item);
		
		// alert('editItem with itemIndex: ' + itemIndex);
		reportElement.initForm(item);
	},
	
	duplicateItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// item is the original item, so don't modify object parameters such as label
		
		reportElement.mode = 'duplicate';
		reportElement.itemIndex = itemIndex;
		
		// var label = item.label;
		// item.label = label + ' ' + langVar('lang_stats.general.copy');
		var oriLabel = item.label;
		var newlabel = langVar('lang_stats.general.item_copy');
		newlabel = newlabel.replace(/__PARAM__1/, oriLabel);
		item.label = newlabel;
		
		// alert('editItem with itemIndex: ' + itemIndex);
		reportElement.initForm(item);
	},
	
	openPanel: function() {
		
		var mode = reportElement.mode;
		var panelLabel = '';
		
		if (mode == 'new') {
			panelLabel = langVar('lang_admin.report_editor.new_report_element');
		}
		else if (mode == 'edit') {
			panelLabel = langVar('lang_admin.report_editor.edit_report_element');
		}
		else {
			panelLabel = langVar('lang_admin.report_editor.edit_duplicated_report_element');
		}
		
		reportElement.panel.open({label:panelLabel});
	},
	
	closePanel: function() {
		
		reportElement.panel.close();
	},
	
	initForm: function(reportElementDb) {
		
		// Reset
		reportElement.labelOri = reportElementDb.label_ori;
		reportElement.activeMetaType = '';
		reportElement.activeReportElementType = '';
		
		// 
		// Initialize reportElementDbs
		//
	
		reportElement.initActiveReportElementDbs(reportElementDb);
		
		//
		//
		// Update form data which are not covered by Customize Report Element Objects
		//
		//
		
		util.setF('ree:report_element_label', reportElementDb.label);
		
		
		/*
			util.setF('ree:show_header_bar', reportElementDb.show_header_bar);
			til.setF('ree:description', reportElementDb.description);
			util.setF('ree:header', reportElementDb.header);
			util.setF('ree:footer', reportElementDb.footer);
			util.setF('ree:date_filter', reportElementDb.date_filter);
			util.setF('ree:filter_expression', reportElementDb.filter_expression);
			
			// Handle table_filter_expression which does not exist for every report element type
			var tableFilterExpression = reportElementDb.table_filter_expression ? reportElementDb.table_filter_expression : '';
			util.setF('ree:table_filter_expression', tableFilterExpression);
		*/
		
		//
		// 
		// Set metaType which handles the Customize Report Element Objects
		//
		//
		
		var metaType = '';
		var reportElementType = reportElementDb.type;
		var constructionType = creUtil.getConstructionType(reportElementType);
		var isLogDetail = (reportElementType == 'log_detail');
		
		
		// Before we set the metaType init the general and filters tab (they are not handled within creControl by metaType!)
		creGeneral.updateForm(reportElementDb, constructionType, isLogDetail);
		creFilters.updateForm(reportElementDb, constructionType, isLogDetail);
		
		if (reportElementType != '') {
			
			if (reportElementType == 'table') {
				metaType = reportElementDb.report_field;
			}
			else {
				metaType = '__RET__' + reportElementType;
			}
		}
		
		util.setF('ree:report_element_meta_type', metaType);
		
		reportElement.display.setMetaType(metaType); // --> this handles creControl.init()
		
		
		//
		// Open the panel
		//
		
		reportElement.openPanel();
	},

	
	saveItem: function() {
		
		var metaType = reportElement.activeMetaType;
		
		if (metaType != '') {
			
			// Save Customize Report Element object
			creControl.saveChanges();
			
			var reportElementType = reportElement.activeReportElementType;
			var constructionType = creUtil.getConstructionType(reportElementType);
			var reportElementDb = reportElement.activeReportElementDbs[reportElementType];
				
			// Note, reportElementDb only contains data of the Basics tab panel!
			// We create a new report element object which is saved to the report element db in listcontrollerB
			
			var obj = {};
			obj.label = util.getF('ree:report_element_label'); // Duplicate labels are allowed!
			obj.label_ori = reportElement.labelOri;
			obj.type = reportElementType;
			
			obj.show_header_bar = reportElementDb.show_header_bar;
			obj.description = reportElementDb.description;
			obj.header = reportElementDb.header;
			obj.footer = reportElementDb.footer;
			obj.date_filter = reportElementDb.date_filter;
			obj.filter_expression = reportElementDb.filter_expression;
			
			if (constructionType != 'overview') {
				
				obj.number_of_rows = reportElementDb.number_of_rows;
				
				if (reportElementType == 'table') {
					obj.report_field = reportElementDb.report_field;
				}
			
				if (constructionType == 'standard') {
					
					var isLogDetail = (reportElementType == 'log_detail');
					
					obj.show_graphs = !isLogDetail ? reportElementDb.show_graphs : false; 
					obj.show_table = !isLogDetail ? reportElementDb.show_table : true;
					
					obj.sort_by = reportElementDb.sort_by;
					obj.sort_direction = reportElementDb.sort_direction;
					
					obj.table_filter_expression = reportElementDb.table_filter_expression;
					
					if (!isLogDetail) {
						
						obj.omit_parenthesized_items = reportElementDb.omit_parenthesized_items;
						obj.use_overview_for_totals = reportElementDb.use_overview_for_totals;
						
						obj.show_remainder_row = reportElementDb.show_remainder_row;
						obj.show_averages_row = reportElementDb.show_averages_row;
						obj.show_min_row = reportElementDb.show_min_row;
						obj.show_max_row = reportElementDb.show_max_row;
						obj.show_totals_row = reportElementDb.show_totals_row;
						
						obj.graphs = util.cloneObject(reportElementDb.graphs);
						obj.pivot_table = util.cloneObject(reportElementDb.pivot_table);
					}
					
					obj.columns =  util.cloneObject(reportElementDb.columns);
				}
				else if (constructionType == 'session_paths') {
					
					obj.number_of_rows_expanded = reportElementDb.number_of_rows_expanded;
					obj.expand_paths_greater_than = reportElementDb.expand_paths_greater_than;
				}
			}
			
			// util.showObject(obj);
			
			// Save the item to the report element list (listcontrollerB handles save of the object)
			reportElementsList.list.saveItem(reportElement.mode, reportElement.itemIndex, obj);
			reportElement.closePanel();
		}
		else {
			// No report element type selected.
			// reportElement.display.setTabPanel('basics');
			util.showE('ree:no_report_element_selceted');
		}
	},
	
	labelBuilder: function(reportElementItem) {
		
		var label = '';
		
		if (reportElementItem.label != '') {
			label = reportElementItem.label;
		}
		else {
			label = '<span>' + langVar('lang_admin.report_editor.no_name_defined') + '</span>';
		}
		
		// alert('label: ' + label);
		
		return label;
	},
	
	//
	//
	//
	// Utilities
	//
	//
	//
	
	defaultColsUtil: {
		
		
		getColumnObject: function(queryFieldItem) {
			
			var column = {};
			column.report_field = queryFieldItem.name;
			column.show_column = true;
			
			if (queryFieldItem.isAggregatingField) {
				
				column.show_percent_column = false;
				column.show_bar_column = false;
				column.show_graph = false;
			}
			
			return column;
		},
		
		getTableColumns: function(queryFields) {
						
			// We add a fake column as the first column. This column
			// becomes replaced with the actual report element report field
			
			var a = [{report_field:'', show_column:true}]; 
			
			var getColObject = reportElement.defaultColsUtil.getColumnObject;
			
			for (var i = 0; i < queryFields.length; i++) {
				
				var item = queryFields[i];
				var isAggregatingField = item.isAggregatingField;
				var sessionField = item.sessionField;
				var nonDefaultSessionFields = /session_(begin|end|entrances|exits)/;
				var isNonDefaultSesssionField = nonDefaultSessionFields.test(sessionField);
				
				if (isAggregatingField && !isNonDefaultSesssionField) {
					a[a.length] = getColObject(item);
				}
			}
			
			return a;
		},
		
		getLogDetailColumns: function(queryFields) {
			
			var a = [];
			
			// KHP-RC, refine which fields are allowed in the log_detail report element.
			// For now we add most of the fields, though some are definely not allowed!
			
			var getColObject = reportElement.defaultColsUtil.getColumnObject;
			var i;
			var item;
			
			//
			// Add non-aggregating fields
			//
			
			for (i = 0; i < queryFields.length; i++) {
				
				item = queryFields[i];
				if (!item.isAggregatingField && item.reportElementTypeSupport.log_detail) {
					
					a[a.length] = getColObject(item);
				}
			}
			
			//
			// Add aggregating fields
			//
			
			for (i = 0; i < queryFields.length; i++) {
				
				item = queryFields[i];
				if (item.isAggregatingField && item.reportElementTypeSupport.log_detail) {
					
					a[a.length] = getColObject(item);
				}
			}
		
			return a;
		},
		
		getSessionReportElementColumns: function(sessionQueryFields, columnsBySessionFieldName) {
			
			// Note, it is possible that there are two query fields with the same category,
			// i.e. two report fields with category = "session_begin". As we don't know which
			// filed should be added we add both in this case.
			
			var a = [];
			
			if (sessionQueryFields.length > 0) {
				
				var getColObject = reportElement.defaultColsUtil.getColumnObject;
			
				for (var i = 0; i < columnsBySessionFieldName.length; i++) {
					
					var sessionField = columnsBySessionFieldName[i];
					
					// Loop through all sessionQueryFields and add each sessionQueryField which
					// matches the specified sessionFieldName in columnsBySessionFieldName
					
					for (var j = 0; j < sessionQueryFields.length; j++) {
						
						var item = sessionQueryFields[j];
						
						if (item.sessionField == sessionField) {
							
							// Add field as column
							
							a[a.length] = getColObject(item);
						}
					}
				}
			}
			
			return a;
		},
		
	
		create: function() {
			
			var queryFields = reports.queryFieldsDb;
			var sessionQueryFields = [];
			
			// Get sessionQueryFields
			for (var i = 0; i < queryFields.length; i++) {
				if (queryFields[i].derivationMethod == 'session_field') {
					sessionQueryFields[sessionQueryFields.length] = util.cloneObject(queryFields[i]);
				}
			}
			
			defaultColumnsDb = reportElement.defaultColumnsDb;
		
			//
			// Set default columns
			//
			
			var cols = reportElement.defaultColsUtil;
			
			defaultColumnsDb.table = cols.getTableColumns(queryFields);
			defaultColumnsDb.log_detail = cols.getLogDetailColumns(queryFields);
			
			defaultColumnsDb.entry_pages = cols.getSessionReportElementColumns(sessionQueryFields, ['session_page', 'session_entrances']);
			defaultColumnsDb.exit_pages = cols.getSessionReportElementColumns(sessionQueryFields, ['session_page', 'session_exits']);
			defaultColumnsDb.session_pages = cols.getSessionReportElementColumns(sessionQueryFields, ['session_page', 'sessions', 'session_events', 'session_duration']);
			defaultColumnsDb.session_users = cols.getSessionReportElementColumns(sessionQueryFields, ['session_user', 'sessions', 'session_events', 'session_duration']);
			defaultColumnsDb.individual_sessions = cols.getSessionReportElementColumns(sessionQueryFields, ['session_id', 'session_user', 'session_events', 'session_begin', 'session_end', 'session_duration']);
		}
	},
	
	
	createDefaultReportElementDb: function(type) {
		
		// Creates a default report element.
		// Note, although the Overview and other report elements don't have i.e.
		// a sort_by property it doesn't harm if we add it to the defaultDb
		// because the property will be simply ignored.
		// However, when we save the item object back to the report element db
		// in listcontrollerB we only save the appropriate report element otions!
	
		var db = {
			label: '',
			label_ori: '',
			show_header_bar: false,
			type: type,
			description: '',
			header:'',
			footer: '',
			omit_parenthesized_items: false,
			use_overview_for_totals: false,
			date_filter: '',
			filter_expression: '',
			table_filter_expression: '',
			report_field: '',
			show_graphs: true,
	        show_table: true,
			sort_by: '',
			sort_direction: '',
	        number_of_rows: 10,
	        number_of_rows_expanded: 10,
	        expand_paths_greater_than: 100,
	        show_remainder_row: true,
	        show_averages_row: false,
	        show_min_row: false,
	        show_max_row: false,
	        show_totals_row: true,
			pivot_table: {
				show_pivot_table: false,
				report_field: '',
				sort_by: '',
				sort_direction: '',
				number_of_rows: 10,
				show_averages_row: false,
				show_min_row: false,
				show_max_row: false
			}
		};
		
		var constructionType = creUtil.getConstructionType(type);
				
		if (constructionType == 'standard') {
			
			// Get a clone of the default columns
			db.columns = util.cloneObject(reportElement.defaultColumnsDb[type]);
		}
		
		// util.showObject(db);
		
		return db;
	},
	
	initActiveReportElementDbs: function(currentReportElementDb) {
		
		// creates default active report element Dbs, except for the given
		// currentReportElementDb which contains the data as in the
		// opened report element item.
		// currentReportElementDb is an empty object when we create
		// a new report element.
	
		var reportElementDbs = {};
		var currentReportElementType = currentReportElementDb.type;
		var reportElementTypes = [
			'overview',
			'table',
			'log_detail',
			'sessions_overview',
			'entry_pages',
			'exit_pages',
			'session_pages',
			'session_users',
			'individual_sessions',
			'session_paths',
			'session_page_paths'];
		
		// var activeReportElementCommon = reportElement.activeReportElement.common;
		// var activeReportElementTypes = reportElement.activeReportElement.types;
		
		var activeReportElementDbs = reportElement.activeReportElementDbs;
		
		for (var i = 0; i < reportElementTypes.length; i++) {
			
			var type = reportElementTypes[i];
			
			// Clean up existing data
			activeReportElementDbs[type] = {};
			
			if (type != currentReportElementType) {
				
				//
				// Create a default report element for the given report element type
				//
				
				activeReportElementDbs[type] = reportElement.createDefaultReportElementDb(type);
				
			}
			else {
				
				//
				// Clone the given report element to activeReportElement
				//
				
				activeReportElementDbs[type] = util.cloneObject(currentReportElementDb);
			}
		}
	}
}
