//
// sessionFields.js
//

var sessionFieldsDb = {}; // session fields data
var sessionFieldsF = {}; // contains active form data after validation

var dbFieldsDb = [];

var yEvent = YAHOO.util.Event;

var sessionFields = {
	
	saveChangesBtn: null,
	undoAllChangesBtn: null
}

function getSessionFieldsData() {
	
	if (!pageInfo.exitActive) {
		
		var url = '?dp+templates.config_pages.session_fields.get_data';
		url += '+p+' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;

		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}

function getSessionFieldsDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
	
		sessionFieldsDb = dat.sessionFields;
		dbFieldsDb = dat.dbFields;
		
		sessionFields.saveChangesBtn = new util.ToolbarButton('save_changes', saveSessionFields, toolbarButtonsDb);		
		sessionFields.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
		
		if (pageInfo.permissions.isEdit) {
			
			// Register isModifiedPageHandler in adminConfig.js
			// (We don't check for modifications if there is no edit 
			// permission because there is no Save button anyway!)
			adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
		}
		else {
			
			sessionFields.saveChangesBtn.disableAndIgnore();
			sessionFields.undoAllChangesBtn.disableAndIgnore();
		}

		sessionFields.saveChangesBtn.enable();
		sessionFields.undoAllChangesBtn.enable();
		
		adminConfig.optionInfo.init('session_fields_form', 'single');
		
		
		// populate lists
		var noneNumericalDbFields = [];
		for (var i = 0; i < dbFieldsDb.length; i++) {
			if (dbFieldsDb[i].type == 'string') {
				noneNumericalDbFields[noneNumericalDbFields.length] = {name: dbFieldsDb[i].name, label: dbFieldsDb[i].label};
			}
		}
		
		util.populateSelect('sessions_id_field', dbFieldsDb, 'name', 'label');
		util.populateSelect('sessions_visitor_id_field', noneNumericalDbFields, 'name', 'label');
		util.populateSelect('sessions_event_field', dbFieldsDb, 'name', 'label');
		util.populateSelect('sessions_page_field', noneNumericalDbFields, 'name', 'label');
		
		updateForm();
		
		util.showE('form_section');
		
		pageInfo.initComplete = true;
	}
}

function updateForm() {
	
	util.setF('sessions_id_field', sessionFieldsDb.sessions_id_field);
	util.setF('sessions_visitor_id_field', sessionFieldsDb.sessions_visitor_id_field);
	util.setF('sessions_event_field', sessionFieldsDb.sessions_event_field);
	util.setF('sessions_page_field', sessionFieldsDb.sessions_page_field);
}

function validateForm() {
	
	// saves all form data in "sessionFieldsF"
	sessionFieldsF.sessions_id_field = util.getF('sessions_id_field');
	sessionFieldsF.sessions_visitor_id_field = util.getF('sessions_visitor_id_field');
	sessionFieldsF.sessions_event_field = util.getF('sessions_event_field');
	sessionFieldsF.sessions_page_field = util.getF('sessions_page_field');
	return true;
}

function isModifiedSessionFields() {
	
	validateForm(); // get latest data into sessionFieldsF object
	
	// compare data
	for (var prop in sessionFieldsDb) {
		
		if (sessionFieldsDb[prop] != sessionFieldsF[prop]) {
			return true;
		}
	}
	
	return false;
}

function saveSessionFields() {
	
	if (isModifiedSessionFields()) {
		
		if (pageInfo.showRebuildDbAdvice) {
					
			rebuildDbAdvice.open(processSaveSessionFields);
		}
		else {
			processSaveSessionFields();
		}
	}
	else {
		
		alert(langVar('lang_stats.general.no_changes_to_save'));
	}
}

function processSaveSessionFields(isHideRebuildDbAdviceMessage) {
	
	// This function may be invoked from rebuildDbAdvice.
	// The argument isHideRebuildDbAdviceMessage only exists if invoked from rebuildDbAdvice
	
	util.hideE('form_section');
	util.showE('saving_info');
	
	var setHideRebuildDbAdviceMessage = (arguments.length == 1) ? isHideRebuildDbAdviceMessage : false;

	var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
	dat += 'v.fp.set_hide_rebuild_db_advice_message=' + setHideRebuildDbAdviceMessage + '&';
	
	for (var prop in sessionFieldsF) {
		dat += 'v.fp.field_options.' + prop + '=' + sessionFieldsF[prop] + '&';
	}
	
	dat = dat.replace(/&$/, '');
	
	var url = '?dp+templates.config_pages.session_fields.save_data';
	url += '+p+' + pageInfo.profileName;
	util.serverPost(url, dat);
	pageInfo.saveActive = true;
}

function processSaveSessionFieldsResponse() {
	// make the active form dat the sessionFieldsDb data
	sessionFieldsDb = util.cloneObject(sessionFieldsF);
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	updateForm();
}

function getIsModifiedPage() {
	
	// Before checking isModified we need to validate the form!
	if (isModifiedSessionFields()) {
		return true;
	}
	return false;
}

