//
//
//
// newProfileWizard.js
//
//
//

// KHP-RC, (25/Sep/2007) Add options.server.database_directory when saving the profile, see email with subject "Re: r7-2 error when creating new profile"

var newProfileWizard = {
	
	licensingFeatures: '', // licensingFeatures is set in index.cfv
	isLite: false,
	
	// profilesDb: [], profilesDb is set in index.cfv
	
	validator: null,
	
	//
	// Final wizard data
	//
	
	dbServer: { // Set defaults for non-enterprise users!
		type: 'internal_sql',
		database_directory: '',
		hostname: '',
		dsn: '',
		username: '',
		password: '',
		database_name: '',
		server_socket: '',
		bulk_import_method: '',
		load_data_directory: '',
		load_data_directory_on_server: '',
		sql_table_name_prefix: '',
		sql_table_name_suffix: ''
	},
	
	turnOnDatabaseFieldsIndices: true,
	turnOnCrossReferenceGroups: true,
	turnOnSessionTracking: true
}

var _wizard_path = []; // defines the taken wizard path, on back the last entry will be removed

var _log_format_list_is_auto; // defines what log format list is active (autodetected = true, all = false)
var _log_format_selected; // the selected log format in the log format wizard!
var _log_format_selected_type; // the type of the selected log format in the log format wizard!

var _log_format_db = []; // array of objects with all log formats, indexed with log format node name
var _log_format_db_loaded = false;

var _log_format_all_list_populated = false;

// var _show_log_format_all_beta_info = false;
// var _show_syslog_all_beta_info = false;
// var _show_syslog_required_all_beta_info = false;

// query string of log source, also used for show matching files!
var _log_source; // object used to generate _qs_log_source and in process_form()
var _qs_log_source;
var _real_time_processing = false;


// log_source / log_format autodetection
var _autodetcting_log_format_start_time;
var _log_format_progress_timer;
var _log_format_autodetecting_id;
var _log_format_autodetection_task_id;

var _detected_log_formats_db; // array of autodetected log formats
var _num_detected_standalone_formats = 0;
var _num_detected_syslog_formats = 0;
var _num_detected_syslog_required_formats = 0;


// variables to assemble the query string qs when creating a new profile
// log format variables are set at the time of selection
var _final_log_format_is_standalone; // true if standalone
// var _final_log_format; // the final standalone format
// var _final_syslog; // the final syslog format
// var _final_syslog_required; // the final syslog required format
var _final_log_format_id; // the final standalone format id
var _final_syslog_id; // the final syslog format id
var _final_syslog_required_id; // the final syslog required format id

var _final_log_format_string; /* log format string is set
	when log format is apache_custom, blue_coat_custom or ez_proxy_custom */


// log format options
var _numerical_fields_db;

var h = util.h;


//
// init
//

window.onload = init;

function init() {
	
	// util.showObject(newProfileWizard.profilesDb);
	// alert('newProfileWizard.init()');
	
	newProfileWizard.validator = new util.Validator();
	
	var licensingFeatures = newProfileWizard.licensingFeatures;
	newProfileWizard.isLite = (licensingFeatures == 'lite');
	
	// alert('newProfileWizard.licensingFeatures: ' + newProfileWizard.licensingFeatures);
	
	yEvent.addListener('local:browse_btn', 'click', browseLocalLogSource);
	yEvent.addListener(['log_source:read_more_btn', 'db_server:read_more_btn', 'db_performance:read_more_btn', 'numerical_fields:read_more_btn'], 'click', newProfileWizardUtil.toggleInfoPanel);

	yEvent.addListener(['log_format_multiple_match_list', 'log_format_all_list'], 'change', check_and_display_log_format_description);
	
	
	// Init database options
	if (licensingFeatures == 'advanced' || licensingFeatures == 'enterprise') {
		
		yEvent.addListener('db_server:type', 'change', toggleDatabaseType);
		yEvent.addListener('db_server:mysql_bulk_import_method', 'change', toggleMysqlBulkImportMethod);
		yEvent.addListener('db_server:mssql_bulk_import_method', 'change', toggleMssqlBulkImportMethod);
		
		util.setF('db_server:type', 'internal_sql');
	}
	
	// alert('newProfileWizard.isLite: ' + newProfileWizard.isLite);
	
	goto_wizard('log_source_page');
}


// **********
// log source
// **********

function browseLocalLogSource() {
	util.fileManagerWindow.open('local_pathname');
}

function set_log_source_display() {
	
	var activeType = util.getF('log_source_type');
	
	util.hideE([
		'log_source_section:local',
		'log_source_section:ftp',
		'log_source_section:sftp',
		'log_source_section:http',
		'log_source_section:odbc', // is used for odbc_mssql && odbc_oracle
		'log_source_section:command',
		'log_source:show_matching_files_section'
	]);
	
	
	var logSourceSection = (activeType.indexOf('odbc') == -1) ? 'log_source_section:' + activeType : 'log_source_section:odbc';
	
	util.showE(logSourceSection);
	var showMatchingFilesBtn = (activeType != 'command' && activeType.indexOf('odbc') == -1) ? true : false;
	util.showE('log_source:show_matching_files_section', showMatchingFilesBtn);
}

function validate_log_source() {
	
	// Note, this function also creates the _log_source array!
	
	// If the log source data are valid the _log_source array saves the log source data which are used to
	// a.) generate the _qs_log_source which is used to get the log format and the show matching files component
	// b.) to generate the hfe log source data in process_form when form data are submitted via POST
	
	var form_is_valid = false;
	var log_source_type = util.getF('log_source_type');
	
	
	if (log_source_type.indexOf('odbc') != -1) {
		var odbc_server_type = log_source_type;
		log_source_type = 'odbc'; // We use odbc_mssql && odbc_oracle for the server type only, the log source type is simply "odbc"!
	}
	
	_log_source = {};
	_log_source.type = log_source_type;
	
	_real_time_processing = util.getF('real_time_processing');

	switch (log_source_type) {

		case 'local' :
		
			var local_pathname = util.getF('local_pathname');
			var local_process_subdir = util.getF('local_process_subdir');
			var local_pattern_is_reg_expr = util.getF('local_pattern_is_reg_expr');
			
			if (value_is_not_empty_msg(local_pathname, _local_pathname_is_empty_message)) {
				
				// Check for valid regular expression
				if (!local_pattern_is_reg_expr || util.isRegularExpression(local_pathname)) {
				
					_log_source.pathname = encode_value(local_pathname);
					_log_source.process_subdirectories = local_process_subdir;
					_log_source.pattern_is_regular_expression = local_pattern_is_reg_expr;
					
					generate_log_source_query_string(log_source_type);
					
					return true;
				}
				else {
					// Invalid regular expression
					alert(_invalid_regular_expression);
				}
			}
			
			return false;
			break;
		
		case 'ftp' :
		
			var ftp_hostname = util.getF('ftp_hostname');
			var ftp_username = util.getF('ftp_username');
			var ftp_password = util.getF('ftp_password');
			var ftp_pathname = util.getF('ftp_pathname');
	
			// Note, the ftp_username and ftp_password are optional, don't validate!
			
			if (value_is_not_empty_msg(ftp_hostname, _ftp_hostname_is_empty_message)) {
				if (value_is_not_empty_msg(ftp_pathname, _ftp_pathname_is_empty_message)) {
					form_is_valid = true;
				}
			}

			if (form_is_valid) {
				
				_log_source.username = encode_value(ftp_username);
				_log_source.password = encode_value(ftp_password);
				_log_source.hostname = encode_value(ftp_hostname);
				_log_source.pathname = encode_value(ftp_pathname);
				_log_source.process_subdirectories = util.getF('ftp:process_subdirectories');
				_log_source.pattern_is_regular_expression = util.getF('ftp_pattern_is_reg_expr');
				_log_source.use_passive = util.getF('ftp_use_passive');
				
				generate_log_source_query_string(log_source_type);
				
				return true;
			}
			
			return false;
			break;
			
		case 'sftp' :
		
			var sftp_hostname = util.getF('sftp_hostname');
			var sftp_username = util.getF('sftp_username');
			var sftp_password = util.getF('sftp_password');
			var sftp_pathname = util.getF('sftp_pathname');
			
			// Note, the sftp_username and sftp_password are optional, don't validate!
			
			if (value_is_not_empty_msg(sftp_hostname, _ftp_hostname_is_empty_message)) {
				if (value_is_not_empty_msg(sftp_pathname, _ftp_pathname_is_empty_message)) {
					form_is_valid = true;
				}
			}

			if (form_is_valid) {
				
				_log_source.username = encode_value(sftp_username);
				_log_source.password = encode_value(sftp_password);
				_log_source.hostname = encode_value(sftp_hostname);
				_log_source.pathname = encode_value(sftp_pathname);
				_log_source.process_subdirectories = util.getF('sftp:process_subdirectories');
				_log_source.pattern_is_regular_expression = util.getF('sftp_pattern_is_reg_expr');
				
				generate_log_source_query_string(log_source_type);
				
				return true;
			}
			
			return false;
			break;

		case 'http' :
		
			var http_hostname = util.getF('http_hostname');
			var http_pathname = util.getF('http_pathname');
			
			if (value_is_not_empty_msg(http_hostname, _http_hostname_is_empty_message)) {
				if (value_is_not_empty_msg(http_pathname, _http_pathname_is_empty_message)) {
					form_is_valid = true;
				}
			}
			
			if (form_is_valid) {
				
				_log_source.hostname = encode_value(http_hostname);
				_log_source.pathname = encode_value(http_pathname);
				
				generate_log_source_query_string(log_source_type);
				
				return true;
			}
			
			return false;
			break;
			
		case 'odbc':
		
			var dsn = util.getF('log_source:odbc:dsn');
			var query = util.getF('log_source:odbc:query');
			var database_name = util.getF('log_source:odbc:database_name');
			
			if (value_is_not_empty_msg(dsn, langVar('lang_admin.new_profile_wizard.database_options_page.define_dsn_value_msg'))) {
				if (value_is_not_empty_msg(query, langVar('lang_admin.new_profile_wizard.database_options_page.define_query_msg'))) {
					if (value_is_not_empty_msg(database_name, langVar('lang_admin.new_profile_wizard.database_options_page.define_database_name_msg'))) {
						form_is_valid = true;
					}
				}
			}
			
			if (form_is_valid) {
				
				// create the server object
				var server = {};
				server.type = odbc_server_type;
				server.dsn = util.getF('log_source:odbc:dsn');
				server.username = util.getF('log_source:odbc:username');
				server.password = util.getF('log_source:odbc:password');
				server.database_name = database_name;
			
				_log_source.server = server;
				_log_source.query = encode_value(query);
				
				return true;
			}
			
			return false;
			break;

		case 'command':
		
			var command = util.getF('command');
						
			if (value_is_not_empty_msg(command, _command_is_empty_message)) {
				
				/*
				qs += volatile_path + '.command+' + encode_name(command);
				_qs_log_source = qs;
				
				*/
				
				_log_source.command = encode_value(command);
				
				generate_log_source_query_string(log_source_type);
				return true;
			}
			
			return false;
			break;
	}
}

function generate_log_source_query_string(log_source_type) {
	
	// Only used for show matching log source files!
	
	_qs_log_source = '';
	
	for (var prop in _log_source) {
		
		var qs_value = _log_source[prop];
			
		if (typeof qs_value == 'boolean') {
			qs_value = qs_value.toString();
		}
			
		if (qs_value != '') {
				
			// alert('name: ' + _log_source[i].name + '\nvalue: ' + _log_source[i].value);
				
			qs_value = encodeURIComponent(qs_value);
		
			_qs_log_source += '+volatile.new_profile.log_source.0.' + prop;
			_qs_log_source += '+' + qs_value;
		}
	}

	// alert('_qs_log_source: ' + _qs_log_source);
}

function generate_log_source_post_string() { // NEW
	
	var dat = '';
		
	for (prop in _log_source) {
		
		// if (typeof(_log_source[prop].value) == 'boolean' || _log_source[i].value != '') {
			
		// alert('name: ' + _log_source[i].name + '\nvalue: ' + _log_source[i].value);
		
		if (prop != 'server') {
		
			dat += 'volatile.new_profile.log_source.0.' + prop;
			dat += '=' + encodeURIComponent(_log_source[prop]) + '&';
		}
		else {
		
			// add server properties
			
			var serverObj = _log_source[prop];
			
			// util.showObject(serverObj);
			
			for (var subProp in serverObj) {
				
				dat += 'volatile.new_profile.log_source.0.server.' + subProp;
				dat += '=' + encodeURIComponent(serverObj[subProp]) + '&';
			}
		}
	}
	
	dat = dat.replace(/&$/, '');
	
	// alert(dat);
	
	return dat;
}

function checkLogSourceDbServerResponse(dat) {
	
	// util.showObject(dat);
	
	if (dat.isValidDatabase) {
		
		// start actual auto detection
		var url = '?dp+templates.new_profile_wizard.check_log_source';
		var dat = 'v.fp.page_token=' + newProfileWizard.pageToken + '&';
		dat += generate_log_source_post_string();
		util.serverPost(url, generate_log_source_post_string());
	}
	else {
		alert(dat.msg);
		show_log_format_progress(false);
	}
}


function server_response_invalid_log_source(error_msg) {
	
	var msg = _msg_invalid_log_source_with_server_response_info + '\n' + error_msg;
	
	stop_log_format_progress_elapsed_time();
	
	show_log_format_progress(false);

	// Fix up Windows backslashes in pathnames
	msg = msg.replace(/(\\\\)/g, "BACKSLASH");
	msg = msg.replace(/BACKSLASH/g, "\\");
	alert(msg);
}

// *********************************
// log_source / detecting log format
// *********************************


function get_detect_log_format_result() {
	
	var url = '?dp+templates.new_profile_wizard.detect_log_format_result';
	
	var dat = 'v.fp.page_token=' + newProfileWizard.pageToken + '&';
	dat += 'volatile.autodetecting_id=' + _log_format_autodetecting_id + '&';
	dat += 'volatile.task_id=' + _log_format_autodetection_task_id;
	
	util.serverPost(url, dat);
}

function checkLogSourceServerResponse(dat) {
	
	// Called from check_log_source.cfv
	
	// alert('checkLogSourceServerResponse()');
	
	if (dat.task_id_exists) {
	
		_log_format_autodetecting_id = dat.autodetecting_id;
		_log_format_autodetection_task_id = dat.task_id;
	
		// alert('server_response_log_source \nautodetecting_id: ' + autodetecting_id + '\ntask_id: ' + task_id);
		
		// IMPOTANT, give autodection at least 3 seconds so that there is enough time
		// that autodection writes any log source error. If we fire get_detect_log_format_result()
		// too fast we may not yet have an autodection result which will start showing progress,
		// it is then progress which may contain a log source error message. Though if progress
		// contains an error message it will show the error on a new page and not in the intended alert! 
		
		setTimeout('get_detect_log_format_result()', 3500);
	}
	else {
		
		alert(dat.error_message);
		
		// Restore log source display
		show_log_format_progress(false);
	}
}

function server_response_autodetection_in_progess(dat) {
	
	// alert('server_response_autodetection_in_progess');
	
	// Display progress info
	
	util.updateT('log_format_progress_suboperation_description_label', dat.suboperation_description);
	util.updateT('log_format_progress_log_bytes_downloaded', dat.log_bytes_downloaded);
	
	// get_detect_log_format_result
	
	setTimeout('get_detect_log_format_result()', 600);
}


function server_response_detected_log_formats(dat) {
	
	// argument dat is an array of 0 to n log format objects (name, label and type)
	
	// util.showObject(detected_log_formats);
	
	var the_formats = get_log_formats_db_with_label_property(dat);
	
	_detected_log_formats_db = [];
	
	_num_detected_standalone_formats = 0;
	_num_detected_syslog_formats = 0;
	_num_detected_syslog_required_formats = 0;
	
	if (the_formats.length > 0) {
		
		// check the number of detected log format types
		
		for (var i = 0; i < the_formats.length; i++) {
			
			var log_format_type = the_formats[i].type;
			
			if (log_format_type == 'syslog') {
				
				_num_detected_syslog_formats++;
			}
			else if (log_format_type == 'syslog_required') {
				
				_num_detected_syslog_required_formats++;
			}
			else {
				
				_num_detected_standalone_formats++;
			}
		}
		
		// alert('Number of detected log format types:\nstandalone: ' + _num_detected_standalone_formats + '\nsyslog: ' + _num_detected_syslog_formats + '\nsyslog_required: ' + _num_detected_syslog_required_formats);
		
		
		if (!newProfileWizard.isLite) {
			
			_detected_log_formats_db = the_formats;
		}
		else {
			
			// Lite version only, pre-clean the detected log formats array
			
			// if only syslogs --> nothing detected
			// if only syslog_required --> nothing detected
			// if standalone plus syslogs but no syslog_required --> delete the syslogs and keep the standalone formats
			// if standalone plus syslog_required but no syslogs --> delete the syslog_required and keep the standalone formats
			
			var syslog_mismatch = false;
			
			if ((_num_detected_syslog_formats == 0 && _num_detected_syslog_required_formats > 0) ||
				(_num_detected_syslog_required_formats == 0 && _num_detected_syslog_formats > 0)) {
				
				syslog_mismatch = true;
			}
			
			if (!syslog_mismatch) {
				
				_detected_log_formats_db = the_formats;
				
			}
			else {
				
				// syslog or syslog_required are no valid matches, remove them!
				
				_num_detected_syslog_formats = 0;
				_num_detected_syslog_required_formats = 0;
				
				if (_num_detected_standalone_formats > 0) {
					
					// consider only the standalone format(s)
					
					for (var i = 0; i < the_formats.length; i++) {
						
						var log_format_item = the_formats[i];
						
						var log_format_type = log_format_item.type;
						
						if (log_format_type != 'syslog' && log_format_type != 'syslog_required') {
							
							var copiedItem = util.cloneObject(log_format_item);
							_detected_log_formats_db[_detected_log_formats_db.length] = copiedItem;
						}
					}
				}
				else {
					
					_detected_log_formats_db = []; // this is an error, like nothing has been detected
				}
			}
		}
	}
	
	
	if (_detected_log_formats_db.length > 0) {
		
		// Sort the detected formats
	
		if (_detected_log_formats_db.length > 1) {
		
			_detected_log_formats_db.sort(compare_labels);
		}
		
		// Create a hash to access log formats by name
		util.createHash(_detected_log_formats_db, 'id');

		// Check for direct match (if 1 x standalone OR 1 x syslog plus 1 x syslog_required)
		// Note, if only a single syslog or a single syslog_required has been detected then treat it also as direct match!
		
		var match_as_string = _num_detected_standalone_formats.toString() + _num_detected_syslog_formats.toString() + _num_detected_syslog_required_formats.toString();
		
		// alert('match_as_string: ' + match_as_string);
		
		if (match_as_string == '100' || match_as_string == '011' || match_as_string == '010' || match_as_string == '001') {
			
			// DIRECT MATCH
			
			// alert('log_format direct match!');
			
			set_log_format_direct_match_page();
			goto_wizard('log_format_direct_match_page');
		}
		else {
			
			// MULTIPLE MATCH, several log formats have been detected
			// alert('log_format multiple match!');
			
			set_log_format_multiple_match_page();
			goto_wizard('log_format_multiple_match_page');
		}
		
	}
	else {
		
		// show log_format_no_match_page
		// alert('log_format no match!');
		
		goto_wizard('log_format_no_match_page');
	}
}

// **********
// log format
// **********

function hide_log_format_description() {
	util.hideE(['log_format_multiple_match_list:log_format_description', 'log_format_all_list:log_format_description']);
}

function check_and_display_log_format_description() {
	
	hide_log_format_description();
	
	var selectElementId = this.id;
	var log_formats_db = selectElementId != 'log_format_all_list' ? _detected_log_formats_db : _log_format_db;
	
	var id = util.getF(this.id);
	var log_format = log_formats_db[h(id)];
	var description = log_format.description;
	
	if (description != '') {
		
		// Show the description. Note, we create a new div so that we get the actual height.
		// If the description exceeds a certain height then we set a max height.
		
		var descriptionElementId = selectElementId + ':log_format_description';
		var descriptionElement = util.getE(descriptionElementId);
		
		// Clean up descriptionElement from any previus decsription
		util.removeChildElements(descriptionElement);
		
		// Create new wrapper div
		var div = util.createE('div', {margin:0,padding:0});
		
		util.chainE(descriptionElement, div);
		div.innerHTML = description;
		
		descriptionElement.style.visibility = 'hidden';
		descriptionElement.style.display = 'block';
		
		// Check height of div
		var region = YAHOO.util.Dom.getRegion(div);
		var maxHeight = 120;
		
		if (region.height > maxHeight) {
			
			// Limit the height of the div
			div.style.height = maxHeight + 'px';
			div.style.overflow = 'scroll';
		}
		
		// Finally display the description
		descriptionElement.style.visibility = 'visible';
	}
}

function set_log_format_direct_match_page() {
	
	if (_num_detected_syslog_formats == 1 && _num_detected_syslog_required_formats == 1) {
		
		util.hideE('log_format_direct_match_standalone_section');
		util.showE('log_format_direct_match_syslog_section');
		
		for (var i = 0; i < _detected_log_formats_db.length; i++) {
			
			var type = _detected_log_formats_db[i].type;
			
			if (type == 'syslog') {
				
				var syslog_label = _detected_log_formats_db[i].label;
			}
			else {
				
				var syslog_required_label = _detected_log_formats_db[i].label;
			}
		}

		util.updateT('log_format_direct_match_syslog_text', syslog_label);
		util.updateT('log_format_direct_match_syslog_required_text', syslog_required_label);
	}
	else {
		
		// IMPORTANT, this case usually handles a single STANDALONE format
		// but it also handles the case if there is only ONE SYLOG or ONE SYSLOG_REQUIRED format!
	
		// If only a sylog or syslog_required format has been detected,
		// show it as a standalone format, the missing of one log format pair
		// will be indicated on the next wizard page.
		
		util.hideE('log_format_direct_match_syslog_section');
		util.showE('log_format_direct_match_standalone_section');
		
		var log_format_label = _detected_log_formats_db[0].label;
		
		// alert('log_format_label: ' + log_format_label);
		
		util.updateT('log_format_direct_match_standalone_text', log_format_label);
	}
	
	// if not Lite then make detected radio button default checked
	
	if (!newProfileWizard.isLite) {
		
		document.getElementById('log_format_direct_match_use_detected_btn').checked = true;
		
		// handle beta info
		
		// var show_beta_info = false;
		
		for (var i = 0; i < _detected_log_formats_db.length; i++) {
		
			var label = _detected_log_formats_db[i].label;
			
			/*
			if (is_beta_log_format(label)) {
				show_beta_info = true;
			}
			*/
		}
		
		// handle_log_format_beta_info(show_beta_info, 'log_format_direct_match_beta_info_section');
	}
}

function set_log_format_multiple_match_page() {
	
	// populate detected log format list
	
	var the_list = document.getElementById('log_format_multiple_match_list');
	// var show_beta_info = false;
	
	the_list.options.length = 0;
	
	for (var i = 0; i < _detected_log_formats_db.length; i++) {
		
		var id = _detected_log_formats_db[i].id;
		var label =	_detected_log_formats_db[i].label;
		the_list.options[i] = new Option(label, id, false, false);
		
		/*
		if (is_beta_log_format(label)) {
			show_beta_info = true;
		}
		*/
	}
	
	if (!newProfileWizard.isLite) {
		
		document.getElementById('log_format_multiple_match_use_detected_btn').checked = true;
		
		// handle_log_format_beta_info(show_beta_info, 'log_format_multiple_match_beta_info_section');
	}
	
	// if detected log format list contains syslog and syslog_required formats
	// then show a More Information link
	
	util.hideE('log_format_multiple_match_instruction');
	util.hideE('log_format_multiple_match_syslog_instruction');
	
	// we need top reset the info box, simulate a show/hide operation
	// so that the label becomes "Show Information"
	util.showE('log_format_multiple_match_syslog_info_box');
	show_hide_info_section('log_format_multiple_match_syslog_info_box');
		
	if (_num_detected_syslog_formats > 0 && _num_detected_syslog_required_formats > 0) {
		
		util.showE('log_format_multiple_match_syslog_instruction');
	}
	else {
	
		util.showE('log_format_multiple_match_instruction');
	}
}

function set_and_goto_log_format_all_page() {
	
	if (_log_format_db_loaded) {
		
		// if the log format list has not yet been populated do it now
		
		var log_format_all_list = document.getElementById('log_format_all_list');
	
		if (log_format_all_list.options.length == 0) {
			
			var number_of_log_formats = _log_format_db.length;
			var number_of_list_items = 0;
			
			for (var i = 0; i < number_of_log_formats; i++) {
				
				var log_format_item =  _log_format_db[i];
				
				// KHP 16/Nov/2010 - only show supported log formats in manual list
				if (log_format_item.notSupportedMessage == '') {
				
					var id = log_format_item.id;
					var label =	log_format_item.label;
					
					log_format_all_list.options[number_of_list_items] = new Option(label, id, false, false);
					
					/*
					if (is_beta_log_format(label)) {
						_show_log_format_all_beta_info = true;
					}
					*/
					number_of_list_items++;
				}
			}
		}
		
		// handle_log_format_beta_info(_show_log_format_all_beta_info, 'log_format_all_beta_info_section');
		
		goto_wizard('log_format_all_page');
	}
	else {
		
		// load the log formats first
		get_log_format_db(); // response will repeat next_wizard()!
	}
}

// ******
// syslog
// ******

function set_syslog_no_match_page() {
	
	// Pro Enterprise only
	// show text info that Sawmill detected a syslog_required but not syslog format
	
	var log_lormat_item = get_log_format_item_by_id(_final_syslog_required_id);
	
	util.updateT('syslog_no_match_syslog_required_label', log_lormat_item.label);
}

function set_syslog_direct_match_page() {
	
	// get the syslog label
	
	for (var i = 0; i < _detected_log_formats_db.length; i++) {
		
		var item = _detected_log_formats_db[i];
		
		if (item.type == 'syslog') {
			
			var syslog_label = item.label;
			var syslog_name = item.name;
		}
	}
	
	var syslog_required_item = get_log_format_item_by_id(_final_syslog_required_id);
	
	util.updateT('syslog_direct_match_syslog_required_label', syslog_required_item.label);
	util.updateT('syslog_direct_match_syslog_label', syslog_label);
}

function set_syslog_multiple_match_page() {
	
	// var show_beta_info = false;
	
	// set syslog_required label for which the syslog format must be selected
	var syslog_required_item = get_log_format_item_by_id(_final_syslog_required_id);
	util.updateT('syslog_multiple_match_syslog_required_label', syslog_required_item.label);
	
	// populate detected syslog list
	
	var the_list = document.getElementById('syslog_multiple_match_list');
	
	the_list.options.length = 0;
	
	for (var i = 0; i < _detected_log_formats_db.length; i++) {
		
		var item = _detected_log_formats_db[i];
			
		if (item.type == 'syslog') {

			var value = item.id;
			var label = item.label;
			the_list.options[the_list.options.length] = new Option(label, value, false, false);
		}
	}
	
	if (!newProfileWizard.isLite) {
		
		document.getElementById('syslog_multiple_match_use_detected_btn').checked = true;
		// handle_log_format_beta_info(show_beta_info, 'syslog_multiple_match_beta_info_section');
	}
}

function set_and_goto_syslog_all_page() {
	
	if (_log_format_db_loaded) {
		
		// if the syslog all list has not yet been populated do it now
		
		var syslog_all_list = document.getElementById('syslog_all_list');
		
		if (syslog_all_list.options.length == 0) {
			
			var number_of_log_formats = _log_format_db.length;
			var number_of_list_items = 0;
			
			for (var i = 0; i < number_of_log_formats; i++) {
				
				var item = _log_format_db[i];
				
				// KHP 16/Nov/2010 - only show supported log formats in manual list
				if (item.type == 'syslog' && item.notSupportedMessage == '') {

					var value = item.id;
					var label =	item.label;
					syslog_all_list.options[number_of_list_items] = new Option(label, value, false, false);
					number_of_list_items++;
				}
			}
		}
		
		// set the active syslog_required label above the syslog list
		var syslog_required_item = get_log_format_item_by_id(_final_syslog_required_id);
		util.updateT('syslog_all_syslog_required_label', syslog_required_item.label);
		
		// handle_log_format_beta_info(_show_syslog_all_beta_info, 'syslog_all_beta_info_section');

		goto_wizard('syslog_all_page');
	}
	else {
		
		// load the log formats first
		get_log_format_db(); // response will repeat next_wizard()!
	}
}

// ***************
// syslog_required
// ***************

function set_syslog_required_no_match_page() {
	
	// Pro Enterprise only
	// show text info that Sawmill detected a syslog but not syslog_required format
	var syslog_item = get_log_format_item_by_id(_final_syslog_id);
	util.updateT('syslog_required_no_match_syslog_label', syslog_item.label);
}

function set_syslog_required_direct_match_page() {
	
	// get the syslog_required label
	
	for (var i = 0; i < _detected_log_formats_db.length; i++) {
		
		var item = _detected_log_formats_db[i];
		
		if (item.type == 'syslog_required') {
			
			var syslog_required_label = item.label;
			var syslog_required_name = item.name;
		}
	}
	
	var syslog_item = get_log_format_item_by_id(_final_syslog_id);
	util.updateT('syslog_required_direct_match_syslog_label', syslog_item.label);
	util.updateT('syslog_required_direct_match_syslog_required_label', syslog_required_label);
}

function set_syslog_required_multiple_match_page() {
	
	// var show_beta_info = false;
	
	// set syslog label for which the syslog_required format must be selected
	var syslog_item = get_log_format_item_by_id(_final_syslog_id);
	util.updateT('syslog_required_multiple_match_syslog_label', syslog_item.label);
	
	// populate detected syslog_required list
	
	var the_list = document.getElementById('syslog_required_multiple_match_list');
	
	the_list.options.length = 0;
	
	for (var i = 0; i < _detected_log_formats_db.length; i++) {
		
		var item =  _detected_log_formats_db[i];
			
		if (item.type == 'syslog_required') {

			var value = item.id;
			var label =	item.label;
			the_list.options[the_list.options.length] = new Option(label, value, false, false);
		}
	}
	
	if (!newProfileWizard.isLite) {
		
		document.getElementById('syslog_required_multiple_match_use_detected_btn').checked = true;
	}
}

function set_and_goto_syslog_required_all_page() {
	
	if (_log_format_db_loaded) {
		
		// if the syslog all list has not yet been populated do it now
		
		var syslog_required_all_list = document.getElementById('syslog_required_all_list');
		
		if (syslog_required_all_list.options.length == 0) {
			
			var number_of_log_formats = _log_format_db.length;
			var number_of_list_items = 0;
			
			for (var i = 0; i < number_of_log_formats; i++) {
				
				var item = _log_format_db[i];         
				
				// KHP 16/Nov/2010 - only show supported log formats in manual list
				if (item.type == 'syslog_required' && item.notSupportedMessage == '') {

					var value = item.id;
					var label =	item.label;
					syslog_required_all_list.options[number_of_list_items] = new Option(label, value, false, false);
					number_of_list_items++;
				}
			}
		}
		
		// set the active syslog label above the syslog_required list
		var syslog_item = get_log_format_item_by_id(_final_syslog_id);
		util.updateT('syslog_required_all_syslog_label', syslog_item.label);
		
		// handle_log_format_beta_info(_show_syslog_required_all_beta_info, 'syslog_required_all_beta_info_section');
		
		goto_wizard('syslog_required_all_page');
	}
	else {
		
		// load the log formats first
		get_log_format_db(); // response will repeat next_wizard()!
	}
}


// ******************
// log format options
// ******************

function checkForLogFormatSupport() {
	
	// Check if the selected log format is supported or not
	
	// var logFormatName = _final_log_format_is_standalone ? _final_log_format : _final_syslog_required;
	var id = _final_log_format_is_standalone ? _final_log_format_id : _final_syslog_required_id;
	
	// Get the logFormat item
	var logFormatObject = get_log_format_item_by_id(id);
	var licensingFeatures = newProfileWizard.licensingFeatures;
	
	// util.updateT('syslog_direct_match_syslog_required_label', _detected_log_formats_db[h(_final_syslog_required)].label);util.showObject(logFormatObject, 'logFormatObject');
	
	if (logFormatObject.isSupportedLogFormat) {
		
		if (licensingFeatures == 'enterprise' ||
			licensingFeatures == 'advanced') {
					
			goto_wizard('db_server_page');
		}
		else if (licensingFeatures == 'pro') {
			
			goto_wizard('db_performance_page');
		}
		else {
			// Lite only
			set_and_goto_log_format_options_page();
		}
	}
	else {
		
		//
		// The log format is not supported
		//
		
		var notSupportedMessage = logFormatObject.notSupportedMessage;
		
		if (notSupportedMessage == '') {
			notSupportedMessage = '-';
		}
		
		util.updateT('log_format_not_supported_message_container', notSupportedMessage);
		goto_wizard('log_format_not_supported_page');
	}
}

function set_and_goto_log_format_options_page() {
	
	show_mini_progress(_checking_for_log_format_options_info);
	
	var id = _final_log_format_is_standalone ? _final_log_format_id : _final_syslog_required_id;
	var log_format_item = get_log_format_item_by_id(id);
	var the_format = log_format_item.name;
	
	var url = '?dp+templates.new_profile_wizard.get_log_format_options';
	var dat = 'v.fp.page_token=' + newProfileWizard.pageToken + '&';
	dat += 'v.fp.log_format=' + the_format;
	
	util.serverPost(url, dat);
}


function server_response_log_format_options(dat) {
		
	_numerical_fields_db = dat;

	if (!newProfileWizard.isLite) {
		
		if (_numerical_fields_db.length == 1) {
			
			// if there is only one numerical field, then automatically
			// check it and continue to the next wizard.
			
			_numerical_fields_db[0].add_field = true;
			
			goto_wizard('profile_name_page');
		}
		else {
			
			// prepare the numerical fields and show the log_format options page
			
			// make the array accesable by name
			// DISABLED on 23 May 2006 by karl because the name "length" does not work
			// as hash name!
			
			// for (var i = 0; i < _numerical_fields_db.length; i++) {
				// _numerical_fields_db[_numerical_fields_db[i].name] = _numerical_fields_db[i];
			// }
			
			build_log_format_options_page();
			
			goto_wizard('log_format_options_page');
		}
	}
	else {
		
		// if Lite then set all numerical fields to checked
		// and go to profile_name_page
		
		for (var i = 0; i < _numerical_fields_db.length; i++) {
		
			_numerical_fields_db[i].add_field = true;
		}
		
		goto_wizard('profile_name_page');
	}
}

function build_log_format_options_page() {
	
	// builds the checkboxes for numerical fields
	
	var table_element = document.getElementById('log_format_options_numerical_field_container');
	
	// clean up existing table
	var c = table_element.firstChild;

	if (c != null) {
		table_element.removeChild(c);
	}
	
	var tbody = document.createElement('tbody');
	table_element.appendChild(tbody);
	
	
	// build the checkbox rows
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
		
		var field_name = _numerical_fields_db[i].name;
		var field_id = 'numerical_field:' + field_name;
		
		var tr = document.createElement('tr');
	
		// build checkbox cell
	
		var td = document.createElement('td');
		td.style.padding = '0px';
		
		var checkbox = document.createElement('input');
		checkbox.type = 'checkbox';
		checkbox.id = field_id;
		checkbox.onclick = update_numerical_field_state;
		
		td.appendChild(checkbox);
		tr.appendChild(td);
		
		// build label cell
		
		var td = document.createElement('td');
		td.style.paddingTop = '4px';
		td.style.paddingBottom = '4px';
		td.style.paddingLeft = '6px';
		var label = document.createElement('label');
		label.htmlFor = field_id;
		var label_text = document.createTextNode(_numerical_fields_db[i].label);
		
		label.appendChild(label_text);
		td.appendChild(label);
		tr.appendChild(td);

		tbody.appendChild(tr);
	}
	
	// set checkbox state
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
	
		var element = document.getElementById('numerical_field:' + _numerical_fields_db[i].name);
		element.checked = _numerical_fields_db[i].add_field;
	}
}

function update_numerical_field_state() {
	
	// update the _numerical_fields_db object
	
	var element_id = this.id;
	var dat = element_id.split(':');
	var field_name = dat[1];
	
	// _numerical_fields_db[field_name].add_field = this.checked;
	
	// _numerical_fields_db is not anymore a hash due the possible
	// name "length", so we loop through all objects to check which
	// which one has been changed.
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
		
		if (field_name == _numerical_fields_db[i].name) {
			
			_numerical_fields_db[i].add_field = this.checked;
			break;
		}
	}
}

function set_all_numerical_fields(checked_state) {
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {

		var element = document.getElementById('numerical_field:' + _numerical_fields_db[i].name);
		
		element.checked = checked_state;
		_numerical_fields_db[i].add_field = checked_state;
	}
}

//
//
// Database
//
//


function toggleDatabaseType() {
	
	// Get and set the serverType
	// var elementId = element.id;
	// var dat = elementId.split(':');	
	var serverType = util.getF('db_server:type');
	var dbServer = newProfileWizard.dbServer;
	
	// alert('toggleDatabaseType - serverType: ' + serverType);
	
	util.hideE([
		'db_server:database_directory:box',
		'db_server:hostname:box',
		'db_server:dsn:box',
		'db_server:common:box',
		'db_server:server_socket:box',
		'db_server:mysql_bulk_import_method:box',
		'db_server:mssql_bulk_import_method:box',
		'db_server:oracle_bulk_import_method:box',
		'db_server:load_data_directory:box',
		'db_server:load_data_directory_on_server:box',
		'db_server:sql_table_name:box',
		'db_server:database_name:info'
	]);
	
	if (serverType == 'internal_sql') {
		
		util.showE('db_server:database_directory:box');
	}
	else {
		
		var defaultFocus;
		
		if (serverType == 'mysql') {
			
			util.showE('db_server:hostname:box');
			util.showE('db_server:server_socket:box');
			util.showE('db_server:mysql_bulk_import_method:box');
			
			// Check if we show the load_data_directory field
			toggleMysqlBulkImportMethod();
			
			defaultFocus = 'db_server:hostname';
		}
		else {
			
			util.showE('db_server:dsn:box');
			
			if (serverType == 'odbc_mssql') {
				util.showE('db_server:mssql_bulk_import_method:box');
				toggleMssqlBulkImportMethod();
			}
			else {
				// odbc_oracle
				util.showE('db_server:oracle_bulk_import_method:box');
			}

			defaultFocus = 'db_server:dsn';
		}
		
		util.showE('db_server:common:box');
		util.showE('db_server:sql_table_name:box');
		util.showE('db_server:database_name:info');
		
		var focusElement = util.getE(defaultFocus);
		focusElement.focus();
		focusElement.select();
	}
}

function toggleMysqlBulkImportMethod() {
	
	var bulkImportMethod = util.getF('db_server:mysql_bulk_import_method');
	var isLoadDataServerInfile = (bulkImportMethod == 'load_data_server_infile');
	util.showE('db_server:load_data_directory:box', isLoadDataServerInfile);
}

function toggleMssqlBulkImportMethod() {
	
	var bulkImportMethod = util.getF('db_server:mssql_bulk_import_method');
	var isBulkInsert = (bulkImportMethod == 'bulk_insert');
	util.showE('db_server:load_data_directory:box', isBulkInsert);
	util.showE('db_server:load_data_directory_on_server:box', isBulkInsert);
}

function validateDatabaseOptions() {
	
	// Set global dbServer variable which is used for further form processing!
	// Note, allow server password and database name to be empty!
	// If the database name is empty we use the profile name as database_name!
	
	var profilesDb = newProfileWizard.profilesDb;
	var i;
	var profileItem;
	
	// util.showObject(profilesDb);
	
	var validator = newProfileWizard.validator;
	validator.reset();
	
	var dbServer = newProfileWizard.dbServer;
	
	// Reset global dbServer object
	for (var prop in dbServer) {dbServer[prop] = '';}
	
	// util.showObject(newProfileWizard.dbServer);
	

	var serverType = util.getF('db_server:type');
	dbServer.type = serverType;
	
	if (serverType == 'internal_sql') {
		
		var databaseDirectory = util.getF('db_server:database_directory');
	
		dbServer.database_directory = databaseDirectory;
		dbServer.sql_table_name_prefix = '';
		dbServer.sql_table_name_suffix = '';
		
		if (databaseDirectory != '') {
			
			// Check for unique databaseDirectory
			
			for (i = 0; i < profilesDb.length; i++) {
				profileItem = profilesDb[i];
								
				if (profileItem.serverType == serverType && profileItem.databaseDirectory == databaseDirectory) {
					
					// Throw custom error message
					validator.isCustom('db_server:database_directory', langVar('lang_admin.database.database_directory_already_exists'));
					break;
				}
			}
		}
	}
	else {
		
		if (serverType == 'mysql') {
			
			dbServer.hostname = validator.isValue('db_server:hostname');
			dbServer.server_socket = util.getF('db_server:server_socket');
			dbServer.bulk_import_method = util.getF('db_server:mysql_bulk_import_method');
			
			if (dbServer.bulk_import_method == 'load_data_server_infile') {
				dbServer.load_data_directory = validator.isValue('db_server:load_data_directory');
			}
		}
		else {
			
			dbServer.dsn = validator.isValue('db_server:dsn');
			
			if (serverType == 'odbc_mssql') {
				
				dbServer.bulk_import_method = util.getF('db_server:mssql_bulk_import_method');
				
				if (dbServer.bulk_import_method == 'bulk_insert') {
					
					dbServer.load_data_directory = validator.isValue('db_server:load_data_directory');
					dbServer.load_data_directory_on_server = validator.isValue('db_server:load_data_directory_on_server');
				}
			}
			else {
				// serverType == 'odbc_oracle'
				dbServer.bulk_import_method = util.getF('db_server:oracle_bulk_import_method');
			}
		}
	
		// Following values are all optional
		dbServer.username = util.getF('db_server:username');
		dbServer.password = util.getF('db_server:password');
		
		var databaseName = util.getF('db_server:database_name');
		dbServer.database_name = databaseName;
		
		dbServer.sql_table_name_prefix = util.getF('db_server:sql_table_name_prefix');
		dbServer.sql_table_name_suffix = util.getF('db_server:sql_table_name_suffix');
		
		if (databaseName != '') {
			
			// Check for unique databaseName 
			for (i = 0; i < profilesDb.length; i++) {
				
				// Note, this is tricky because the database name is not just used in the database server
				// but also in /LogAnalysisInfo/Databases/database_name. That means that the database name must not match
				// any of the existsing profile names or any other database name, even if it is from a different server!

				profileItem = profilesDb[i];
				if (profileItem.name == databaseName || profileItem.databaseName == databaseName) {
					
					// Throw custom error message
					validator.isCustom('db_server:database_name', langVar('lang_admin.database.database_name_already_exists'));
					break;
				}
			}
		}
	}

	if (validator.allValid()) {
		return true;
	}
	
	return false;
}

function validateDatabaseOptionsOnServerSide() {
	
	// Checks for a valid database server connection
	// Update 15/Feb/2009 - and checks for 
	// that no internal datbase exists for any given database directory
	// and checks for a unique database name if a database name is given.
	
	var dbServer = newProfileWizard.dbServer;

	var url = '?dp+templates.new_profile_wizard.validate_database_options';
	var dat = 'v.fp.page_token=' + newProfileWizard.pageToken + '&';
	
	for (var prop in dbServer) {
		
		var itemValue = dbServer[prop];
		if (itemValue != '') {
			itemValue = encodeURIComponent(itemValue);
		}
		
		dat += 'v.fp.db_server.' + prop + '=' + itemValue + '&';
	}
	
	dat = dat.replace(/&$/, '');
	
	util.serverPost(url, dat);
}

function validateDatabaseOptionsOnServerSideResponse(dat) {
	
	// alert('checkDatabaseServerResponse()');

	if (!dat.isError) {
		
		// goto_wizard('profile_name_page');
		// set_and_goto_log_format_options_page();
		goto_wizard('db_performance_page');
	}
	else {
		
		var msg = dat.errorMessage;
		
		// hide mini progress
		util.hideE('mini_progress_section');
		set_wizard_buttons();
		show_wizard_page('db_server_page');
		alert(msg);
	}
}


//
//
// profile label
//
//

function validateProfileLabel(profileLabel) {
	
	var profilesDb = newProfileWizard.profilesDb;
	
	// Check profile label to be unique
	for (i = 0; i < profilesDb.length; i++) {
		
		if (profilesDb[i].label == profileLabel) {
			return false;
		}
	}
	
	return true;
}

//
//
// wizard sequence
//
//

function next_wizard() {
	
	var active_wizard_page = _wizard_path[_wizard_path.length - 1];

	switch (active_wizard_page) {

		case 'log_source_page':
		
			if (validate_log_source()) {
				
				// disable log source window and show message 'detecting log format'
				show_log_format_progress(true);
				
				// alert(_qs_log_source);
				
				if (_log_source.type != 'odbc') {
					
					var url = '?dp+templates.new_profile_wizard.check_log_source';
				}
				else {
					// check the database server prior detecting the log format
					var url = '?dp+templates.new_profile_wizard.check_log_source_db_server';
				}
				
				var dat = 'v.fp.page_token=' + newProfileWizard.pageToken + '&';
				dat += generate_log_source_post_string();
				util.serverPost(url, dat);
			}
			else {
				return false;
			}		
			break;
			
		case 'log_format_no_match_page':
		
			set_and_goto_log_format_all_page();

			break;
			
		case 'log_format_direct_match_page':
		
			var use_direct_match = true;
			
			if (!newProfileWizard.isLite && util.getF('log_format_direct_match_use_manual_btn')) {
			
				use_direct_match = false;
			}
			
			if (use_direct_match) {
				
				// set the active log format for form processing and to receive the log format options
				
				// Note, we handle detected log formats, so apache_custom and blue_coat_custom formats are not possible
				// and we don't need to handle a log_format_string page!
				
				// Note, it is possible that the direct match page displays a single syslog or
				// a single syslog_required format, in this case we have to show a syslog or syslog_required no mathc page!
				
				if (_num_detected_standalone_formats == 1) {
					
					_final_log_format_is_standalone = true;
					
					_final_log_format_id = _detected_log_formats_db[0].id;
					
					checkForLogFormatSupport();
					
				}
				else {
					
					_final_log_format_is_standalone = false;
					
					if (_num_detected_syslog_formats == 1 && _num_detected_syslog_required_formats == 1) {
					
						for (var i = 0; i < _detected_log_formats_db.length; i++) {
							
							if (_detected_log_formats_db[i].type == 'syslog') {
								
								_final_syslog_id = _detected_log_formats_db[i].id;
							}
							else {
								
								_final_syslog_required_id = _detected_log_formats_db[i].id;
							}
						}
						
						checkForLogFormatSupport();
					}
					else {
						
						// the syslog or syslog_required format is missing, only one of them has been detected
						
						if (_detected_log_formats_db[0].type == 'syslog') {
							
							// syslog_required is missing
							
							_final_syslog_id = _detected_log_formats_db[0].id;
							
							set_syslog_required_no_match_page();
							
							goto_wizard('syslog_required_no_match_page');
						}
						else {
							
							// syslog is missing
							
							_final_syslog_required_id = _detected_log_formats_db[0].id;
							
							set_syslog_no_match_page();
							
							goto_wizard('syslog_no_match_page');
						}
					}
				}
			}
			else {
				
				// Pro/Enterprise only, show all log formats page
				
				set_and_goto_log_format_all_page();
			}
		
			break;
			
			
		case 'log_format_multiple_match_page' :
		
			var use_detected_from_list = true;
			
			if (!newProfileWizard.isLite && util.getF('log_format_multiple_match_use_manual_btn')) {
		
				use_detected_from_list = false;
			}
			
			// alert('use_detected_from_list: ' + use_detected_from_list);
		
			if (use_detected_from_list) {
				
				var log_format_multiple_match_list = document.getElementById('log_format_multiple_match_list');
				var log_format_multiple_match_list_index = log_format_multiple_match_list.selectedIndex;
				
				if (log_format_multiple_match_list_index >= 0) {
					
					// var selected_log_format = log_format_multiple_match_list.options[log_format_multiple_match_list_index].value;
					var selected_log_format_id = log_format_multiple_match_list.options[log_format_multiple_match_list_index].value;
					var selected_log_format_item = get_log_format_item_by_id(selected_log_format_id);
					var selected_log_format_type = selected_log_format_item.type;
				
					// alert('selected_log_format: ' + selected_log_format + '\nselected_log_format_type: ' + selected_log_format_type);

					// Note, we handle detected log formats, so apache_custom and blue_coat_custom formats are not possible
					// and we don't need to handle a log_format_string page!
					
					if (selected_log_format_type == 'syslog') {
						
						_final_log_format_is_standalone = false;
						_final_syslog_id = selected_log_format_id;
						
						if (_num_detected_syslog_required_formats == 0) {
							
							// This case is not possible in Lite, as there is no syslog_required format detected any
							// syslog format would have been removed from the _detected_log_formats_db
							
							// The Pro/Enterprise user can continue the wizard but gets a warning!
							
							set_syslog_required_no_match_page();
							
							goto_wizard('syslog_required_no_match_page');
						}
						else if (_num_detected_syslog_required_formats == 1) {
							
							set_syslog_required_direct_match_page();
							
							goto_wizard('syslog_required_direct_match_page');
						}
						else {
							
							set_syslog_required_multiple_match_page();
							
							goto_wizard('syslog_required_multiple_match_page');
						}
					}
					else if (selected_log_format_type == 'syslog_required') {
						
						_final_log_format_is_standalone = false;
						_final_syslog_required_id = selected_log_format_id;
						
						if (_num_detected_syslog_formats == 0) {
							
							// This case is not possible in Lite, as there is no syslog_required format detected any
							// syslog format would have been removed from the _detected_log_formats_db
							
							// The Pro/Enterprise user can continue the wizard but gets a warning!
							
							set_syslog_no_match_page();
							
							goto_wizard('syslog_no_match_page');
						}
						else if (_num_detected_syslog_formats == 1) {
							
							set_syslog_direct_match_page();
							
							goto_wizard('syslog_direct_match_page');
						}
						else {
							
							set_syslog_multiple_match_page();
							
							goto_wizard('syslog_multiple_match_page');
						}
					}
					else {
						
						// this is a standalone format
						
						// Note, apache_custom and blue_coat_custom formats are only possible in this case!
						// These two formats are never auto detected!
						
						_final_log_format_is_standalone = true;
						_final_log_format_id = selected_log_format_id;
							
						checkForLogFormatSupport();
					}
				}
				else {
					
					alert(_msg_no_log_format_selected);
				}
			}
			else {
				
				// Pro/Enterprise only, show all log formats page
				
				set_and_goto_log_format_all_page();
			}
		
			break;
		
		
		case 'log_format_all_page' :
		
			// Pro/Enterprise only
		
			var log_format_all_list = document.getElementById('log_format_all_list');
			var log_format_all_list_index = log_format_all_list.selectedIndex;
			
			if (log_format_all_list_index >= 0) {
				
				// var selected_log_format = log_format_all_list.options[log_format_all_list_index].value;
				var selected_log_format_id = log_format_all_list.options[log_format_all_list_index].value;
				var selected_log_format_item = get_log_format_item_by_id(selected_log_format_id);
				var selected_log_format_type = selected_log_format_item.type;
				
				// alert('selected_log_format: ' + selected_log_format + '\nselected_log_format_type: ' + selected_log_format_type);
				
				if (selected_log_format_type == 'syslog') {
					
					_final_log_format_is_standalone = false;
					_final_syslog_id = selected_log_format_id;
					
					set_and_goto_syslog_required_all_page();
				}
				else if (selected_log_format_type == 'syslog_required') {
					
					_final_log_format_is_standalone = false;
					_final_syslog_required_id = selected_log_format_id;
					
					set_and_goto_syslog_all_page();
				}
				else {
					
					// this is a standalone format
					
					// Note, apache_custom, blue_coat_custom and ez_proxy_custom formats are only possible in this case!
					// These two formats are never auto detected!
					
					_final_log_format_is_standalone = true;
					_final_log_format_id = selected_log_format_id;
					
					var selected_log_format_name = selected_log_format_item.name;
					
					if (selected_log_format_name == 'apache_custom' || 
						selected_log_format_name == 'blue_coat_custom' ||
						selected_log_format_name == 'ez_proxy_custom') {
						
						// set the log format string instruction
						util.hideE(['log_format_string_instruction:apache_custom', 'log_format_string_instruction:ez_proxy_custom']);
						
						if (selected_log_format_name == 'apache_custom') {
							util.showE('log_format_string_instruction:apache_custom');
						}
						else if (selected_log_format_name == 'ez_proxy_custom') {
							util.showE('log_format_string_instruction:ez_proxy_custom');
						}
						
						goto_wizard('log_format_string_page');
					}
					else {
						
						checkForLogFormatSupport();
					}
				}
			}
			else {
			
				alert(_msg_no_log_format_selected);
			}

			break;
			
			
		case 'syslog_no_match_page' :
	
			set_and_goto_syslog_all_page();
		
			break;
			
			
		case 'syslog_direct_match_page' :
		
			var use_direct_match = true;
			
			if (!newProfileWizard.isLite && util.getF('syslog_direct_match_use_manual_btn')) {
			
				use_direct_match = false;
			}
			
			if (use_direct_match) {
				
				// only one syslog exists, set it as the final syslog_required format
				
				for (var i = 0; i < _detected_log_formats_db.length; i++) {
					
					if (_detected_log_formats_db[i].type == 'syslog') {
						
						_final_syslog_id = _detected_log_formats_db[i].id;
						break;
					}
				}
				
				checkForLogFormatSupport();
			}
			else {
		
				set_and_goto_syslog_all_page();
			}
		
			break;
			
		case 'syslog_multiple_match_page' :
		
			var use_detected_from_list = true;
			
			if (!newProfileWizard.isLite && util.getF('syslog_multiple_match_use_manual_btn')) {
		
				use_detected_from_list = false;
			}
		
			if (use_detected_from_list) {
				
				var syslog_multiple_match_list = document.getElementById('syslog_multiple_match_list');
				var syslog_multiple_match_list_index = syslog_multiple_match_list.selectedIndex;
				
				if (syslog_multiple_match_list_index >= 0) {
					
					_final_syslog_id = syslog_multiple_match_list.options[syslog_multiple_match_list_index].value;
					
					checkForLogFormatSupport();
				}
				else {
					
					alert(_msg_no_sylog_selected);
				}
			}
			else {
				
				set_and_goto_syslog_all_page();
			}

			break;
			
		
		case 'syslog_all_page' :
		
			// Pro/Enterprise only
		
			var syslog_all_list = document.getElementById('syslog_all_list');
			var syslog_all_list_index = syslog_all_list.selectedIndex;
			
			if (syslog_all_list_index >= 0) {
				
				_final_syslog_id = syslog_all_list.options[syslog_all_list_index].value;
				
				checkForLogFormatSupport();
			}
			else {
				
				alert(_msg_no_sylog_selected);
			}
		
			break;
			

		case 'syslog_required_no_match_page' :
		
			set_and_goto_syslog_required_all_page();

			break;
			
			
		case 'syslog_required_direct_match_page' :
		
			var use_direct_match = true;
			
			if (!newProfileWizard.isLite && util.getF('syslog_required_direct_match_use_manual_btn')) {
			
				use_direct_match = false;
			}
			
			if (use_direct_match) {
				
				// only one syslog_required exists, set it as the final syslog_required format
				
				for (var i = 0; i < _detected_log_formats_db.length; i++) {
					
					if (_detected_log_formats_db[i].type == 'syslog_required') {
						
						_final_syslog_required_id = _detected_log_formats_db[i].id;
						break;
					}
				}
				
				checkForLogFormatSupport();
			}
			else {
		
				set_and_goto_syslog_required_all_page();
			}
		
			break;
			
		case 'syslog_required_multiple_match_page' :
		
			var use_detected_from_list = true;
			
			if (!newProfileWizard.isLite && util.getF('syslog_required_multiple_match_use_manual_btn')) {
		
				use_detected_from_list = false;
			}
		
			if (use_detected_from_list) {
				
				var syslog_required_multiple_match_list = document.getElementById('syslog_required_multiple_match_list');
				var syslog_required_multiple_match_list_index = syslog_required_multiple_match_list.selectedIndex;
				
				if (syslog_required_multiple_match_list_index >= 0) {
					
					_final_syslog_required_id = syslog_required_multiple_match_list.options[syslog_required_multiple_match_list_index].value;
					
					checkForLogFormatSupport();
				}
				else {
					
					alert(_msg_no_sylog_required_selected);
				}
			}
			else {
				
				set_and_goto_syslog_required_all_page();
			}
		
			break;
			
		
		case 'syslog_required_all_page' :
		
			// Pro/Enterprise only
		
			var syslog_required_all_list = document.getElementById('syslog_required_all_list');
			var syslog_required_all_list_index = syslog_required_all_list.selectedIndex;
			
			if (syslog_required_all_list_index >= 0) {
				
				_final_syslog_required_id = syslog_required_all_list.options[syslog_required_all_list_index].value;
				checkForLogFormatSupport();
			}
			else {
				
				alert(_msg_no_sylog_required_selected);
			}
		
			break;


		case 'log_format_string_page' :
		
			// var log_format_string_value = util.getF('log_format_string_value');
			
			// The log format string must support leading or trailing spaces!
			var log_format_string_value = util.getF('log_format_string_value', false);
			
			// alert('log_format_string_value: >>>' + log_format_string_value + '<<<');

			if (value_is_not_empty(log_format_string_value)) {
				
				// set value for form processing
				// KHP 18/Jan/2010 - don't escape double quotes in custom log format string.
				// _final_log_format_string = log_format_string_value.replace(/"/g, '\\"');
				
				_final_log_format_string = log_format_string_value;
				// alert('_final_log_format_string: ' + _final_log_format_string);
				
				checkForLogFormatSupport();
			}
			else {
				alert(_msg_no_log_format_string_defined);
			}			
			break;
		
		
		case 'db_server_page' :
		
			if (validateDatabaseOptions()) {
				
				// util.showObject(newProfileWizard.dbServer);
				
				if (newProfileWizard.dbServer.type == 'internal_sql' && newProfileWizard.dbServer.database_directory == '') {
					
					// goto_wizard('profile_name_page');
					// set_and_goto_log_format_options_page();
					goto_wizard('db_performance_page');
				}
				else {
					validateDatabaseOptionsOnServerSide();  // Server response handles further actions
				}
			}
			
			break;
			
		case 'db_performance_page' :
		
			newProfileWizard.turnOnDatabaseFieldsIndices = util.getF('db_performance:turn_on_database_fields_indices');
			newProfileWizard.turnOnCrossReferenceGroups = util.getF('db_performance:turn_on_cross_reference_groups');
			newProfileWizard.turnOnSessionTracking = util.getF('db_performance:turn_on_session_tracking');
		
			set_and_goto_log_format_options_page();
		
			break;
			
		case 'log_format_options_page' :
		
			var isCheckedNumericalField = false;
		
			for (var i = 0; i < _numerical_fields_db.length; i++) {
				
				if (_numerical_fields_db[i].add_field == true) {
					
					isCheckedNumericalField = true;
					break;
				}
			}
			
			if (isCheckedNumericalField) {
				
				goto_wizard('profile_name_page');
				
				/*
				if (newProfileWizard.licensingFeatures == 'advanced' || newProfileWizard.licensingFeatures == 'enterprise') {
					
					goto_wizard('db_server_page');
				}
				else {
					goto_wizard('profile_name_page');
					
				}
				*/
			}
			else {
				
				alert(_msg_log_format_options_numerical_field_nothing_checked);
			}
			
			break;

		case 'profile_name_page' :
		
			finishWizard();
		
			break;
	}
}

function goto_wizard(page_name) { // hide active wizard and show next wizard as in argument
		
	var wizard_position = _wizard_path.length; // position to which the next wizard will be set

	if (wizard_position != 0) {
		hide_wizard_page(_wizard_path[wizard_position - 1]); // hide the active wizard
	}
	
	// hide mini progress section
	if (document.getElementById('mini_progress_section').style.display == 'block') {
		
		util.hideE('mini_progress_section');
	}
	
	// hide infoPanel
	// newProfileWizardUtil.closeInfoPanel();

	show_wizard_page(page_name);
	_wizard_path[_wizard_path.length] = page_name;

	set_wizard_buttons();
}

function show_wizard_page(page_name) { // shows the wizard
	
	// alert('page_name: ' + page_name);
	var wizard_page, wizard_label;
	
	wizard_page = document.getElementById(page_name);
	
	// set the wizard number
	// var wizard_number = _wizard_path.length > 0 ? _wizard_path.length : 1; 
	// util.updateT('wizard_number', wizard_number);
	
	// hide infoPanel
	newProfileWizardUtil.closeInfoPanel();
	
	// set the wizard label
	if (page_name != 'log_format_string_page') {
		wizard_label = _wizard_labels[page_name];
		
	}
	else {
		// use the log format label, i.e. Apache Custom Log Format
		var log_format_item = get_log_format_item_by_id(_final_log_format_id);
		wizard_label = log_format_item.label;
	}
	
	util.updateT('wizard_label', wizard_label);
	
	// alert('page_name: ' + page_name + '\nwizard_page: ' + wizard_page + '\nwizard_page_label: ' + wizard_page_label);
	
	document.getElementById('wizard_label').style.visibility = 'visible';
	wizard_page.style.display = 'block';
	
	// wizard_page_label.style.display = 'block';
	
	if (page_name == 'profile_name_page') {
		
		document.getElementById('profile_name').focus();
		document.getElementById('profile_name').select();
	}
}

function hide_wizard_page(page_name) {
	
	var wizard_page = document.getElementById(page_name);
	
	wizard_page.style.display = 'none';
	document.getElementById('wizard_label').style.visibility = 'hidden';
	
	if (page_name == 'log_source_page') {
		
		document.getElementById('log_format_progress_section').style.display = 'none';
	}
}

function back_wizard() {
	
	// get the current wizard position
	
	var wizard_to_hide = _wizard_path[_wizard_path.length - 1]
	var wizard_to_show = _wizard_path[_wizard_path.length - 2]
	// var array_length_before = _wizard_path.length;

	
	_wizard_path.pop(); //removes the wizard_to_hide from the _wizard_path array

	hide_wizard_page(wizard_to_hide);
	set_wizard_buttons();
	
	// set wizard number
	// util.updateT('wizard_number', _wizard_path.length);
	
	show_wizard_page(wizard_to_show);
}

function disable_wizard_buttons() {
	
	document.getElementById('back_btn').disabled = true;
	document.getElementById('next_btn').disabled = true;
}

function set_wizard_buttons() {
	
	var back_btn = document.getElementById('back_btn');
	var next_btn = document.getElementById('next_btn');

	var active_wizard_page = _wizard_path[_wizard_path.length - 1];

	if (active_wizard_page == 'log_source_page') { // set to first
		
		back_btn.disabled = true;
		next_btn.disabled = false;
		
	}
	else if (active_wizard_page == 'profile_name_page') { //set to last
		
		back_btn.disabled = false;
		next_btn.disabled = false;
		
		next_btn.value = _finish_button_label;
	}
	else if (active_wizard_page == 'log_format_not_supported_page') {
		
		back_btn.disabled = false;
		next_btn.disabled = true;
	}
	else { // set to between
		
		back_btn.disabled = false;
		next_btn.disabled = false;
		next_btn.value = _next_button_label;
		
		if (newProfileWizard.isLite && active_wizard_page == 'log_format_no_match_page') {
		
			next_btn.disabled = true;
		}
		else {
		
			next_btn.disabled = false;
		}
	}
}

//
//
// finsih wizard
//
//

function finish_wizard_via_enter_key(evt) {
	
	var key_code = (evt.which) ? evt.which : evt.keyCode;
	
	// alert(key_code);

	if (key_code == 13 || key_code == 3) {
		finishWizard();
	}
}

function finishWizard() {
	
	// var profile_name = strip_whitespace(document.getElementById('profile_name').value);
	var profileLabel = util.getF('profile_name');
	
	// alert('profileLabel: ' + profileLabel);
	
	if (profileLabel != '') {
		
		if (validateProfileLabel(profileLabel)) {
			
			// disable the cancel button
			util.disableE('cancel_btn');
			
			show_mini_progress(_saving_new_profile_info);
			
			var url = '?dp+templates.new_profile_wizard.finish_wizard';
			
			var dat = 'v.fp.page_token=' + newProfileWizard.pageToken + '&';
			dat += process_form(profileLabel);
			util.serverPost(url, dat);
		}
		else {
			
			var msg = _msg_profile_name_already_exist;
			msg = msg.replace(/__PARAM__1__/, '"' + profileLabel + '"');
			alert(msg);
			return false;
		}
	}
	else {
		
		alert(_msg_no_profile_name_defined);
		return false;
	}		
}

function finishWizardResponse(dat) {
	
		
	// alert('response received, dat is: ' + dat);
			
	util.hideE('mini_progress_section');
	util.showE('profile_saved_info_section');
	
	// alert('profile_node_name:' + profile_node_name);
	
	// Change the Cancel button to Close due a Firefox bug where the New Profile Wizard doesn't close
	// var cancel_btn = document.getElementById('cancel_btn');
	// cancel_btn.value = _close_button_label;
	
	if (opener) {
		
		// Note, if the opener is yet open we close the window
		// in newProfileCreatedInfo()
		
		opener.newProfileInfo.openViaNewProfileWizard(dat.newProfileName, dat.numberOfAllProfiles, dat.profilesDb);
	}
	else {
		window.close();
	}
}

//
//
// process_form
//
//

function process_form(profileLabel) {
	
	var dat = '';
	
	// send _autodetecting_id
	dat += 'volatile.new_profile.autodetecting_id=' + _log_format_autodetecting_id + '&';
	
	//
	// log source
	//
	
	dat += generate_log_source_post_string() + '&';

	//
	// if real time processing is enabled then send it
	//
	
	if (_real_time_processing) {
		dat += 'volatile.new_profile.real_time_processing=true&'
	}
	
	//
	// log format
	//
	
	if (_final_log_format_is_standalone) {
		
		var log_format_item = get_log_format_item_by_id(_final_log_format_id);
		var log_format_name = log_format_item.name;
		
		dat += 'volatile.new_profile.log_format_type=standalone&';
		dat += 'volatile.new_profile.log_format=' + log_format_name + '&';
		
		// if the log format is apache_custom blue_coat_custom or ez_proxy_custom add the _log_formt_string
		
		if (log_format_name == 'apache_custom' || 
			log_format_name == 'blue_coat_custom' ||
			log_format_name == 'ez_proxy_custom') {

			dat += 'volatile.new_profile.log_format_string=' + encodeURIComponent(_final_log_format_string) + '&';
		}
	}
	else {
		
		var syslog_item = get_log_format_item_by_id(_final_syslog_id);
		var syslog_required_item = get_log_format_item_by_id(_final_syslog_required_id);
		
		dat += 'volatile.new_profile.log_format_type=syslog&';
		dat += 'volatile.new_profile.syslog_format=' + syslog_item.name + '&';
		dat += 'volatile.new_profile.syslog_required_format=' + syslog_required_item.name + '&';
	}
	
	//
	// database server
	//
	
	var db_path = 'volatile.new_profile.database.server.';
	var dbServer = newProfileWizard.dbServer;
	
	for (var prop in dbServer) {
		dat += db_path + prop + '=' + encodeURIComponent(dbServer[prop]) + '&';
	}
	
	//
	// database performance
	//
	
	dat += 'volatile.new_profile.turn_on_database_fields_indices=' + newProfileWizard.turnOnDatabaseFieldsIndices + '&';
	dat += 'volatile.new_profile.turn_on_cross_reference_groups=' + newProfileWizard.turnOnCrossReferenceGroups + '&';
	dat += 'volatile.new_profile.turn_on_session_tracking=' + newProfileWizard.turnOnSessionTracking + '&';
	
	//
	// log format options - numerical fields
	//
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
		
		if (_numerical_fields_db[i].add_field) {
			
			dat += 'volatile.new_profile.numerical_fields.' + _numerical_fields_db[i].name + '=true&';
		}
	}
	
	//
	// profile name
	//
	
	dat += 'volatile.new_profile.profile_name=' + encodeURIComponent(profileLabel);
	
	// dat += 'volatile.show_reports_upon_finish=' + document.getElementById('show_reports_upon_finish').checked;
	
	// alert(dat);
	
	return dat;
}

// ===================
// log source progress
// ===================

function show_log_format_progress(show_log_format_progress) {
	
	// hides the log source wizard and shows log format progress
	
	var log_format_progress_section = document.getElementById('log_format_progress_section');
	
	if (show_log_format_progress) {
		
		// hide infoPanel
		newProfileWizardUtil.closeInfoPanel();
		
		disable_wizard_buttons();
		hide_wizard_page('log_source_page');
		
		adjust_log_format_progress();
				
		log_format_progress_section.style.display = 'block';
		
		var start_date = new Date();
		_autodetcting_log_format_start_time = start_date.getTime();
		
		// alert(_autodetcting_log_format_start_time);
		
		_log_format_progress_timer = setInterval('set_log_format_progress_elapsed_time()', 1000);
		
	}
	else {
		
		// return to log source view
		
		set_wizard_buttons();
		log_format_progress_section.style.display = 'none';
		show_wizard_page('log_source_page');
	}
}

function adjust_log_format_progress() {
		
	var log_format_progress_log_bytes_downloaded_row = document.getElementById('log_format_progress_log_bytes_downloaded_row');
	var log_format_progress_download_info_row = document.getElementById('log_format_progress_download_info_row');

	// check the log source type
	
	var log_source_type;
	
	for (var i = 0; i < _log_source.length; i++) {
		
		if (_log_source[i].name == 'type') {
			
			log_source_type = _log_source[i].value;
		}
	}
	
	// alert('log_source_type: ' + log_source_type);
	
	util.updateT('log_format_progress_suboperation_description_label', '-');
	util.updateT('log_format_progress_elapsed_time', '00:00:00');
	
	if (log_source_type == 'ftp' || log_source_type == 'http') {
	
		util.updateT('log_format_progress_log_bytes_downloaded', '-');
		log_format_progress_download_info_row.style.display = '';
		log_format_progress_log_bytes_downloaded_row.style.display = '';
	}
	else {
		
		log_format_progress_download_info_row.style.display = 'none';
		log_format_progress_log_bytes_downloaded_row.style.display = 'none';
	}	
}

function set_log_format_progress_elapsed_time() {
	
	var current_date = new Date();
	var current_time = current_date.getTime();
	
	var elapsed_time = Math.round((current_time - _autodetcting_log_format_start_time) / 1000);
	
	var remainder = 0;
	var hours = 0;
	var minutes = 0;
	var seconds = 0;
	
	if (elapsed_time >= 3600) {
		
		remainder = elapsed_time % 3600;
		hours = (elapsed_time - remainder) / 3600;
		
		elapsed_time = remainder;
	}
	
	if (elapsed_time >= 60) {
		
		remainder = elapsed_time % 60;
		minutes = (elapsed_time - remainder) / 60;
		
		elapsed_time = remainder;
	}
	
	seconds = elapsed_time;
	
	hours = (hours > 9) ? hours : '0' + hours;
	minutes = (minutes > 9) ? minutes : '0' + minutes;
	seconds = (seconds > 9) ? seconds : '0' + seconds;
	
	var elapsed_time_text = hours + ':' + minutes + ':' + seconds;
	
	util.updateT('log_format_progress_elapsed_time', elapsed_time_text);
}

function stop_log_format_progress_elapsed_time() {

	clearInterval(_log_format_progress_timer);
}

// ====================
// log format utilities
// ====================


function get_log_format_db() {
	
	show_mini_progress(langVar('lang_admin.new_profile_wizard.loading_log_format_list'));
	
	var url = '?dp+templates.new_profile_wizard.get_log_format_db';
	var dat = 'v.fp.page_token=' + newProfileWizard.pageToken;
	util.serverPost(url, dat);
}

function server_response_get_log_format_db(dat) {
	
	_log_format_db = get_log_formats_db_with_label_property(dat);
	
	//
	// sort the array
	//
	
	_log_format_db.sort(compare_labels);
	
	// util.showObject(_log_format_db, '_log_format_db after sort()');
	
	//
	// create hash
	//
	
	util.createHash(_log_format_db, 'id');
	
	_log_format_db_loaded = true;
	
	// simply repeat next_wizard();
	
	next_wizard();
}

function get_log_formats_db_with_label_property(log_formats) {
	
	// This returns a new log format array where each log format has
	// exactly one label. Log formats with multiple labels in the labels array
	// are split into separate log formats.
	// This requires the addition of a separate log format ID due
	// the possibility of identical log format names.
	
	var a = [];
	
	var num_of_log_formats = log_formats.length;
	var number_of_new_items = 0;
	
	for (var i = 0; i < num_of_log_formats; i++) {
		
		var item = log_formats[i];
		var item_labels = item.labels;
		var log_format_name = item.name;
		
		// Add individual log format item for each label in item_labels
		
		for (var j = 0; j < item_labels.length; j++) {
			
			// Compose unique ID
			// The ID must be identical in autodetected_db and _log_format_db array so that we can refer
			// to both by ID. Hence we use the log format name + index of label
			var id = log_format_name + '_' + j;
			
			var new_item = {};
			new_item.id = id;
			new_item.label = item_labels[j];
			new_item.name = log_format_name;
			new_item.description = item.description;
			new_item.type = item.type;
			new_item.isSupportedLogFormat = item.isSupportedLogFormat;
			new_item.notSupportedMessage = item.notSupportedMessage;
			
			a[number_of_new_items] = new_item;
			
			number_of_new_items++;
		}
	}
	
	// Clear log_formats
	log_formats = [];
	
	return a;
}

function get_log_format_item_by_id(id) {
	
	// Returns the log format item of the given id
	
	var item = {};
	
	if (_log_format_db_loaded) {
		
		// alert('get_log_format_item_by_id() OK 1: id: )' + id);
		
		// All log formats exist in database
		item = _log_format_db[h(id)];
		
		// alert('item: ' + item);
	}
	else {
		// Get item from _detected_log_formats_db
		item = _detected_log_formats_db[h(id)];
	}
	
	return item;
}

//
//
// restoreNewProfileWizardPageAfterError
//
//

function restoreNewProfileWizardPageAfterError() {
	
	// restoreNewProfileWizardPageAfterError is called from util.closeServerBackgroundCallAlertInfo
	// to restore the wizard page after any alert window becomes closed. This is in particular
	// important for final step so that log format developers must not start over from the beginning.
	
	var active_wizard_page = _wizard_path[_wizard_path.length - 1];
	
	// alert('active_wizard_page: ' + active_wizard_page);

	util.hideE('mini_progress_section');
	
	// resore the wizard page
	show_wizard_page(active_wizard_page);
	
	set_wizard_buttons();
	util.enableE('cancel_btn');
}


// ==============
// help utilities
// ==============

function show_hide_info_section(element_id) {
	
	// alert(element_id);
	var info_box_element = document.getElementById(element_id);
	info_box_element.style.display = (info_box_element.style.display == 'none') ? 'block' : 'none';
}


// =========
// utilities
// =========


function set_to_detected_btn_switch(element_id) {
	
	// automatically checks a radio button 'use detected' if a detected list item becomes selected
	// Note, in Lite the radio buttons do not exist!
	
	var the_radio_button = document.getElementById(element_id);
	
	if (the_radio_button != null && !the_radio_button.checked) {
	
		the_radio_button.checked = true;
	}
}

function deselect_list(element_id) {
	
	// deselects any item in the specified list
	the_list = document.getElementById(element_id);
	the_list.selectedIndex = -1;
	
	// Hide any log format description
	hide_log_format_description();
}

function show_mini_progress(progress_text) {
	
	disable_wizard_buttons();
	
	// hide infoPanel
	newProfileWizardUtil.closeInfoPanel();
	
	// hide active wizard page
	hide_wizard_page(_wizard_path[_wizard_path.length - 1]);
		
	util.updateT('progress_info_text', progress_text);
	util.showE('mini_progress_section');
}

function compare_labels(a, b) {
	// sorts the log format arrays by label
	var a_label = a.label.toLowerCase();
	var b_label = b.label.toLowerCase();
	
	if (a_label < b_label) {
		return -1;
	}
	else if (a_label > b_label) {
		return 1;
	}
	else {
		return 0;
	}
}
	
function encode_value(the_value) {
	
	if (typeof the_value != 'boolean') {
	
		the_value = the_value.replace(/\$/g, '__HexEsc__24');
		the_value = the_value.replace(/\\/g, '__HexEsc__5C');
		the_value = the_value.replace(/\+/g, '__HexEsc__2B');
	}
	
	return the_value;
}
