//
//
//
// newProfileWizardUtil.js
//
//
//


var newProfileWizardUtil = {
	
	infoPanel: null,
	infoPanelWidth: 300,
	isOpenInfoPanel: false,
	
	initInfoPanel: function() {
		
		//
		// Init the infoPanel
		//
		
		var panelObj = {
			panelId: 'info:panel',
			panelClassName: 'panel-30',
			panelHeaderLabel: ' ',
			width: newProfileWizardUtil.infoPanelWidth,
			zIndex: 20,
			isCover: false,
			isSticky: false,
			closeEvent: newProfileWizardUtil.closeInfoPanel
		};
		
		newProfileWizardUtil.infoPanel = new util.Panel3(panelObj);
	},
	
	toggleInfoPanel: function() {
		
		if (!newProfileWizardUtil.isOpenInfoPanel) {
		
			// alert('this.id: ' + this.id);
			var elementId = this.id;
			newProfileWizardUtil.openInfoPanel(elementId);
		}
		else {
			newProfileWizardUtil.closeInfoPanel();
		}
	},
	
	openInfoPanel: function(elementId) {
		
		if (newProfileWizardUtil.infoPanel == null) {
			newProfileWizardUtil.initInfoPanel();
		}
		
		// Get region from button element
		
		var buttonRegion = yDom.getRegion(elementId);
		// util.showObject(buttonRegion);
		var panelTop = buttonRegion.bottom + 4;
		var panelLeft = buttonRegion.right - newProfileWizardUtil.infoPanelWidth;
		
		// Make sure panelLeft is not out of document region
		if (panelLeft < 20) {
			panelLeft = 20;
		}
		else {
			
			var documentWidth = yDom.getDocumentWidth();
			// alert('documentWidth: ' + documentWidth);
			
			if (panelLeft + newProfileWizardUtil.infoPanelWidth >= documentWidth) {
				
				panelLeft = documentWidth - (newProfileWizardUtil.infoPanelWidth + 20);
				
				if (panelLeft < 20) {
					panelLeft = 20;
				}
			}
		}
		
		// Hide info text elements
		util.hideE(['info:log_source_info', 'info:db_server_info', 'info:db_performance_info', 'info:numerical_fields_info']);
		var infoTextElementId = '';
		
		switch (elementId) {
			
			case 'log_source:read_more_btn':
				infoTextElementId = 'info:log_source_info';
				break;
			
			case 'db_server:read_more_btn' :
				infoTextElementId = 'info:db_server_info';
				break;
				
			case 'db_performance:read_more_btn' :
				infoTextElementId = 'info:db_performance_info';
				break;
				
			case 'numerical_fields:read_more_btn' :
				infoTextElementId = 'info:numerical_fields_info';
				break;
		}
		
		util.showE(infoTextElementId);
		
		newProfileWizardUtil.infoPanel.open({top:panelTop, left:panelLeft});
		newProfileWizardUtil.isOpenInfoPanel = true;
	},
	
	closeInfoPanel: function() {
		
		// Check if the infoPanel is already open before trying to close it because
		// we may fire closeInfoPanel() without actually being open.
		
		if (newProfileWizardUtil.isOpenInfoPanel) {
			newProfileWizardUtil.infoPanel.close();
			newProfileWizardUtil.isOpenInfoPanel = false;
		}
	}
}
