//
// filterItem - global filter items editor
//


var filterItem = {
	
	panel: null,
	validator: null,
	
	// active filter item properties
	id: '',
	isActive: false,
	isNew: false,
	isItemInGroup: false,
	groupItemId: '',
	
	activeOperatorListType: '', // text | numerical
	
	textFieldItemOperators: [
		{name:'item_name', label:langVar('lang_stats.global_filter.is_item_name')},
		{name:'wildcard', label:langVar('lang_stats.global_filter.is_wildcard_expression')},
		{name:'regexp', label:langVar('lang_stats.global_filter.is_regular_expression')},
		{name:'not_item_name', label:langVar('lang_stats.global_filter.not_item_name')},
		{name:'not_wildcard', label:langVar('lang_stats.global_filter.not_wildcard_expression')},
		{name:'not_regexp', label:langVar('lang_stats.global_filter.not_regular_expression')}
	],
	
	numericalFieldItemOperators: [
		{name:'lt', label:langVar('lang_stats.global_filter.is_less_than')},
		{name:'gt', label:langVar('lang_stats.global_filter.is_greater_than')}
	]
};


filterItem.init = function() {
	
	var panelObj = {
		panelId:"filter_item:panel",
		panelClassName: 'panel-50',
		panelHeaderLabel: '-',
		left: 70,
		top: 80,
		zIndex: 40,
		isCover: true,
		closeEvent: filterItem.close
	};
			
	filterItem.panel = new util.Panel3(panelObj);
	
	filterItem.validator = new util.Validator();
	
	// Populate field item list
	// Note, we don't allow date_time fields in global filter! Date time is set via df only!
	
	var queryFieldsDb = reportInfo.queryFieldsDb;
	
	// util.showObject(queryFieldsDb);
	
	var filterFieldsDb = [{name:'', label:langVar('lang_stats.global_filter.select_field')}];
	for (var i = 0; i < queryFieldsDb.length; i++) {
		
		var queryField = queryFieldsDb[i];
		var isValidField = false;
		
		if (queryField.category != 'date_time' && queryField.sessionField == '') {
			
			var isAggregatingField = queryField.isAggregatingField;
			isValidField = (!isAggregatingField || (isAggregatingField && (queryField.aggregationMethod != 'unique')));
		}
		
		if (isValidField) {
			filterFieldsDb[filterFieldsDb.length] = {name:queryField.name, label:queryField.label};
		}
	}
	util.populateSelect('filter_item:field_list', filterFieldsDb, 'name', 'label');
	
	
	// Populate default operator list for text field items
	filterItem.updateFieldItemOperatorList('text');
	
	
	// Populate day of week list
	var weekdays = [{name:'', label:langVar('lang_stats.global_filter.select_day_of_week')}];
	for (var i = 1; i < 8; i++) {
		var label = lang.weekdays[i - 1];
		weekdays[weekdays.length] = {name:i, label:label};
	}
	util.populateSelect('filter_item:day_of_week_list', weekdays, 'name', 'label');
	
	// Populate hour of day list
	var hours = [{name:'', label:langVar('lang_stats.global_filter.select_hour')}];
	for (var i = 0; i < 24; i++) {
		var label = lang.hours[i];
		hours[hours.length] = {name:i, label:label};
	}
	util.populateSelect('filter_item:hour_of_day_list', hours, 'name', 'label');

	yEvent.addListener('filter_item:filter_item_type_list', 'change', filterItem.typeActor);
	yEvent.addListener('filter_item:field_list', 'change', filterItem.fieldActor);
	yEvent.addListener('filter_item:field_item_operator_list', 'change', filterItem.operatorActor);
	
	var okBtn = new util.Button2('filter_item:ok_btn', 'btn-50', filterItem.saveItem);
	var cancelBtn = new util.Button2('filter_item:cancel_btn', 'btn-50', filterItem.close);
}

filterItem.open = function(item, isActive, isNew, isItemInGroup, groupItemId) {
	
	// item is a filterItem object send from globalFilter.js
	
	// Initialize panel, buttons and list if not yet done
	if (filterItem.panel == null) {
		filterItem.init();
	}
	
	// util.showObject(item);
	
	filterItem.id = item.id;
	filterItem.isActive = isActive;
	filterItem.isNew = isNew;
	filterItem.isItemInGroup = isItemInGroup;
	filterItem.groupItemId = groupItemId;

	
	filterItem.updateForm(item);
	
	globalFilter.disableForm();
	
	var panelHeaderLabel = isNew ? langVar('lang_stats.global_filter.new_item') : langVar('lang_stats.global_filter.edit_item');
	filterItem.panel.open({label:panelHeaderLabel});
}


filterItem.close = function() {
	
	filterItem.validator.reset();
	filterItem.panel.close();
	globalFilter.enableForm();
}


filterItem.updateFieldItemOperatorList = function(operatorListType) {

	// operatorListType is text | numerical
	
	if (filterItem.activeOperatorListType != operatorListType) {
		
		// Update operator list
		var theListItems = (operatorListType == 'text') ? filterItem.textFieldItemOperators : filterItem.numericalFieldItemOperators;
		util.populateSelect('filter_item:field_item_operator_list', theListItems, 'name', 'label');
		filterItem.activeOperatorListType = operatorListType;
	}
}

filterItem.getFieldItemOperator = function() {
	
	// returns an object
	// o.isExpression = true | false
	// o.isNegated = true | false
	// o.expressionType = '' | 'wildcard' | 'regexp' | lt | gt
	
	// lt (less than) and gt (greater than) have been added for numerical fields
	
	var o = {};
	var operatorValue = util.getF('filter_item:field_item_operator_list');
	var isExpression = false;
	var isNegated = false;
	var expressionType = '';
	
	if (operatorValue.indexOf('wildcard') != -1 || operatorValue.indexOf('regexp') != -1) {
		isExpression = true;
		expressionType = (operatorValue.indexOf('wildcard') != -1) ? 'wildcard' : 'regexp';
	}
	else if (operatorValue == 'lt' || operatorValue == 'gt') {
		expressionType = operatorValue;
	}
	
	if (operatorValue.indexOf('not_') != -1) {
		isNegated = true;
	}

	o.isExpression = isExpression;
	o.isNegated = isNegated;
	o.expressionType = expressionType;
	
	return o;
}

//
// filterItemType
//

filterItem.typeActor = function() {
	
	var filterType = util.getF('filter_item:filter_item_type_list');
	filterItem.setType(filterType);
}

filterItem.setType = function(filterType) {
	
	util.hideE(['filter_item:form:field', 'filter_item:form:session_contains', 'filter_item:form:session_start', 'filter_item:form:expression']);
	util.showE('filter_item:form:' + filterType);
}

//
// filterItem - field, operator and item value handling
//

filterItem.fieldActor = function() {
	
	// Invoked upon field change
	var fieldName = util.getF('filter_item:field_list');
	
	if (fieldName != '') {
		
		// Update the operator list (text or numerical)
		
		var queryField = reportInfo.queryFieldsDb[h(fieldName)];
		var isAggregatingField = queryField.isAggregatingField;
		
		var operatorListType = isAggregatingField ? 'numerical' : 'text';
		filterItem.updateFieldItemOperatorList(operatorListType);
		
		var defaultOperator = isAggregatingField ? 'lt' : 'item_name';
		util.setF('filter_item:field_item_operator_list', defaultOperator);
	}
	
	// Check/update the item value section
	filterItem.setFieldItemValueSection();
},

filterItem.operatorActor = function() {
	
	// Check/update the item value section
	filterItem.setFieldItemValueSection();
}

filterItem.setFieldItemValueSection = function() {
	
	// This sets the item value section depending on the
	// selected field and the selected operator.
	
	util.hideE(['filter_item:field_item_value_row', 'filter_item:field_item_day_of_week_row', 'filter_item:field_item_hour_of_day_row']);

	var fieldName = util.getF('filter_item:field_list');
	
	if (fieldName != '') {
		
		var queryField = reportInfo.queryFieldsDb[h(fieldName)];
		var fieldCategory = queryField.category;
		var isAggregatingField = queryField.isAggregatingField;
		
		var o = filterItem.getFieldItemOperator();
		var isExpression = o.isExpression; // wildcard or regular expression
		
		if ( !isAggregatingField && !isExpression && (fieldCategory == 'day_of_week' || fieldCategory == 'hour_of_day')) {
			
			if (fieldCategory == 'day_of_week') {
				util.showE('filter_item:field_item_day_of_week_row');
			}
			else {
				util.showE('filter_item:field_item_hour_of_day_row');
			}
		}
		else {
			util.showE('filter_item:field_item_value_row');
		}
	}
	else {
		
		// No field selected, show field_item_value_row
		util.showE('filter_item:field_item_value_row');
	}
}

//
// updateForm
//

filterItem.updateForm = function(item) {
		
	// Reset form
	util.resetF('filter_item:form');
	
	// The itemType is '' for unsaved filters and 'filter_item' for saved filters!
	
	var filterType = item.filterType;
	util.setF('filter_item:filter_item_type_list', filterType);
	
	switch (filterType) {
		
		case 'field' :
		
			var fieldName = item.fieldName;
	
			util.setF('filter_item:field_list', fieldName);
			
			//
			// update operator list if we edit an existing field
			//
			
			if (fieldName != '') {
			
				var queryField = reportInfo.queryFieldsDb[h(fieldName)];
				var isAggregatingField = queryField.isAggregatingField;
			
				var operatorListType = isAggregatingField ? 'numerical' : 'text';
				filterItem.updateFieldItemOperatorList(operatorListType);
			}
			
			//
			// set operator value
			//
			
			var operatorValue;
			var expressionType = item.expressionType;
			
			if (expressionType == '') {
				operatorValue = 'item_name';
			}
			else {
				operatorValue = expressionType;
			}
			
			if (item.isNegated) {
				operatorValue = 'not_' + operatorValue;
			}
			
			util.setF('filter_item:field_item_operator_list', operatorValue);
			
			
			//
			// set item value
			//
			
			var valueElementId = 'filter_item:field_item_value';
			
			if (item.expressionType == '') {
				
				var fieldCategory = (fieldName != '') ? reportInfo.queryFieldsDb[h(fieldName)].category : '';
				
				if (fieldCategory == 'day_of_week') {
					
					valueElementId = 'filter_item:day_of_week_list';
				}
				else if (fieldCategory == 'hour_of_day') {
				
					valueElementId = 'filter_item:hour_of_day_list';
				}
			}
			
			util.setF(valueElementId, item.itemValue);
			break;
		
		case 'session_contains' :
		
			if (item.isNegated) {
				util.setF('filter_item:session_contains_negation_on_btn', true);
			}
			util.setF('filter_item:session_contains_value', item.itemValue);
		
			break;
		
		case 'session_start' :
		
			if (item.isNegated) {
				util.setF('filter_item:session_start_negation_on_btn', true);
			}
			util.setF('filter_item:session_start_value', item.itemValue);
		
			break;
		
		case 'expression' :
		
			util.setF('filter_item:expression_item_label', item.label);
			util.setF('filter_item:expression_item_value', item.itemValue);
		
			break;
	}
	
	filterItem.setType(filterType);
	filterItem.setFieldItemValueSection();
}

filterItem.saveItem = function() {
	
	var isItemInGroup = filterItem.isItemInGroup;
	var validator = filterItem.validator;
	var obj = {};

	var filterType = util.getF('filter_item:filter_item_type_list');
	
	obj.id = filterItem.id;
	obj.filterType = filterType;
	
	if (!isItemInGroup) {
		obj.isActive = filterItem.isActive;
	}
	
	switch (filterType) {
		
		case 'field' :
		
			var fieldName = validator.isValue('filter_item:field_list');
					
			if (fieldName != '') {
				
				obj.fieldName = fieldName;
			
				var queryField = reportInfo.queryFieldsDb[h(fieldName)];
				var isAggregatingField = queryField.isAggregatingField;
				var operatorListType = isAggregatingField ? 'numerical' : 'text';
				
				var operatorObj = filterItem.getFieldItemOperator();
				
				// util.showObject(operatorObj);
				
				obj.isNegated = operatorObj.isNegated;
				
				var expressionType = operatorObj.expressionType;
				
				if (!isAggregatingField) {
				
					var isWildcardExpression = (expressionType == 'wildcard') ? true : false;
					var isRegularExpression = (expressionType == 'regexp') ? true : false;
					
					if (!isWildcardExpression && !isRegularExpression) {
						
						// We need to get the fieldCategory to check if
						// we have a day_of_week or hour_of_day list active
						var fieldCategory = queryField.category;
						var valueElementId = 'filter_item:field_item_value'
						
						if (fieldCategory == 'day_of_week') {
							valueElementId = 'filter_item:day_of_week_list';
						}
						else if (fieldCategory == 'hour_of_day') {
							valueElementId = 'filter_item:hour_of_day_list';
						}
						
						obj.itemValue = validator.isValue(valueElementId);
					}
					else {
						
						obj.itemValue = validator.isValue('filter_item:field_item_value');
						
						if (isWildcardExpression) {
							expressionType = 'wildcard';
						}
						else {
							// isRegularExpression
							expressionType = 'regexp';
							obj.itemValue = validator.isRegularExpression('filter_item:field_item_value');
						}
					}
				}
				else {
					
					// Numerical field, 
					// we allow int and float, so we just check for number
					obj.itemValue = validator.isNumber('filter_item:field_item_value');
				}
				
				obj.expressionType = expressionType;
			}
		
			break;
			
		case 'session_contains' : 
		
			obj.isNegated = util.getF('filter_item:session_contains_negation_on_btn');
			obj.itemValue = validator.isValue('filter_item:session_contains_value');
		
			break;
			
		case 'session_start' : 
		
			obj.isNegated = util.getF('filter_item:session_start_negation_on_btn');
			obj.itemValue = validator.isValue('filter_item:session_start_value');
		
			break;
			
		case 'expression' :
		
			obj.label = validator.isValue('filter_item:expression_item_label');
			
			// Check for duplicate names - We have a problem here because
			// the label only exists for expressions but not for any other FilterType,
			// so we simply allow duplicate expression labels!
			
			obj.itemValue = validator.isValue('filter_item:expression_item_value');
		
			break;
	}
	
	if (validator.allValid()) {
		
		// util.showObject(obj);
		filterItem.close();
		globalFilter.saveFilterItem(obj, filterItem.isNew, isItemInGroup, filterItem.groupItemId);
	}
}
